/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class FSSamfsckViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "FSSamfsck";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/fs/FSSamfsck.jsp";
    private CCPageTitleModel pageTitleModel = null;
    private boolean error = false;
    public static final String CHILD_RADIO = "fsckType";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_STATICTEXT = "StaticText";
    public static final String CHILD_LABEL = "Label";
    public static final String CHILD_TEXTFIELD = "TextField";
    public static final String CHILD_MOUNTHIDDEN = "MountHidden";
    public static final String CHILD_PARENT_FORM = "ParentForm";
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCRadioButton;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public FSSamfsckViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(CHILD_TEXTFIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = FSSamfsckViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_RADIO, class$com$sun$web$ui$view$html$CCRadioButton == null ? (class$com$sun$web$ui$view$html$CCRadioButton = FSSamfsckViewBean.class$("com.sun.web.ui.view.html.CCRadioButton")) : class$com$sun$web$ui$view$html$CCRadioButton);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSSamfsckViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_STATICTEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = FSSamfsckViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(CHILD_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = FSSamfsckViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(CHILD_MOUNTHIDDEN, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSSamfsckViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_PARENT_FORM, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = FSSamfsckViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        if (super.isChildSupported(name)) {
            TraceUtil.trace3("Exiting");
            return super.createChild(name);
        }
        if (name.equals(CHILD_MOUNTHIDDEN)) {
            TraceUtil.trace3("Exiting");
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_PARENT_FORM)) {
            TraceUtil.trace3("Exiting");
            return new CCStaticTextField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_TEXTFIELD)) {
            TraceUtil.trace3("Exiting");
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_LABEL)) {
            TraceUtil.trace3("Exiting");
            return new CCLabel((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_STATICTEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_RADIO)) {
            return new CCRadioButton((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            child.setValue((Object)"info");
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            TraceUtil.trace3("Exiting");
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        String parentForm = httprq.getParameter("parentForm");
        String serverName = this.getServerName();
        try {
            this.setPathName();
        }
        catch (SamFSException samEx) {
            ((CCButton)this.getChild("Submit")).setDisabled(true);
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "setPathName()", "Failed to retrieve preference information", serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSSamfsck.error", samEx.getSAMerrno(), samEx.getMessage(), serverName);
        }
        ((CCRadioButton)this.getChild(CHILD_RADIO)).setValue((Object)"check");
        TraceUtil.trace2("parentForm = " + parentForm);
        ((CCStaticTextField)this.getChild(CHILD_PARENT_FORM)).setValue((Object)parentForm);
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/fs/FSPopupPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private void setPathName() throws SamFSException {
        TraceUtil.trace3("Entering");
        String serverName = this.getServerName();
        String fsName = this.getFSName();
        String location = "";
        int mounted = 0;
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(fsName);
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        location = fs2.getFsckLogfileLocation();
        mounted = fs2.getState();
        SamUtil.doPrint("mounted is " + mounted);
        SamUtil.doPrint("location is " + location);
        ((CCTextField)this.getChild(CHILD_TEXTFIELD)).setValue((Object)location);
        CCRadioButton radio = (CCRadioButton)this.getChild(CHILD_RADIO);
        if (mounted == 0) {
            ((CCHiddenField)this.getChild(CHILD_MOUNTHIDDEN)).setValue((Object)"yes");
            radio.setOptions(new OptionList(new String[]{"FSSamfsck.fscktype1"}, new String[]{"check"}));
        } else {
            ((CCHiddenField)this.getChild(CHILD_MOUNTHIDDEN)).setValue((Object)"no");
            radio.setOptions(new OptionList(new String[]{"FSSamfsck.fscktype1", "FSSamfsck.fscktype2"}, new String[]{"check", "both"}));
        }
        if (radio.stringValue() == null) {
            radio.setValue((Object)"check");
        }
        TraceUtil.trace3("Exiting");
    }

    String getFSName() {
        String fsName = (String)this.getPageSessionAttribute("SAMQFS_FS_NAME");
        if (fsName == null) {
            fsName = RequestManager.getRequest().getParameter("fsNameParam");
            this.setPageSessionAttribute("SAMQFS_FS_NAME", (Serializable)((Object)fsName));
        }
        return fsName;
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String serverName = this.getServerName();
        String fsName = this.getFSName();
        boolean checkAndRepair = false;
        String type = this.getDisplayFieldStringValue(CHILD_RADIO);
        String loc = this.getDisplayFieldStringValue(CHILD_TEXTFIELD);
        SamUtil.doPrint("FSC2K: type is " + type + ", loc is " + loc);
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            FileSystem fileSystem = sysModel.getSamQFSSystemFSManager().getFileSystem(fsName);
            if (fileSystem == null) {
                throw new SamFSException(null, -1000);
            }
            if (sysModel.getServerAPIVersion().compareTo("1.2") >= 0 && sysModel.doesFileExist(loc)) {
                throw new SamFSException(null, -1009);
            }
            if (type.equals("both")) {
                checkAndRepair = true;
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSamfsckHrefRequest", "Start samfsck filesystem " + fsName);
            fileSystem.setFsckLogfileLocation(loc);
            long jobID = fileSystem.samfsck(checkAndRepair, loc);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSamfsckHrefRequest", "Done samfsck filesystem " + fsName + "with Job ID " + jobID);
            if (jobID < 0L) {
                SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("FSSummary.samfsckresult", new String[]{fsName, loc}), serverName);
            } else {
                StringBuffer href = new StringBuffer().append("<a href=\"../fs/FSSummary?").append("FSSummary.FileSystemSummaryView.JobIdHref=").append(jobID).append(",").append("Jobs.jobType6").append(",Current").append("\" ").append("name=\"FSSummary.FileSystemSummaryView.").append("JobIdHref").append("\" ").append("onclick=\"javascript:var f=document.FSSummaryForm;").append("if (f != null) {f.action=this.href;f.submit();").append("return false}\">").append(jobID).append("</a>");
                SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("FSSummary.samfsckjob", new String[]{fsName, loc, Long.toString(jobID)}), serverName);
                this.setSubmitSuccessful(true);
            }
        }
        catch (SamFSException ex) {
            if (ex.getSAMerrno() == -1000) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSubmitRequest()", "can not retrieve file system", serverName);
            } else if (ex.getSAMerrno() == -1009) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSubmitRequest()", "catalog file exists", serverName);
            }
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSSummary.error.samfsck", ex.getSAMerrno(), ex.getMessage(), serverName);
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

