/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class AddSharedMemberViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "AddSharedMember";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/fs/AddSharedMember.jsp";
    private static final String HOST_NAMES = "HostNames";
    private static final String IP_ADDRESSES = "IPAddresses";
    private static final String ERROR_MESSAGES = "ErrorMessages";
    private CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public AddSharedMemberViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(HOST_NAMES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddSharedMemberViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(IP_ADDRESSES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddSharedMemberViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(ERROR_MESSAGES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddSharedMemberViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(IP_ADDRESSES) || name.equals(HOST_NAMES) || name.equals(ERROR_MESSAGES)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/fs/AddSharedMemberPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/AddSharedMemberPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return propertySheetModel;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("AddSharedMember.pageTitle", new String[]{this.getFSName()}));
        this.prepopulateFields();
        this.populateHostInformation();
        this.populateJavascriptMessages();
        TraceUtil.trace3("Exiting");
    }

    private void prepopulateFields() {
        String mountPoint = (String)propertySheetModel.getValue("MountPointValue");
        String type = (String)propertySheetModel.getValue("MemberType");
        if (type == null || type.length() == 0) {
            propertySheetModel.setValue("MemberType", (Object)"client");
        }
        propertySheetModel.setValue("MountPointValue", (Object)this.getMountPoint());
        try {
            propertySheetModel.setValue("typeinlinehelp", (Object)SamUtil.getResourceString("AddSharedMember.inlinehelp.type", new String[]{new NonSyncStringBuffer(this.getMDSName()).append(" (").append(this.getMDSHostArchitecture()).append(")").toString()}));
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("Failed to retrieve MDS information of fs " + this.getFSName());
            propertySheetModel.setValue("typeinlinehelp", (Object)SamUtil.getResourceString("AddSharedMember.inlinehelp.type", new String[]{SamUtil.getResourceString("filesystem.desc.unknown")}));
        }
    }

    public boolean beginMountAfterAddValueDisplay(ChildDisplayEvent event) {
        return this.isMDSMounted();
    }

    private String getFSName() {
        String fsName = (String)this.getPageSessionAttribute("SAMQFS_FS_NAME");
        if (fsName == null) {
            fsName = RequestManager.getRequest().getParameter("SAMQFS_FS_NAME");
            if (fsName != null) {
                this.setPageSessionAttribute("SAMQFS_FS_NAME", (Serializable)((Object)fsName));
            } else {
                throw new IllegalArgumentException("File System name not supplied");
            }
        }
        return fsName;
    }

    private String getMountPoint() {
        String mountPoint = RequestManager.getRequest().getParameter("MOUNT_POINT");
        if (mountPoint != null) {
            this.setPageSessionAttribute("MOUNT_POINT", (Serializable)((Object)mountPoint));
        } else {
            mountPoint = (String)this.getPageSessionAttribute("MOUNT_POINT");
        }
        return mountPoint;
    }

    private boolean isMDSMounted() {
        String mdsMountedStr = (String)this.getPageSessionAttribute("SAMQFS_MDS_MOUNTED");
        if (mdsMountedStr == null) {
            mdsMountedStr = RequestManager.getRequest().getParameter("SAMQFS_MDS_MOUNTED");
            if (mdsMountedStr != null) {
                this.setPageSessionAttribute("SAMQFS_MDS_MOUNTED", (Serializable)((Object)mdsMountedStr));
            } else {
                throw new IllegalArgumentException("File System name not supplied");
            }
        }
        return Boolean.valueOf(mdsMountedStr);
    }

    private void populateJavascriptMessages() {
        ((CCHiddenField)this.getChild(ERROR_MESSAGES)).setValue((Object)new NonSyncStringBuffer(SamUtil.getResourceString("AddSharedMember.error.choosehost")).append("###").append(SamUtil.getResourceString("AddSharedMember.error.checksecondaryip")).append("###").append(SamUtil.getResourceString("AddSharedMember.error.needmountpoint")).toString());
    }

    private void populateHostInformation() {
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
            String[] hostsNotInUsed = fsManager.getHostsNotUsedBy(this.getFSName(), this.getServerName());
            this.populateHostNames(hostsNotInUsed);
            this.populateIPAddresses(fsManager, hostsNotInUsed);
        }
        catch (SamFSMultiHostException multiEx) {
            TraceUtil.trace1("SamFSMultiHostException is caught!");
            TraceUtil.trace1("Reason: " + multiEx.getMessage());
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "AddSharedMember.error.populate.hostname", multiEx.getSAMerrno(), SamUtil.handleMultiHostException(multiEx), this.getServerName());
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("SamFSException is caught!");
            TraceUtil.trace1("Reason: " + samEx.getMessage());
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "populateHostNames", "Failed to retrieve unused hosts information!", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "AddSharedMember.error.populate.hostname", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            TraceUtil.trace1("Unknown Exception caught!");
            TraceUtil.trace1("Reason: " + ex.getMessage());
            SamUtil.setWarningAlert((ContainerView)this, "Alert", "error.unexpected", "Unknown error occurred");
        }
    }

    private void populateHostNames(String[] hostsNotInUsed) throws SamFSMultiHostException, SamFSException, Exception {
        this.printDebugMessages(hostsNotInUsed);
        CCDropDownMenu hostNameDropDown = (CCDropDownMenu)this.getChild("HostDropDownValue");
        hostNameDropDown.setLabelForNoneSelected("AddSharedMember.dropdown.hostname.noneselect");
        NonSyncStringBuffer entryDelimitor = new NonSyncStringBuffer("###");
        NonSyncStringBuffer marker = new NonSyncStringBuffer("!!!");
        NonSyncStringBuffer bufForHostNames = new NonSyncStringBuffer();
        for (int i = 0; i < hostsNotInUsed.length; ++i) {
            if (i != 0) {
                bufForHostNames.append((Object)entryDelimitor);
            }
            if (this.markedEntry(hostsNotInUsed[i])) {
                bufForHostNames.append((Object)marker);
            }
            bufForHostNames.append(hostsNotInUsed[i]);
        }
        ((CCHiddenField)this.getChild(HOST_NAMES)).setValue((Object)bufForHostNames.toString());
    }

    private void populateIPAddresses(SamQFSSystemSharedFSManager fsManager, String[] hostsNotInUsed) throws SamFSMultiHostException, SamFSException, Exception {
        NonSyncStringBuffer entryDelimitor = new NonSyncStringBuffer("###");
        NonSyncStringBuffer ipDelimitor = new NonSyncStringBuffer(",");
        NonSyncStringBuffer bufForIP = new NonSyncStringBuffer();
        for (int i = 0; i < hostsNotInUsed.length; ++i) {
            if (i != 0) {
                bufForIP.append((Object)entryDelimitor);
            }
            String[] ipAddresses = fsManager.getIPAddresses(hostsNotInUsed[i]);
            bufForIP.append(hostsNotInUsed[i]).append((Object)ipDelimitor);
            bufForIP.append((Object)this.createIPString(ipAddresses, ipDelimitor));
        }
        ((CCHiddenField)this.getChild(IP_ADDRESSES)).setValue((Object)bufForIP.toString());
    }

    private NonSyncStringBuffer createIPString(String[] ipAddresses, NonSyncStringBuffer ipDelimitor) {
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        if (ipAddresses == null) {
            TraceUtil.trace3("Calling fsManager.getIPAddresses returns null!");
            return buf;
        }
        for (int i = 0; i < ipAddresses.length; ++i) {
            if (i != 0) {
                buf.append((Object)ipDelimitor);
            }
            buf.append(ipAddresses[i]);
        }
        return buf;
    }

    private void printDebugMessages(String[] hostsNotInUsed) {
        NonSyncStringBuffer buf = new NonSyncStringBuffer("Total Number of Hosts NOT in used: ");
        for (int i = 0; i < hostsNotInUsed.length; ++i) {
            if (i + 1 == hostsNotInUsed.length) {
                buf.append(hostsNotInUsed[i]).append("<end>");
                continue;
            }
            buf.append(hostsNotInUsed[i]).append(",");
        }
        TraceUtil.trace3(buf.toString());
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        String selectedHost;
        boolean isClient;
        boolean hasError;
        block13: {
            TraceUtil.trace3("Entering");
            hasError = false;
            boolean readOnly = Boolean.valueOf((String)propertySheetModel.getValue("ReadOnlyValue"));
            boolean mountAtBoot = Boolean.valueOf((String)propertySheetModel.getValue("MountAtBootValue"));
            boolean backGround = Boolean.valueOf((String)propertySheetModel.getValue("MountBackgroundValue"));
            boolean mountAfterAdd = this.isMDSMounted() ? Boolean.valueOf((String)propertySheetModel.getValue("MountAfterAddValue")).booleanValue() : this.isMDSMounted();
            isClient = "client".equals((String)propertySheetModel.getValue("MemberType"));
            selectedHost = (String)propertySheetModel.getValue("HostDropDownValue");
            String primaryIP = (String)propertySheetModel.getValue("PrimaryIPDropDownValue");
            String secondaryIP = (String)propertySheetModel.getValue("SecondaryIPDropDownValue");
            String mountPoint = (String)propertySheetModel.getValue("MountPointValue");
            this.printSubmitTraceString(selectedHost, isClient, primaryIP, secondaryIP, mountPoint, readOnly, mountAtBoot, backGround, mountAfterAdd);
            String[] ipArray = this.createIPArray(primaryIP, secondaryIP);
            try {
                SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
                fsManager.addHostToSharedFS(this.getFSName(), this.getServerName(), mountPoint, selectedHost, ipArray, readOnly, mountAtBoot, true, mountAfterAdd, !isClient, backGround);
                this.setPageSessionAttribute("MOUNT_POINT", (Serializable)((Object)mountPoint));
            }
            catch (SamFSMultiHostException multiEx) {
                hasError = true;
                TraceUtil.trace1("SamFSMultiHostException caught! ERROR CODE: " + multiEx.getSAMerrno());
                TraceUtil.trace1("Reason: " + multiEx.getMessage());
                SamUtil.setErrorAlert((ContainerView)this, "Alert", SamUtil.getResourceString("AddSharedMember.error.add", new String[]{selectedHost, isClient ? SamUtil.getResourceString("AddSharedMember.radio.client") : SamUtil.getResourceString("AddSharedMember.radio.pmds"), this.getFSName()}), multiEx.getSAMerrno(), SamUtil.handleMultiHostException(multiEx), selectedHost);
            }
            catch (SamFSException ex) {
                hasError = true;
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "Failed to add the specified host as a shared member", selectedHost);
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", SamUtil.getResourceString("AddSharedMember.error.add", new String[]{selectedHost, isClient ? SamUtil.getResourceString("AddSharedMember.radio.client") : SamUtil.getResourceString("AddSharedMember.radio.pmds"), this.getFSName()}), ex.getSAMerrno(), ex.getMessage(), selectedHost);
            }
            if (hasError) {
                this.forwardTo(this.getRequestContext());
            } else {
                try {
                    SamQFSSystemModel sysModel = SamUtil.getModel(selectedHost);
                    FileSystem myFS = sysModel.getSamQFSSystemFSManager().getFileSystem(this.getFSName());
                    if (myFS == null) {
                        TraceUtil.trace2("new FS not found. Wait 5 seconds ...");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException intEx) {
                            TraceUtil.trace3("InterruptedException Caught: Reason: " + intEx.getMessage());
                        }
                    }
                }
                catch (SamFSException ex) {
                    hasError = true;
                    SamUtil.setErrorAlert((ContainerView)this, "Alert", SamUtil.getResourceString("AddSharedMember.error.add", new String[]{selectedHost, isClient ? SamUtil.getResourceString("AddSharedMember.radio.client") : SamUtil.getResourceString("AddSharedMember.radio.pmds"), this.getFSName()}), ex.getSAMerrno(), ex.getMessage(), selectedHost);
                    if (ex.getSAMerrno() != 30132) break block13;
                    TraceUtil.trace2("ex.NOT_FOUND caught again!");
                    TraceUtil.trace2("wait for 5 seconds ...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException intEx) {
                        TraceUtil.trace3("InterruptedException Caught: Reason: " + intEx.getMessage());
                    }
                }
            }
        }
        if (!hasError) {
            SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", SamUtil.getResourceString("AddSharedMember.action.add", new String[]{selectedHost, isClient ? SamUtil.getResourceString("AddSharedMember.radio.client") : SamUtil.getResourceString("AddSharedMember.radio.pmds"), this.getFSName()}), this.getServerName());
            this.setSubmitSuccessful(true);
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private String[] createIPArray(String primaryIP, String secondaryIP) {
        String[] ipArray = null;
        ipArray = "---".equals(secondaryIP) ? new String[]{primaryIP} : new String[]{primaryIP, secondaryIP};
        return ipArray;
    }

    private boolean markedEntry(String hostName) throws SamFSException {
        return !SamUtil.getModel(hostName).getArchitecture().equals(this.getMDSHostArchitecture());
    }

    private String getMDSHostArchitecture() throws SamFSException {
        String arch = (String)this.getPageSessionAttribute("ARCHITECTURE");
        if (arch == null) {
            arch = SamUtil.getModel(this.getMDSName()).getArchitecture();
            this.setPageSessionAttribute("ARCHITECTURE", (Serializable)((Object)arch));
        }
        return arch;
    }

    private String getMDSName() throws SamFSException {
        String mdsName = (String)this.getPageSessionAttribute("SHARED_MD_SERVER");
        if (mdsName == null) {
            mdsName = SamUtil.getModel(this.getServerName()).getSamQFSSystemFSManager().getFileSystem(this.getFSName()).getServerName();
            this.setPageSessionAttribute("SHARED_MD_SERVER", (Serializable)((Object)mdsName));
        }
        return mdsName;
    }

    private void printSubmitTraceString(String selectedHost, boolean isClient, String primaryIP, String secondaryIP, String mountPoint, boolean readOnly, boolean mountAtBoot, boolean backGround, boolean mountAfterAdd) {
        TraceUtil.trace3(new NonSyncStringBuffer("Submit Button clicked: selectedHost: ").append(selectedHost).append(" isClient: ").append(isClient).append(" primaryIP: ").append(primaryIP).append(" secondaryIP: ").append(secondaryIP).append(" mountPoint: ").append(mountPoint).append(" readOnly: ").append(readOnly).append(" mountAtBoot: ").append(mountAtBoot).append(" backGround: ").append(backGround).append(" mountAfterAdd: ").append(mountAfterAdd).toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

