/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;

public class AddClusterNodePopupViewBean
extends CommonSecondaryViewBeanBase {
    public static final String PAGE_NAME = "AddClusterNodePopup";
    public static final String DEFAULT_URL = "/jsp/fs/AddClusterNodePopup.jsp";
    public static final String NODE_TABLE = "FSDAddClusterNodeTable";
    public static final String NODE_NAMES = "nodeNames";
    public static final String SELECTED_NODES = "selectedNodes";
    private CCPageTitleModel ptModel = null;
    private CCActionTableModel tableModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$web$ui$view$table$CCActionTable;

    public AddClusterNodePopupViewBean() {
        super(PAGE_NAME, DEFAULT_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.ptModel = this.getPageTitleModel();
        this.tableModel = this.getTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        this.registerChild(NODE_NAMES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddClusterNodePopupViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(SELECTED_NODES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddClusterNodePopupViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.ptModel);
        this.registerChild(NODE_TABLE, class$com$sun$web$ui$view$table$CCActionTable == null ? (class$com$sun$web$ui$view$table$CCActionTable = AddClusterNodePopupViewBean.class$("com.sun.web.ui.view.table.CCActionTable")) : class$com$sun$web$ui$view$table$CCActionTable);
        this.tableModel.registerChildren((ContainerViewBase)this);
        super.registerChildren();
    }

    public View createChild(String name) {
        if (name.equals(NODE_NAMES) || name.equals(SELECTED_NODES)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(NODE_TABLE)) {
            return new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tableModel, name);
        }
        if (this.tableModel.isChildSupported(name)) {
            return this.tableModel.createChild((View)this, name);
        }
        if (PageTitleUtil.isChildSupported(this.ptModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, this.ptModel, name);
        }
        if (super.isChildSupported(name)) {
            return super.createChild(name);
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    private CCActionTableModel getTableModel() {
        return new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/AddClusterNodeTable.xml");
    }

    private CCPageTitleModel getPageTitleModel() {
        return PageTitleUtil.createModel("/jsp/fs/AddClusterNodePageTitle.xml");
    }

    private List getCurrentNodes() throws SamFSException {
        String serverName = this.getServerName();
        ArrayList<String> nodes = new ArrayList<String>();
        GenericFileSystem filesystem = SamUtil.getModel(serverName).getSamQFSSystemFSManager().getGenericFileSystem(this.getFSName());
        if (filesystem == null) {
            return nodes;
        }
        GenericFileSystem[] instance = filesystem.getHAFSInstances();
        for (int i = 0; i < instance.length; ++i) {
            nodes.add(instance[i].getHostName());
        }
        return nodes;
    }

    private void populateTableModel() {
        this.tableModel.setSelectionType("multiple");
        String serverName = this.getServerName();
        String fsName = this.getFSName();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            ClusterNodeInfo[] nodeInfo = sysModel.getClusterNodes();
            List currentNodes = this.getCurrentNodes();
            NonSyncStringBuffer buffer = new NonSyncStringBuffer();
            int rowCount = 0;
            for (int i = 0; i < nodeInfo.length; ++i) {
                if (currentNodes.contains(nodeInfo[i].getName())) continue;
                if (i > 0) {
                    this.tableModel.appendRow();
                }
                this.tableModel.setValue("NodeNameText", (Object)nodeInfo[i].getName());
                this.tableModel.setValue("StateText", (Object)nodeInfo[i].getStatus());
                this.tableModel.setValue("IDText", (Object)new Integer(nodeInfo[i].getID()));
                this.tableModel.setValue("PrivateAddressText", (Object)nodeInfo[i].getPrivIP());
                buffer.append(nodeInfo[i].getName()).append(";");
                ++rowCount;
            }
            if (rowCount < 1) {
                ((CCButton)this.getChild("Submit")).setDisabled(true);
            }
            ((CCHiddenField)this.getChild(NODE_NAMES)).setValue((Object)buffer.toString());
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to retrieve cluster nodes", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "Error retrieving cluster information", sfe.getSAMerrno(), sfe.getMessage(), serverName);
            ((CCButton)this.getChild("Submit")).setDisabled(true);
        }
    }

    private String getFSName() {
        String fsName = (String)this.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        if (fsName == null) {
            fsName = RequestManager.getRequest().getParameter("SAMQFS_FILE_SYSTEM_NAME");
            this.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)fsName));
        }
        return fsName;
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        super.beginDisplay(evt);
        this.tableModel.setActionValue("NodeName", (Object)"AddCluster.heading.name");
        this.tableModel.setActionValue("State", (Object)"AddCluster.heading.status");
        this.tableModel.setActionValue("ID", (Object)"AddCluster.heading.id");
        this.tableModel.setActionValue("PrivateAddress", (Object)"AddCluster.heading.privateip");
        this.populateTableModel();
    }

    public void handleSubmitRequest(RequestInvocationEvent evt) throws ServletException, IOException {
        String temp = this.getDisplayFieldStringValue(SELECTED_NODES);
        String[] selectedNode = temp.split(";");
        String serverName = this.getServerName();
        String fsName = this.getFSName();
        try {
            SamQFSSystemFSManager fsManager = SamUtil.getModel(serverName).getSamQFSSystemFSManager();
            FileSystem fs2 = fsManager.getFileSystem(this.getFSName());
            for (int i = 0; i < selectedNode.length; ++i) {
                fsManager.addHostToHAFS(fs2, selectedNode[i]);
            }
            SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", "fs.cluster.addnode.success", serverName);
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "unable to add cluster nodes to fs", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "fs.cluster.addnode.failure", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        this.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

