/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCriteriaApplyFS;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCriteriaCopySettings;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCriteriaWizardImplData;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;

public class NewCriteriaWizardImpl
extends SamWizardImpl {
    public static final String PAGEMODEL_NAME = "NewCriteriaPageModelName";
    public static final String PAGEMODEL_NAME_PREFIX = "NewCriteriaWizardMode";
    public static final String IMPL_NAME = "NewCriteriaWizardImpl";
    public static final String IMPL_NAME_PREFIX = "NewCriteriaImpl";
    public static final String IMPL_CLASS_NAME = "com.sun.netstorage.samqfs.web.archive.wizards.NewCriteriaWizardImpl";
    public static final String CURRENT_CRITERIA = "DefaultPolicyCriteria";
    public static final String SELECTED_FILESYSTEMS = "selected_criteria_fs";
    public static final String DUMP_ON = "new_criteria_is_dump_on";
    public static final String DUMP_PATH = "new_criteria_dump_path";

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return new NewCriteriaWizardImpl(requestContext);
    }

    public NewCriteriaWizardImpl(RequestContext requestContext) {
        super(requestContext, PAGEMODEL_NAME);
        TraceUtil.trace3("Entering");
        String serverName = requestContext.getRequest().getParameter("SERVER_NAME");
        TraceUtil.trace3(new NonSyncStringBuffer("WizardImpl Const' serverName is ").append(serverName).toString());
        this.wizardModel.setValue("SERVER_NAME", serverName);
        String policyName = requestContext.getRequest().getParameter("SAMQFS_POLICY_NAME");
        TraceUtil.trace3(new NonSyncStringBuffer("WizardImpl Const' policyName is ").append(policyName).toString());
        this.wizardModel.setValue("SAMQFS_POLICY_NAME", policyName);
        this.initializeWizard(requestContext);
        this.initializeWizardControl(requestContext);
        TraceUtil.trace3("Exiting");
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return NewCriteriaWizardImpl.getWizardWindowModel(IMPL_NAME, "ArchiveWizard.Criteria.title", IMPL_CLASS_NAME, cmdChild);
    }

    private void initializeWizard(RequestContext requestContext) {
        TraceUtil.trace3("Entering");
        this.wizardName = IMPL_NAME;
        this.wizardTitle = "ArchiveWizard.Criteria.title";
        this.pageClass = NewCriteriaWizardImplData.pageClass;
        this.pageTitle = NewCriteriaWizardImplData.pageTitle;
        this.stepHelp = NewCriteriaWizardImplData.stepHelp;
        this.stepText = NewCriteriaWizardImplData.stepText;
        this.stepInstruction = NewCriteriaWizardImplData.stepInstruction;
        this.cancelMsg = NewCriteriaWizardImplData.cancelmsg;
        this.pages = this.getWizardPages();
        this.setShowResultsPage(true);
        this.initializeWizardPages(this.pages);
        TraceUtil.trace3("Exiting");
    }

    private int[] getWizardPages() {
        int[] p;
        int[] pages = null;
        boolean dumpOn = false;
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2001);
            }
            dumpOn = appModel.isDumpOn();
            if (dumpOn) {
                this.wizardModel.setValue(DUMP_ON, new Boolean(true));
                SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                this.wizardModel.setValue(DUMP_PATH, sysModel.getDefaultDumpPath());
            } else {
                this.wizardModel.setValue(DUMP_ON, new Boolean(false));
                this.wizardModel.setValue("saveMethodText", SamUtil.getResourceString("NewCriteriaWizard.savePage.commit"));
            }
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), this.getClass(), "Model Error", "Unable to initialize System Model", this.getServerName());
        }
        pages = dumpOn ? (this.getPolicyName().equals("no_archive") ? (p = new int[]{0, 2, 3, 4, 5}) : (p = new int[]{0, 1, 2, 3, 4, 5})) : (this.getPolicyName().equals("no_archive") ? (p = new int[]{0, 2, 4, 5}) : (p = new int[]{0, 1, 2, 4, 5}));
        return pages;
    }

    public Class getPageClass(String pageId) {
        Class result = super.getPageClass(pageId);
        return result;
    }

    public boolean nextStep(WizardEvent event) {
        String pageId = event.getPageId();
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        super.nextStep(event);
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 0: {
                return this.processMatchCriteriaPage(event);
            }
            case 1: {
                return this.processCopySettingsPage(event);
            }
            case 2: {
                return this.processApplyToFSPage(event);
            }
            case 3: {
                return this.processSavePage(event);
            }
        }
        return true;
    }

    public boolean previousStep(WizardEvent event) {
        String pageId = event.getPageId();
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        super.previousStep(event);
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 1: {
                this.processCopySettingsPage(event);
                break;
            }
            case 2: {
                this.processApplyToFSPage(event);
                break;
            }
            case 3: {
                this.processSavePage(event);
            }
        }
        return true;
    }

    public boolean finishStep(WizardEvent event) {
        if (!super.finishStep(event)) {
            return true;
        }
        SamQFSSystemModel sysModel = null;
        try {
            ArrayList resultList;
            String duplicate;
            sysModel = SamUtil.getModel(this.getServerName());
            Boolean dumpon = (Boolean)this.wizardModel.getValue(DUMP_ON);
            if (dumpon != null && dumpon.booleanValue()) {
                String path = (String)this.wizardModel.getValue(DUMP_PATH);
                sysModel.setDumpPath(path);
            }
            ArchivePolCriteria theCriteria = this.getCurrentPolicyCriteria();
            ArrayList filesystems = (ArrayList)this.wizardModel.getValue(SELECTED_FILESYSTEMS);
            String[] fsList = new String[]{};
            if (filesystems != null) {
                filesystems.trimToSize();
                fsList = new String[filesystems.size()];
                fsList = filesystems.toArray(fsList);
            }
            if ((duplicate = (String)(resultList = sysModel.getSamQFSSystemArchiveManager43().isDuplicateCriteria(theCriteria, fsList, false)).get(0)).equals("true")) {
                this.wizardModel.setValue("dupCriteria", resultList.get(1));
                this.wizardModel.setValue("dupPolName", resultList.get(2));
                throw new SamFSException(null, -2025);
            }
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(this.getPolicyName());
            thePolicy.addArchivePolCriteria(theCriteria, fsList);
            LogUtil.info(this.getClass(), "finishStep", new NonSyncStringBuffer("Done creating new criteria for policy ").append(this.getPolicyName()).toString());
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("NewCriteriaWizard.success.message", this.getPolicyName()));
            TraceUtil.trace2(new NonSyncStringBuffer("Succesfully created new criteria for policy: ").append(this.getPolicyName()).toString());
            return true;
        }
        catch (SamFSException ex) {
            if (sysModel != null) {
                sysModel.clearContext();
            }
            boolean multiMsgOccurred = false;
            boolean warningOccurred = false;
            String processMsg = null;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                multiMsgOccurred = true;
            } else if (ex instanceof SamFSWarnings) {
                warningOccurred = true;
                processMsg = "Warning in archiver configuration";
            } else {
                processMsg = new NonSyncStringBuffer("Failed to add new criteria for policy ").append(this.getPolicyName()).toString();
            }
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", processMsg, this.getServerName());
            int errCode = ex.getSAMerrno();
            if (multiMsgOccurred) {
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("WizardResultAlertSummary", "ArchiveConfig.error");
                this.wizardModel.setValue("WizardResultAlertDetail", "ArchiveConfig.error.detail");
                this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            } else if (warningOccurred) {
                this.wizardModel.setValue("Finish_result", "Warning");
                this.wizardModel.setValue("WizardResultAlertSummary", "ArchiveConfig.error");
                this.wizardModel.setValue("WizardResultAlertDetail", "ArchiveConfig.warning.detail");
                this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            } else {
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("WizardResultAlertSummary", "NewCriteriaWizard.error.summary");
                this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            }
            return true;
        }
    }

    private boolean processMatchCriteriaPage(WizardEvent event) {
        ArchivePolCriteria criteria = this.getCurrentPolicyCriteria();
        ArchivePolCriteriaProp properties = criteria.getArchivePolCriteriaProperties();
        String startingDir = (String)this.wizardModel.getValue("StartingDir");
        String string = startingDir = startingDir != null ? startingDir.trim() : "";
        if (startingDir.equals("")) {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.startingDirEmpty");
            return false;
        }
        if (startingDir.indexOf(32) != -1) {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.startingDirSpace");
            return false;
        }
        if (startingDir.charAt(0) == '/') {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.startingDirAbsolutePath");
            return false;
        }
        properties.setStartingDir(startingDir);
        this.wizardModel.setValue("startingDirText", startingDir);
        String namePattern = (String)this.wizardModel.getValue("NamePattern");
        String string2 = namePattern = namePattern != null ? namePattern.trim() : "";
        if (!namePattern.equals("")) {
            if (namePattern.indexOf(32) != -1) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.namePattern");
                return false;
            }
            if (!PolicyUtil.isValidNamePattern(namePattern)) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.namePattern");
                return false;
            }
        }
        properties.setNamePattern(namePattern);
        this.wizardModel.setValue("namePatternText", namePattern);
        String drivesMin = (String)this.wizardModel.getValue("MinSize");
        String drivesMax = (String)this.wizardModel.getValue("MaxSize");
        drivesMin = drivesMin != null ? drivesMin.trim() : "";
        String string3 = drivesMax = drivesMax != null ? drivesMax.trim() : "";
        if (!drivesMin.equals("") && drivesMax.equals("")) {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.maxSize");
            return false;
        }
        if (drivesMin.equals("") && !drivesMax.equals("")) {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.minSize");
            return false;
        }
        if (!drivesMin.equals("") && !drivesMax.equals("")) {
            String drivesMinSizeUnit = (String)this.wizardModel.getValue("MinSizeUnits");
            boolean mn = false;
            boolean mnu = false;
            boolean mx = false;
            boolean mxu = false;
            long min = -1L;
            int minu = -1;
            long max = -1L;
            int maxu = -1;
            try {
                min = Long.parseLong(drivesMin);
                if (min < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.minSize");
                    return false;
                }
                mn = true;
                if (SelectableGroupHelper.NOVAL.equals(drivesMinSizeUnit)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.minSizeUnit");
                    return false;
                }
                minu = Integer.parseInt(drivesMinSizeUnit);
                mnu = true;
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.minSize");
                return false;
            }
            String drivesMaxSizeUnit = (String)this.wizardModel.getValue("MaxSizeUnits");
            try {
                max = Long.parseLong(drivesMax);
                if (max < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.maxSize");
                    return false;
                }
                mx = true;
                if (SelectableGroupHelper.NOVAL.equals(drivesMaxSizeUnit)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.maxSizeUnit");
                    return false;
                }
                maxu = Integer.parseInt(drivesMaxSizeUnit);
                mxu = true;
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.maxSize");
                return false;
            }
            if (!PolicyUtil.isMaxGreaterThanMin(min, minu, max, maxu)) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.minMaxSize");
                return false;
            }
            properties.setMinSize(min);
            properties.setMinSizeUnit(minu);
            properties.setMaxSize(max);
            properties.setMaxSizeUnit(maxu);
            this.wizardModel.setValue("minSizeText", new NonSyncStringBuffer().append(min).append(" ").append(SamUtil.getSizeUnitL10NString(minu)).toString());
            this.wizardModel.setValue("maxSizeText", new NonSyncStringBuffer().append(max).append(" ").append(SamUtil.getSizeUnitL10NString(maxu)).toString());
        } else {
            properties.setMinSize(-1L);
            properties.setMinSizeUnit(-1);
            properties.setMaxSize(-1L);
            properties.setMaxSizeUnit(-1);
            this.wizardModel.setValue("minSizeText", "");
            this.wizardModel.setValue("maxSizeText", "");
        }
        String accessAge = (String)this.wizardModel.getValue("AccessAge");
        String accessAgeUnit = (String)this.wizardModel.getValue("AccessAgeUnits");
        String string4 = accessAge = accessAge != null ? accessAge.trim() : "";
        if (!accessAge.equals("")) {
            long accessAgeValue = -1L;
            if (accessAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.accessAgeUnit");
                return false;
            }
            try {
                accessAgeValue = Long.parseLong(accessAge);
                if (accessAgeValue <= 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.accessAge");
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.accessAge");
                return false;
            }
            properties.setAccessAge(accessAgeValue);
            properties.setAccessAgeUnit(Integer.parseInt(accessAgeUnit));
            this.wizardModel.setValue("accessAgeText", new NonSyncStringBuffer().append(accessAge).append(" ").append(SamUtil.getTimeUnitL10NString(Integer.parseInt(accessAgeUnit))).toString());
        } else {
            properties.setAccessAge(-1L);
            properties.setAccessAgeUnit(-1);
            this.wizardModel.setValue("accessAgeText", "");
        }
        String owner = (String)this.wizardModel.getValue("Owner");
        String string5 = owner = owner != null ? owner.trim() : "";
        if (!(owner.equals("") || owner.indexOf(32) == -1 && PolicyUtil.isUserValid(owner, this.getServerName()))) {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.owner");
            return false;
        }
        properties.setOwner(owner);
        this.wizardModel.setValue("ownerText", owner);
        String group = (String)this.wizardModel.getValue("Group");
        String string6 = group = group != null ? group.trim() : "";
        if (!group.equals("")) {
            if (group.indexOf(32) != -1) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.group");
                return false;
            }
            if (!PolicyUtil.isGroupValid(group, this.getServerName())) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.matchCriteriaPage.error.groupNotExist");
                return false;
            }
        }
        properties.setGroup(group);
        this.wizardModel.setValue("groupText", group);
        String polName = (String)this.wizardModel.getValue("SAMQFS_POLICY_NAME");
        if (!polName.equals("no_archive")) {
            String stagingStr = (String)this.wizardModel.getValue("Staging");
            int staging = -1;
            if (!stagingStr.equals(SelectableGroupHelper.NOVAL)) {
                staging = Integer.parseInt(stagingStr);
            }
            properties.setStageAttributes(staging);
            this.wizardModel.setValue("stagingText", this.getStagingOptionString(staging));
            String releasingStr = (String)this.wizardModel.getValue("Releasing");
            int releasing = -1;
            if (!releasingStr.equals(SelectableGroupHelper.NOVAL)) {
                releasing = Integer.parseInt(releasingStr);
            }
            properties.setReleaseAttributes(releasing);
            this.wizardModel.setValue("releasingText", this.getReleasingOptionString(releasing));
        } else {
            this.wizardModel.setValue("releasingText", "");
            this.wizardModel.setValue("stagingText", "");
        }
        return true;
    }

    private boolean processCopySettingsPage(WizardEvent event) {
        ArchivePolCriteria criteria = this.getCurrentPolicyCriteria();
        ArchivePolCriteriaCopy[] copy = criteria.getArchivePolCriteriaCopies();
        NewCriteriaCopySettings theView = (NewCriteriaCopySettings)event.getView();
        CCActionTable table = (CCActionTable)theView.getChild("CopySettingsTable");
        try {
            table.restoreStateData();
        }
        catch (ModelControlException mce) {
            SamUtil.processException((Exception)((Object)mce), this.getClass(), "processCopySettingsPage", "Unable to restore copy table state data", this.getServerName());
        }
        CCActionTableModel tableModel = (CCActionTableModel)table.getModel();
        int rowCount = tableModel.getNumRows();
        TraceUtil.trace2(new NonSyncStringBuffer("rowCount = ").append(rowCount).toString());
        boolean copyValid = true;
        NonSyncStringBuffer copyErrors = new NonSyncStringBuffer();
        NonSyncStringBuffer archiveAgeStringBuf = new NonSyncStringBuffer();
        NonSyncStringBuffer unarchiveAgeStringBuf = new NonSyncStringBuffer();
        NonSyncStringBuffer releaseOptionsStringBuf = new NonSyncStringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            tableModel.setRowIndex(i);
            int copyNum = copy[i].getArchivePolCriteriaCopyNumber();
            String archiveAge = (String)tableModel.getValue("ArchiveAgeText");
            archiveAge = archiveAge != null ? archiveAge.trim() : "";
            TraceUtil.trace2(new NonSyncStringBuffer("archiveAge = ").append(archiveAge).toString());
            long aage = -1L;
            if (archiveAge.equals("")) {
                copyValid = false;
                copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.archiveAge")).append("\\n");
            } else {
                try {
                    aage = Long.parseLong(archiveAge);
                    if (aage <= 0L) {
                        copyValid = false;
                        copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.archiveAge")).append("\\n");
                    }
                }
                catch (NumberFormatException nfe) {
                    copyValid = false;
                    copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.archiveAge")).append("\\n");
                }
            }
            String archiveAgeUnit = (String)tableModel.getValue("ArchiveAgeUnits");
            TraceUtil.trace2(new NonSyncStringBuffer("archiveAgeUnit = ").append(archiveAgeUnit).toString());
            int aageu = -1;
            if (aage > 0L) {
                if (archiveAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                    copyValid = false;
                    copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.archiveAgeUnit")).append("\\n");
                } else {
                    try {
                        aageu = Integer.parseInt(archiveAgeUnit);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            String unarchiveAge = (String)tableModel.getValue("UnarchiveAgeText");
            String unarchiveAgeUnits = (String)tableModel.getValue("UnarchiveAgeUnits");
            unarchiveAge = unarchiveAge != null ? unarchiveAge.trim() : "";
            TraceUtil.trace2(new NonSyncStringBuffer("unarchiveAge = ").append(unarchiveAge).toString());
            TraceUtil.trace2(new NonSyncStringBuffer("unarchiveAgeUnit = ").append(unarchiveAgeUnits).toString());
            long uage = -1L;
            int uageu = -1;
            if (!unarchiveAge.equals("")) {
                try {
                    uage = Long.parseLong(unarchiveAge);
                    if (uage <= 0L) {
                        copyValid = false;
                        copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.unarchiveAge")).append("\\n");
                    } else if (unarchiveAgeUnits.equals(SelectableGroupHelper.NOVAL)) {
                        copyValid = false;
                        copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.unarchiveAgeUnit")).append("\\n");
                    } else {
                        try {
                            uageu = Integer.parseInt(unarchiveAgeUnits);
                        }
                        catch (NumberFormatException nfe) {}
                    }
                }
                catch (NumberFormatException nfe) {
                    copyValid = false;
                    copyErrors.append(SamUtil.getResourceString("archiving.copyerrors", Integer.toString(copyNum))).append(SamUtil.getResourceString("NewCriteriaWizard.copySettingsPage.error.unarchiveAge")).append("\\n");
                }
            }
            String rOptions = (String)tableModel.getValue("ReleaseOptionsText");
            TraceUtil.trace2(new NonSyncStringBuffer("releaseOptions = ").append(rOptions).toString());
            releaseOptionsStringBuf.append(SamUtil.getResourceString("archiving.copynumber", Integer.toString(copyNum))).append(": ");
            if (rOptions.equals(SelectableGroupHelper.NOVAL)) {
                copy[i].setNoRelease(false);
                copy[i].setRelease(false);
                releaseOptionsStringBuf.append(SamUtil.getResourceString("ArchivePolCopy.general.spaceRequired")).append("<br>");
            } else {
                boolean releaseOption = new Boolean(rOptions);
                if (releaseOption) {
                    copy[i].setNoRelease(false);
                    copy[i].setRelease(true);
                    releaseOptionsStringBuf.append(SamUtil.getResourceString("ArchivePolCopy.general.release")).append("<br>");
                } else {
                    copy[i].setNoRelease(true);
                    copy[i].setRelease(false);
                    releaseOptionsStringBuf.append(SamUtil.getResourceString("ArchivePolCopy.general.noRelease")).append("<br>");
                }
            }
            copy[i].setArchiveAge(aage);
            copy[i].setArchiveAgeUnit(aageu);
            copy[i].setUnarchiveAge(uage);
            copy[i].setUnarchiveAgeUnit(uageu);
            archiveAgeStringBuf.append(SamUtil.getResourceString("archiving.copynumber", Integer.toString(copyNum))).append(": ").append(aage).append(" ").append(SamUtil.getTimeUnitL10NString(aageu)).append("<br>");
            unarchiveAgeStringBuf.append(SamUtil.getResourceString("archiving.copynumber", Integer.toString(copyNum))).append(": ");
            if (uage != -1L) {
                unarchiveAgeStringBuf.append(uage).append(" ").append(SamUtil.getTimeUnitL10NString(uageu)).append("<br>");
                continue;
            }
            unarchiveAgeStringBuf.append("<br>");
        }
        if (!copyValid) {
            event.setSeverity(0);
            event.setErrorMessage(copyErrors.toString());
            return false;
        }
        this.wizardModel.setValue("archiveAgeText", archiveAgeStringBuf.toString());
        this.wizardModel.setValue("unarchiveAgeText", unarchiveAgeStringBuf.toString());
        this.wizardModel.setValue("releaseOptionsText", releaseOptionsStringBuf.toString());
        return true;
    }

    private boolean processApplyToFSPage(WizardEvent event) {
        ArchivePolCriteria criteria = this.getCurrentPolicyCriteria();
        NewCriteriaApplyFS view = (NewCriteriaApplyFS)event.getView();
        CCActionTable table = (CCActionTable)view.getChild("FileSystemTable");
        try {
            table.restoreStateData();
        }
        catch (ModelControlException mce) {
            SamUtil.processException((Exception)((Object)mce), this.getClass(), "processApplyTOFSPage", "Unable to restore table state data", this.getServerName());
        }
        CCActionTableModel tableModel = (CCActionTableModel)table.getModel();
        Integer[] rows = tableModel.getSelectedRows();
        if (rows == null || rows.length <= 0) {
            this.wizardModel.setValue(SELECTED_FILESYSTEMS, new ArrayList(0));
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.applyFSPage.error.fsNotSelected");
            return false;
        }
        ArrayList<String> selectedFS = new ArrayList<String>(rows.length);
        NonSyncStringBuffer fsStringBuf = new NonSyncStringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            tableModel.setRowIndex(rows[i].intValue());
            String fs2 = (String)tableModel.getValue("HiddenFSName");
            selectedFS.add(fs2);
            fsStringBuf.append(fs2).append("<br>");
        }
        this.wizardModel.setValue(SELECTED_FILESYSTEMS, selectedFS);
        this.wizardModel.setValue("applyFSText", fsStringBuf.toString());
        return true;
    }

    private boolean processSavePage(WizardEvent event) {
        NonSyncStringBuffer saveStringBuf = new NonSyncStringBuffer();
        String saveRadio = (String)this.wizardModel.getValue("SaveRadioButton");
        if (saveRadio != null && saveRadio.equals("save")) {
            String dumpPath = (String)this.wizardModel.getValue("SaveTextField");
            String string = dumpPath = dumpPath != null ? dumpPath.trim() : "";
            if (dumpPath.equals("")) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.savePage.error.invalidDumpPath");
                return false;
            }
            if (!SamUtil.isValidNonSpecialCharString(dumpPath)) {
                event.setSeverity(0);
                event.setErrorMessage("NewCriteriaWizard.savePage.error.invalidDumpPath");
                return false;
            }
            this.wizardModel.setValue(DUMP_ON, new Boolean(true));
            this.wizardModel.setValue(DUMP_PATH, dumpPath);
            saveStringBuf.append(SamUtil.getResourceString("NewCriteriaWizard.savePage.save")).append(": ").append(dumpPath);
        } else if (saveRadio != null && saveRadio.equals("commit")) {
            this.wizardModel.setValue(DUMP_ON, new Boolean(false));
            saveStringBuf.append(SamUtil.getResourceString("NewCriteriaWizard.savePage.commit"));
        } else {
            event.setSeverity(0);
            event.setErrorMessage("NewCriteriaWizard.savePage.error.noSelection");
            return false;
        }
        this.wizardModel.setValue("saveMethodText", saveStringBuf.toString());
        return true;
    }

    private ArchivePolCriteria getCurrentPolicyCriteria() {
        ArchivePolCriteria criteria = (ArchivePolCriteria)this.wizardModel.getValue(CURRENT_CRITERIA);
        if (criteria != null) {
            return criteria;
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(this.getPolicyName());
            criteria = thePolicy.getDefaultArchivePolCriteriaForPolicy();
            this.wizardModel.setValue(CURRENT_CRITERIA, criteria);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), this.getClass(), "Model Error", "Unable to retrieve Policy", this.getServerName());
        }
        return criteria;
    }

    private String getStagingOptionString(int optionValue) {
        String optionString = "NewCriteriaWizard.criteria.staging.auto";
        switch (optionValue) {
            case 10001: {
                optionString = "NewCriteriaWizard.criteria.staging.associative";
                break;
            }
            case 10002: {
                optionString = "NewCriteriaWizard.criteria.staging.never";
                break;
            }
            case 10003: {
                optionString = "NewCriteriaWizard.criteria.staging.defaults";
            }
        }
        return SamUtil.getResourceString(optionString);
    }

    private String getReleasingOptionString(int optionValue) {
        String optionString = "NewCriteriaWizard.criteria.releasing.reached";
        switch (optionValue) {
            case 10005: {
                optionString = "NewCriteriaWizard.criteria.releasing.never";
                break;
            }
            case 10006: {
                optionString = "NewCriteriaWizard.criteria.releasing.partial";
                break;
            }
            case 10007: {
                optionString = "NewCriteriaWizard.criteria.releasing.onecopy";
                break;
            }
            case 10008: {
                optionString = "NewCriteriaWizard.criteria.releasing.defaults";
            }
        }
        return SamUtil.getResourceString(optionString);
    }

    private String getServerName() {
        String serverName = (String)this.wizardModel.getValue("SERVER_NAME");
        return serverName == null ? "" : serverName;
    }

    private String getPolicyName() {
        String policyName = (String)this.wizardModel.getValue("SAMQFS_POLICY_NAME");
        return policyName == null ? "" : policyName;
    }
}

