/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.ReservationMethodHelper;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.archive.wizards.CopyMediaValidator;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCopyWizardImplData;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;

public class NewCopyWizardImpl
extends SamWizardImpl {
    public static final String PAGEMODEL_NAME = "NewCopyPageModelName";
    public static final String PAGEMODEL_NAME_PREFIX = "NewCopyWizardMode";
    public static final String IMPL_NAME = "NewCopyWizardImpl";
    public static final String IMPL_NAME_PREFIX = "NewCopyImpl";
    public static final String IMPL_CLASS_NAME = "com.sun.netstorage.samqfs.web.archive.wizards.NewCopyWizardImpl";
    public static final String COPY_GUIWRAPPER = "new_gui_copy_wrapper";
    public static final String ARCHIVING_TYPE = "archiving_type_string";
    public static final String MEDIA_TYPE = "new_copy_media_type";
    public static final String TAPE = "tape";
    public static final String DISK = "disk";
    private boolean wizardInitialized = false;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView;

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return new NewCopyWizardImpl(requestContext);
    }

    protected NewCopyWizardImpl(RequestContext requestContext) {
        super(requestContext, PAGEMODEL_NAME);
        TraceUtil.trace3("Entering");
        String serverName = requestContext.getRequest().getParameter("SERVER_NAME");
        TraceUtil.trace3(new NonSyncStringBuffer("WizardImpl Const' serverName is ").append(serverName).toString());
        this.wizardModel.setValue("SERVER_NAME", serverName);
        String policyName = requestContext.getRequest().getParameter("SAMQFS_POLICY_NAME");
        TraceUtil.trace3(new NonSyncStringBuffer("WizardImpl Const' policyName is ").append(policyName).toString());
        this.wizardModel.setValue("SAMQFS_POLICY_NAME", policyName);
        this.initializeWizard(requestContext);
        this.initializeWizardControl(requestContext);
        TraceUtil.trace3("Exiting");
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return NewCopyWizardImpl.getWizardWindowModel(IMPL_NAME, "ArchiveWizard.copy.title", IMPL_CLASS_NAME, cmdChild);
    }

    private void initializeWizard(RequestContext requestContext) {
        TraceUtil.trace3("Entering");
        this.wizardName = IMPL_NAME;
        this.wizardTitle = "ArchiveWizard.copy.title";
        this.pageClass = NewCopyWizardImplData.pageClass;
        this.pageTitle = NewCopyWizardImplData.pageTitle;
        this.stepHelp = NewCopyWizardImplData.stepHelp;
        this.stepText = NewCopyWizardImplData.stepText;
        this.stepInstruction = NewCopyWizardImplData.stepInstruction;
        this.cancelMsg = NewCopyWizardImplData.cancelmsg;
        this.setShowResultsPage(true);
        this.pages = NewCopyWizardImplData.DiskPrefOn;
        this.initializeWizardPages(this.pages);
        ArchiveCopyGUIWrapper myWrapper = this.getArchiveCopyGUIWrapper();
        this.wizardModel.setValue("SaveMethod", SamUtil.getResourceString("AddLibrary.page7.radio1"));
        String serverName = requestContext.getRequest().getParameter("SERVER_NAME");
        this.wizardModel.setValue("SERVER_NAME", serverName);
        try {
            String version = SamUtil.getAPIVersion(serverName);
            this.wizardModel.setValue("SERVER_VERSION", version);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), this.getClass(), "initializeWizard", "Unable to retrieve server version", serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    private void updateWizardPages() {
        boolean dumpOn = false;
        boolean isTapeCopy = false;
        String dumpLocation = "";
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2001);
            }
            dumpOn = appModel.isDumpOn();
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            dumpLocation = sysModel.getDefaultDumpPath();
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "getWizardPages", "Failed to initialize System Model", this.getServerName());
        }
        if (TAPE.equals((String)this.wizardModel.getValue(MEDIA_TYPE))) {
            isTapeCopy = true;
        }
        if (dumpOn) {
            this.wizardModel.setValue("DUMP", "on");
            this.wizardModel.setValue("SaveRadioButton", "save");
            this.wizardModel.setValue("LOCATION", dumpLocation);
            this.wizardModel.setValue("SaveTextField", dumpLocation);
            this.pages = isTapeCopy ? NewCopyWizardImplData.TapePrefOn : NewCopyWizardImplData.DiskPrefOn;
        } else {
            this.wizardModel.setValue("DUMP", "off");
            this.pages = isTapeCopy ? NewCopyWizardImplData.TapePrefOff : NewCopyWizardImplData.DiskPrefOff;
        }
        this.initializeWizardPages(this.pages);
    }

    public String[] getFuturePages(String currentPageId) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering getFuturePages(): currentPageId is ").append(currentPageId).toString());
        int page = this.pageIdToPage(currentPageId) + 1;
        String[] futurePages = null;
        if (page - 1 == 0) {
            futurePages = new String[]{};
        } else {
            int howMany = this.pages.length - page;
            futurePages = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                futurePages[i] = Integer.toString(page + i + 1);
            }
        }
        TraceUtil.trace3("Exiting");
        return futurePages;
    }

    public String[] getFutureSteps(String currentPageId) {
        TraceUtil.trace3("Entering getFutureSteps()");
        int page = this.pageIdToPage(currentPageId);
        String[] futureSteps = null;
        if (page == 0) {
            futureSteps = new String[]{};
        } else {
            int howMany = this.pages.length - page - 1;
            futureSteps = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                int futurePage = this.pages[page + i + 1];
                futureSteps[i] = this.stepText[futurePage];
            }
        }
        TraceUtil.trace3("Exiting");
        return futureSteps;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        super.nextStep(wizardEvent);
        this.wizardInitialized = true;
        int id = this.pageIdToPage(wizardEvent.getPageId());
        switch (this.pages[id]) {
            case 0: {
                return this.processCopyMediaPage(wizardEvent);
            }
            case 1: {
                return this.processTapeCopyOptionsPage(wizardEvent);
            }
            case 2: {
                return this.processDiskCopyOptionsPage(wizardEvent);
            }
            case 3: {
                return this.processSavePage(wizardEvent, true);
            }
        }
        return true;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Calling previousStep");
        super.previousStep(wizardEvent);
        int id = this.pageIdToPage(wizardEvent.getPageId());
        switch (this.pages[id]) {
            case 1: {
                return this.processLockandIgnoreRecycle(wizardEvent, true);
            }
            case 2: {
                return this.processLockandIgnoreRecycle(wizardEvent, false);
            }
            case 3: {
                return this.processSavePage(wizardEvent, false);
            }
        }
        return true;
    }

    public boolean finishStep(WizardEvent event) {
        boolean result = true;
        boolean warningException = false;
        String errMsg = null;
        String errCode = null;
        String warningSummary = null;
        if (!super.finishStep(event)) {
            return true;
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            String dumpOn = (String)this.wizardModel.getValue("DUMP");
            if (dumpOn != null && dumpOn.equals("on")) {
                String path = (String)this.wizardModel.getValue("LOCATION");
                sysModel.setDumpPath(path);
            }
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(this.getPolicyName());
            ArchiveCopyGUIWrapper wrapper = this.getArchiveCopyGUIWrapper();
            ArchiveVSNMap vsnMap = wrapper.getArchiveCopy().getArchiveVSNMap();
            int mediaType = vsnMap.getArchiveMediaType();
            String version = (String)this.wizardModel.getValue("SERVER_VERSION");
            String selectedVSN = (String)this.wizardModel.getValue("selected_vsn_radio");
            boolean isNewDiskVSN = "newdiskvsn".equals(selectedVSN);
            if ("1.3".compareTo(version) <= 0 && mediaType == 133 && isNewDiskVSN) {
                String name = (String)this.wizardModel.getValue("name");
                String host = (String)this.wizardModel.getValue("host");
                String path = (String)this.wizardModel.getValue("path");
                String currentServer = (String)this.wizardModel.getValue("SERVER_NAME");
                if (currentServer.equals(host)) {
                    host = null;
                }
                sysModel.getSamQFSSystemMediaManager().createDiskVSN(name, host, path);
                vsnMap.setMapExpression(name);
            }
            vsnMap.setWillBeSaved(true);
            thePolicy.addArchiveCopy(wrapper);
        }
        catch (SamFSWarnings sfw) {
            result = false;
            warningException = true;
            warningSummary = "ArchiveConfig.error";
            errMsg = "ArchiveConfig.warning.detail";
        }
        catch (SamFSMultiMsgException sfme) {
            result = false;
            warningException = true;
            warningSummary = "ArchiveConfig.error";
            errMsg = "ArchiveConfig.warning.detail";
        }
        catch (SamFSException samEx) {
            result = false;
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "finishStep", "Failed to create new copy", this.getServerName());
            errMsg = samEx.getMessage();
            errCode = Integer.toString(samEx.getSAMerrno());
        }
        if (result) {
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", "ArchivePolCopy.action.add");
        } else if (warningException) {
            this.wizardModel.setValue("Finish_result", "Warning");
            this.wizardModel.setValue("WizardResultAlertSummary", warningSummary);
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
        } else {
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "ArchivePolCopy.error.add");
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
            this.wizardModel.setValue("Detail_code", errCode);
        }
        return true;
    }

    private boolean processLockandIgnoreRecycle(WizardEvent wizardEvent, boolean isTapeCopy) {
        String lockCheckBox;
        TraceUtil.trace3("Entering");
        ArchiveCopyGUIWrapper wrapper = this.getArchiveCopyGUIWrapper();
        ArchiveCopy copy = wrapper.getArchiveCopy();
        if (!isTapeCopy) {
            String ignoreRecycling = (String)this.wizardModel.getValue("IgnoreRecyclingCheckBox");
            boolean isIgnore = ignoreRecycling.equals("true");
            copy.setIgnoreRecycle(isIgnore);
        }
        boolean locked = (lockCheckBox = (String)this.wizardModel.getValue("LockCheckBox")).equals("true");
        copy.setBufferLocked(locked);
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processCopyMediaPage(WizardEvent event) {
        TraceUtil.trace3("Entering");
        ArchiveCopyGUIWrapper wrapper = this.getArchiveCopyGUIWrapper();
        String version = (String)this.wizardModel.getValue("SERVER_VERSION");
        if ("1.3".compareTo(version) <= 0) {
            CopyMediaValidator validator = new CopyMediaValidator(this.wizardModel, event, wrapper);
            boolean result = validator.validate();
            this.wizardModel.setValue("ArchiveAge", validator.getSummaryArchiveAge());
            this.wizardModel.setValue("ArchiveType", validator.getSummaryArchiveType());
            this.wizardModel.setValue("DiskVSN", validator.getSummaryDiskVSNName());
            this.wizardModel.setValue("DiskArchivePath", validator.getSummaryDiskVSNPath());
            this.wizardModel.setValue("VSNPoolName", validator.getSummaryVSNPoolName());
            this.wizardModel.setValue("SpecifyVSN", validator.getSummarySpecifiedVSNs());
            this.wizardModel.setValue("Reserve", validator.getSummaryRMString());
            this.updateWizardPages();
            return result;
        }
        String archiveAge = (String)this.wizardModel.getValue("ArchiveAgeTextField");
        if (archiveAge == null || archiveAge.trim().length() == 0) {
            this.saveCopyMediaRadioButtonSetting();
            event.setSeverity(0);
            event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAgeNegInt");
            return false;
        }
        long age = -1L;
        try {
            age = Long.parseLong(archiveAge);
            if (age < 0L) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAgeNegInt");
                return false;
            }
            wrapper.getArchivePolCriteriaCopy().setArchiveAge(age);
        }
        catch (NumberFormatException nfe) {
            this.saveCopyMediaRadioButtonSetting();
            event.setSeverity(0);
            event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAge");
            return false;
        }
        String ageUnit = (String)this.wizardModel.getValue("ArchiveAgeDropDown");
        if (SelectableGroupHelper.NOVAL.equals(ageUnit)) {
            this.saveCopyMediaRadioButtonSetting();
            event.setSeverity(0);
            event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAgeDropDown");
            return false;
        }
        wrapper.getArchivePolCriteriaCopy().setArchiveAgeUnit(Integer.parseInt(ageUnit));
        this.wizardModel.setValue("ArchiveAge", new NonSyncStringBuffer().append(age).append(" ").append(this.getTimeUnitString(Integer.parseInt(ageUnit))));
        String mediaRadio = (String)this.wizardModel.getValue("MedTypeRadio1");
        if (mediaRadio == null) {
            event.setSeverity(0);
            event.setErrorMessage("NewArchivePolWizard.page3.errMsg1");
            return false;
        }
        this.wizardModel.setValue(MEDIA_TYPE, mediaRadio);
        this.wizardModel.setValue("ArchiveType", mediaRadio);
        ArchiveVSNMap vsnMap = wrapper.getArchiveCopy().getArchiveVSNMap();
        if (mediaRadio.equals(DISK)) {
            String diskVolume = (String)this.wizardModel.getValue("DiskVolumeNameTextField");
            if (diskVolume == null || diskVolume.trim().length() == 0) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errDiskParam");
                return false;
            }
            if (diskVolume.trim().indexOf(" ") != -1) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errInvalidDiskVolumeName");
                return false;
            }
            wrapper.getArchiveCopy().setDiskArchiveVSN(diskVolume.trim());
            this.wizardModel.setValue("DiskVSN", diskVolume.trim());
            vsnMap.setArchiveMediaType(-1);
            String diskDevice = (String)this.wizardModel.getValue("DiskDeviceTextField");
            String createPath = (String)this.wizardModel.getValue("createPath");
            if (diskDevice == null || diskDevice.trim().length() == 0) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errDiskParam");
                return false;
            }
            if (!SamUtil.isWellFormedPath(diskDevice)) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errInvalidDiskDeviceName");
                return false;
            }
            if (diskDevice.trim().charAt(0) != '/') {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errInvalidAbsoluteDiskDeviceName");
                return false;
            }
            String serverName = this.getServerName();
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
                if (!createPath.equals("true") && !sysModel.doesFileExist(diskDevice)) {
                    event.setSeverity(0);
                    event.setErrorMessage("archiving.diskvsn.newvsn.error.pathnonexistent");
                    return false;
                }
            }
            catch (SamFSException sfe) {
                TraceUtil.trace1("SamFSException caught while retrieving vsn path");
                SamUtil.processException((Exception)((Object)sfe), this.getClass(), "processCopyMediaParameters", "Error retrieving disk vsn path", serverName);
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", sfe.getMessage());
                this.wizardModel.setValue("ERROR_CODE", Integer.toString(sfe.getSAMerrno()));
            }
            wrapper.getArchiveCopy().setDiskArchiveVSNPath(diskDevice.trim());
            this.wizardModel.setValue("DiskArchivePath", diskDevice.trim());
            this.wizardModel.setValue("MediaType", "");
            this.wizardModel.setValue("VSNPoolName", "");
            this.wizardModel.setValue("SpecifyVSN", "");
        } else if (mediaRadio.equals(TAPE)) {
            String rmFS;
            String rmPolicy;
            String mediaType = (String)this.wizardModel.getValue("TapeDropDown");
            if (mediaType.equals("--")) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errMediaType");
                return false;
            }
            vsnMap.setArchiveMediaType(SamUtil.getMediaType(mediaType));
            this.wizardModel.setValue("MediaType", mediaType);
            String vsnPool = (String)this.wizardModel.getValue("VSNPoolDropDownMenu");
            String startVSN = (String)this.wizardModel.getValue("StartTextField");
            startVSN = startVSN != null ? startVSN.trim() : "";
            String endVSN = (String)this.wizardModel.getValue("EndTextField");
            endVSN = endVSN != null ? endVSN.trim() : "";
            String vsnRange = (String)this.wizardModel.getValue("RangeTextField");
            String string = vsnRange = vsnRange != null ? vsnRange.trim() : "";
            if ((vsnPool == null || vsnPool.equals("--")) && (startVSN.equals("") || endVSN.equals("")) && vsnRange.equals("")) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errMediaTypeParam");
                return false;
            }
            boolean vpool = false;
            boolean sevsn = false;
            boolean rvsn = false;
            if (vsnPool != null && !vsnPool.equals("--")) {
                try {
                    SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                    VSNPool pool = sysModel.getSamQFSSystemArchiveManager43().getVSNPool(vsnPool);
                    if (pool.getMediaType() != SamUtil.getMediaType(mediaType)) {
                        event.setSeverity(0);
                        event.setErrorMessage("NewArchivePolWizard.page3.errVSNPoolMediaType");
                        return false;
                    }
                    vsnMap.setPoolExpression(vsnPool);
                    this.wizardModel.setValue("VSNPoolName", vsnPool);
                    vpool = true;
                }
                catch (SamFSException sfe) {
                    TraceUtil.trace1("SamFSException caught when retrieving Pool information");
                    SamUtil.processException((Exception)((Object)sfe), this.getClass(), "processCopyMediaParameters", "Retrieving Pool information", this.getServerName());
                    this.wizardModel.setValue("ERROR", "Yes");
                    this.wizardModel.setValue("ERROR_MSGS", sfe.getMessage());
                    this.wizardModel.setValue("ERROR_CODE", Integer.toString(sfe.getSAMerrno()));
                    return true;
                }
            }
            if (!startVSN.equals("") && !endVSN.equals("")) {
                if (!SamUtil.isValidVSNString(startVSN)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewArchivePolWizard.page3.errStartInvalidVSN");
                    return false;
                }
                if (!SamUtil.isValidVSNString(endVSN)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewArchivePolWizard.page3.errEndInvalidVSN");
                    return false;
                }
                vsnMap.setMapExpressionStartVSN(startVSN);
                vsnMap.setMapExpressionEndVSN(endVSN);
                sevsn = true;
            }
            if (!vsnRange.equals("")) {
                vsnMap.setMapExpression(vsnRange);
                rvsn = true;
            }
            this.wizardModel.setValue("SpecifyVSN", this.getSpecifyVSNString(startVSN, endVSN, vsnRange));
            if (!(vpool || sevsn || rvsn)) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page3.errMediaTypeParam");
                return false;
            }
            wrapper.getArchiveCopy().setDiskArchiveVSNPath("");
            wrapper.getArchiveCopy().setDiskArchiveVSNPath("");
            wrapper.getArchiveCopy().setDiskArchiveVSNHost("");
            this.wizardModel.setValue("DiskVSN", "");
            this.wizardModel.setValue("DiskArchivePath", "");
            ArchiveCopy copy = wrapper.getArchiveCopy();
            ReservationMethodHelper rmh = new ReservationMethodHelper();
            NonSyncStringBuffer summaryRM = new NonSyncStringBuffer();
            String rmAttributes = (String)this.wizardModel.getValue("rmAttributes");
            if (!rmAttributes.equals(SelectableGroupHelper.NOVAL)) {
                rmh.setAttributes(Integer.parseInt(rmAttributes));
            }
            if ("true".equals(rmPolicy = (String)this.wizardModel.getValue("rmPolicy"))) {
                rmh.setSet(1);
                summaryRM.append(SamUtil.getResourceString("archiving.reservation.method.policy")).append(" | ");
            }
            if ("true".equals(rmFS = (String)this.wizardModel.getValue("rmFS"))) {
                rmh.setFS(4);
                summaryRM.append(SamUtil.getResourceString("archiving.reservation.method.fs")).append(" | ");
            }
            switch (rmh.getAttributes()) {
                case 8: {
                    summaryRM.append(SamUtil.getResourceString("archiving.reservation.method.dir")).append(" | ");
                    break;
                }
                case 16: {
                    summaryRM.append(SamUtil.getResourceString("archiving.reservation.method.user")).append(" | ");
                    break;
                }
                case 32: {
                    summaryRM.append(SamUtil.getResourceString("archiving.reservation.method.group")).append(" | ");
                    break;
                }
            }
            copy.setReservationMethod(rmh.getValue());
            String temp = summaryRM.toString().trim();
            if (temp.length() > 0) {
                temp = temp.substring(0, temp.length() - 1);
            }
            this.wizardModel.setValue("Reserve", temp);
        }
        this.updateWizardPages();
        this.wizardModel.setValue(COPY_GUIWRAPPER, wrapper);
        return true;
    }

    private boolean processTapeCopyOptionsPage(WizardEvent event) {
        ArchiveCopyGUIWrapper wrapper = this.getArchiveCopyGUIWrapper();
        ArchiveCopy copy = wrapper.getArchiveCopy();
        String offlineCopyString = (String)this.wizardModel.getValue("OfflineCopyDropDown");
        if (!SelectableGroupHelper.NOVAL.equals(offlineCopyString)) {
            copy.setOfflineCopyMethod(Integer.parseInt(offlineCopyString));
        } else {
            copy.setOfflineCopyMethod(-1);
        }
        this.wizardModel.setValue("OfflineCopy", this.getOfflineCopyString(Integer.parseInt(offlineCopyString)));
        String drives = (String)this.wizardModel.getValue("DrivesTextField");
        String string = drives = drives != null ? drives.trim() : "";
        if (!drives.equals("")) {
            try {
                int d = Integer.parseInt(drives);
                if (d < 0) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.drives");
                    return false;
                }
                copy.setDrives(d);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.drives");
                return false;
            }
        } else {
            copy.setDrives(-1);
        }
        String drivesMin = ((String)this.wizardModel.getValue("DrivesMinTextField")).trim();
        String drivesMax = ((String)this.wizardModel.getValue("DrivesMaxTextField")).trim();
        drivesMin = drivesMin != null ? drivesMin.trim() : "";
        String string2 = drivesMax = drivesMax != null ? drivesMax.trim() : "";
        if (!drivesMin.equals("") && drivesMax.equals("")) {
            event.setSeverity(0);
            event.setErrorMessage("NewPolicyWizard.copyoption.error.minmaxeither");
            return false;
        }
        if (drivesMin.equals("") && !drivesMax.equals("")) {
            event.setSeverity(0);
            event.setErrorMessage("NewPolicyWizard.copyoption.error.minmaxeither");
            return false;
        }
        if (!drivesMin.equals("") && !drivesMax.equals("")) {
            String drivesMinSizeUnit = (String)this.wizardModel.getValue("DrivesMinSizeDropDown");
            boolean mn = false;
            boolean mnu = false;
            boolean mx = false;
            boolean mxu = false;
            long min = -1L;
            int minu = -1;
            long max = -1L;
            int maxu = -1;
            try {
                min = Long.parseLong(drivesMin);
                if (min < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.mindrives");
                    return false;
                }
                mn = true;
                if (SelectableGroupHelper.NOVAL.equals(drivesMinSizeUnit)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.mindrivesunit");
                    return false;
                }
                minu = Integer.parseInt(drivesMinSizeUnit);
                mnu = true;
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.mindrives");
                return false;
            }
            String drivesMaxSizeUnit = (String)this.wizardModel.getValue("DrivesMaxSizeDropDown");
            try {
                max = Long.parseLong(drivesMax);
                if (max < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.maxdrives");
                    return false;
                }
                mx = true;
                if (SelectableGroupHelper.NOVAL.equals(drivesMaxSizeUnit)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.maxdrivesunit");
                    return false;
                }
                maxu = Integer.parseInt(drivesMaxSizeUnit);
                mxu = true;
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.maxdrives");
                return false;
            }
            if (!PolicyUtil.isMaxGreaterThanMin(min, minu, max, maxu)) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.mingreaterthanmax");
                return false;
            }
            copy.setMinDrives(min);
            copy.setMinDrivesUnit(minu);
            copy.setMaxDrives(max);
            copy.setMaxDrivesUnit(maxu);
            this.wizardModel.setValue("MaxDrive", new NonSyncStringBuffer().append(max).append(" ").append(SamUtil.getSizeUnitL10NString(maxu)).toString());
            this.wizardModel.setValue("MinDrive", new NonSyncStringBuffer().append(min).append(" ").append(SamUtil.getSizeUnitL10NString(minu)).toString());
        } else {
            copy.setMinDrives(-1L);
            copy.setMinDrivesUnit(-1);
            copy.setMaxDrives(-1L);
            copy.setMaxDrivesUnit(-1);
            this.wizardModel.setValue("MaxDrive", "");
            this.wizardModel.setValue("MinDrive", "");
        }
        String bufferSize = (String)this.wizardModel.getValue("BufferSizeTextField");
        String string3 = bufferSize = bufferSize != null ? bufferSize.trim() : "";
        if (!bufferSize.equals("")) {
            try {
                int size = Integer.parseInt(bufferSize);
                if (size < 2 || size > 1024) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.buffersize");
                    return false;
                }
                copy.setBufferSize(size);
                String lockCheckBox = (String)this.wizardModel.getValue("LockCheckBox");
                boolean locked = lockCheckBox.equals("true");
                copy.setBufferLocked(locked);
                this.wizardModel.setValue("BufferSize", bufferSize);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.buffersize");
                return false;
            }
        } else {
            copy.setBufferSize(-1);
            this.wizardModel.setValue("BufferSize", "");
        }
        String startAge = (String)this.wizardModel.getValue("StartAgeTextField");
        String string4 = startAge = startAge != null ? startAge.trim() : "";
        if (!startAge.equals("")) {
            try {
                long age = Long.parseLong(startAge);
                if (age < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startage");
                    return false;
                }
                String startAgeUnit = (String)this.wizardModel.getValue("StartAgeDropDown");
                if (startAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startageunit");
                    return false;
                }
                int ageUnit = Integer.parseInt(startAgeUnit);
                copy.setStartAge(age);
                copy.setStartAgeUnit(ageUnit);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.startage");
                return false;
            }
        } else {
            copy.setStartAge(-1L);
            copy.setStartAgeUnit(-1);
        }
        String startCount = (String)this.wizardModel.getValue("StartCountTextField");
        String string5 = startCount = startCount != null ? startCount.trim() : "";
        if (!startCount.equals("")) {
            try {
                int count = Integer.parseInt(startCount);
                if (count < 0) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startcount");
                    return false;
                }
                copy.setStartCount(count);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.startcount");
                return false;
            }
        } else {
            copy.setStartCount(-1);
        }
        String startSize = (String)this.wizardModel.getValue("StartSizeTextField");
        String string6 = startSize = startSize != null ? startSize.trim() : "";
        if (!startSize.equals("")) {
            try {
                long size = Long.parseLong(startSize);
                if (size < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startsize");
                    return false;
                }
                String startSizeUnit = (String)this.wizardModel.getValue("StartSizeDropDown");
                if (startSizeUnit.equals(SelectableGroupHelper.NOVAL)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startsizeunit");
                    return false;
                }
                int sizeUnit = Integer.parseInt(startSizeUnit);
                copy.setStartSize(size);
                copy.setStartSizeUnit(sizeUnit);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.startsize");
                return false;
            }
        } else {
            copy.setStartSize(-1L);
            copy.setStartSizeUnit(-1);
        }
        this.wizardModel.setValue(COPY_GUIWRAPPER, wrapper);
        return true;
    }

    private boolean processDiskCopyOptionsPage(WizardEvent event) {
        String minGain;
        ArchiveCopyGUIWrapper wrapper = this.getArchiveCopyGUIWrapper();
        ArchiveCopy copy = wrapper.getArchiveCopy();
        String offlineCopyString = (String)this.wizardModel.getValue("OfflineCopyDropDown");
        if (offlineCopyString.equals(SelectableGroupHelper.NOVAL)) {
            copy.setOfflineCopyMethod(-1);
        } else {
            int ocMethod = Integer.parseInt(offlineCopyString);
            copy.setOfflineCopyMethod(ocMethod);
            this.wizardModel.setValue("OfflineCopy", this.getOfflineCopyString(Integer.parseInt(offlineCopyString)));
        }
        String bufferSize = (String)this.wizardModel.getValue("BufferSizeTextField");
        String string = bufferSize = bufferSize != null ? bufferSize.trim() : "";
        if (!bufferSize.equals("")) {
            try {
                int size = Integer.parseInt(bufferSize);
                if (size < 2 || size > 1024) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.buffersize");
                    return false;
                }
                copy.setBufferSize(size);
                this.wizardModel.setValue("BufferSize", bufferSize);
                String lockCheckBox = (String)this.wizardModel.getValue("LockCheckBox");
                boolean locked = lockCheckBox.equals("true");
                copy.setBufferLocked(locked);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.buffersize");
                return false;
            }
        } else {
            copy.setBufferSize(-1);
            this.wizardModel.setValue("BufferSize", "");
        }
        String startAge = (String)this.wizardModel.getValue("StartAgeTextField");
        String string2 = startAge = startAge != null ? startAge.trim() : "";
        if (!startAge.equals("")) {
            try {
                long age = Long.parseLong(startAge);
                if (age < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startage");
                    return false;
                }
                String startAgeUnit = (String)this.wizardModel.getValue("StartAgeDropDown");
                if (startAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startageunit");
                    return false;
                }
                int ageUnit = Integer.parseInt(startAgeUnit);
                copy.setStartAge(age);
                copy.setStartAgeUnit(ageUnit);
                this.wizardModel.setValue("StartAge", new NonSyncStringBuffer().append(age).append(" ").append(this.getTimeUnitString(ageUnit)).toString());
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.startage");
                return false;
            }
        } else {
            copy.setStartAge(-1L);
            copy.setStartAgeUnit(-1);
            this.wizardModel.setValue("StartAge", "");
        }
        String startCount = (String)this.wizardModel.getValue("StartCountTextField");
        String string3 = startCount = startCount != null ? startCount.trim() : "";
        if (!startCount.equals("")) {
            try {
                int count = Integer.parseInt(startCount);
                if (count < 0) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startcount");
                    return false;
                }
                copy.setStartCount(count);
                this.wizardModel.setValue("StartCount", startCount);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.startcount");
                return false;
            }
        } else {
            copy.setStartCount(-1);
            this.wizardModel.setValue("StartCount", "");
        }
        String startSize = (String)this.wizardModel.getValue("StartSizeTextField");
        String string4 = startSize = startSize != null ? startSize.trim() : "";
        if (!startSize.equals("")) {
            try {
                long size = Long.parseLong(startSize);
                if (size < 0L) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startsize");
                    return false;
                }
                String startSizeUnit = (String)this.wizardModel.getValue("StartSizeDropDown");
                if (startSizeUnit.equals(SelectableGroupHelper.NOVAL)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.startsizeunit");
                    return false;
                }
                int sizeUnit = Integer.parseInt(startSizeUnit);
                copy.setStartSize(size);
                copy.setStartSizeUnit(sizeUnit);
                this.wizardModel.setValue("StartSize", new NonSyncStringBuffer().append(startSize).append(" ").append(SamUtil.getSizeUnitL10NString(sizeUnit)).toString());
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.startsize");
                return false;
            }
        } else {
            copy.setStartSize(-1L);
            copy.setStartSizeUnit(-1);
            this.wizardModel.setValue("StartSize", "");
        }
        String recycleHwm = (String)this.wizardModel.getValue("RecycleHwmTextField");
        String string5 = recycleHwm = recycleHwm != null ? recycleHwm.trim() : "";
        if (!recycleHwm.equals("")) {
            try {
                int hwm = Integer.parseInt(recycleHwm);
                if (hwm > 100 || hwm < 0) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewArchivePolWizard.page5.errRecycleHwm");
                    return false;
                }
                copy.setRecycleHWM(hwm);
                this.wizardModel.setValue("RecycleHWM", recycleHwm);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page5.errRecycleHwm");
                return false;
            }
        } else {
            copy.setRecycleHWM(-1);
            this.wizardModel.setValue("RecycleHWM", "");
        }
        String ignoreRecycling = (String)this.wizardModel.getValue("IgnoreRecyclingCheckBox");
        boolean isIgnore = ignoreRecycling.equals("true");
        copy.setIgnoreRecycle(isIgnore);
        String mailAddress = (String)this.wizardModel.getValue("mailAddress");
        String string6 = mailAddress = mailAddress != null ? mailAddress.trim() : "";
        if (mailAddress.indexOf(" ") != -1) {
            event.setSeverity(0);
            event.setErrorMessage("NewArchivePolWizard.page5.errMailingAddress");
            return false;
        }
        if (!mailAddress.equals("")) {
            copy.setNotificationAddress(mailAddress);
        }
        String string7 = minGain = (minGain = (String)this.wizardModel.getValue("MinGainTextField")) != null ? minGain.trim() : "";
        if (!minGain.equals("")) {
            try {
                int gain = Integer.parseInt(minGain);
                if (gain > 100 || gain < 0) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewPolicyWizard.copyoption.error.mingain");
                    return false;
                }
                copy.setMinGain(gain);
            }
            catch (NumberFormatException nfe) {
                event.setSeverity(0);
                event.setErrorMessage("NewPolicyWizard.copyoption.error.mingain");
                return false;
            }
        } else {
            copy.setMinGain(-1);
        }
        this.wizardModel.setValue(COPY_GUIWRAPPER, wrapper);
        return true;
    }

    private boolean processSavePage(WizardEvent event, boolean isNextStep) {
        String saveRadio = (String)this.wizardModel.getValue("SaveRadioButton");
        String dumpPath = (String)this.wizardModel.getValue("SaveTextField");
        String string = dumpPath = dumpPath != null ? dumpPath.trim() : "";
        if (!isNextStep) {
            if (saveRadio != null) {
                if (saveRadio.equals("NewArchivePolWizard.page7.commit")) {
                    this.wizardModel.setValue("DUMP", "off");
                } else {
                    this.wizardModel.setValue("DUMP", "on");
                    this.wizardModel.setValue("LOCATION", dumpPath);
                }
            }
        } else {
            if (saveRadio == null) {
                event.setSeverity(0);
                event.setErrorMessage("NewArchivePolWizard.page7.errMsg2");
                return false;
            }
            if (saveRadio.equals("NewArchivePolWizard.page7.commit")) {
                this.wizardModel.setValue("DUMP", "off");
                this.wizardModel.setValue("SaveMethod", SamUtil.getResourceString("NewArchivePolWizard.page7.commit"));
            } else {
                if (dumpPath.equals("")) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewArchivePolWizard.page7.errMsg1");
                    return false;
                }
                if (!SamUtil.isValidNonSpecialCharString(dumpPath)) {
                    event.setSeverity(0);
                    event.setErrorMessage("NewArchivePolWizard.page7.errMsg3");
                    return false;
                }
                this.wizardModel.setValue("DUMP", "on");
                this.wizardModel.setValue("LOCATION", dumpPath);
                this.wizardModel.setValue("SaveMethod", new NonSyncStringBuffer(SamUtil.getResourceString("NewArchivePolWizard.page7.save")).append(" ").append(dumpPath));
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public ArchiveCopyGUIWrapper getArchiveCopyGUIWrapper() {
        ArchiveCopyGUIWrapper wrapper = (ArchiveCopyGUIWrapper)this.wizardModel.getValue(COPY_GUIWRAPPER);
        if (wrapper == null) {
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                wrapper = sysModel.getSamQFSSystemArchiveManager43().getArchiveCopyGUIWrapper();
                this.wizardModel.setValue(COPY_GUIWRAPPER, wrapper);
            }
            catch (SamFSException sfe) {
                SamUtil.processException((Exception)((Object)sfe), this.getClass(), "getArchiveCopyGUIWrapper", "Failed to to retrieve copy gui wrapper", this.getServerName());
            }
        }
        return wrapper;
    }

    public void closeStep(WizardEvent wizardEvent) {
        TraceUtil.trace2("Clearing out wizard model...");
        this.wizardModel.clear();
        TraceUtil.trace2("Done!");
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        this.wizardModel.setValue("ERROR", "No");
        this.wizardModel.clear();
        return true;
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        if (this.wizardInitialized) {
            this.wizardModel.setValue("ERROR", "No");
        }
        String version = (String)this.wizardModel.getValue("SERVER_VERSION");
        if (page == 0 && "1.3".compareTo(version) <= 0) {
            return class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView == null ? (class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView = NewCopyWizardImpl.class$("com.sun.netstorage.samqfs.web.archive.wizards.CopyMediaParametersView")) : class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView;
        }
        return super.getPageClass(pageId);
    }

    private String getTimeUnitString(int value) {
        switch (value) {
            case 5: {
                return SamUtil.getResourceString("ArchiveSetup.seconds");
            }
            case 6: {
                return SamUtil.getResourceString("ArchiveSetup.minutes");
            }
            case 7: {
                return SamUtil.getResourceString("ArchiveSetup.hours");
            }
            case 8: {
                return SamUtil.getResourceString("ArchiveSetup.days");
            }
            case 9: {
                return SamUtil.getResourceString("ArchiveSetup.weeks");
            }
        }
        return "";
    }

    private String getReservationString(int value) {
        switch (value) {
            case 14: {
                return SamUtil.getResourceString("NewArchivePolWizard.page4.reserveOption1");
            }
            case 15: {
                return SamUtil.getResourceString("NewArchivePolWizard.page4.reserveOption2");
            }
            case 16: {
                return SamUtil.getResourceString("NewArchivePolWizard.page4.reserveOption3");
            }
            case 17: {
                return SamUtil.getResourceString("NewArchivePolWizard.page4.reserveOption4");
            }
            case 18: {
                return SamUtil.getResourceString("NewArchivePolWizard.page4.reserveOption5");
            }
        }
        return "";
    }

    private String getOfflineCopyString(int value) {
        switch (value) {
            case 5: {
                return SamUtil.getResourceString("NewPolicyWizard.tapecopyoption.offlineCopy.direct");
            }
            case 6: {
                return SamUtil.getResourceString("NewPolicyWizard.tapecopyoption.offlineCopy.stageAhead");
            }
            case 7: {
                return SamUtil.getResourceString("NewPolicyWizard.tapecopyoption.offlineCopy.stageAll");
            }
        }
        return "NewPolicyWizard.tapecopyoption.offlineCopy.default";
    }

    private String getSpecifyVSNString(String startVSN, String endVSN, String vsnRange) {
        NonSyncStringBuffer returnStringBuffer = new NonSyncStringBuffer();
        if (startVSN != null && endVSN != null && startVSN.length() != 0 && endVSN.length() != 0) {
            returnStringBuffer.append(SamUtil.getResourceString("NewPolicyWizard.specifyVSN", new String[]{startVSN, endVSN}));
        }
        if (vsnRange != null && vsnRange.length() != 0) {
            if (returnStringBuffer.length() != 0) {
                returnStringBuffer.append(", ");
            }
            return returnStringBuffer.append(vsnRange).toString();
        }
        return returnStringBuffer.toString();
    }

    private void saveCopyMediaRadioButtonSetting() {
        String mediaRadio = (String)this.wizardModel.getValue("MedTypeRadio1");
        if (mediaRadio != null) {
            this.wizardModel.setValue(MEDIA_TYPE, mediaRadio);
        }
    }

    private String getServerName() {
        String serverName = (String)this.wizardModel.getValue("SERVER_NAME");
        return serverName == null ? "" : serverName;
    }

    private String getPolicyName() {
        String policyName = (String)this.wizardModel.getValue("SAMQFS_POLICY_NAME");
        return policyName == null ? "" : policyName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

