/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.CopyOptionsViewBase;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.ReservationMethodHelper;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import java.util.List;

public class TapeCopyOptionsView
extends CopyOptionsViewBase {
    private static final String PS_XML = "/jsp/archive/TapeCopyOptionsPropertySheet.xml";
    private static String[] sizeDropDowns = new String[]{"minOverflowUnit", "maxSizePerDriveUnit", "maxSizeForArchiveUnit", "multiDriveTriggerUnit", "startSizeUnit", "recycleSizeUnit"};

    public TapeCopyOptionsView(View parent, String name) {
        super(parent, PS_XML, name);
    }

    protected void initializeDropDownMenus() {
        for (int i = 0; i < sizeDropDowns.length; ++i) {
            CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild(sizeDropDowns[i]);
            dropDown.setOptions(new OptionList(SelectableGroupHelper.Sizes.labels, SelectableGroupHelper.Sizes.values));
        }
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("rmAttribute");
        dropDown.setOptions(new OptionList(SelectableGroupHelper.ReservationMethod.labels, SelectableGroupHelper.ReservationMethod.values));
        dropDown = (CCDropDownMenu)this.getChild("sortMethod");
        dropDown.setOptions(new OptionList(SelectableGroupHelper.SortMethod.labels, SelectableGroupHelper.SortMethod.values));
        dropDown = (CCDropDownMenu)this.getChild("unarchiveTimeRef");
        dropDown.setOptions(new OptionList(SelectableGroupHelper.UATimeReference.labels, SelectableGroupHelper.UATimeReference.values));
        dropDown = (CCDropDownMenu)this.getChild("offlineMethod");
        dropDown.setOptions(new OptionList(SelectableGroupHelper.OfflineCopyMethod.labels, SelectableGroupHelper.OfflineCopyMethod.values));
        dropDown = (CCDropDownMenu)this.getChild("startAgeUnit");
        dropDown.setOptions(new OptionList(SelectableGroupHelper.Times.labels, SelectableGroupHelper.Times.values));
    }

    public void loadCopyOptions() throws SamFSException {
        this.loadCommonCopyOptions();
        ArchiveCopy theCopy = this.getCurrentArchiveCopy();
        String serverName = ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
        ArchiveVSNMap vsnMap = theCopy.getArchiveVSNMap();
        if (vsnMap == null) {
            vsnMap = PolicyUtil.getAllsetsCopyVSNMap(theCopy, serverName);
        }
        CCStaticTextField text = (CCStaticTextField)this.getChild("mediaType");
        text.setValue((Object)SamUtil.getMediaTypeString(vsnMap.getArchiveMediaType()));
        int reservationMethod = theCopy.getReservationMethod();
        ReservationMethodHelper rmh = new ReservationMethodHelper();
        rmh.setValue(reservationMethod);
        CCCheckBox checkBox = (CCCheckBox)this.getChild("rmPolicy");
        String rmPolicy = rmh.getSet() == 1 ? "true" : "false";
        checkBox.setValue((Object)rmPolicy);
        checkBox = (CCCheckBox)this.getChild("rmFileSystem");
        String rmFS = rmh.getFS() == 4 ? "true" : "false";
        checkBox.setValue((Object)rmFS);
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("rmAttribute");
        dropDown.setValue((Object)Integer.toString(rmh.getAttributes()));
        CCTextField textField = (CCTextField)this.getChild("drivesToUse");
        int maxDrives = theCopy.getDrives();
        if (maxDrives != -1) {
            textField.setValue((Object)Integer.toString(maxDrives));
        }
        long maxPerDrive = theCopy.getMaxDrives();
        dropDown = (CCDropDownMenu)this.getChild("maxSizePerDriveUnit");
        if (maxPerDrive != -1L) {
            textField = (CCTextField)this.getChild("maxSizePerDrive");
            textField.setValue((Object)Long.toString(maxPerDrive));
            dropDown.setValue((Object)Integer.toString(theCopy.getMaxDrivesUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(2));
        }
        long multiDriveTrigger = theCopy.getMinDrives();
        dropDown = (CCDropDownMenu)this.getChild("multiDriveTriggerUnit");
        if (multiDriveTrigger != -1L) {
            textField = (CCTextField)this.getChild("multiDriveTrigger");
            textField.setValue((Object)Long.toString(multiDriveTrigger));
            dropDown.setValue((Object)Integer.toString(theCopy.getMinDrivesUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(2));
        }
        long maxOverflow = theCopy.getOverflowMinSize();
        dropDown = (CCDropDownMenu)this.getChild("minOverflowUnit");
        if (maxOverflow != -1L) {
            textField = (CCTextField)this.getChild("minOverflow");
            textField.setValue((Object)Long.toString(maxOverflow));
            dropDown.setValue((Object)Integer.toString(theCopy.getOverflowMinSizeUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(2));
        }
        long recyclerDataSize = theCopy.getRecycleDataSize();
        dropDown = (CCDropDownMenu)this.getChild("recycleSizeUnit");
        if (recyclerDataSize != -1L) {
            textField = (CCTextField)this.getChild("recycleSize");
            textField.setValue((Object)Long.toString(recyclerDataSize));
            dropDown.setValue((Object)Integer.toString(theCopy.getRecycleDataSizeUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(2));
        }
        int vsnCount = theCopy.getMaxVSNCount();
        if (vsnCount != -1) {
            textField = (CCTextField)this.getChild("maxVSNCount");
            textField.setValue((Object)Integer.toString(vsnCount));
        }
    }

    public List validateCopyOptions() throws SamFSException {
        List errors;
        ArchiveCopy theCopy;
        block39: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                theCopy = this.getCurrentArchiveCopy();
                                errors = super.validateCommonCopyOptions();
                                ReservationMethodHelper rmh = new ReservationMethodHelper();
                                int attributes = Integer.parseInt(this.getDisplayFieldStringValue("rmAttribute"));
                                if (attributes > 0) {
                                    rmh.setAttributes(attributes);
                                }
                                if (this.getDisplayFieldStringValue("rmPolicy").equals("true")) {
                                    rmh.setSet(1);
                                }
                                if (this.getDisplayFieldStringValue("rmFileSystem").equals("true")) {
                                    rmh.setFS(4);
                                }
                                theCopy.setReservationMethod(rmh.getValue());
                                String maxDriveString = this.getDisplayFieldStringValue("drivesToUse");
                                String string = maxDriveString = maxDriveString == null ? "" : maxDriveString.trim();
                                if (!maxDriveString.equals("")) {
                                    CCLabel label = (CCLabel)this.getChild("drivesToUse".concat("Label"));
                                    try {
                                        int maxDrives = Integer.parseInt(maxDriveString);
                                        if (maxDrives > 0) {
                                            theCopy.setDrives(maxDrives);
                                            break block34;
                                        }
                                        errors.add("archiving.error.drives");
                                        label.setShowError(true);
                                    }
                                    catch (NumberFormatException nfe) {
                                        errors.add("archiving.error.drives");
                                        label.setShowError(true);
                                    }
                                } else {
                                    theCopy.setDrives(-1);
                                }
                            }
                            String maxPerDriveString = this.getDisplayFieldStringValue("maxSizePerDrive");
                            String string = maxPerDriveString = maxPerDriveString == null ? "" : maxPerDriveString.trim();
                            if (!maxPerDriveString.equals("")) {
                                CCLabel label = (CCLabel)this.getChild("maxSizePerDrive".concat("Label"));
                                try {
                                    long maxPerDrive = Long.parseLong(maxPerDriveString);
                                    int maxPerDriveUnit = Integer.parseInt(this.getDisplayFieldStringValue("maxSizePerDriveUnit"));
                                    if (PolicyUtil.isValidSize(maxPerDrive, maxPerDriveUnit)) {
                                        theCopy.setMaxDrives(maxPerDrive);
                                        theCopy.setMaxDrivesUnit(maxPerDriveUnit);
                                        break block35;
                                    }
                                    errors.add("archiving.error.drivesmax");
                                    label.setShowError(true);
                                }
                                catch (NumberFormatException nfe) {
                                    errors.add("archiving.error.drivesmax");
                                    label.setShowError(true);
                                }
                            } else {
                                theCopy.setMaxDrives(-1L);
                                theCopy.setMaxDrivesUnit(-1);
                            }
                        }
                        String driveTriggerString = this.getDisplayFieldStringValue("multiDriveTrigger");
                        String string = driveTriggerString = driveTriggerString == null ? "" : driveTriggerString.trim();
                        if (!driveTriggerString.equals("")) {
                            CCLabel label = (CCLabel)this.getChild("multiDriveTrigger".concat("Label"));
                            try {
                                long driveTrigger = Long.parseLong(driveTriggerString);
                                int driveTriggerUnit = Integer.parseInt(this.getDisplayFieldStringValue("multiDriveTriggerUnit"));
                                if (PolicyUtil.isValidSize(driveTrigger, driveTriggerUnit)) {
                                    theCopy.setMinDrives(driveTrigger);
                                    theCopy.setMinDrivesUnit(driveTriggerUnit);
                                    break block36;
                                }
                                errors.add("archiving.error.drivesmin");
                                label.setShowError(true);
                            }
                            catch (NumberFormatException nfe) {
                                errors.add("archiving.error.drivesmin");
                                label.setShowError(true);
                            }
                        } else {
                            theCopy.setMinDrives(-1L);
                            theCopy.setMinDrivesUnit(-1);
                        }
                    }
                    String minOverflowString = this.getDisplayFieldStringValue("minOverflow");
                    String string = minOverflowString = minOverflowString == null ? "" : minOverflowString.trim();
                    if (!minOverflowString.equals("")) {
                        CCLabel label = (CCLabel)this.getChild("minOverflow".concat("Label"));
                        try {
                            long minOverflow = Long.parseLong(minOverflowString);
                            int minOverflowUnit = Integer.parseInt(this.getDisplayFieldStringValue("minOverflowUnit"));
                            if (PolicyUtil.isValidSize(minOverflow, minOverflowUnit)) {
                                theCopy.setOverflowMinSize(minOverflow);
                                theCopy.setOverflowMinSizeUnit(minOverflowUnit);
                                break block37;
                            }
                            errors.add("archiving.error.overflowmin");
                            label.setShowError(true);
                        }
                        catch (NumberFormatException nfe) {
                            errors.add("archiving.error.overflowmin");
                            label.setShowError(true);
                        }
                    } else {
                        theCopy.setOverflowMinSize(-1L);
                        theCopy.setOverflowMinSizeUnit(-1);
                    }
                }
                String dataSizeString = this.getDisplayFieldStringValue("recycleSize");
                String string = dataSizeString = dataSizeString == null ? "" : dataSizeString.trim();
                if (!dataSizeString.equals("")) {
                    CCLabel label = (CCLabel)this.getChild("recycleSize".concat("Label"));
                    try {
                        long dataSize = Long.parseLong(dataSizeString);
                        int dataSizeUnit = Integer.parseInt(this.getDisplayFieldStringValue("recycleSizeUnit"));
                        if (PolicyUtil.isValidSize(dataSize, dataSizeUnit)) {
                            theCopy.setRecycleDataSize(dataSize);
                            theCopy.setRecycleDataSizeUnit(dataSizeUnit);
                            break block38;
                        }
                        errors.add("archiving.error.recyclequantity");
                        label.setShowError(true);
                    }
                    catch (NumberFormatException nfew) {
                        errors.add("archiving.error.recyclequantity");
                        label.setShowError(true);
                    }
                } else {
                    theCopy.setRecycleDataSize(-1L);
                    theCopy.setRecycleDataSizeUnit(-1);
                }
            }
            String maxVSNString = this.getDisplayFieldStringValue("maxVSNCount");
            String string = maxVSNString = maxVSNString == null ? "" : maxVSNString.trim();
            if (!maxVSNString.equals("")) {
                CCLabel label = (CCLabel)this.getChild("maxVSNCount".concat("Label"));
                try {
                    int vsnCount = Integer.parseInt(maxVSNString);
                    if (vsnCount <= 0) {
                        errors.add("ArchivePolCopy.error.maxVSNCount");
                        label.setShowError(true);
                        break block39;
                    }
                    theCopy.setMaxVSNCount(vsnCount);
                }
                catch (NumberFormatException nfe) {
                    errors.add("ArchivePolCopy.error.maxVSNCount");
                    label.setShowError(true);
                }
            } else {
                theCopy.setMaxVSNCount(-1);
            }
        }
        if (errors.size() == 0) {
            ArchivePolicy thePolicy = theCopy.getArchivePolicy();
            thePolicy.updatePolicy();
        }
        return errors;
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        this.initializeDropDownMenus();
    }

    public String getPageletUrl() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        Integer copyMediaType = (Integer)parent.getPageSessionAttribute("SAMQFS_copy_media_type");
        if (copyMediaType != 133) {
            return "/jsp/archive/TapeCopyOptionsPagelet.jsp";
        }
        return "/jsp/archive/BlankPagelet.jsp";
    }
}

