/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.DiskVSNSummaryViewBean;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;

public class DiskVSNSummaryView
extends CommonTableContainerView {
    private CCActionTableModel model = null;

    public DiskVSNSummaryView(View view, String name) {
        super(view, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "DiskVSNSummaryTable";
        this.createTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren(this.model);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        return super.createChild(this.model, name);
    }

    private void createTableModel() {
        TraceUtil.trace3("Entering");
        this.model = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/DiskVSNSummaryTable.xml");
        TraceUtil.trace3("Exiting");
    }

    private void initializeColumnHeaders() {
        TraceUtil.trace3("Entering");
        this.model.setActionValue("NewDiskVSN", (Object)"archiving.new");
        this.model.setActionValue("RemoveDiskVSN", (Object)"archiving.remove");
        this.model.setActionValue("EditMediaFlags", (Object)"archiving.diskvsn.edit.flags");
        this.model.setActionValue("vsnNameColumn", (Object)"archiving.diskvsn.name");
        this.model.setActionValue("vsnPathColumn", (Object)"archiving.diskvsn.path");
        this.model.setActionValue("vsnHostColumn", (Object)"archiving.diskvsn.host");
        this.model.setActionValue("usageColumn", (Object)"common.capacity.usage");
        this.model.setActionValue("flagsColumn", (Object)"archiving.diskvsn.flags");
        TraceUtil.trace3("Exiting");
    }

    public void populateTableModel() {
        TraceUtil.trace3("Entering");
        DiskVSNSummaryViewBean parent = (DiskVSNSummaryViewBean)this.getParentViewBean();
        String serverName = parent.getServerName();
        NonSyncStringBuffer vsns = new NonSyncStringBuffer();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            DiskVolume[] diskVolumes = sysModel.getSamQFSSystemMediaManager().getDiskVSNs();
            for (int i = 0; i < diskVolumes.length; ++i) {
                String hostName;
                if (i > 0) {
                    this.model.appendRow();
                }
                if (serverName.equals(hostName = diskVolumes[i].getRemoteHost()) || hostName == null || hostName.length() <= 0) {
                    hostName = SamUtil.getResourceString("archiving.diskvsn.currentserver", serverName);
                }
                this.model.setValue("vsnName", (Object)diskVolumes[i].getName());
                this.model.setValue("hiddenVSNName", (Object)diskVolumes[i].getName());
                this.model.setValue("vsnHost", (Object)hostName);
                this.model.setValue("vsnPath", (Object)diskVolumes[i].getPath());
                long capacity = diskVolumes[i].getCapacityKB();
                long free = diskVolumes[i].getAvailableSpaceKB();
                int percentUsed = PolicyUtil.getPercentUsage(capacity, free);
                String imagePath = "/samqfsui/images/samqfs_blank.gif";
                if (percentUsed != -1) {
                    imagePath = "/samqfsui/images/usagebar/".concat(Integer.toString(percentUsed)).concat(".gif");
                }
                this.model.setValue("UsageImage", (Object)imagePath);
                String capacityText = "(".concat(new Capacity(capacity, 1).toString()).concat(")");
                this.model.setValue("CapacityText", (Object)capacityText);
                this.model.setValue("flagsHref", (Object)diskVolumes[i].getName());
                this.model.setValue("flags", (Object)this.getFlagString(diskVolumes[i]));
                vsns.append(diskVolumes[i].getName()).append(";");
                this.model.setRowSelected(i, false);
            }
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "Unable to retrieve disk vsns", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "archiving.diskvsn.load.error", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        CCHiddenField field = (CCHiddenField)parent.getChild("vsns");
        field.setValue((Object)vsns.toString());
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeColumnHeaders();
        CCButton editMediaFlags = (CCButton)this.getChild("EditMediaFlags");
        editMediaFlags.setDisabled(true);
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            ((CCButton)this.getChild("NewDiskVSN")).setDisabled(true);
            this.model.setSelectionType("none");
        }
        TraceUtil.trace3("Exiting");
    }

    private String getFlagString(DiskVolume vsn) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        int count = 0;
        if (vsn.isBadMedia()) {
            buffer.append(SamUtil.getResourceString("archiving.diskvsn.flags.badmedia"));
            ++count;
        }
        if (vsn.isUnavailable()) {
            if (count > 0) {
                buffer.append(" ...");
                return buffer.toString();
            }
            buffer.append(SamUtil.getResourceString("archiving.diskvsn.flags.unavailable"));
            ++count;
        }
        if (vsn.isReadOnly()) {
            if (count > 0) {
                buffer.append(" ...");
                return buffer.toString();
            }
            buffer.append(SamUtil.getResourceString("archiving.diskvsn.flags.readonly"));
            ++count;
        }
        if (vsn.isLabeled()) {
            if (count > 0) {
                buffer.append(" ...");
                return buffer.toString();
            }
            buffer.append(SamUtil.getResourceString("archiving.diskvsn.flags.labeled"));
            ++count;
        }
        if (vsn.isUnknown()) {
            if (count > 0) {
                buffer.append(" ...");
                return buffer.toString();
            }
            buffer.append(SamUtil.getResourceString("archiving.diskvsn.flags.unknown"));
            ++count;
        }
        if (vsn.isRemote()) {
            if (count > 0) {
                buffer.append(" ...");
                return buffer.toString();
            }
            buffer.append(SamUtil.getResourceString("archiving.diskvsn.flags.remote"));
            ++count;
        }
        return buffer.toString();
    }
}

