/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.CopySettingsTiledView;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCPagelet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;

public class CopySettingsView
extends CommonTableContainerView
implements CCPagelet {
    public static final String TILED_VIEW = "CopySettingsTiledView";
    private CCActionTableModel tableModel = null;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$CopySettingsTiledView;

    public CopySettingsView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "CopySettingsTable";
        this.createTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$CopySettingsTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$CopySettingsTiledView = CopySettingsView.class$("com.sun.netstorage.samqfs.web.archive.CopySettingsTiledView")) : class$com$sun$netstorage$samqfs$web$archive$CopySettingsTiledView);
        super.registerChildren(this.tableModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(TILED_VIEW)) {
            return new CopySettingsTiledView((View)this, this.tableModel, name);
        }
        return super.createChild(this.tableModel, name, TILED_VIEW);
    }

    private void createTableModel() {
        this.tableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/CopySettingsTable.xml");
    }

    private void initializeTableHeaders() {
        this.tableModel.setActionValue("CopyNumber", (Object)"archiving.policy.copy.number");
        this.tableModel.setActionValue("ArchiveAge", (Object)"archiving.archiveage");
        this.tableModel.setActionValue("UnarchiveAge", (Object)"archiving.unarchiveage");
        this.tableModel.setActionValue("ReleaseOptions", (Object)"archiving.releaseoptions");
        this.tableModel.setActionValue("Save", (Object)"archiving.save");
        this.tableModel.setActionValue("Reset", (Object)"archiving.reset");
    }

    public void populateTableModel() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        Integer criteriaNumber = (Integer)parent.getPageSessionAttribute("SAMQFS_criteria_number");
        Integer policyType = (Integer)parent.getPageSessionAttribute("SAMQFS_policy_type");
        if (criteriaNumber == null && policyType == 1001) {
            criteriaNumber = new Integer(0);
            parent.setPageSessionAttribute("SAMQFS_criteria_number", criteriaNumber);
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            SamQFSSystemArchiveManager43 manager = sysModel.getSamQFSSystemArchiveManager43();
            manager.getAllArchivePolicies();
            ArchivePolicy thePolicy = manager.getArchivePolicy(policyName);
            ArchivePolCriteria theCriteria = thePolicy.getArchivePolCriteria(criteriaNumber);
            ArchivePolCriteriaCopy[] copies = theCriteria.getArchivePolCriteriaCopies();
            this.tableModel.clear();
            for (int i = 0; i < copies.length; ++i) {
                if (i > 0) {
                    this.tableModel.appendRow();
                }
                this.tableModel.setValue("CopyNumberText", (Object)SamUtil.getResourceString("archiving.copynumber", Integer.toString(copies[i].getArchivePolCriteriaCopyNumber())));
                this.tableModel.setValue("CopyNumberHidden", (Object)Integer.toString(copies[i].getArchivePolCriteriaCopyNumber()));
                if (copies[i].getArchiveAge() >= 0L) {
                    this.tableModel.setValue("ArchiveAgeText", (Object)Long.toString(copies[i].getArchiveAge()));
                }
                this.tableModel.setValue("ArchiveAgeUnits", (Object)Integer.toString(copies[i].getArchiveAgeUnit()));
                if (copies[i].getUnarchiveAge() >= 0L) {
                    this.tableModel.setValue("UnarchiveAgeText", (Object)Long.toString(copies[i].getUnarchiveAge()));
                }
                this.tableModel.setValue("UnarchiveAgeUnits", (Object)Integer.toString(copies[i].getUnarchiveAgeUnit()));
                int releaseOptions = 0;
                if (copies[i].isNoRelease()) {
                    releaseOptions += 4;
                }
                if (copies[i].isRelease()) {
                    releaseOptions += 2;
                }
                this.tableModel.setValue("ReleaseOptionsText", (Object)Integer.toString(releaseOptions));
            }
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "populateTableModels", "Unable to populate tables", serverName);
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModels", "Unable to populate tables", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", SamUtil.getResourceString("-2020"), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
    }

    public void handleSaveRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        Integer criteriaNumber = (Integer)parent.getPageSessionAttribute("SAMQFS_criteria_number");
        ArrayList<String> errors = new ArrayList<String>();
        ArchivePolCriteriaCopy criteriaCopy = null;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            ArchivePolCriteria theCriteria = thePolicy.getArchivePolCriteria(criteriaNumber);
            CCActionTable table = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
            table.restoreStateData();
            CCActionTableModel model = (CCActionTableModel)table.getModel();
            int rowCount = model.getNumRows();
            block14: for (int i = 0; i < rowCount; ++i) {
                model.setRowIndex(i);
                String s = (String)model.getValue("CopyNumberHidden");
                long archiveAge = -1L;
                int archiveAgeUnit = -1;
                long unarchiveAge = -1L;
                int unarchiveAgeUnit = -1;
                boolean copyValid = true;
                String archiveAgeStr = (String)model.getValue("ArchiveAgeText");
                String string = archiveAgeStr = archiveAgeStr != null ? archiveAgeStr.trim() : "";
                if (!archiveAgeStr.equals("")) {
                    try {
                        archiveAge = Long.parseLong(archiveAgeStr);
                        if (archiveAge < 0L) {
                            copyValid = false;
                            errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        copyValid = false;
                        errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                    }
                } else {
                    copyValid = false;
                    errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.missing", SamUtil.getResourceString("archiving.copynumber", s)));
                }
                String archiveAgeUnitStr = (String)model.getValue("ArchiveAgeUnits");
                archiveAgeUnit = Integer.parseInt(archiveAgeUnitStr);
                String unarchiveAgeStr = (String)model.getValue("UnarchiveAgeText");
                String unarchiveAgeUnitStr = (String)model.getValue("UnarchiveAgeUnits");
                String string2 = unarchiveAgeStr = unarchiveAgeStr != null ? unarchiveAgeStr.trim() : "";
                if (!unarchiveAgeStr.equals("")) {
                    try {
                        unarchiveAge = Long.parseLong(unarchiveAgeStr);
                        if (unarchiveAge < 0L) {
                            copyValid = false;
                            errors.add(SamUtil.getResourceString("archiving.criteriacopy.unarchiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        copyValid = false;
                        errors.add(SamUtil.getResourceString("archiving.criteriacopy.unarchiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                    }
                }
                unarchiveAgeUnit = Integer.parseInt(unarchiveAgeUnitStr);
                String releaseOptionsStr = (String)model.getValue("ReleaseOptionsText");
                if (!copyValid) continue;
                int copyNumber2 = Integer.parseInt(s);
                criteriaCopy = PolicyUtil.getArchivePolCriteriaCopy(theCriteria, copyNumber2);
                criteriaCopy.setArchiveAge(archiveAge);
                criteriaCopy.setArchiveAgeUnit(archiveAgeUnit);
                criteriaCopy.setUnarchiveAge(unarchiveAge);
                criteriaCopy.setUnarchiveAgeUnit(unarchiveAgeUnit);
                int options = Integer.parseInt(releaseOptionsStr);
                switch (options) {
                    case 0: {
                        criteriaCopy.setNoRelease(false);
                        criteriaCopy.setRelease(false);
                        continue block14;
                    }
                    case 2: {
                        criteriaCopy.setNoRelease(false);
                        criteriaCopy.setRelease(true);
                        continue block14;
                    }
                    case 4: {
                        criteriaCopy.setNoRelease(true);
                        criteriaCopy.setRelease(false);
                        continue block14;
                    }
                }
            }
            if (errors.size() > 0) {
                NonSyncStringBuffer buffer = new NonSyncStringBuffer();
                Iterator it = errors.iterator();
                buffer.append("<uL>");
                while (it.hasNext()) {
                    buffer.append("<li>");
                    buffer.append(it.next()).append("<br>");
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
                SamUtil.setErrorAlert((ContainerView)parent, "Alert", "archiving.copysettings.validation.error", -2022, buffer.toString(), serverName);
            } else {
                thePolicy.updatePolicy();
                String ci = SamUtil.getResourceString("archiving.criterianumber", new String[]{criteriaNumber.toString()});
                SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("archiving.copysettings.save.success", new String[]{ci}));
            }
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "handleSaveRequest", "Unable to save copy settings", serverName);
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "handleSaveRequest", "Unable to save copy settings", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchiveConfig.error", smme.getSAMerrno(), "ArchiveConfig.error.detail", serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleSaveRequest", "Unable to save copy settings", serverName);
            String[] temp1 = new String[]{criteriaNumber.toString()};
            String[] temp2 = new String[]{SamUtil.getResourceString("archiving.criterianumber", temp1)};
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", SamUtil.getResourceString("archiving.copysettings.save.failure", temp2), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        catch (ModelControlException mce) {
            SamUtil.processException((Exception)((Object)mce), ((Object)((Object)this)).getClass(), "handleSaveRequest", "Unable to save copy settings", serverName);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        this.initializeTableHeaders();
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            ((CCButton)this.getChild("Save")).setDisabled(true);
            ((CCButton)this.getChild("Reset")).setDisabled(true);
        }
    }

    public String getPageletUrl() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        Integer type = (Integer)parent.getPageSessionAttribute("SAMQFS_policy_type");
        if (type == 1001) {
            return "/jsp/archive/CopySettingsPagelet.jsp";
        }
        return "/jsp/archive/BlankPagelet.jsp";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

