/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.event.TiledViewRequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.CommonTiledViewBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class ServerSelectionTiledView
extends CommonTiledViewBase {
    public static final String CHILD_ALARM_HREF = "AlarmHref";
    public static final String CHILD_SERVER_HREF = "ServerHref";
    public static final String CHILD_VERSION_HREF = "VersionHref";
    public static final String CHILD_DISK_CACHE_HREF = "DiskCacheHref";
    public static final String CHILD_MEDIA_CAPACITY_HREF = "MediaCapacityHref";
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$server$VersionHighlightViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean;

    public ServerSelectionTiledView(View parent, CCActionTableModel model, String name) {
        super(parent, model, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Exiting");
    }

    public void handleServerHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.handleForward(event, 0);
        TraceUtil.trace3("Exiting");
    }

    public void handleAlarmHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.handleForward(event, 1);
        TraceUtil.trace3("Exiting");
    }

    public void handleDiskCacheHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.handleForward(event, 2);
        TraceUtil.trace3("Exiting");
    }

    public void handleMediaCapacityHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.handleForward(event, 3);
        TraceUtil.trace3("Exiting");
    }

    public void handleVersionHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_VERSION_HREF);
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$server$VersionHighlightViewBean == null ? (class$com$sun$netstorage$samqfs$web$server$VersionHighlightViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.server.VersionHighlightViewBean")) : class$com$sun$netstorage$samqfs$web$server$VersionHighlightViewBean);
        BreadCrumbUtil.breadCrumbPathForward(this.getParentViewBean(), PageInfo.getPageInfo().getPageNumber(this.getParentViewBean().getName()));
        targetView.setPageSessionAttribute("PAGE_PATH", (Serializable)((Integer[])this.getParentViewBean().getPageSessionAttribute("PAGE_PATH")));
        targetView.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void handleForward(RequestInvocationEvent event, int choice) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.model.setRowIndex(((TiledViewRequestInvocationEvent)event).getTileNumber());
        ViewBean targetView = null;
        String str = null;
        String[] infoArray = ((String)this.model.getValue("HiddenInfo")).split("###");
        switch (choice) {
            case 0: {
                str = (String)this.getDisplayFieldValue(CHILD_SERVER_HREF);
                targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
                break;
            }
            case 1: {
                str = (String)this.getDisplayFieldValue(CHILD_ALARM_HREF);
                targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.alarms.CurrentAlarmSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean);
                break;
            }
            case 2: {
                str = (String)this.getDisplayFieldValue(CHILD_DISK_CACHE_HREF);
                targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
                break;
            }
            case 3: {
                str = (String)this.getDisplayFieldValue(CHILD_MEDIA_CAPACITY_HREF);
                targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean);
            }
        }
        switch (Integer.parseInt(infoArray[1])) {
            case 4: {
                this.executeDownRoutine(str);
                break;
            }
            case 5: {
                this.executeAccessDeniedRoutine(str);
                break;
            }
            case 6: {
                this.executeNotSupportedRoutine(str);
                break;
            }
            default: {
                this.executeRegularRoutine(str, targetView);
            }
        }
        TraceUtil.trace3("Exiting");
    }

    private SamQFSSystemModel getSystemModel(String str) throws ModelControlException {
        SamQFSSystemModel sysModel = null;
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            sysModel = appModel.getSamQFSSystemModel(str);
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1(new NonSyncStringBuffer("Exception occurred: ").append(samEx.getMessage()).toString());
            LogUtil.error(((Object)((Object)this)).getClass(), "handleForward", samEx.getMessage());
            throw new ModelControlException("Fatal Error occurred in handleForward(). Reason: " + samEx.getMessage());
        }
        return sysModel;
    }

    private void executeDownRoutine(String serverName) throws ModelControlException {
        boolean hasError = false;
        ViewBean targetView = null;
        SamQFSSystemModel sysModel = this.getSystemModel(serverName);
        try {
            SamUtil.doPrint(new NonSyncStringBuffer("Server is marked as DOWN already in the Server Selection ").append(" page. Attempt to reconnect to ").append(serverName).append("...").toString());
            sysModel.reconnect();
            hasError = sysModel.isDown();
        }
        catch (Exception e) {
            hasError = true;
        }
        if (!hasError) {
            TraceUtil.trace1("hasError: " + hasError);
            targetView = this.getParentViewBean();
        } else {
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean == null ? (class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.util.ErrorHandleViewBean")) : class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean);
            String errorMsgs = null;
            String errorDetails = null;
            SamUtil.doPrint(new NonSyncStringBuffer("Version Status: ").append(sysModel.getVersionStatus()).toString());
            switch (sysModel.getVersionStatus()) {
                case 1001: {
                    errorMsgs = SamUtil.getResourceString("ErrorHandle.alertElement2");
                    errorDetails = SamUtil.getServerDownMessage();
                    break;
                }
                case 1002: {
                    errorMsgs = SamUtil.getResourceString("ErrorHandle.alertElement3");
                    errorDetails = SamUtil.getResourceString("ErrorHandle.alertElementFailedDetail3");
                    break;
                }
                default: {
                    errorMsgs = SamUtil.getResourceString("ErrorHandle.alertElement3");
                    errorDetails = SamUtil.getResourceString("ErrorHandle.alertElementFailedDetail4");
                }
            }
            CCAlertInline alert = (CCAlertInline)targetView.getChild("Alert");
            alert.setSummary(errorMsgs);
            alert.setDetail("<br>" + errorDetails, (Object[])new String[]{serverName});
        }
        targetView.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)serverName));
        targetView.forwardTo(this.getRequestContext());
    }

    private void executeAccessDeniedRoutine(String serverName) throws ModelControlException {
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean == null ? (class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.util.ErrorHandleViewBean")) : class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean);
        CCAlertInline alert = (CCAlertInline)targetView.getChild("Alert");
        alert.setType("error");
        alert.setSummary(SamUtil.getResourceString("ErrorHandle.accessDeniedSummary", new String[]{serverName}));
        alert.setDetail("<br>" + SamUtil.getAccessDeniedMessage(), (Object[])new String[]{serverName});
        targetView.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)serverName));
        targetView.forwardTo(this.getRequestContext());
    }

    private void executeNotSupportedRoutine(String serverName) throws ModelControlException {
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean == null ? (class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.util.ErrorHandleViewBean")) : class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean);
        CCAlertInline alert = (CCAlertInline)targetView.getChild("Alert");
        alert.setType("error");
        String serverVersion = this.getSystemModel(serverName).getServerProductVersion();
        alert.setSummary(SamUtil.getResourceString("ErrorHandle.serverNotSupportedSummary", new String[]{serverName, serverVersion}));
        alert.setDetail("<br>" + SamUtil.getResourceString("ErrorHandle.serverNotSupportedDetail"), (Object[])new String[]{serverName});
        targetView.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)serverName));
        targetView.forwardTo(this.getRequestContext());
    }

    private void executeRegularRoutine(String serverName, ViewBean targetView) throws ModelControlException {
        boolean isDown = false;
        SamQFSSystemModel sysModel = this.getSystemModel(serverName);
        short licenseType = -1;
        String samfsServerAPIVersion = "1.3";
        try {
            isDown = sysModel.isDown();
            samfsServerAPIVersion = sysModel.getServerAPIVersion();
            samfsServerAPIVersion = samfsServerAPIVersion == null ? "1.3" : samfsServerAPIVersion;
            TraceUtil.trace1(new NonSyncStringBuffer().append("samfsServerAPIVersion: ").append(samfsServerAPIVersion).toString());
            licenseType = sysModel.getLicenseType();
        }
        catch (Exception ex) {
            TraceUtil.trace1(new NonSyncStringBuffer().append("Exception while trying to get license type").append(ex.getMessage() != null ? ex.getMessage() : "null").toString());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "executeRegularRoutine()", "Failed to retreive license from server", serverName);
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean == null ? (class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.util.ErrorHandleViewBean")) : class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean);
            CCAlertInline alert = (CCAlertInline)targetView.getChild("Alert");
            alert.setType("error");
            alert.setSummary(SamUtil.getResourceString("license.error", new String[]{serverName}));
            if (ex.getMessage() != null) {
                alert.setDetail(ex.getMessage());
            }
            targetView.forwardTo(this.getRequestContext());
            TraceUtil.trace3("Exiting");
            return;
        }
        if (isDown) {
            TraceUtil.trace1("Server " + serverName + " is now marked as down or has an error");
            targetView = this.getParentViewBean();
        } else if (licenseType != -1) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            Hashtable<String, ServerInfo> serverTable = (Hashtable<String, ServerInfo>)session.getAttribute("SAMFS_SERVER_INFO");
            if (serverTable == null) {
                serverTable = new Hashtable<String, ServerInfo>();
            }
            TraceUtil.trace2(new NonSyncStringBuffer("Got samfs license type: ").append((int)licenseType).toString());
            TraceUtil.trace2(new NonSyncStringBuffer("Got samfs server api version: ").append(samfsServerAPIVersion).toString());
            serverTable.put(serverName, new ServerInfo(serverName, samfsServerAPIVersion, licenseType));
            session.setAttribute("SAMFS_SERVER_INFO", serverTable);
            session.setAttribute("SERVER_NAME", (Object)serverName);
            TraceUtil.trace2(new NonSyncStringBuffer("Put Server information in session: ").append(serverTable.toString()).toString());
        } else {
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean == null ? (class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean = ServerSelectionTiledView.class$("com.sun.netstorage.samqfs.web.util.ErrorHandleViewBean")) : class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean);
            CCAlertInline alert = (CCAlertInline)targetView.getChild("Alert");
            alert.setType("error");
            alert.setSummary(SamUtil.getResourceString("license.error", new String[]{serverName}));
        }
        targetView.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)serverName));
        targetView.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

