/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemJobManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.GenericFileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.SharedMemberImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.SamfsckJobImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class FileSystemImpl
extends GenericFileSystemImpl
implements FileSystem {
    private int fsType = -1;
    private String fsTypeName = "unknown";
    private int archType = -1;
    private int equipOrdinal = -1;
    private int shareStatus = -1;
    private String serverName = new String();
    private int dauSize = -1;
    private GregorianCalendar timeAboveHWM = null;
    private GregorianCalendar dateCreated = null;
    private FileSystemMountProperties mountProps = null;
    private ArrayList metaDevices = new ArrayList();
    private ArrayList dataDevices = new ArrayList();
    private ArrayList stripedGrps = new ArrayList();
    private ArrayList archPolicies = new ArrayList();
    private ArrayList archPolCriteria = new ArrayList();
    private SamQFSSystemModelImpl model = null;
    private String logfile = new String();
    private static int immediateIndicator = 0;

    protected void setCapacity() {
        int i;
        if (this.dataDevices != null) {
            for (i = 0; i < this.dataDevices.size(); ++i) {
                this.capacity += ((DiskCache)this.dataDevices.get(i)).getCapacity();
            }
        }
        if (this.stripedGrps != null) {
            for (i = 0; i < this.stripedGrps.size(); ++i) {
                this.capacity += ((StripedGroup)this.stripedGrps.get(i)).getCapacity();
            }
        }
        this.capacity *= 1024L;
    }

    protected void setAvailableSpace() {
        int i;
        if (this.dataDevices != null) {
            for (i = 0; i < this.dataDevices.size(); ++i) {
                this.avail += ((DiskCache)this.dataDevices.get(i)).getAvailableSpace();
            }
        }
        if (this.stripedGrps != null) {
            for (i = 0; i < this.stripedGrps.size(); ++i) {
                this.avail += ((StripedGroup)this.stripedGrps.get(i)).getAvailableSpace();
            }
        }
        this.avail *= 1024L;
    }

    public FileSystemImpl() {
    }

    public FileSystemImpl(String name, int fsType, int archType, int equipOrdinal, String mountPoint, int state, int shareStatus, int dauSize, GregorianCalendar timeAboveHWM, GregorianCalendar dateCreated, FileSystemMountProperties mountProps, ArrayList metaDevices, ArrayList dataDevices, ArrayList stripedGrps, ArrayList archPolicies, ArrayList alarms, ArrayList jobs, String logfile) throws SamFSException {
        if (name == null || name == new String() || mountPoint == null || mountPoint == new String()) {
            throw new SamFSException("INVALID_FILE_SYSTEM");
        }
        this.name = name;
        this.fsType = fsType;
        this.archType = archType;
        this.equipOrdinal = equipOrdinal;
        this.mountPoint = mountPoint;
        this.state = state;
        this.shareStatus = shareStatus;
        this.dauSize = dauSize;
        this.timeAboveHWM = timeAboveHWM;
        this.dateCreated = dateCreated;
        this.mountProps = mountProps;
        this.metaDevices = metaDevices;
        this.dataDevices = dataDevices;
        this.stripedGrps = stripedGrps;
        this.archPolicies = archPolicies;
        this.setCapacity();
        this.setAvailableSpace();
        this.consumed = (int)((this.capacity - this.avail) * 100L / this.capacity);
    }

    public void setModel(SamQFSSystemModelImpl model) {
        this.model = model;
    }

    public int getFSTypeByProduct() {
        int type = 10;
        if (this.getFSType() == 0) {
            type = this.getArchivingType() == 2 ? 12 : 11;
        }
        return type;
    }

    public int getFSType() {
        return this.fsType;
    }

    public String getFSTypeName() {
        return this.fsTypeName;
    }

    public int getArchivingType() {
        return this.archType;
    }

    public int getEquipOrdinal() {
        return this.equipOrdinal;
    }

    public int getShareStatus() {
        int returnedStatus = this.shareStatus;
        if (this.shareStatus != -1 && this.shareStatus != 0) {
            returnedStatus = 1;
        }
        return returnedStatus;
    }

    public void setShareStatus(int shareStatus) {
        this.shareStatus = shareStatus;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getDAUSize() {
        return this.dauSize;
    }

    public GregorianCalendar getTimeAboveHWM() {
        return this.timeAboveHWM;
    }

    public void setTimeAboveHWM(GregorianCalendar timeAboveHWM) {
        this.timeAboveHWM = timeAboveHWM;
    }

    public GregorianCalendar getDateCreated() {
        return this.dateCreated;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public FileSystemMountProperties getMountProperties() {
        return this.mountProps;
    }

    public void setMountProperties(FileSystemMountProperties prop) {
        this.mountProps = prop;
        ((FileSystemMountPropertiesImpl)this.mountProps).setFileSystem(this);
    }

    public DiskCache[] getMetadataDevices() {
        DiskCache[] meta = null;
        if (this.metaDevices != null) {
            meta = this.metaDevices.toArray(new DiskCache[0]);
        }
        return meta;
    }

    private void addMetadataDevice(DiskCache disk) {
        if (this.metaDevices == null) {
            this.metaDevices = new ArrayList();
        }
        this.metaDevices.add(disk);
    }

    public DiskCache[] getDataDevices() {
        DiskCache[] data = null;
        if (this.dataDevices != null) {
            data = this.dataDevices.toArray(new DiskCache[0]);
        }
        return data;
    }

    private void addDataDevice(DiskCache disk) {
        if (this.dataDevices == null) {
            this.dataDevices = new ArrayList();
        }
        this.dataDevices.add(disk);
    }

    public StripedGroup[] getStripedGroups() {
        StripedGroup[] grp = null;
        if (this.stripedGrps != null) {
            grp = this.stripedGrps.toArray(new StripedGroup[0]);
        }
        return grp;
    }

    private void addStripedGroup(StripedGroup group) {
        if (this.stripedGrps == null) {
            this.stripedGrps = new ArrayList();
        }
        this.stripedGrps.add(group);
    }

    public void addJob(BaseJob job) {
    }

    public void removeJob(BaseJob job) {
    }

    public void changeMountOptions() throws SamFSException {
    }

    public void mount() throws SamFSException {
        this.state = 0;
    }

    public void unmount() throws SamFSException {
        this.state = 1;
    }

    public void stopFSArchive() throws SamFSException {
    }

    public void idleFSArchive() throws SamFSException {
    }

    public void runFSArchive() throws SamFSException {
    }

    public void grow(DiskCache[] metadata, DiskCache[] data, StripedGroup[] groups) throws SamFSException {
        int i;
        if (metadata != null) {
            for (i = 0; i < metadata.length; ++i) {
                this.addMetadataDevice(metadata[i]);
            }
        }
        if (data != null) {
            for (i = 0; i < data.length; ++i) {
                this.addDataDevice(data[i]);
            }
        }
        if (groups != null) {
            for (i = 0; i < groups.length; ++i) {
                this.addStripedGroup(groups[i]);
            }
        }
    }

    public long samfsck(boolean checkAndRepair, String logFilePath) throws SamFSException {
        long jobId = -1L;
        if (++immediateIndicator % 3 != 0) {
            BaseJobImpl job = new BaseJobImpl((int)(Math.random() * 100000.0), 0, 8, new String(), new GregorianCalendar(), new GregorianCalendar());
            SamfsckJobImpl jobS = new SamfsckJobImpl(job, this.getName(), "sysadmin");
            SamQFSSystemModel[] models = SamQFSFactory.getSamQFSAppModel().getAllSamQFSSystemModels();
            if (models != null) {
                for (int i = 0; i < models.length; ++i) {
                    ((SamQFSSystemJobManagerImpl)models[i].getSamQFSSystemJobManager()).addJob(jobS);
                }
            }
            jobId = job.getJobId();
        } else {
            immediateIndicator = 0;
        }
        return jobId;
    }

    public String getFsckLogfileLocation() {
        return this.logfile;
    }

    public void setFsckLogfileLocation(String logfile) {
        this.logfile = logfile;
    }

    public SharedMember getSharedMember() {
        String hostName = new String();
        String[] ipAddresses = new String[]{};
        if (this.model != null) {
            hostName = this.model.getHostname();
            ipAddresses = this.model.getIPAddresses();
        }
        int sVal = -1;
        switch (this.shareStatus) {
            case 1: {
                sVal = 0;
                break;
            }
            case 2: {
                sVal = 1;
                break;
            }
            case 3: {
                sVal = 2;
            }
        }
        boolean mounted = false;
        if (this.state == 0) {
            mounted = true;
        }
        return new SharedMemberImpl(hostName, ipAddresses, sVal, mounted);
    }

    public String toString() {
        int i;
        long capacity = 0L;
        long availSpace = 0L;
        int consumedSpace = 0;
        try {
            capacity = this.getCapacity();
            availSpace = this.getAvailableSpace();
            consumedSpace = this.getConsumedSpacePercentage();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Name: " + this.name + "\n");
        buf.append("FS Type: " + this.fsType + "\n");
        buf.append("Archiving Type: " + this.archType + "\n");
        buf.append("Equip Ordinal: " + this.equipOrdinal + "\n");
        buf.append("Mount Point: " + this.mountPoint + "\n");
        buf.append("State: " + this.state + "\n");
        buf.append("Share Status: " + this.shareStatus + "\n");
        buf.append("Capacity: " + capacity + "\n");
        buf.append("Available Space: " + availSpace + "\n");
        buf.append("Consumed Space: " + consumedSpace + "% \n");
        buf.append("DAU Size: " + this.dauSize + "\n");
        buf.append("Time Above HWM: " + SamQFSUtil.dateTime(this.timeAboveHWM) + "\n");
        buf.append("Date Created: " + SamQFSUtil.dateTime(this.dateCreated) + "\n");
        buf.append("Server Name: " + this.serverName + "\n");
        buf.append("Mount Properties: \n" + this.mountProps.toString() + "\n");
        try {
            if (this.metaDevices != null) {
                for (i = 0; i < this.metaDevices.size(); ++i) {
                    buf.append("Metadata Devices: \n" + ((DiskCache)this.metaDevices.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.dataDevices != null) {
                for (i = 0; i < this.dataDevices.size(); ++i) {
                    buf.append("Data Devices: \n" + ((DiskCache)this.dataDevices.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.stripedGrps != null) {
                for (int i2 = 0; i2 < this.stripedGrps.size(); ++i2) {
                    buf.append("Striped Groups: \n" + ((StripedGroup)this.stripedGrps.get(i2)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.archPolicies != null) {
                for (int i3 = 0; i3 < this.archPolicies.size(); ++i3) {
                    buf.append("Archive Policies For FS: \n" + ((ArchivePolicy)this.archPolicies.get(i3)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.archPolCriteria != null) {
                for (int i4 = 0; i4 < this.archPolCriteria.size(); ++i4) {
                    buf.append("Archive Policy Criteria For FS: \n" + ((ArchivePolCriteria)this.archPolCriteria.get(i4)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public ArchivePolCriteria[] getArchivePolCriteriaForFS() throws SamFSException {
        return this.archPolCriteria.toArray(new ArchivePolCriteria[0]);
    }

    public void addPolCriteria(ArchivePolCriteria[] newPolCriteriaList) throws SamFSException {
        if (newPolCriteriaList != null) {
            for (int i = 0; i < newPolCriteriaList.length; ++i) {
                int index = this.archPolCriteria.indexOf(newPolCriteriaList[i]);
                if (index == -1) {
                    this.archPolCriteria.add(newPolCriteriaList[i]);
                }
                if (((ArchivePolCriteriaImpl)newPolCriteriaList[i]).isFSPresent(this.getName())) continue;
                newPolCriteriaList[i].addFileSystemForCriteria(this.getName());
            }
        }
    }

    public void removePolCriteria(ArchivePolCriteria[] newPolCriteriaList) throws SamFSException {
        if (newPolCriteriaList != null) {
            for (int i = 0; i < newPolCriteriaList.length; ++i) {
                int index = this.archPolCriteria.indexOf(newPolCriteriaList[i]);
                if (index != -1) {
                    this.archPolCriteria.remove(index);
                }
                if (!((ArchivePolCriteriaImpl)newPolCriteriaList[i]).isFSPresent(this.getName())) continue;
                newPolCriteriaList[i].deleteFileSystemForCriteria(this.getName());
            }
        }
    }

    public void reorderPolCriteria(ArchivePolCriteria[] reorderedList) throws SamFSException {
        this.archPolCriteria.clear();
        if (reorderedList != null) {
            for (int i = 0; i < reorderedList.length; ++i) {
                this.archPolCriteria.add(i, reorderedList[i]);
            }
        }
    }

    public void changePolicyOrdering(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy policy, int targetPosition) throws SamFSException {
        if (policy == null) {
            throw new SamFSException("INVALID_POLICY");
        }
        if (this.archPolicies == null || this.archPolicies.size() == 0) {
            this.addPolicy(policy);
        } else {
            try {
                this.removePol(policy);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (targetPosition == -1 || targetPosition > this.archPolicies.size()) {
                targetPosition = this.archPolicies.size();
            } else if (--targetPosition < 0) {
                targetPosition = 0;
            }
            this.archPolicies.add(targetPosition, policy);
        }
    }

    public com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] getArchivePoliciesForFS() throws SamFSException {
        com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] pol = null;
        if (this.archPolicies != null) {
            pol = this.archPolicies.toArray(new com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[0]);
        }
        return pol;
    }

    public void addPolicies(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] policies) throws SamFSException {
        if (policies != null) {
            for (int i = 0; i < policies.length; ++i) {
                this.addPolicy(policies[i]);
            }
        }
    }

    public void removePolicies(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] policies) throws SamFSException {
        if (policies != null) {
            for (int i = 0; i < policies.length; ++i) {
                this.removePolicy(policies[i]);
            }
        }
    }

    public void addPolicy(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy pol) throws SamFSException {
        this.addPol(pol);
        ((ArchivePolicyImpl)pol).addFS(this);
    }

    public void removePolicy(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy pol) throws SamFSException {
        this.removePol(pol);
        ((ArchivePolicyImpl)pol).removeFS(this);
    }

    public void addPol(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy pol) throws SamFSException {
        if (this.archPolicies == null) {
            this.archPolicies = new ArrayList();
        }
        this.archPolicies.add(pol);
    }

    public void removePol(com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy pol) throws SamFSException {
        int index = this.archPolicies.indexOf(pol);
        if (index == -1) {
            throw new SamFSException("NO_SUCH_POLICY_MEMBERSHIP_FOUND");
        }
        this.archPolicies.remove(index);
    }

    public void removePol(String policyName) throws SamFSException {
        if (this.archPolicies != null) {
            for (int i = 0; i < this.archPolicies.size(); ++i) {
                com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy pol = (com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy)this.archPolicies.get(i);
                if (!pol.getPolicyName().equals(policyName)) continue;
                this.archPolicies.remove(i);
                break;
            }
        }
    }
}

