/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemJobManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import java.util.ArrayList;

public class SamQFSSystemJobManagerImpl
implements SamQFSSystemJobManager {
    SamQFSSystemModelImpl theModel;
    private ArrayList jobs = new ArrayList();
    private int timeInterval = 30;

    public SamQFSSystemJobManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public BaseJob[] getAllJobs() throws SamFSException {
        return this.jobs.toArray(new BaseJob[0]);
    }

    public BaseJob[] getJobsByType(int type) throws SamFSException {
        ArrayList specificJobs = new ArrayList();
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((BaseJob)this.jobs.get(i)).getType() != type) continue;
                specificJobs.add(this.jobs.get(i));
            }
        }
        return specificJobs.toArray(new BaseJob[0]);
    }

    public BaseJob[] getJobsByCondition(int condition) throws SamFSException {
        ArrayList specificJobs = new ArrayList();
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((BaseJob)this.jobs.get(i)).getCondition() != condition) continue;
                specificJobs.add(this.jobs.get(i));
            }
        }
        return specificJobs.toArray(new BaseJob[0]);
    }

    public BaseJob getJobById(long id) throws SamFSException {
        BaseJob job = null;
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((BaseJob)this.jobs.get(i)).getJobId() != id) continue;
                job = (BaseJob)this.jobs.get(i);
                break;
            }
        }
        return job;
    }

    public void cancelJob(BaseJob job) throws SamFSException {
        if (job == null) {
            throw new SamFSException("INVALID_JOB");
        }
        int index = this.jobs.indexOf(job);
        if (index != -1) {
            this.jobs.remove(index);
        }
    }

    public void addJob(BaseJob job) throws SamFSException {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        this.jobs.add(job);
    }

    public int getTimeInterval() throws SamFSException {
        return this.timeInterval;
    }

    public void setTimeInterval(int timeInterval) throws SamFSException {
        this.timeInterval = timeInterval;
    }

    protected void setJobs(ArrayList jobs) {
        this.jobs = jobs;
    }
}

