/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.media;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.StripedGrp;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;

public class StripedGroupImpl
extends BaseDeviceImpl
implements StripedGroup {
    private StripedGrp stripedGrp = null;
    private String name = new String();
    private DiskCache[] members = new DiskCache[0];
    private long capacity = -1L;
    private long availableSpace = -1L;
    private int consumedSpace = -1;

    public StripedGroupImpl() {
    }

    public StripedGroupImpl(String name, DiskCache[] members) throws SamFSException {
        this.name = name;
        this.members = members;
        this.compute();
        DiskDev[] disks = new DiskDev[members.length];
        for (int i = 0; i < members.length; ++i) {
            disks[i] = ((DiskCacheImpl)members[i]).getJniDisk();
        }
        this.stripedGrp = new StripedGrp(name, disks);
    }

    public StripedGroupImpl(StripedGrp grp) {
        this.stripedGrp = grp;
        this.name = grp.getName();
        DiskDev[] list = grp.getMembers();
        if (list != null) {
            this.members = new DiskCache[list.length];
            for (int i = 0; i < list.length; ++i) {
                this.members[i] = new DiskCacheImpl(list[i]);
            }
        }
        this.compute();
    }

    public StripedGrp getJniStripedGroup() {
        return this.stripedGrp;
    }

    public String getName() {
        return this.name;
    }

    public int getDiskCacheType() {
        int type = -1;
        if (this.members != null) {
            type = this.members[0].getDiskCacheType();
        }
        return type;
    }

    public DiskCache[] getMembers() {
        return this.members;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public int getConsumedSpacePercentage() {
        return this.consumedSpace;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name: " + this.name + "\n");
        buf.append("Disk Cache Information: " + this.name + "\n");
        if (this.members != null) {
            try {
                for (int i = 0; i < this.members.length; ++i) {
                    buf.append(this.members[i].toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("---- \n");
        buf.append("Capacity: " + this.capacity + "\n");
        buf.append("Available Space: " + this.availableSpace + "\n");
        buf.append("Consumed Space: " + this.consumedSpace + "% \n");
        return buf.toString();
    }

    private void compute() {
        this.capacity = 0L;
        this.availableSpace = 0L;
        for (int i = 0; i < this.members.length; ++i) {
            this.capacity += this.members[i].getCapacity();
            this.availableSpace += this.members[i].getAvailableSpace();
        }
        this.consumedSpace = 0;
        if (this.capacity > 0L) {
            this.consumedSpace = (int)((this.capacity - this.availableSpace) * 100L / this.capacity);
        }
    }
}

