/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.LibDev;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.mgmt.rec.LibRecParams;
import com.sun.netstorage.samqfs.mgmt.rec.Recycler;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.LibraryImpl;
import com.sun.netstorage.samqfs.web.model.media.Library;

public class RecycleParamsImpl
implements RecycleParams {
    private SamQFSSystemModelImpl model = null;
    private LibRecParams jniPrm = null;
    private String libPath = new String();
    private int hwm = -1;
    private int minGain = -1;
    private int vsnLimit = -1;
    private long sizeLimit = -1L;
    private int sizeUnit = -1;
    private boolean perform = false;

    public RecycleParamsImpl() {
    }

    public RecycleParamsImpl(Library library, int hwm, int minGain, int vsnLimit, long sizeLimit, int sizeUnit, boolean perform) {
        this.libPath = library.getDevicePath();
        this.hwm = hwm;
        this.minGain = minGain;
        this.vsnLimit = vsnLimit;
        this.sizeLimit = sizeLimit;
        this.sizeUnit = sizeUnit;
        this.perform = perform;
    }

    public RecycleParamsImpl(SamQFSSystemModelImpl model, LibRecParams jniPrm) {
        this.model = model;
        this.jniPrm = jniPrm;
        this.setup();
    }

    public Library getLibrary() throws SamFSException {
        LibDev jni;
        LibraryImpl lib = null;
        if (this.model != null && SamQFSUtil.isValidString(this.libPath) && (jni = Media.getLibraryByPath((Ctx)this.model.getJniContext(), (String)this.libPath)) != null) {
            lib = new LibraryImpl(this.model, jni);
        }
        return lib;
    }

    public String getLibraryName() {
        return this.libPath;
    }

    public int getHWM() throws SamFSException {
        return this.hwm;
    }

    public void setHWM(int hwm) throws SamFSException {
        this.hwm = hwm;
        if (this.jniPrm != null) {
            if (hwm != -1) {
                this.jniPrm.setHWM(hwm);
            } else {
                this.jniPrm.resetHWM();
            }
        }
    }

    public int getMinGain() throws SamFSException {
        return this.minGain;
    }

    public void setMinGain(int gain) throws SamFSException {
        this.minGain = gain;
        if (this.jniPrm != null) {
            if (gain != -1) {
                this.jniPrm.setMinGain(gain);
            } else {
                this.jniPrm.resetMinGain();
            }
        }
    }

    public int getVSNLimit() throws SamFSException {
        return this.vsnLimit;
    }

    public void setVSNLimit(int limit) throws SamFSException {
        this.vsnLimit = limit;
        if (this.jniPrm != null) {
            if (limit != -1) {
                this.jniPrm.setVSNCount(limit);
            } else {
                this.jniPrm.resetVSNCount();
            }
        }
    }

    public long getSizeLimit() throws SamFSException {
        return this.sizeLimit;
    }

    public void setSizeLimit(long limit) throws SamFSException {
        this.sizeLimit = limit;
        if (this.jniPrm != null) {
            if (limit != -1L) {
                if (this.sizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.sizeUnit);
                    this.jniPrm.setDatasize(SamQFSUtil.fsizeToString(new Long(limit).toString() + unit));
                }
            } else {
                this.jniPrm.resetDatasize();
            }
        }
    }

    public int getSizeUnit() throws SamFSException {
        return this.sizeUnit;
    }

    public void setSizeUnit(int unit) throws SamFSException {
        this.sizeUnit = unit;
        if (this.jniPrm != null) {
            if (unit != -1) {
                if (this.sizeLimit != -1L) {
                    String ut = SamQFSUtil.getUnitString(this.sizeUnit);
                    this.jniPrm.setDatasize(SamQFSUtil.fsizeToString(new Long(this.sizeLimit).toString() + ut));
                }
            } else {
                this.jniPrm.resetDatasize();
            }
        }
    }

    public boolean isPerform() throws SamFSException {
        return this.perform;
    }

    public void setPerform(boolean perform) throws SamFSException {
        this.perform = perform;
        if (this.jniPrm != null) {
            this.jniPrm.setIgnore(perform);
        }
    }

    public void changeParams() throws SamFSException {
        if (this.jniPrm != null) {
            Recycler.setLibRecParams((Ctx)this.model.getJniContext(), (LibRecParams)this.jniPrm);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Library: " + this.libPath + "\n");
        buf.append("HWM: " + this.hwm + "\n");
        buf.append("Min Gain: " + this.minGain + "\n");
        buf.append("VSN Limit: " + this.vsnLimit + "\n");
        buf.append("Size Limit: " + this.sizeLimit + "\n");
        buf.append("Perform: " + this.perform + "\n");
        return buf.toString();
    }

    private void setup() {
        if (this.jniPrm != null) {
            this.libPath = this.jniPrm.getPath();
            this.hwm = this.jniPrm.getHWM();
            this.minGain = this.jniPrm.getMinGain();
            this.vsnLimit = this.jniPrm.getVSNCount();
            String dataSize = this.jniPrm.getDatasize();
            if (SamQFSUtil.isValidString(dataSize)) {
                String size = SamQFSUtil.stringToFsize(dataSize);
                this.sizeLimit = SamQFSUtil.getLongVal(size);
                this.sizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.perform = this.jniPrm.getIgnore();
        }
    }
}

