/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.ArFSDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive.LegacySetInfo;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemArchiveManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveFileParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.LegacySetInfoImpl;
import java.util.ArrayList;
import java.util.HashMap;

public class ArchivePolicyImpl
implements ArchivePolicy,
Cloneable {
    private SamQFSSystemModelImpl model;
    private String policyName;
    private ArchiveFileParams fileParams;
    private ArrayList archCopies;
    private ArrayList fsNameList;
    private boolean legacy;
    private ArrayList legacyInfoList;
    private ArrayList wizardFSList;

    public ArchivePolicyImpl() {
        this.model = null;
        this.policyName = new String();
        this.fileParams = null;
        this.archCopies = new ArrayList();
        this.fsNameList = new ArrayList();
        this.legacy = true;
        this.legacyInfoList = new ArrayList();
        this.wizardFSList = new ArrayList();
    }

    public ArchivePolicyImpl(String policyName, String startingDir, ArchiveFileParams fileParams, ArrayList archCopies, ArrayList fsNameList) throws SamFSException {
        this.model = null;
        this.policyName = new String();
        this.fileParams = null;
        this.archCopies = new ArrayList();
        this.fsNameList = new ArrayList();
        this.legacy = true;
        this.legacyInfoList = new ArrayList();
        this.wizardFSList = new ArrayList();
        if (policyName == null || policyName == new String()) {
            throw new SamFSException("logic.invalidPolName");
        }
        if (startingDir == null) {
            startingDir = new String();
        }
        this.policyName = policyName;
        this.fileParams = fileParams;
        if (fileParams != null) {
            fileParams.setStartingDir(startingDir);
        }
        if (archCopies != null) {
            this.archCopies = archCopies;
        }
        if (fsNameList != null) {
            this.fsNameList = fsNameList;
        }
    }

    public ArchivePolicyImpl(SamQFSSystemModelImpl model, ArrayList clusters, ArrayList cParams, ArrayList vMaps) {
        block22: {
            ArrayList criteriaList;
            block21: {
                int i;
                int i2;
                int i3;
                this.model = null;
                this.policyName = new String();
                this.fileParams = null;
                this.archCopies = new ArrayList();
                this.fsNameList = new ArrayList();
                this.legacy = true;
                this.legacyInfoList = new ArrayList();
                this.wizardFSList = new ArrayList();
                criteriaList = new ArrayList();
                this.model = model;
                this.legacy = true;
                if (clusters != null && clusters.size() == 1) {
                    this.legacy = false;
                }
                if (this.legacy) break block21;
                criteriaList = (ArrayList)clusters.get(0);
                Criteria rep = (Criteria)criteriaList.get(0);
                this.policyName = rep.getSetName();
                this.fileParams = new ArchiveFileParamsImpl(this, rep);
                ArchiveVSNMapImpl[] mapObjs = new ArchiveVSNMapImpl[4];
                for (i3 = 0; i3 < 4; ++i3) {
                    mapObjs[i3] = null;
                }
                if (vMaps != null && vMaps.size() > 0) {
                    for (i3 = 0; i3 < vMaps.size(); ++i3) {
                        int copyNo = SamQFSUtil.getCopyNumber(((VSNMap)vMaps.get(i3)).getCopyName());
                        if (copyNo < 1 || copyNo > 4) continue;
                        try {
                            mapObjs[copyNo - 1] = new ArchiveVSNMapImpl(model, null, (VSNMap)vMaps.get(i3));
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                CopyParams[] cpObjs = new CopyParams[4];
                for (i2 = 0; i2 < 4; ++i2) {
                    cpObjs[i2] = null;
                }
                if (cParams != null && cParams.size() > 0) {
                    for (i2 = 0; i2 < cParams.size(); ++i2) {
                        int copyNo = SamQFSUtil.getCopyNumber(((CopyParams)cParams.get(i2)).getName());
                        if (copyNo < 1 || copyNo > 4) continue;
                        cpObjs[copyNo - 1] = (CopyParams)cParams.get(i2);
                    }
                }
                Copy[] copies = new Copy[4];
                for (int i4 = 0; i4 < 4; ++i4) {
                    copies[i4] = null;
                }
                Copy[] tmpCopies = rep.getCopies();
                for (i = 0; i < tmpCopies.length; ++i) {
                    if (tmpCopies[i] == null) continue;
                    copies[i] = tmpCopies[i];
                }
                for (i = 0; i < 4; ++i) {
                    if (copies[i] == null && cpObjs[i] == null && mapObjs[i] == null) continue;
                    try {
                        ArchiveCopyImpl cpImpl = new ArchiveCopyImpl(this, mapObjs[i], i + 1, copies[i], cpObjs[i]);
                        if (mapObjs != null && mapObjs[i] != null) {
                            mapObjs[i].setArchiveCopy(cpImpl);
                        }
                        this.archCopies.add(cpImpl);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Criteria[] crits = criteriaList.toArray(new Criteria[0]);
                if (crits.length <= 0) break block22;
                for (int i5 = 0; i5 < crits.length; ++i5) {
                    this.fsNameList.add(crits[i5].getFilesysName());
                }
                break block22;
            }
            if (clusters != null && clusters.size() > 1) {
                criteriaList = (ArrayList)clusters.get(0);
                Criteria rep = (Criteria)criteriaList.get(0);
                this.policyName = rep.getSetName();
                for (int i = 0; i < clusters.size(); ++i) {
                    ArrayList list = (ArrayList)clusters.get(i);
                    this.legacyInfoList.add(new LegacySetInfoImpl(this, list));
                }
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < this.legacyInfoList.size(); ++i) {
                    String name = ((LegacySetInfoImpl)this.legacyInfoList.get(i)).getCurrentlySuggestedName();
                    boolean done = false;
                    while (!done) {
                        Object o = map.get(name);
                        if (o != null) {
                            name = name + "1";
                            continue;
                        }
                        ((LegacySetInfoImpl)this.legacyInfoList.get(i)).setCurrentlySuggestedName(name);
                        map.put(name, name);
                        done = true;
                    }
                }
            }
        }
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public LegacySetInfo[] getLegacySetInfo() {
        return this.legacyInfoList.toArray(new LegacySetInfo[0]);
    }

    public String getPolicyName() throws SamFSException {
        return this.policyName;
    }

    public String getStartingDir() throws SamFSException {
        String startingDir = new String();
        if (this.fileParams != null) {
            startingDir = this.fileParams.getStartingDir();
        }
        return startingDir;
    }

    public ArchiveFileParams getFileCharacteristics() throws SamFSException {
        return this.fileParams;
    }

    public void setFileCharacteristics(ArchiveFileParams fileParams) throws SamFSException {
        this.fileParams = fileParams;
    }

    public ArchiveCopy[] getArchiveCopies() throws SamFSException {
        return this.archCopies.toArray(new ArchiveCopy[0]);
    }

    public ArchiveCopy getArchiveCopy(int copyNo) throws SamFSException {
        ArchiveCopy[] copies = this.archCopies.toArray(new ArchiveCopy[0]);
        ArchiveCopy copy = null;
        for (int i = 0; i < copies.length; ++i) {
            if (copies[i].getCopyNumber() != copyNo) continue;
            copy = copies[i];
            break;
        }
        return copy;
    }

    public int getNoOfFileSystemsInPolicy() {
        return this.fsNameList.size();
    }

    public String[] getAllFileSystemNamesForPolicy() {
        return this.fsNameList.toArray(new String[0]);
    }

    public FileSystem[] getFileSystemsForPolicy() throws SamFSException {
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        FileSystem[] fs2 = null;
        if (this.model != null && (fs2 = this.model.getSamQFSSystemFSManager().getAllFileSystems()) != null && this.fsNameList != null && this.fsNameList.size() > 0) {
            int i;
            HashMap<String, FileSystem> map = new HashMap<String, FileSystem>();
            for (i = 0; i < fs2.length; ++i) {
                map.put(fs2[i].getName(), fs2[i]);
            }
            for (i = 0; i < this.fsNameList.size(); ++i) {
                FileSystem fsys = (FileSystem)map.get((String)this.fsNameList.get(i));
                if (fsys == null) continue;
                fsList.add(fsys);
            }
        }
        return fsList.toArray(new FileSystem[0]);
    }

    public void changeFileCharacteristics() throws SamFSException {
        this.updatePolicy(true);
    }

    public void addArchiveCopy(ArchiveCopy copy) throws SamFSException {
        if (this.archCopies == null) {
            this.archCopies = new ArrayList();
        }
        this.archCopies.add(copy);
    }

    public void changeArchiveCopies() throws SamFSException {
        this.updatePolicy(false);
    }

    private void updatePolicy(boolean criteriaOnly) throws SamFSException {
        Object cp;
        int i;
        ArrayList<ArFSDirective> fsDirs = new ArrayList<ArFSDirective>();
        ArFSDirective[] dir = Archiver.getArFSDirectives((Ctx)this.model.getJniContext());
        if (dir != null) {
            for (int i2 = 0; i2 < dir.length; ++i2) {
                int index = this.fsNameList.indexOf(dir[i2].getFSName());
                if (index == -1) continue;
                fsDirs.add(dir[i2]);
            }
        }
        Criteria cr = ((ArchiveFileParamsImpl)this.fileParams).getJniCriteria();
        Copy[] copy = new Copy[4];
        for (i = 0; i < 4; ++i) {
            copy[i] = null;
        }
        for (i = 0; i < this.archCopies.size(); ++i) {
            cp = ((ArchiveCopyImpl)this.archCopies.get(i)).getJniCopy();
            int index = ((ArchiveCopyImpl)this.archCopies.get(i)).getCopyNumber() - 1;
            copy[index] = cp;
        }
        for (i = 0; i < fsDirs.size(); ++i) {
            ArFSDirective tmpDir = (ArFSDirective)fsDirs.get(i);
            Criteria[] c = tmpDir.getCriteria();
            if (c == null || c.length <= 0) continue;
            int arrayIndex = -1;
            for (int j = 0; j < c.length; ++j) {
                if (!c[j].getSetName().equals(this.getPolicyName())) continue;
                arrayIndex = j;
                break;
            }
            if (arrayIndex == -1) continue;
            c[arrayIndex] = SamQFSUtil.updateCriteria(c[arrayIndex], cr, copy, criteriaOnly);
            Archiver.setArFSDirective((Ctx)this.model.getJniContext(), (ArFSDirective)tmpDir);
        }
        if (!criteriaOnly) {
            for (i = 0; i < this.archCopies.size(); ++i) {
                cp = (ArchiveCopyImpl)this.archCopies.get(i);
                ArchiveVSNMap map = ((ArchiveCopyImpl)cp).getArchiveVSNMap();
                if (map != null) {
                    ((ArchiveVSNMapImpl)map).update();
                }
                CopyParams cParam = ((ArchiveCopyImpl)cp).getJniCopyParams();
                Archiver.setCopyParams((Ctx)this.model.getJniContext(), (CopyParams)cParam);
            }
        }
        Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
    }

    public void addFileSystemForPolicy(FileSystem filesystem) throws SamFSException {
        if (filesystem != null) {
            this.addFileSystemForPolicy(filesystem.getName());
        }
    }

    public void addFileSystemForPolicy(String filesystem) throws SamFSException {
        if (SamQFSUtil.isValidString(filesystem)) {
            int position = 0;
            ArFSDirective fsDir = Archiver.getArFSDirective((Ctx)this.model.getJniContext(), (String)filesystem);
            Criteria[] c = null;
            if (fsDir != null) {
                c = fsDir.getCriteria();
            }
            if (c != null) {
                position = c.length + 1;
            }
            this.addFileSystemForPolicy(filesystem, fsDir, position);
        }
    }

    public void addFileSystemForPolicy(String filesystem, ArFSDirective fsDir, int position) throws SamFSException {
        boolean logicExistence = false;
        int index = this.fsNameList.indexOf(filesystem);
        if (index != -1) {
            logicExistence = true;
        }
        Criteria[] c = null;
        boolean backendExistence = false;
        if (fsDir != null && (c = fsDir.getCriteria()) != null) {
            for (int i = 0; i < c.length; ++i) {
                if (!c[i].getSetName().equals(this.getPolicyName()) || !filesystem.equals(c[i].getFilesysName())) continue;
                backendExistence = true;
                break;
            }
        }
        if (!logicExistence && !backendExistence) {
            int i;
            Criteria cr = ((ArchiveFileParamsImpl)this.fileParams).getJniCriteria();
            Copy[] copy = new Copy[4];
            for (i = 0; i < 4; ++i) {
                copy[i] = null;
            }
            for (i = 0; i < this.archCopies.size(); ++i) {
                Copy cp = ((ArchiveCopyImpl)this.archCopies.get(i)).getJniCopy();
                index = ((ArchiveCopyImpl)this.archCopies.get(i)).getCopyNumber() - 1;
                copy[index] = cp;
            }
            if (!(cr = SamQFSUtil.createCriteria(filesystem, cr, copy)).getSetName().equals(this.getPolicyName())) {
                cr = SamQFSUtil.createCriteriaNewName(this.getPolicyName(), cr);
            }
            if (fsDir == null || c == null || c.length == 0) {
                if (fsDir == null) {
                    fsDir = new ArFSDirective();
                }
                c = new Criteria[]{cr};
                fsDir.setCriteria(c);
                Ctx ctx = this.model.getJniContext();
                String dumpPath = this.model.getDumpPath();
                boolean resetCtx = false;
                SamQFSSystemArchiveManagerImpl manager = (SamQFSSystemArchiveManagerImpl)this.model.getSamQFSSystemArchiveManager();
                boolean saveToFileOn = manager.isArchiveSaveToFileOn();
                if (!saveToFileOn && SamQFSUtil.isValidString(dumpPath)) {
                    ctx.setDumpPath(dumpPath);
                    resetCtx = true;
                }
                Archiver.setArFSDirective((Ctx)ctx, (ArFSDirective)fsDir);
                if (resetCtx) {
                    this.model.setDumpPath(null);
                    ctx.setDumpPath(null);
                }
            } else {
                Criteria[] crs = new Criteria[c.length + 1];
                if (position < 0 || position > c.length) {
                    position = c.length;
                }
                for (int i2 = 0; i2 <= c.length; ++i2) {
                    crs[i2] = i2 < position ? c[i2] : (i2 == position ? cr : c[i2 - 1]);
                }
                fsDir.setCriteria(crs);
                Ctx ctx = this.model.getJniContext();
                String dumpPath = this.model.getDumpPath();
                boolean resetCtx = false;
                SamQFSSystemArchiveManagerImpl manager = (SamQFSSystemArchiveManagerImpl)this.model.getSamQFSSystemArchiveManager();
                boolean saveToFileOn = manager.isArchiveSaveToFileOn();
                if (!saveToFileOn && SamQFSUtil.isValidString(dumpPath)) {
                    ctx.setDumpPath(dumpPath);
                    resetCtx = true;
                }
                Archiver.setArFSDirective((Ctx)this.model.getJniContext(), (ArFSDirective)fsDir);
                if (resetCtx) {
                    this.model.setDumpPath(null);
                    ctx.setDumpPath(null);
                }
            }
        } else {
            throw new SamFSException("logic.mismatchLogicBackend");
        }
        this.fsNameList.add(filesystem);
    }

    public void deleteFileSystemForPolicy(FileSystem filesystem) throws SamFSException {
        if (filesystem != null) {
            this.deleteFileSystemForPolicy(filesystem.getName());
        }
    }

    public void deleteFileSystemForPolicy(String filesystem) throws SamFSException {
        this.deleteFileSystemForPolicy(filesystem, false);
    }

    public void deleteFileSystemForPolicy(String filesystem, boolean allow) throws SamFSException {
        int i;
        int index = this.fsNameList.indexOf(filesystem);
        if (!allow && index != -1 && this.fsNameList.size() == 1) {
            throw new SamFSException("logic.last_fs_in_policy");
        }
        ArFSDirective fsDir = Archiver.getArFSDirective((Ctx)this.model.getJniContext(), (String)filesystem);
        Criteria[] newCrit = null;
        Criteria[] c = null;
        if (fsDir != null) {
            c = fsDir.getCriteria();
        }
        int currentPosition = -1;
        if (c != null && c.length > 0) {
            for (i = 0; i < c.length; ++i) {
                if (!c[i].getSetName().equals(this.getPolicyName())) continue;
                currentPosition = i;
                break;
            }
        }
        if (currentPosition != -1) {
            if (c.length == 1) {
                fsDir.setCriteria(new Criteria[0]);
                Archiver.setArFSDirective((Ctx)this.model.getJniContext(), (ArFSDirective)fsDir);
            } else {
                newCrit = new Criteria[c.length - 1];
                for (i = 0; i < c.length; ++i) {
                    if (i < currentPosition) {
                        newCrit[i] = c[i];
                        continue;
                    }
                    if (i <= currentPosition) continue;
                    newCrit[i - 1] = c[i];
                }
                fsDir.setCriteria(newCrit);
                Archiver.setArFSDirective((Ctx)this.model.getJniContext(), (ArFSDirective)fsDir);
            }
        }
        if (index != -1) {
            this.fsNameList.remove(index);
        }
    }

    public void deleteFileSystemForPolicy(String[] filesystems) throws SamFSException {
        if (filesystems != null && filesystems.length > 0) {
            for (int i = 0; i < filesystems.length; ++i) {
                this.deleteFileSystemForPolicy(filesystems[i]);
            }
        }
    }

    public Object clone() {
        ArchivePolicyImpl policy = null;
        try {
            ArrayList<Object> copies = new ArrayList<Object>();
            if (this.archCopies != null) {
                for (int i = 0; i < this.archCopies.size(); ++i) {
                    ArchiveCopyImpl copy = (ArchiveCopyImpl)this.archCopies.get(i);
                    copies.add(copy.clone());
                }
            }
            ArrayList fileSystems = new ArrayList();
            ArchiveFileParamsImpl params = null;
            if (this.fileParams != null) {
                params = (ArchiveFileParamsImpl)((ArchiveFileParamsImpl)this.fileParams).clone();
            }
            policy = new ArchivePolicyImpl(this.policyName, this.getStartingDir(), params, copies, fileSystems);
            params.setArchivePolicy(policy);
            if (copies != null && copies.size() > 0) {
                for (int i = 0; i < copies.size(); ++i) {
                    ((ArchiveCopyImpl)copies.get(i)).setArchivePolicy(policy);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return policy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Policy Name: " + this.policyName + "\n");
        try {
            buf.append("Starting Dir: " + this.getStartingDir() + "\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        buf.append("File Characteristics: " + this.fileParams.toString() + "\n");
        try {
            if (this.archCopies != null) {
                for (int i = 0; i < this.archCopies.size(); ++i) {
                    buf.append("Archive Copies: " + ((ArchiveCopy)this.archCopies.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.fsNameList != null) {
                for (int i = 0; i < this.fsNameList.size(); ++i) {
                    buf.append("FileSystems For Policy: " + (String)this.fsNameList.get(i) + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public void setPolicyName(String policyName) throws SamFSException {
        this.policyName = policyName;
    }

    public void setModel(SamQFSSystemModelImpl model) {
        this.model = model;
    }

    public void setStartingDir(String startingDir) throws SamFSException {
        if (startingDir != null && this.fileParams != null) {
            this.fileParams.setStartingDir(startingDir);
        }
    }

    public void setCopyArrayList(ArrayList list) {
        this.archCopies = list;
    }

    public void setCandidateFileSystems(FileSystem[] fs2) {
        this.wizardFSList.clear();
        if (fs2 != null) {
            for (int i = 0; i < fs2.length; ++i) {
                this.wizardFSList.add(fs2[i]);
            }
        }
    }

    public FileSystem[] getCandidateFileSystems() {
        return this.wizardFSList.toArray(new FileSystem[0]);
    }

    public void clearCandidateFileSystems() {
        this.wizardFSList.clear();
    }
}

