/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.admin;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.adm.NotifSummary;
import com.sun.netstorage.samqfs.web.model.admin.Notification;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class NotificationImpl
implements Notification {
    private NotifSummary jniNotif = null;
    private String name = new String();
    private String emailAddress = new String();
    private String origEmailAddress = new String();
    private boolean deviceDownNotify = false;
    private boolean archiverInterruptNotify = false;
    private boolean reqMediaNotify = false;
    private boolean recycleNotify = false;
    private boolean dumpInterruptNotify = false;
    private boolean fsNospaceNotify = false;

    public NotificationImpl() {
    }

    public NotificationImpl(String name, String emailAddress, boolean deviceDownNotify, boolean archiverInterruptNotify, boolean reqMediaNotify, boolean recycleNotify) throws SamFSException {
        if (!SamQFSUtil.isValidString(name) || !SamQFSUtil.isValidString(emailAddress)) {
            throw new SamFSException("logic.invalidNameOrAddress");
        }
        this.name = name;
        this.emailAddress = emailAddress;
        this.deviceDownNotify = deviceDownNotify;
        this.archiverInterruptNotify = archiverInterruptNotify;
        this.reqMediaNotify = reqMediaNotify;
        this.recycleNotify = recycleNotify;
    }

    public NotificationImpl(String name, String emailAddress, boolean deviceDownNotify, boolean archiverInterruptNotify, boolean reqMediaNotify, boolean recycleNotify, boolean dumpInterruptNotify, boolean fsNospaceNotify) throws SamFSException {
        this(name, emailAddress, deviceDownNotify, archiverInterruptNotify, reqMediaNotify, recycleNotify);
        this.dumpInterruptNotify = dumpInterruptNotify;
        this.fsNospaceNotify = fsNospaceNotify;
    }

    public NotificationImpl(NotifSummary notif) {
        this.jniNotif = notif;
        this.setup();
    }

    public NotifSummary getJniNotif() {
        return this.jniNotif;
    }

    public String getName() throws SamFSException {
        return this.name;
    }

    public void setName(String name) throws SamFSException {
        this.name = name;
    }

    public String getEmailAddress() throws SamFSException {
        return this.emailAddress;
    }

    public String getOrigEmailAddress() throws SamFSException {
        return this.origEmailAddress;
    }

    public void setEmailAddress(String email) throws SamFSException {
        this.emailAddress = email;
    }

    public boolean isDeviceDownNotify() throws SamFSException {
        return this.deviceDownNotify;
    }

    public void setDeviceDownNotify(boolean devDown) throws SamFSException {
        this.deviceDownNotify = devDown;
    }

    public boolean isArchiverInterruptNotify() throws SamFSException {
        return this.archiverInterruptNotify;
    }

    public void setArchiverInterruptNotify(boolean archIntr) throws SamFSException {
        this.archiverInterruptNotify = archIntr;
    }

    public boolean isReqMediaNotify() throws SamFSException {
        return this.reqMediaNotify;
    }

    public void setReqMediaNotify(boolean reqMedia) throws SamFSException {
        this.reqMediaNotify = reqMedia;
    }

    public boolean isRecycleNotify() throws SamFSException {
        return this.recycleNotify;
    }

    public void setRecycleNotify(boolean recycle) throws SamFSException {
        this.recycleNotify = recycle;
    }

    public boolean isDumpInterruptNotify() throws SamFSException {
        return this.dumpInterruptNotify;
    }

    public void setDumpInterruptNotify(boolean dumpIntr) throws SamFSException {
        this.dumpInterruptNotify = dumpIntr;
    }

    public boolean isFsNospaceNotify() {
        return this.fsNospaceNotify;
    }

    public void setFsNospaceNotify(boolean fsNospace) {
        this.fsNospaceNotify = fsNospace;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null) {
            buf.append("Name: " + this.name + "\n");
        }
        if (this.emailAddress != null) {
            buf.append("Email Address: " + this.emailAddress + "\n");
        }
        buf.append("Device Down Notify: " + this.deviceDownNotify + "\n");
        buf.append("Archiver Interrupt Notify: " + this.archiverInterruptNotify + "\n");
        buf.append("Req Media Notify: " + this.reqMediaNotify + "\n");
        buf.append("Recycle Notify: " + this.recycleNotify + "\n");
        buf.append("Dump Interrupt Notify: " + this.dumpInterruptNotify + "\n");
        return buf.toString();
    }

    private void setup() {
        if (this.jniNotif != null) {
            this.name = this.jniNotif.getAdminName();
            this.origEmailAddress = this.emailAddress = this.jniNotif.getEmailAddr();
            boolean[] bools = this.jniNotif.getSubj();
            this.deviceDownNotify = bools[0];
            this.archiverInterruptNotify = bools[1];
            this.reqMediaNotify = bools[2];
            this.recycleNotify = bools[3];
            this.dumpInterruptNotify = bools[4];
            this.fsNospaceNotify = bools[5];
        }
    }
}

