/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.Job;
import com.sun.netstorage.samqfs.mgmt.SamFSAccessDeniedException;
import com.sun.netstorage.samqfs.mgmt.SamFSCommException;
import com.sun.netstorage.samqfs.mgmt.SamFSConnection;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSIncompatVerException;
import com.sun.netstorage.samqfs.mgmt.SamFSNotInitException;
import com.sun.netstorage.samqfs.mgmt.adm.License;
import com.sun.netstorage.samqfs.mgmt.adm.SysInfo;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.ConfigStatus;
import com.sun.netstorage.samqfs.web.model.DaemonInfo;
import com.sun.netstorage.samqfs.web.model.LogAndTraceInfo;
import com.sun.netstorage.samqfs.web.model.PkgInfo;
import com.sun.netstorage.samqfs.web.model.SamExplorerOutputs;
import com.sun.netstorage.samqfs.web.model.SamQFSDataStore;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAdminManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAlarmManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemJobManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemMediaManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SystemCapacity;
import com.sun.netstorage.samqfs.web.model.SystemInfo;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSDataStoreImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemAdminManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemAlarmManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemArchiveManager43Impl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemArchiveManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemJobManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemMediaManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public class SamQFSSystemModelImpl
implements SamQFSSystemModel {
    public static long DEFAULT_RPC_TIME_OUT = 65L;
    public static long DEFAULT_RPC_CONNECTION_TIME_OUT = 5L;
    public static long DEFAULT_RPC_MAX_TIME_OUT = 110L;
    private SamQFSDataStoreImpl dataStore;
    private String hostname;
    private boolean down;
    private boolean accessDenied;
    private boolean serverSupported;
    private SamFSConnection connection;
    private String dumpPath;
    private String defaultDumpPath;
    private String serverAPIVersion;
    private String serverProductVersion;
    private Ctx context;
    private short license;
    private int versionStatus;
    private SamQFSSystemFSManager fsManager;
    private SamQFSSystemArchiveManager archiveManager;
    private SamQFSSystemArchiveManager43 archiveManager43;
    private SamQFSSystemMediaManager mediaManager;
    private SamQFSSystemJobManager jobManager;
    private SamQFSSystemAlarmManager alarmManager;
    private SamQFSSystemAdminManager adminManager;
    private String scVersion;
    private String scName;

    public SamQFSSystemModelImpl(String hostname) {
        block10: {
            this.dataStore = null;
            this.hostname = new String();
            this.down = false;
            this.accessDenied = false;
            this.serverSupported = true;
            this.connection = null;
            this.dumpPath = null;
            this.defaultDumpPath = "/etc/opt/SUNWsamfs";
            this.serverAPIVersion = new String();
            this.serverProductVersion = new String();
            this.context = null;
            this.license = (short)-1;
            this.versionStatus = 1001;
            this.fsManager = null;
            this.archiveManager = null;
            this.archiveManager43 = null;
            this.mediaManager = null;
            this.jobManager = null;
            this.alarmManager = null;
            this.adminManager = null;
            this.scVersion = "N/A";
            this.scName = "N/A";
            if (!SamQFSUtil.isValidString(hostname)) {
                throw new IllegalArgumentException();
            }
            this.hostname = hostname;
            try {
                this.connection = SamFSConnection.getNewSetTimeout((String)hostname, (long)DEFAULT_RPC_CONNECTION_TIME_OUT);
                this.connection.setTimeout(DEFAULT_RPC_TIME_OUT);
                this.context = new Ctx(this.connection, null);
                try {
                    this.serverAPIVersion = this.connection.getServerAPIver();
                    this.serverProductVersion = this.connection.getServerVer();
                }
                catch (Exception e) {
                    this.serverAPIVersion = "1.0";
                    this.serverProductVersion = "4.1";
                }
                this.dataStore = new SamQFSDataStoreImpl(this);
                this.down = false;
                this.accessDenied = false;
                boolean bl = this.serverSupported = this.serverAPIVersion.compareTo("1.3") >= 0;
                if (this.serverAPIVersion.compareTo("1.4") >= 0) {
                    try {
                        this.scVersion = SysInfo.getSCVersion((Ctx)this.context);
                        if (this.scVersion != null && this.scVersion.length() > 0) {
                            this.scName = SysInfo.getSCName((Ctx)this.context);
                        }
                        break block10;
                    }
                    catch (SamFSException e) {
                        TraceUtil.trace1("[ignored]" + (Object)((Object)e));
                    }
                    break block10;
                }
                this.scVersion = "";
            }
            catch (Exception e) {
                this.down = true;
                if (e instanceof SamFSIncompatVerException) {
                    this.versionStatus = ((SamFSIncompatVerException)e).isClientVerNewer() ? 1002 : 1003;
                }
                if (!(e instanceof SamFSAccessDeniedException)) break block10;
                this.accessDenied = true;
            }
        }
        this.processLicense();
    }

    public void reconnect() throws SamFSException {
        block11: {
            try {
                SamQFSUtil.doPrint("Debug: Calling reconnect...");
                System.out.println("Debug: Calling reconnect...");
                if (this.connection != null) {
                    try {
                        this.connection.destroy();
                    }
                    catch (SamFSException e) {
                        // empty catch block
                    }
                }
                this.connection = SamFSConnection.getNewSetTimeout((String)this.hostname, (long)DEFAULT_RPC_CONNECTION_TIME_OUT);
                this.connection.setTimeout(DEFAULT_RPC_TIME_OUT);
                this.context = new Ctx(this.connection, null);
                try {
                    this.serverAPIVersion = this.connection.getServerAPIver();
                    this.serverProductVersion = this.connection.getServerVer();
                }
                catch (Exception e) {
                    this.serverAPIVersion = "1.0";
                    this.serverProductVersion = "4.1";
                }
                this.dataStore = new SamQFSDataStoreImpl(this);
                this.down = false;
                this.scVersion = "n/a2";
                this.scName = "n/a2";
                if (this.serverAPIVersion.compareTo("1.4") >= 0) {
                    try {
                        this.scVersion = SysInfo.getSCVersion((Ctx)this.context);
                        if (this.scVersion != null && this.scVersion.length() > 0) {
                            this.scName = SysInfo.getSCName((Ctx)this.context);
                        }
                        break block11;
                    }
                    catch (SamFSException e) {
                        TraceUtil.trace1("[ignored]" + (Object)((Object)e));
                    }
                    break block11;
                }
                this.scVersion = "";
            }
            catch (Exception e) {
                this.down = true;
                if (!(e instanceof SamFSIncompatVerException)) break block11;
                this.versionStatus = ((SamFSIncompatVerException)e).isClientVerNewer() ? 1002 : 1003;
            }
        }
        this.processLicense();
    }

    public void reinitialize() throws SamFSException {
        if (this.connection != null) {
            SamQFSUtil.doPrint("Debug: Calling reinit...");
            this.connection.reinit();
        }
    }

    public void terminateConn() {
        if (this.connection != null) {
            try {
                this.connection.destroy();
                this.connection = null;
            }
            catch (SamFSException samFSException) {
                // empty catch block
            }
        }
    }

    public int getVersionStatus() {
        return this.versionStatus;
    }

    public String getServerAPIVersion() {
        return this.serverAPIVersion;
    }

    public String getServerProductVersion() {
        return this.serverProductVersion;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getServerHostname() {
        String serverHostName = this.hostname;
        if (this.serverAPIVersion.compareTo("1.1") > 0 && this.getJniConnection() != null) {
            serverHostName = this.getJniConnection().getServerHostname();
        }
        return serverHostName;
    }

    public boolean isClusterNode() {
        return this.scVersion != null && this.scVersion.length() > 0;
    }

    public String getClusterVersion() {
        return this.scVersion;
    }

    public String getClusterName() {
        return this.scName;
    }

    public int getPlexMgrState() throws SamFSException {
        return SysInfo.getSCUIState((Ctx)this.context);
    }

    public String getArchitecture() {
        String architecture = new String();
        if (this.serverAPIVersion.compareTo("1.3.1") >= 0 && this.connection != null) {
            architecture = this.getJniConnection().getServerArch();
        }
        return architecture;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown() {
        this.down = true;
    }

    public short getLicenseType() throws SamFSException {
        if (this.license == -1) {
            this.processLicense();
        }
        return this.license;
    }

    public SamQFSDataStore getDataStore() throws SamFSException {
        return this.dataStore;
    }

    public synchronized Ctx getJniContext() {
        return this.context;
    }

    public synchronized SamFSConnection getJniConnection() {
        return this.connection;
    }

    public String getDumpPath() throws SamFSException {
        return this.dumpPath;
    }

    public void setDumpPath(String dumpPath) throws SamFSException {
        this.dumpPath = dumpPath;
    }

    public String getDefaultDumpPath() {
        return this.defaultDumpPath;
    }

    public void setDefaultDumpPath(String dumpPath) {
        this.defaultDumpPath = dumpPath;
    }

    public void clearContext() {
        if (this.context != null) {
            this.context.setDumpPath(null);
            this.context.setReadPath(null);
        }
        this.dumpPath = null;
    }

    public SystemCapacity getCapacity() throws SamFSException {
        String capacity = SysInfo.getCapacity((Ctx)this.context);
        return new SystemCapacity(ConversionUtil.strToProps(capacity));
    }

    public SystemInfo getSystemInfo() throws SamFSException {
        return new SystemInfo(SysInfo.getOSInfo((Ctx)this.context));
    }

    public PkgInfo[] getPkgInfo() throws SamFSException {
        PkgInfo[] pkgInfo = null;
        String[] pkgInfoStrs = SysInfo.getPackageInfo((Ctx)this.context, null);
        if (pkgInfoStrs == null) {
            return new PkgInfo[0];
        }
        pkgInfo = new PkgInfo[pkgInfoStrs.length];
        for (int i = 0; i < pkgInfoStrs.length; ++i) {
            pkgInfo[i] = new PkgInfo(pkgInfoStrs[i]);
        }
        return pkgInfo;
    }

    public LogAndTraceInfo[] getLogAndTraceInfo() throws SamFSException {
        LogAndTraceInfo[] logInfo = null;
        String[] logAndTraceStrs = SysInfo.getLogInfo((Ctx)this.context);
        if (logAndTraceStrs == null) {
            return new LogAndTraceInfo[0];
        }
        logInfo = new LogAndTraceInfo[logAndTraceStrs.length];
        for (int i = 0; i < logAndTraceStrs.length; ++i) {
            logInfo[i] = new LogAndTraceInfo(logAndTraceStrs[i]);
        }
        return logInfo;
    }

    public DaemonInfo[] getDaemonInfo() throws SamFSException {
        DaemonInfo[] dmnInfo = null;
        String[] daemonInfoStrs = Job.getAllActivities((Ctx)this.context, (int)100, (String)"type=SAMD");
        if (daemonInfoStrs == null) {
            return new DaemonInfo[0];
        }
        dmnInfo = new DaemonInfo[daemonInfoStrs.length];
        for (int i = 0; i < daemonInfoStrs.length; ++i) {
            dmnInfo[i] = new DaemonInfo(daemonInfoStrs[i]);
        }
        return dmnInfo;
    }

    public ConfigStatus[] getConfigStatus() throws SamFSException {
        ConfigStatus[] cfgStatus = null;
        String[] cfgStatusStrs = SysInfo.getConfigStatus((Ctx)this.context);
        if (cfgStatusStrs == null) {
            return new ConfigStatus[0];
        }
        cfgStatus = new ConfigStatus[cfgStatusStrs.length];
        for (int i = 0; i < cfgStatusStrs.length; ++i) {
            cfgStatus[i] = new ConfigStatus(cfgStatusStrs[i]);
        }
        return cfgStatus;
    }

    public String[] getConfigStatusDetails(String keyConfig) {
        return new String[0];
    }

    public ClusterNodeInfo[] getClusterNodes() throws SamFSException {
        ClusterNodeInfo[] nodes = null;
        if (this.serverAPIVersion.compareTo("1.4") < 0) {
            return new ClusterNodeInfo[0];
        }
        String[] scNodeStrs = SysInfo.getSCNodes((Ctx)this.context);
        if (scNodeStrs == null) {
            return new ClusterNodeInfo[0];
        }
        nodes = new ClusterNodeInfo[scNodeStrs.length];
        for (int i = 0; i < scNodeStrs.length; ++i) {
            nodes[i] = new ClusterNodeInfo(scNodeStrs[i]);
        }
        return nodes;
    }

    public SamExplorerOutputs[] getSamExplorerOutputs() throws SamFSException {
        SamExplorerOutputs[] outputs = null;
        if (this.serverAPIVersion.compareTo("1.4") < 0) {
            return new SamExplorerOutputs[0];
        }
        String[] explorerOutputs = SysInfo.listSamExplorerOutputs((Ctx)this.context);
        if (explorerOutputs == null) {
            return new SamExplorerOutputs[0];
        }
        outputs = new SamExplorerOutputs[explorerOutputs.length];
        for (int i = 0; i < explorerOutputs.length; ++i) {
            outputs[i] = new SamExplorerOutputs(explorerOutputs[i]);
        }
        return outputs;
    }

    public void runSamExplorer(String location, int logLines) throws SamFSException {
        block0: {
            if (location == null || logLines <= 0) break block0;
            String[] stringArray = SysInfo.runSamExplorer((Ctx)this.getJniContext(), (String)location, (int)logLines);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("=====================================\n");
        buf.append("Hostname: " + this.hostname + "\n");
        try {
            int i;
            FileSystem[] fsList = this.getSamQFSSystemFSManager().getAllFileSystems();
            ArchivePolicy[] policyList = this.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            Library[] libList = this.getSamQFSSystemMediaManager().getAllLibraries();
            buf.append("File Systems:\n");
            for (i = 0; i < fsList.length; ++i) {
                buf.append(fsList[i]);
            }
            buf.append("Archive Policies:\n");
            for (i = 0; i < policyList.length; ++i) {
                buf.append(policyList[i]);
            }
            buf.append("Libraries:\n");
            for (i = 0; i < libList.length; ++i) {
                buf.append(libList[i]);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        buf.append("=====================================\n");
        return buf.toString();
    }

    public SamQFSSystemFSManager getSamQFSSystemFSManager() {
        if (this.fsManager == null) {
            this.fsManager = new SamQFSSystemFSManagerImpl(this);
        }
        return this.fsManager;
    }

    public SamQFSSystemArchiveManager getSamQFSSystemArchiveManager() {
        if (this.archiveManager == null) {
            this.archiveManager = new SamQFSSystemArchiveManagerImpl(this);
        }
        return this.archiveManager;
    }

    public SamQFSSystemArchiveManager43 getSamQFSSystemArchiveManager43() {
        if (this.archiveManager43 == null) {
            this.archiveManager43 = new SamQFSSystemArchiveManager43Impl(this);
        }
        return this.archiveManager43;
    }

    public SamQFSSystemMediaManager getSamQFSSystemMediaManager() {
        if (this.mediaManager == null) {
            this.mediaManager = new SamQFSSystemMediaManagerImpl(this);
        }
        return this.mediaManager;
    }

    public SamQFSSystemJobManager getSamQFSSystemJobManager() {
        if (this.jobManager == null) {
            this.jobManager = new SamQFSSystemJobManagerImpl(this);
        }
        return this.jobManager;
    }

    public SamQFSSystemAlarmManager getSamQFSSystemAlarmManager() {
        if (this.alarmManager == null) {
            this.alarmManager = new SamQFSSystemAlarmManagerImpl(this);
        }
        return this.alarmManager;
    }

    public SamQFSSystemAdminManager getSamQFSSystemAdminManager() {
        if (this.adminManager == null) {
            this.adminManager = new SamQFSSystemAdminManagerImpl(this);
        }
        return this.adminManager;
    }

    private void getLicenseTypeFromJni() throws SamFSException {
        this.license = (short)-1;
        short jniVal = License.getFSType((Ctx)this.getJniContext());
        switch (jniVal) {
            case 1: {
                this.license = 1;
                break;
            }
            case 2: {
                this.license = (short)2;
                break;
            }
            case 3: {
                this.license = (short)3;
            }
        }
    }

    private void processLicense() {
        if (!this.down) {
            try {
                this.getLicenseTypeFromJni();
            }
            catch (SamFSException se) {
                this.license = (short)-1;
                this.processException((Exception)((Object)se));
            }
        } else {
            this.license = (short)-1;
        }
    }

    public void processException(Exception e) {
        this.clearContext();
        try {
            if (e instanceof SamFSNotInitException) {
                this.reinitialize();
            } else if (e instanceof SamFSCommException) {
                if (((SamFSException)((Object)e)).getSAMerrno() == 30804) {
                    this.reinitialize();
                } else {
                    this.reconnect();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean doesFileExist(String filePath) throws SamFSException {
        boolean exist = false;
        if (SamQFSUtil.isValidString(filePath)) {
            exist = FileUtil.fileExists((Ctx)this.getJniContext(), (String)filePath);
        }
        return exist;
    }

    public boolean isAccessDenied() {
        return this.accessDenied;
    }

    public boolean isServerSupported() {
        return this.serverSupported;
    }
}

