/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.SamFSConnection;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiStepOpException;
import com.sun.netstorage.samqfs.mgmt.arc.ArFSDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.VSNOp;
import com.sun.netstorage.samqfs.mgmt.fs.AU;
import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.FS;
import com.sun.netstorage.samqfs.mgmt.fs.FSInfo;
import com.sun.netstorage.samqfs.mgmt.fs.MountOptions;
import com.sun.netstorage.samqfs.mgmt.fs.Restore;
import com.sun.netstorage.samqfs.mgmt.fs.StripedGrp;
import com.sun.netstorage.samqfs.mgmt.stg.Stager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.GenericMountOptions;
import com.sun.netstorage.samqfs.web.model.fs.RemoteFile;
import com.sun.netstorage.samqfs.web.model.fs.RestoreDumpFile;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.model.fs.StageFile;
import com.sun.netstorage.samqfs.web.model.impl.jni.MultiHostUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSDataStoreImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.FileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.GenericFileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.RestoreFileImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.StripedGroupImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class SamQFSSystemFSManagerImpl
extends MultiHostUtil
implements SamQFSSystemFSManager {
    private SamQFSSystemModelImpl theModel;
    private int stripeGroupIndex = 0;
    private Hashtable fsCache;
    private FsmVersion version45;
    protected RemoteFile[] remoteFiles;
    protected String searchedDumpFullPath = null;
    protected boolean getFromCache = false;
    protected String[] cachedSearchNames;

    public SamQFSSystemFSManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
        this.fsCache = new Hashtable();
    }

    private FsmVersion getVersion45() {
        if (this.version45 == null) {
            this.version45 = new FsmVersion("4.5", this.theModel.getHostname());
        }
        return this.version45;
    }

    public String[] getAllFileSystemNames() throws SamFSException {
        String[] fsNames = FS.getNames((Ctx)this.theModel.getJniContext());
        if (fsNames == null) {
            fsNames = new String[]{};
        }
        return fsNames;
    }

    public String[] getFileSystemNamesAllTypes() throws SamFSException {
        String[] fsNames = FS.getNamesAllTypes((Ctx)this.theModel.getJniContext());
        if (fsNames == null) {
            fsNames = new String[]{};
        }
        return fsNames;
    }

    public FileSystem[] getAllFileSystems() throws SamFSException {
        FileSystem[] fs2 = null;
        FSInfo[] fsInfo = FS.getAll((Ctx)this.theModel.getJniContext());
        if (fsInfo == null) {
            fs2 = new FileSystem[]{};
        } else {
            fs2 = new FileSystem[fsInfo.length];
            for (int i = 0; i < fsInfo.length; ++i) {
                fs2[i] = new FileSystemImpl(this.theModel, fsInfo[i]);
            }
        }
        return fs2;
    }

    public FileSystem[] getAllFileSystems(int archivingType) throws SamFSException {
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        FileSystem[] fsAll = this.getAllFileSystems();
        if (fsAll != null && fsAll.length > 0) {
            for (int i = 0; i < fsAll.length; ++i) {
                if (fsAll[i].getArchivingType() != archivingType) continue;
                fsList.add(fsAll[i]);
            }
        }
        return fsList.toArray(new FileSystem[0]);
    }

    public GenericFileSystem[] getNonSAMQFileSystems() throws SamFSException {
        GenericFileSystem[] fsArr = null;
        String[] fsStrs = FS.getGenericFilesystems((Ctx)this.theModel.getJniContext(), (String)"ufs,vxfs");
        if (fsStrs == null) {
            return new GenericFileSystem[0];
        }
        fsArr = new GenericFileSystemImpl[fsStrs.length];
        for (int i = 0; i < fsStrs.length; ++i) {
            fsArr[i] = new GenericFileSystemImpl(this.theModel.getHostname(), fsStrs[i]);
            this.fsCache.put(((GenericFileSystemImpl)fsArr[i]).getName(), fsArr[i]);
        }
        return fsArr;
    }

    public GenericFileSystem getGenericFileSystem(String fsName) throws SamFSException {
        GenericFileSystem fs2 = null;
        if (fsName != null) {
            if (fsName.startsWith("/")) {
                if (this.fsCache.get(fsName) == null) {
                    this.getNonSAMQFileSystems();
                }
                fs2 = (GenericFileSystem)this.fsCache.get(fsName);
            } else {
                FSInfo fsInfo;
                block7: {
                    fsInfo = null;
                    try {
                        fsInfo = FS.get((Ctx)this.theModel.getJniContext(), (String)fsName);
                    }
                    catch (SamFSException e) {
                        if (e.getSAMerrno() == 30132) break block7;
                        throw e;
                    }
                }
                if (fsInfo != null) {
                    fs2 = new FileSystemImpl(this.theModel, fsInfo);
                }
            }
        }
        return fs2;
    }

    public void invalidateCachedFS(String fsName) {
        this.fsCache.remove(fsName);
    }

    public FileSystem getFileSystem(String fsName) throws SamFSException {
        return (FileSystem)this.getGenericFileSystem(fsName);
    }

    public FileSystemMountProperties getDefaultMountProperties(int fsType, int archType, int dauSize, boolean stripedGrp, int shareStatus, boolean multiReader) throws SamFSException {
        String type = "ms";
        if (fsType == 0) {
            type = "ma";
        }
        boolean shared = true;
        if (shareStatus == 0) {
            shared = false;
        }
        MountOptions mount = FS.getDefaultMountOpts((Ctx)this.theModel.getJniContext(), (String)type, (int)dauSize, (boolean)stripedGrp, (boolean)shared, (boolean)multiReader);
        return new FileSystemMountPropertiesImpl(mount);
    }

    public FileSystem createFileSystem(String fsName, int fsType, int archType, int equipOrdinal, String mountPoint, int shareStatus, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiStepOpException, SamFSException {
        FileSystem fs2 = this.createFileSystem(fsName, fsType, archType, equipOrdinal, mountPoint, shareStatus, DAUSize, mountProps, metadataDevices, dataDevices, null, false, mountAtBoot, createMountPoint, mountAfterCreate);
        return fs2;
    }

    public FileSystem createFileSystem(String fsName, int fsType, int archType, int equipOrdinal, String mountPoint, int shareStatus, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups, boolean single, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiStepOpException, SamFSException {
        int i;
        if (!SamQFSUtil.isValidString(fsName) || !SamQFSUtil.isValidString(mountPoint)) {
            throw new SamFSException("logic.invalidFSParam");
        }
        int equ = equipOrdinal;
        if (equ == -1) {
            equ = 0;
        }
        String type = "ms";
        if (fsType == 0) {
            type = "ma";
        }
        DiskDev[] meta = null;
        DiskDev[] data = null;
        StripedGrp[] grp = null;
        String eqTypeForJni = "md";
        if (single && metadataDevices != null && metadataDevices.length > 0) {
            eqTypeForJni = "mr";
        }
        if (metadataDevices != null) {
            meta = new DiskDev[metadataDevices.length];
            for (i = 0; i < metadataDevices.length; ++i) {
                meta[i] = ((DiskCacheImpl)metadataDevices[i]).getJniDisk();
            }
        }
        if (dataDevices != null) {
            data = new DiskDev[dataDevices.length];
            for (i = 0; i < dataDevices.length; ++i) {
                data[i] = ((DiskCacheImpl)dataDevices[i]).getJniDisk();
                data[i].setEquipType(eqTypeForJni);
            }
        }
        if (stripedGroups != null) {
            grp = new StripedGrp[stripedGroups.length];
            for (i = 0; i < stripedGroups.length; ++i) {
                grp[i] = ((StripedGroupImpl)stripedGroups[i]).getJniStripedGroup();
            }
        }
        MountOptions opt = ((FileSystemMountPropertiesImpl)mountProps).getJniMountOptions();
        FSInfo fsInfo = new FSInfo(fsName, equ, DAUSize, type, meta, data, grp, opt, mountPoint);
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        FS.createAndMount((Ctx)this.theModel.getJniContext(), (FSInfo)fsInfo, (boolean)mountAtBoot, (boolean)createMountPoint, (boolean)mountAfterCreate);
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
        FileSystemImpl fs2 = new FileSystemImpl(this.theModel, fsInfo);
        this.theModel.getDataStore().clearAvailableAllocatableUnits();
        this.theModel.getDataStore().clearTemporaryStripedGroups();
        return fs2;
    }

    public FileSystem createHAFileSystem(String[] hostnames, String fsName, int fsType, int equipOrdinal, String mountPoint, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups, boolean singleDAU, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiHostException {
        int i;
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        if (!SamQFSUtil.isValidString(fsName) || !SamQFSUtil.isValidString(mountPoint)) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        if (metadataDevices == null || metadataDevices.length == 0) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        if (!(dataDevices != null && dataDevices.length != 0 || stripedGroups != null && stripedGroups.length != 0)) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        int equ = equipOrdinal;
        if (equ == -1) {
            equ = 0;
        }
        String type = "ms";
        if (fsType == 0) {
            type = "ma";
        }
        DiskDev[] meta = null;
        DiskDev[] data = null;
        StripedGrp[] grp = null;
        String eqTypeForJni = "md";
        if (singleDAU && metadataDevices != null && metadataDevices.length > 0) {
            eqTypeForJni = "mr";
        }
        if (metadataDevices != null) {
            meta = new DiskDev[metadataDevices.length];
            for (i = 0; i < metadataDevices.length; ++i) {
                meta[i] = ((DiskCacheImpl)metadataDevices[i]).getJniDisk();
            }
        }
        if (dataDevices != null) {
            data = new DiskDev[dataDevices.length];
            for (i = 0; i < dataDevices.length; ++i) {
                data[i] = ((DiskCacheImpl)dataDevices[i]).getJniDisk();
                data[i].setEquipType(eqTypeForJni);
            }
        }
        if (stripedGroups != null) {
            grp = new StripedGrp[stripedGroups.length];
            for (i = 0; i < stripedGroups.length; ++i) {
                grp[i] = ((StripedGroupImpl)stripedGroups[i]).getJniStripedGroup();
            }
        }
        MountOptions opt = ((FileSystemMountPropertiesImpl)mountProps).getJniMountOptions();
        opt.setSynchronizedMetadata((short)1);
        FSInfo fsInfo = new FSInfo(fsName, equ, DAUSize, "ma", meta, data, grp, opt, mountPoint);
        SamQFSSystemModelImpl[] models = SamQFSSystemFSManagerImpl.getSystemModels(hostnames);
        FileSystemImpl fs2 = null;
        String savePath = null;
        try {
            fs2 = new FileSystemImpl(models[0], fsInfo);
            savePath = this.theModel.getDumpPath();
        }
        catch (SamFSException e) {
            throw new SamFSMultiHostException(e.getMessage());
        }
        for (int i2 = 0; i2 < models.length; ++i2) {
            try {
                boolean resetCtx = false;
                if (SamQFSUtil.isValidString(savePath)) {
                    models[i2].getJniContext().setDumpPath(savePath);
                    resetCtx = true;
                }
                FS.createAndMount((Ctx)models[i2].getJniContext(), (FSInfo)fsInfo, (boolean)false, (boolean)createMountPoint, (boolean)mountAfterCreate);
                if (i2 == 0) {
                    models[0].getDataStore().clearAvailableAllocatableUnits();
                    models[0].getDataStore().clearTemporaryStripedGroups();
                }
                models[i2].setDumpPath(null);
                if (resetCtx) {
                    models[i2].getJniContext().setDumpPath(null);
                }
                if (i2 != 0) continue;
                fsInfo.doNotMkfs();
                mountAfterCreate = false;
                continue;
            }
            catch (SamFSException e) {
                errorHostNames.add(hostnames[i2]);
                errorExceptions.add(e);
                if (i2 == 0) break;
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]), (Object)fs2);
        }
        return fs2;
    }

    public void addHostToHAFS(FileSystem fs2, String host) throws SamFSMultiStepOpException, SamFSException {
        SamQFSSystemModelImpl newHostModel = (SamQFSSystemModelImpl)SamQFSSystemFSManagerImpl.getApp().getSamQFSSystemModel(host);
        FSInfo fsInfo = null;
        MountOptions opts = null;
        try {
            fsInfo = ((FileSystemImpl)fs2).getJniFSInfo();
            this.verifyEQsAreAvailOnNewHost(fsInfo, newHostModel);
        }
        catch (SamFSException e) {
            if (e.getSAMerrno() == 31116) {
                e = new SamFSException("logic.sharedFSEQInUse", e.getSAMerrno());
            }
            throw e;
        }
        opts = fsInfo.getMountOptions();
        opts.setArchive(opts.isArchive());
        opts.setSynchronizedMetadata((short)1);
        fsInfo.doNotMkfs();
        String savePath = newHostModel.getDumpPath();
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(savePath)) {
            newHostModel.getJniContext().setDumpPath(savePath);
            resetCtx = true;
        }
        FS.createAndMount((Ctx)newHostModel.getJniContext(), (FSInfo)fsInfo, (boolean)false, (boolean)true, (boolean)false);
        newHostModel.setDumpPath(null);
        if (resetCtx) {
            newHostModel.getJniContext().setDumpPath(null);
        }
    }

    public void removeHostFromHAFS(FileSystem fs2, String host) throws SamFSException {
        FS.remove((Ctx)((SamQFSSystemModelImpl)SamQFSSystemFSManagerImpl.getApp().getSamQFSSystemModel(host)).getJniContext(), (String)fs2.getName());
    }

    public void growFileSystem(FileSystem fs2, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups) throws SamFSException {
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        ((FileSystemImpl)fs2).grow(metadataDevices, dataDevices, stripedGroups);
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
        this.theModel.getDataStore().clearAvailableAllocatableUnits();
    }

    public void createDirectory(String fullPath) throws SamFSException {
        if (SamQFSUtil.isValidString(fullPath)) {
            FileUtil.createDir((Ctx)this.theModel.getJniContext(), (String)fullPath);
        }
    }

    public DiskCache[] discoverAUs(boolean availOnly, String[] hosts, boolean forShared) throws SamFSException {
        AU[] auList;
        SamFSConnection connection = this.theModel.getJniConnection();
        TraceUtil.trace2("will launch discoverAUs(" + availOnly + ", " + (hosts == null ? "null)" : "hosts" + SamQFSUtil.arr2Str(hosts)) + ")");
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_MAX_TIME_OUT);
        }
        Ctx ctx = this.theModel.getJniContext();
        if (hosts != null) {
            auList = AU.discoverHAAUs((Ctx)ctx, (String[])hosts, (boolean)availOnly);
        } else {
            AU[] aUArray = auList = availOnly ? AU.discoverAvailAUs((Ctx)ctx) : AU.discoverAUs((Ctx)ctx);
        }
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_TIME_OUT);
        }
        DiskCache[] disks = null;
        if (auList == null) {
            disks = new DiskCache[]{};
        } else {
            disks = new DiskCache[auList.length];
            for (int i = 0; i < auList.length; ++i) {
                DiskDev ddev = new DiskDev(auList[i]);
                if (hosts != null && !forShared) {
                    ddev.convertPathToGlobal();
                }
                disks[i] = new DiskCacheImpl(ddev);
            }
        }
        return disks;
    }

    public DiskCache[] discoverAvailableAllocatableUnits(String[] haHosts) throws SamFSException {
        SamQFSUtil.doPrint("Debug: discoverAvailableAllocatableUnits()");
        return this.discoverAUs(true, haHosts, false);
    }

    public DiskCache[] discoverAllocatableUnits(String[] haHosts) throws SamFSException {
        SamQFSUtil.doPrint("Debug: discoverAllocatableUnits()");
        return this.discoverAUs(false, haHosts, false);
    }

    public DiskCache getAvailableDisk(String path) throws SamFSException {
        DiskCache[] disks;
        DiskCache disk = ((SamQFSDataStoreImpl)this.theModel.getDataStore()).getAvailableDisk(path);
        if (disk == null && (disks = this.discoverAvailableAllocatableUnits(null)) != null) {
            for (int i = 0; i < disks.length; ++i) {
                if (!disks[i].getDevicePath().equals(path)) continue;
                disk = disks[i];
                break;
            }
        }
        return disk;
    }

    public StripedGroup createStripedGroup(String name, DiskCache[] disks) throws SamFSException {
        if (!SamQFSUtil.isValidString(name)) {
            name = new String();
        }
        return new StripedGroupImpl(name, disks);
    }

    public String[] checkSlicesForOverlaps(String[] slices) throws SamFSException {
        String[] list = new String[]{};
        if (!this.theModel.getServerAPIVersion().equals("1.0")) {
            list = AU.checkSlicesForOverlaps((Ctx)this.theModel.getJniContext(), (String[])slices);
        }
        return list;
    }

    public ArchivePolCriteria[] getAllAvailablePolCriteria(FileSystem fs2) throws SamFSException {
        ArrayList<ArchivePolCriteria> available = new ArrayList<ArchivePolCriteria>();
        if (fs2 != null && fs2.getArchivingType() == 2) {
            ArchivePolicy[] policies = this.theModel.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            ArrayList<ArchivePolCriteria> tempList = new ArrayList<ArchivePolCriteria>();
            if (policies != null) {
                for (int i = 0; i < policies.length; ++i) {
                    if (policies[i].getPolicyType() != 1002 && policies[i].getPolicyType() != 1003) continue;
                    ArchivePolCriteria[] polCrits = ((ArchivePolicyImpl)policies[i]).getArchivePolCriteriaForFS(fs2.getName());
                    tempList.clear();
                    for (int j = 0; j < polCrits.length; ++j) {
                        tempList.add(polCrits[j]);
                    }
                    ArchivePolCriteria[] polTotCrits = policies[i].getArchivePolCriteria();
                    for (int j = 0; j < polTotCrits.length; ++j) {
                        int index = tempList.indexOf(polTotCrits[j]);
                        if (index != -1) continue;
                        available.add(polTotCrits[j]);
                    }
                }
            }
        }
        return available.toArray(new ArchivePolCriteria[0]);
    }

    public void deleteFileSystem(GenericFileSystem gfs) throws SamFSException {
        if (gfs == null) {
            throw new SamFSException("logic.invalidFS");
        }
        if (gfs.getState() == 0) {
            throw new SamFSException("logic.mountedFS");
        }
        if (gfs.getFSTypeByProduct() == 13) {
            FS.removeGenericFS((Ctx)this.theModel.getJniContext(), (String)gfs.getName(), (String)gfs.getFSTypeName());
            return;
        }
        FileSystem fs2 = (FileSystem)gfs;
        if ((this.theModel.getLicenseType() == 2 || this.theModel.getLicenseType() == 3) && fs2.getArchivingType() == 2) {
            ArFSDirective ars;
            com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] pol = fs2.getArchivePoliciesForFS();
            if (pol != null) {
                for (int i = 0; i < pol.length; ++i) {
                    pol[i].deleteFileSystemForPolicy(fs2);
                }
            }
            if ((ars = Archiver.getArFSDirective((Ctx)this.theModel.getJniContext(), (String)fs2.getName())) != null) {
                Archiver.resetArFSDirective((Ctx)this.theModel.getJniContext(), (String)fs2.getName());
            }
            for (int i = 1; i <= 4; ++i) {
                String copyName = fs2.getName() + "." + i;
                try {
                    VSNOp.removeMap((Ctx)this.theModel.getJniContext(), (String)copyName);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        FS.remove((Ctx)this.theModel.getJniContext(), (String)fs2.getName());
        this.theModel.getDataStore().clearAvailableAllocatableUnits();
        if ((this.theModel.getLicenseType() == 2 || this.theModel.getLicenseType() == 3) && fs2.getArchivingType() == 2) {
            if (this.theModel.getServerAPIVersion().compareTo("1.3") >= 0) {
                this.setMetadataDumpSchedParams(fs2.getName(), null);
            }
            Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        }
    }

    public com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] getAllAvailableArchivePolicies(FileSystem fs2) throws SamFSException {
        ArrayList<com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy> available = new ArrayList<com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy>();
        if (fs2 != null && fs2.getArchivingType() == 2) {
            com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] pols;
            com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] polsInFS = fs2.getArchivePoliciesForFS();
            HashMap<String, com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy> map = new HashMap<String, com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy>();
            if (polsInFS != null) {
                for (int i = 0; i < polsInFS.length; ++i) {
                    map.put(polsInFS[i].getPolicyName(), polsInFS[i]);
                }
            }
            if ((pols = this.theModel.getSamQFSSystemArchiveManager().getAllArchivePolicies()) != null) {
                for (int i = 0; i < pols.length; ++i) {
                    Object o = map.get(pols[i].getPolicyName());
                    if (o != null) continue;
                    available.add(pols[i]);
                }
            }
        }
        return available.toArray(new com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[0]);
    }

    public RemoteFile[] getDirEntries(int maxEntries, String dirPath, Filter filter) throws SamFSException {
        this.remoteFiles = null;
        String[] fileNames = FileUtil.getDirEntries((Ctx)this.theModel.getJniContext(), (int)maxEntries, (String)dirPath, (String)(filter == null ? null : filter.toString()));
        if (fileNames != null) {
            fileNames = this.prependDirName(dirPath, fileNames, 0, fileNames.length);
            this.remoteFiles = new RemoteFile[fileNames.length];
            String[] fDetails = FileUtil.getFileDetails((Ctx)this.theModel.getJniContext(), (String)"", (String[])fileNames);
            int[] fTypes = FileUtil.getFileStatus((Ctx)this.theModel.getJniContext(), (String[])fileNames);
            for (int i = 0; i < fileNames.length; ++i) {
                this.remoteFiles[i] = new RemoteFile(fileNames[i], fTypes[i], ConversionUtil.strToProps(fDetails[i]));
            }
        }
        return this.remoteFiles;
    }

    public RemoteFile[] getDirEntriesFromLocalCache(int startPos, int howMany) {
        int n;
        int n2 = n = this.remoteFiles == null ? 0 : this.remoteFiles.length;
        if (startPos + howMany > n) {
            howMany = n - startPos;
        }
        RemoteFile[] files = new RemoteFile[howMany];
        for (int i = startPos; i < howMany; ++i) {
            files[i] = this.remoteFiles[i];
        }
        return files;
    }

    public void setMetadataDumpSchedParams(String fsName, DumpSched dumpParams) throws SamFSException {
        Restore.setParams((Ctx)this.theModel.getJniContext(), (String)fsName, (String)(dumpParams == null ? null : dumpParams.toString()));
    }

    public DumpSched getMetadataDumpSchedParams(String fsName) throws SamFSException {
        DumpSched dump = null;
        String dumpParamsStr = Restore.getParams((Ctx)this.theModel.getJniContext(), (String)fsName);
        if (dumpParamsStr != null && dumpParamsStr.length() > 0) {
            dump = new DumpSched(ConversionUtil.strToProps(dumpParamsStr));
        }
        return dump;
    }

    public long startMetadataDump(String fsName, String fullDumpPath) throws SamFSException {
        String id = Restore.takeDump((Ctx)this.theModel.getJniContext(), (String)fsName, (String)fullDumpPath);
        return 100L * ConversionUtil.strToLongVal(id) + 10L;
    }

    public RestoreDumpFile[] getAvailableDumpFiles(String fsName, String directory) throws SamFSException {
        String[] dumpNames = null;
        dumpNames = this.getVersion45().isAPICompatibleWithUI() ? Restore.getDumps((Ctx)this.theModel.getJniContext(), (String)fsName, (String)directory) : Restore.getDumps((Ctx)this.theModel.getJniContext(), (String)fsName);
        int n = dumpNames == null ? 0 : dumpNames.length;
        String[] dumpInfos = null;
        dumpInfos = this.getVersion45().isAPICompatibleWithUI() ? Restore.getDumpStatus((Ctx)this.theModel.getJniContext(), (String)fsName, (String)directory, (String[])dumpNames) : Restore.getDumpStatus((Ctx)this.theModel.getJniContext(), (String)fsName, (String[])dumpNames);
        RestoreDumpFile[] files = new RestoreDumpFile[n];
        for (int i = 0; i < n; ++i) {
            files[i] = new RestoreDumpFile(dumpNames[i], ConversionUtil.strToProps(dumpInfos[i]));
        }
        return files;
    }

    public long enableDumpFileForUse(String fsName, String directory, String dumpFilename) throws SamFSException {
        String idStr;
        String dumpPath = dumpFilename;
        if (this.getVersion45().isAPICompatibleWithUI()) {
            dumpPath = SamUtil.buildPath(directory, dumpFilename);
        }
        if ((idStr = Restore.decompressDump((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpPath)) == null) {
            return -1L;
        }
        return 100L * ConversionUtil.strToLongVal(idStr) + 11L;
    }

    public RestoreFile getRestoreFile(String fsName, String directory, String dumpFilename, String fileName) throws SamFSException {
        String dumpPath = dumpFilename;
        if (this.getVersion45().isAPICompatibleWithUI()) {
            dumpPath = SamUtil.buildPath(directory, dumpFilename);
        }
        return new RestoreFileImpl(fileName, Restore.getVersionDetails((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpPath, (String)fileName));
    }

    public RestoreFile getEntireFSRestoreFile() throws SamFSException {
        RestoreFileImpl file = new RestoreFileImpl(".", new String[]{"fake details"});
        file.setRestorePath(".");
        return file;
    }

    protected String[] prependDirName(String dirName, String[] fileNames, int startIdx, int pageCount) {
        String[] fullNames = new String[fileNames.length];
        int count = startIdx + pageCount;
        for (int i = startIdx; i < count; ++i) {
            fullNames[i] = dirName + "/" + fileNames[i];
        }
        return fullNames;
    }

    protected RestoreFile[] getRestoreFiles(String fsName, String dumpFullPath, String[] fileNames, int startIdx, int pageCount) throws SamFSException {
        RestoreFile[] restoreFiles = new RestoreFile[fileNames.length];
        int count = startIdx + pageCount;
        for (int i = startIdx; i < count; ++i) {
            String[] fDetails = Restore.getVersionDetails((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpFullPath, (String)fileNames[i]);
            restoreFiles[i] = new RestoreFileImpl(fileNames[i], fDetails);
        }
        return restoreFiles;
    }

    public RestoreFile[] getDumpFileContents(String fsName, String directory, String dumpFilename, String dirName, Filter filter, int maxCount, int startIdx, int pageCount) throws SamFSException {
        String[] fileNames;
        String dumpPath = dumpFilename;
        if (this.getVersion45().isAPICompatibleWithUI()) {
            dumpPath = SamUtil.buildPath(directory, dumpFilename);
        }
        if (!dumpPath.equals(this.searchedDumpFullPath)) {
            this.getFromCache = false;
            this.searchedDumpFullPath = null;
        }
        if ((fileNames = Restore.listVersions((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpPath, (int)maxCount, (String)dirName, (String)(filter == null ? null : filter.toString()))) == null || fileNames.length == 0) {
            return new RestoreFile[0];
        }
        if (pageCount <= 0) {
            pageCount = fileNames.length - startIdx;
        }
        if (startIdx + pageCount > fileNames.length) {
            pageCount = fileNames.length - startIdx;
        }
        return this.getRestoreFiles(fsName, dumpPath, this.prependDirName(dirName, fileNames, startIdx, pageCount), startIdx, pageCount);
    }

    public long searchDumpFileContents(String fsName, String directory, String dumpFilename, Filter filter, int maxCount) throws SamFSException {
        String dumpPath = dumpFilename;
        if (this.getVersion45().isAPICompatibleWithUI()) {
            dumpPath = SamUtil.buildPath(directory, dumpFilename);
        }
        this.searchedDumpFullPath = dumpPath;
        this.getFromCache = false;
        String taskID = Restore.searchFiles((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpPath, (int)maxCount, null, (String)filter.toString());
        return 100L * ConversionUtil.strToLongVal(taskID) + 13L;
    }

    public RestoreFile[] getSearchResults(String fsName, int startIdx, int pageCount) throws SamFSException {
        if (this.searchedDumpFullPath == null) {
            return new RestoreFile[0];
        }
        if (!this.getFromCache) {
            try {
                String[] fileNames = Restore.getSearchResults((Ctx)this.theModel.getJniContext(), (String)fsName);
                if (fileNames == null || fileNames.length == 0) {
                    return new RestoreFile[0];
                }
                this.cachedSearchNames = fileNames;
                this.getFromCache = true;
            }
            catch (SamFSException e) {
                this.cachedSearchNames = new String[0];
                this.getFromCache = true;
                throw e;
            }
        }
        if (pageCount <= 0) {
            pageCount = this.cachedSearchNames.length - startIdx;
        }
        if (startIdx + pageCount > this.cachedSearchNames.length) {
            pageCount = this.cachedSearchNames.length - startIdx;
        }
        return this.getRestoreFiles(fsName, this.searchedDumpFullPath, this.cachedSearchNames, startIdx, pageCount);
    }

    public long restoreFiles(String fsName, String directory, String dumpFilename, int replaceType, RestoreFile[] files) throws SamFSException {
        if (replaceType != 0 && replaceType != 1 && replaceType != 2) {
            throw new SamFSException("Invalid replace type:  " + String.valueOf(replaceType));
        }
        String dumpPath = dumpFilename;
        if (this.getVersion45().isAPICompatibleWithUI()) {
            dumpPath = SamUtil.buildPath(directory, dumpFilename);
        }
        String taskID = Restore.restoreInodes((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpPath, (String[])new String[]{files[0].getAbsolutePath()}, (String[])new String[]{files[0].getRestorePath()}, (int[])new int[]{files[0].getStageCopy()}, (int)replaceType);
        return 100L * ConversionUtil.strToLongVal(taskID) + 12L;
    }

    public String getDumpFileTopLevelDirectory(String fsName, String directory, String dumpFile) {
        return ".";
    }

    public void cleanDump(String fsName, String directory, String dumpName) throws SamFSException {
        String dumpPath = dumpName;
        if (this.getVersion45().isAPICompatibleWithUI()) {
            dumpPath = SamUtil.buildPath(directory, dumpName);
        }
        Restore.cleanDump((Ctx)this.theModel.getJniContext(), (String)fsName, (String)dumpPath);
    }

    public void deleteDump(String fsName, String directory, String dumpName) throws SamFSException {
        String fullPath = SamUtil.buildPath(directory, dumpName);
        Restore.deleteDump((Ctx)this.theModel.getJniContext(), (String)fsName, (String)fullPath);
    }

    public void setIsDumpRetainedPermanently(String fsName, String directory, String dumpName, boolean retainValue) throws SamFSException {
        String fullPath = SamUtil.buildPath(directory, dumpName);
        Restore.setIsDumpRetainedPermanently((Ctx)this.theModel.getJniContext(), (String)fullPath, (boolean)retainValue);
    }

    public GenericFileSystem createUFS(DiskCache dev, String mountPoint, GenericMountOptions mountOpts, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiStepOpException, SamFSException {
        DiskDev[] data = new DiskDev[]{((DiskCacheImpl)dev).getJniDisk()};
        MountOptions jniMo = new MountOptions();
        jniMo.setReadOnlyMount(mountOpts.isReadOnlyMount());
        jniMo.setNoSetUID(mountOpts.isNoSetUID());
        FSInfo fsInfo = new FSInfo(dev.getDevicePath(), 0, 0, "ufs", null, data, null, jniMo, mountPoint);
        FS.createAndMount((Ctx)this.theModel.getJniContext(), (FSInfo)fsInfo, (boolean)mountAtBoot, (boolean)createMountPoint, (boolean)mountAfterCreate);
        return new GenericFileSystemImpl(this.theModel.getHostname(), dev.getDevicePath(), "ufs", 0, mountPoint, dev.getCapacity(), dev.getAvailableSpace());
    }

    public StageFile[] getStageFiles(int maxEntries, String dirPath, Filter filter) throws SamFSException {
        if (maxEntries == 0) {
            maxEntries = 25;
        }
        String filterString = filter == null ? null : filter.toString();
        String[] fileName = FileUtil.getDirEntries((Ctx)this.theModel.getJniContext(), (int)maxEntries, (String)dirPath, (String)filterString);
        StageFile[] stageFile = null;
        if (fileName != null && fileName.length > 0) {
            stageFile = new StageFile[fileName.length];
            int theseDetails = 61711;
            for (int i = 0; i < fileName.length; ++i) {
                fileName[i] = dirPath.concat("/").concat(fileName[i]);
            }
            String[] fileDetail = FileUtil.getExtFileDetails((Ctx)this.theModel.getJniContext(), (String[])fileName, (int)theseDetails);
            for (int i = 0; i < fileDetail.length; ++i) {
                stageFile[i] = this.parseStageFileDetails(fileDetail[i]);
            }
        }
        return stageFile;
    }

    protected StageFile parseStageFileDetails(String details) {
        Properties properties = ConversionUtil.delimitedStringToProperties(details);
        String fileName = properties.getProperty("file_name");
        String temp = properties.getProperty("file_type");
        int type = temp != null ? Integer.parseInt(temp.trim()) : -1;
        temp = properties.getProperty("size");
        long size = temp != null ? Long.parseLong(temp.trim()) : -1L;
        temp = properties.getProperty("create");
        long ctime = temp != null ? Long.parseLong(temp.trim()) : -1L;
        temp = properties.getProperty("modified");
        long mtime = temp != null ? Long.parseLong(temp.trim()) : -1L;
        StageFile file = new StageFile(fileName, size, mtime, type);
        temp = properties.getProperty("stage_atts");
        file.setStageAttributes(temp != null ? Integer.parseInt(temp) : -1);
        temp = properties.getProperty("release_atts");
        file.setReleaseAttributes(temp != null ? Integer.parseInt(temp) : -1);
        file.setProperties(properties);
        file.setRawDetails(details);
        return file;
    }

    protected int getOnlineStatus(Properties properties) {
        int onlineStatus = 0;
        String segmented = properties.getProperty("seg_count");
        if (segmented == null || Integer.parseInt(segmented) <= 0) {
            String temp = properties.getProperty("online");
            if (temp != null) {
                onlineStatus = 1;
            }
            if ((temp = properties.getProperty("offline")) != null) {
                onlineStatus = 2;
            }
            if ((temp = properties.getProperty("partial_online")) != null) {
                onlineStatus = 4;
            }
        }
        return onlineStatus;
    }

    public String[] getStageCopyDetails(String filePath) throws SamFSException {
        int theseDetails = 0;
        return FileUtil.getCopyDetails((Ctx)this.theModel.getJniContext(), (String)filePath, (int)theseDetails);
    }

    public void stageFiles(int[] copy, String[] filePaths, int[] options) throws SamFSException {
        Stager.stageFiles((Ctx)this.theModel.getJniContext(), (int[])copy, (String[])filePaths, (int[])options);
    }
}

