/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCDateTimeModel;
import java.io.Serializable;
import java.util.Date;

public class DumpSchedDateTimeModel
extends CCDateTimeModel
implements Serializable {
    public static final String REPEAT_INTERVAL_4HOURS = "Interval4Hours";
    public static final String REPEAT_INTERVAL_8HOURS = "Interval8Hours";

    public DumpSchedDateTimeModel() {
        this.setStartDateTime(new Date());
        this.createRepeatInterval(REPEAT_INTERVAL_4HOURS, 1, 1, "FSScheduleDump.repeatInterval.4hours");
        this.createRepeatInterval(REPEAT_INTERVAL_8HOURS, 1, 1, "FSScheduleDump.repeatInterval.8hours");
        String[] intervals = new String[]{"hourly", REPEAT_INTERVAL_4HOURS, REPEAT_INTERVAL_8HOURS, "daily", "weekly", "monthly"};
        this.setRepeatIntervals(intervals);
        this.setSelectedRepeatIntervalName("daily");
        this.setType(1);
        this.setShowRequiredMsg(false);
        TraceUtil.initTrace();
        TraceUtil.trace3("I'm here");
    }

    public String getRepeatIntervalPresentation(String intervalName) {
        if (intervalName.equals("monthly")) {
            return "FSScheduleDump.repeatInterval.30days";
        }
        return super.getRepeatIntervalPresentation(intervalName);
    }

    public static String getIntervalNameFromUnit(long repeat) {
        String intervalString = "weekly";
        if (repeat <= 0L) {
            intervalString = "onetime";
        } else if (repeat <= 3600L) {
            intervalString = "hourly";
        } else if (repeat <= 14400L) {
            intervalString = REPEAT_INTERVAL_4HOURS;
        } else if (repeat <= 28800L) {
            intervalString = REPEAT_INTERVAL_8HOURS;
        } else if (repeat <= 86400L) {
            intervalString = "daily";
        } else if (repeat <= 604800L) {
            intervalString = "weekly";
        } else if (repeat <= 2592000L) {
            intervalString = "monthly";
        }
        return intervalString;
    }

    public static long getIntervalUnitFromName(String intervalString) {
        long repeat = 2592000L;
        if (intervalString.equals("onetime")) {
            repeat = 0L;
        } else if (intervalString.equals("hourly")) {
            repeat = 3600L;
        } else if (intervalString.equals(REPEAT_INTERVAL_4HOURS)) {
            repeat = 14400L;
        } else if (intervalString.equals(REPEAT_INTERVAL_8HOURS)) {
            repeat = 28800L;
        } else if (intervalString.equals("daily")) {
            repeat = 86400L;
        } else if (intervalString.equals("weekly")) {
            repeat = 604800L;
        } else if (intervalString.equals("monthly")) {
            repeat = 2592000L;
        }
        return repeat;
    }

    public String toString() {
        return super.toString();
    }
}

