/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.wizards.ReservationFSView;
import com.sun.netstorage.samqfs.web.media.wizards.ReservationImplData;
import com.sun.netstorage.samqfs.web.media.wizards.ReservationMethodView;
import com.sun.netstorage.samqfs.web.media.wizards.ReservationPolicyView;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import javax.servlet.http.HttpServletRequest;

public class ReservationImpl
extends SamWizardImpl {
    public static final String WIZARDPAGEMODELNAME = "ReservationPageModelName";
    public static final String WIZARDPAGEMODELNAME_PREFIX = "WizardModel";
    public static final String WIZARDIMPLNAME = "ReservationWizardImpl";
    public static final String WIZARDIMPLNAME_PREFIX = "WizardImpl";
    public static final String WIZARDCLASSNAME = "com.sun.netstorage.samqfs.web.media.wizards.ReservationImpl";
    private boolean fsFlag = false;
    private boolean policyFlag = false;
    private boolean ownerFlag = false;
    private static String libraryName = null;
    private static String slotNumber = null;
    private static String eqValue = null;
    private static String serverName = null;
    private String method = null;
    private boolean wizardInitialized = false;

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering create()");
        TraceUtil.trace3("Exiting");
        return new ReservationImpl(requestContext);
    }

    public ReservationImpl(RequestContext requestContext) {
        super(requestContext, WIZARDPAGEMODELNAME);
        this.processInitialRequest(requestContext.getRequest());
        this.initializeWizard();
        this.initializeWizardControl(requestContext);
    }

    private void initializeWizard() {
        TraceUtil.trace3("Entering");
        this.wizardName = "ReservationImpl";
        this.wizardTitle = "Reservation.title";
        this.pageClass = ReservationImplData.pageClass;
        this.pageTitle = ReservationImplData.pageTitle;
        this.stepHelp = ReservationImplData.stepHelp;
        this.stepText = ReservationImplData.stepText;
        this.stepInstruction = ReservationImplData.stepInstruction;
        this.cancelMsg = ReservationImplData.cancelMsg;
        this.pages = ReservationImplData.defaultPages;
        this.setShowResultsPage(true);
        this.initializeWizardPages(this.pages);
        TraceUtil.trace3("Exiting");
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return ReservationImpl.getWizardWindowModel(WIZARDIMPLNAME, "Reservation.title", WIZARDCLASSNAME, cmdChild);
    }

    private void processInitialRequest(HttpServletRequest request) {
        serverName = request.getParameter("serverNameParam");
        libraryName = request.getParameter("libraryNameParam");
        slotNumber = request.getParameter("slotNumberParam");
        eqValue = request.getParameter("eqValueParam");
        if (serverName != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Wizard Key: serverName is ").append(serverName).toString());
            this.wizardModel.setValue("SERVER_NAME", serverName);
        } else {
            serverName = "";
            SamUtil.doPrint("Wizard Key: serverName is null");
        }
        if (libraryName != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Wizard Key: libraryName is ").append(libraryName).toString());
        } else {
            libraryName = "";
            SamUtil.doPrint("Wizard Key: libraryName is null");
        }
        if (slotNumber != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Wizard Key: slotNumber is ").append(slotNumber).toString());
        } else {
            slotNumber = "";
            SamUtil.doPrint("Wizard Key: slotNumber is null");
        }
        if (eqValue != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Wizard Key: eqValue is ").append(eqValue).toString());
        } else {
            eqValue = "";
            SamUtil.doPrint("Wizard Key: eqValue is null");
        }
    }

    public String[] getFuturePages(String currentPageId) {
        TraceUtil.trace3("Entering getFuturePages()");
        int page = this.pageIdToPage(currentPageId) + 1;
        String[] futurePages = null;
        if (page - 1 == 0) {
            futurePages = new String[]{};
        } else {
            int howMany = this.pages.length - page;
            futurePages = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                futurePages[i] = Integer.toString(page + i);
            }
        }
        TraceUtil.trace3("Exiting");
        return futurePages;
    }

    public String[] getFutureSteps(String currentPageId) {
        TraceUtil.trace3("Entering getFutureSteps()");
        int page = this.pageIdToPage(currentPageId);
        String[] futureSteps = null;
        if (page == 0) {
            futureSteps = new String[]{};
        } else {
            int howMany = this.pages.length - page - 1;
            futureSteps = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                int futureStep = page + 1 + i;
                int futurePage = this.pages[futureStep];
                futureSteps[i] = this.stepText[futurePage];
            }
        }
        TraceUtil.trace3("Exiting");
        return futureSteps;
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        if (this.wizardInitialized) {
            this.wizardModel.setValue("ERROR", "No");
        }
        return super.getPageClass(pageId);
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        super.nextStep(wizardEvent);
        this.wizardInitialized = true;
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer().append("nextStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 0: {
                result = this.processMethodPage(wizardEvent);
                if (!result) break;
                this.updateWizardSteps();
                break;
            }
            case 1: {
                result = this.processFSPage(wizardEvent, true);
                break;
            }
            case 2: {
                result = this.processPolicyPage(wizardEvent, true);
                break;
            }
            case 3: {
                result = this.processOwnerPage(wizardEvent);
            }
        }
        TraceUtil.trace3("Entering");
        return result;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        super.previousStep(wizardEvent);
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer("previousStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 1: {
                result = this.processFSPage(wizardEvent, false);
                break;
            }
            case 2: {
                result = this.processPolicyPage(wizardEvent, false);
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
        return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        boolean returnValue = true;
        String errMsg = null;
        String errCode = null;
        int eq = -1;
        if (!super.finishStep(wizardEvent)) {
            return false;
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            VSN myVSN = null;
            String ogdName = null;
            String fsName = null;
            String policyName = null;
            int ownerType = -1;
            if (this.fsFlag) {
                fsName = (String)this.wizardModel.getValue("fsValue");
            }
            if (this.policyFlag) {
                policyName = (String)this.wizardModel.getValue("policyValue");
            }
            if (this.ownerFlag) {
                if (this.method.equals("ReservationOwner.radio1")) {
                    ownerType = 2;
                    ogdName = (String)this.wizardModel.getValue("ownerValue");
                } else if (this.method.equals("ReservationOwner.radio2")) {
                    ownerType = 3;
                    ogdName = (String)this.wizardModel.getValue("groupValue");
                } else {
                    ownerType = 4;
                    ogdName = (String)this.wizardModel.getValue("dirValue");
                }
                SamUtil.doPrint(new NonSyncStringBuffer().append("ogdName is ").append(ogdName).toString());
            }
            myVSN = this.getSelectedVSN();
            eq = myVSN.getSlotNumber();
            this.wizardModel.setValue("slot_num", Integer.toString(eq));
            SamUtil.doPrint("finishStep: About to reserve !!!");
            LogUtil.info(this.getClass(), "finishStep", "Start reserving VSN");
            myVSN.reserve(policyName, fsName, ownerType, ogdName);
            LogUtil.info(this.getClass(), "finishStep", "Done reserving VSN");
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep", "Failed to reserve VSN", serverName);
            errMsg = ex.getMessage();
            errCode = Integer.toString(ex.getSAMerrno());
            returnValue = false;
        }
        if (returnValue) {
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("VSNSummary.msg.reserve", Integer.toString(eq)));
        } else {
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "VSNSummary.error.reserve");
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
            this.wizardModel.setValue("Detail_code", errCode);
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private String saveSelectFSSettings(WizardEvent wizardEvent, boolean next) {
        TraceUtil.trace3("Entering");
        try {
            ReservationFSView pageView = (ReservationFSView)wizardEvent.getView();
            CCActionTable actionTable = (CCActionTable)pageView.getChild("SelectFSTable");
            actionTable.restoreStateData();
            CCActionTableModel fsModel = (CCActionTableModel)actionTable.getModel();
            Integer[] selectedRows = fsModel.getSelectedRows();
            if (selectedRows.length == 0) {
                if (next) {
                    this.setErrorMessage(wizardEvent, "Reservation.page2.errMsg");
                    TraceUtil.trace3("Exiting");
                    return "NO_ENTRY";
                }
                TraceUtil.trace3("Clearing fs field");
                this.wizardModel.setValue("fsValue", "");
                TraceUtil.trace3("Exiting");
                return "SUCCESS";
            }
            int row = selectedRows[0];
            fsModel.setRowIndex(row);
            String fsName = (String)fsModel.getValue("NameText");
            this.wizardModel.setValue("fsValue", fsName);
            SamUtil.doPrint(new NonSyncStringBuffer("Selected FS name is ").append(fsName).toString());
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), this.getClass(), "saveSelectFSSettings", "Failed to save filesystem selections", serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", mcex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
        }
        TraceUtil.trace3("Exiting");
        return "SUCCESS";
    }

    private String saveSelectPolicySettings(WizardEvent wizardEvent, boolean next) {
        TraceUtil.trace3("Entering");
        SamUtil.doPrint(new NonSyncStringBuffer().append("saveSelectPolicySettings: next is ").append(next).toString());
        try {
            CCActionTable actionTable = null;
            ReservationPolicyView pageView = (ReservationPolicyView)wizardEvent.getView();
            actionTable = (CCActionTable)pageView.getChild("SelectPolicyTable");
            actionTable.restoreStateData();
            CCActionTableModel polModel = (CCActionTableModel)actionTable.getModel();
            Integer[] selectedRows = polModel.getSelectedRows();
            if (selectedRows.length == 0) {
                if (next) {
                    this.setErrorMessage(wizardEvent, "Reservation.page3.errMsg");
                    TraceUtil.trace3("Exiting");
                    return "NO_ENTRY";
                }
                TraceUtil.trace3("Clearing policy field");
                this.wizardModel.setValue("policyValue", "");
                TraceUtil.trace3("Exiting");
                return "SUCCESS";
            }
            int row = selectedRows[0];
            polModel.setRowIndex(row);
            String polName = (String)polModel.getValue("NameText");
            this.wizardModel.setValue("policyValue", polName);
            SamUtil.doPrint(new NonSyncStringBuffer("Selected Policy Name is ").append(polName).toString());
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), this.getClass(), "saveSelectPolicySettings", "Failed to save policy selections", serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", mcex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
        }
        TraceUtil.trace3("Exiting");
        return "SUCCESS";
    }

    private boolean processMethodPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        ReservationMethodView pageView = (ReservationMethodView)wizardEvent.getView();
        this.fsFlag = ((String)pageView.getDisplayFieldValue("CheckBox1")).equals("true");
        this.policyFlag = ((String)pageView.getDisplayFieldValue("CheckBox2")).equals("true");
        this.ownerFlag = ((String)pageView.getDisplayFieldValue("CheckBox3")).equals("true");
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        SamUtil.doPrint(new NonSyncStringBuffer().append("fsFlag is ").append(this.fsFlag).toString());
        SamUtil.doPrint(new NonSyncStringBuffer().append("policyFlag is ").append(this.policyFlag).toString());
        SamUtil.doPrint(new NonSyncStringBuffer().append("ownerFlag is ").append(this.ownerFlag).toString());
        if (!(this.fsFlag || this.policyFlag || this.ownerFlag)) {
            this.setErrorMessage(wizardEvent, "Reservation.method.errMsg");
            TraceUtil.trace3("Exiting");
            return false;
        }
        if (this.fsFlag) {
            buf.append(SamUtil.getResourceString("ReservationMethod.checkbox1"));
        } else {
            this.wizardModel.setValue("fsValue", "");
        }
        if (this.policyFlag) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append(SamUtil.getResourceString("ReservationMethod.checkbox2"));
        } else {
            this.wizardModel.setValue("policyValue", "");
        }
        if (this.ownerFlag) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append(SamUtil.getResourceString("ReservationMethod.checkbox3"));
        } else {
            this.wizardModel.setValue("ownerValue", "");
            this.wizardModel.setValue("groupValue", "");
            this.wizardModel.setValue("dirValue", "");
        }
        this.wizardModel.setValue("methodValue", buf.toString());
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processFSPage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        String errMsg = this.saveSelectFSSettings(wizardEvent, isNextStep);
        TraceUtil.trace3(new NonSyncStringBuffer("errMsg in processFSPage() is ").append(errMsg).toString());
        boolean success = false;
        if (errMsg != null && errMsg.length() != 0) {
            if (errMsg.equals("NO_ENTRY")) {
                return false;
            }
            if (errMsg.equals("SUCCESS")) {
                success = true;
            }
        }
        if (!success) {
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", errMsg);
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(-2509));
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processPolicyPage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        String errMsg = this.saveSelectPolicySettings(wizardEvent, isNextStep);
        boolean success = false;
        if (errMsg != null && errMsg.length() != 0) {
            if (errMsg.equals("NO_ENTRY")) {
                return false;
            }
            if (errMsg.equals("SUCCESS")) {
                success = true;
            }
        }
        if (!success) {
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", errMsg);
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(-2509));
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processOwnerPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        this.method = (String)this.wizardModel.getValue("RadioButton1");
        if (this.method == null) {
            TraceUtil.trace3("Exiting: method is null");
            this.setErrorMessage(wizardEvent, "Reservation.page4.errMsg1");
            return false;
        }
        this.method = this.method.trim();
        int showError = 0;
        SamUtil.doPrint(new NonSyncStringBuffer("method is ").append(this.method).toString());
        if (this.method.length() == 0) {
            showError = 2;
        } else if (this.method.equals("ReservationOwner.radio1")) {
            this.wizardModel.setValue("groupValue", "");
            this.wizardModel.setValue("dirValue", "");
            String ownerValue = (String)this.wizardModel.getValue("ownerValue");
            if (ownerValue != null && ownerValue.length() != 0) {
                if (ownerValue.trim().indexOf("/") != -1) {
                    showError = 1;
                } else if (ownerValue.trim().length() == 0) {
                    showError = 2;
                }
            } else {
                showError = 2;
            }
        } else if (this.method.equals("ReservationOwner.radio2")) {
            this.wizardModel.setValue("ownerValue", "");
            this.wizardModel.setValue("dirValue", "");
            String groupValue = (String)this.wizardModel.getValue("groupValue");
            if (groupValue != null && groupValue.length() != 0) {
                if (groupValue.trim().indexOf("/") != -1) {
                    showError = 1;
                } else if (groupValue.trim().length() == 0) {
                    showError = 2;
                }
            } else {
                showError = 2;
            }
        } else if (this.method.equals("ReservationOwner.radio3")) {
            this.wizardModel.setValue("ownerValue", "");
            this.wizardModel.setValue("groupValue", "");
            String dirValue = (String)this.wizardModel.getValue("dirValue");
            if (dirValue != null && dirValue.length() != 0) {
                if (dirValue.trim().indexOf("/") != -1) {
                    showError = 1;
                } else if (dirValue.trim().length() == 0) {
                    showError = 2;
                }
            } else {
                showError = 2;
            }
        }
        if (showError == 1 || showError == 2) {
            if (showError == 1) {
                this.setErrorMessage(wizardEvent, "Reservation.page4.errMsg2");
            } else {
                this.setErrorMessage(wizardEvent, "Reservation.page4.errMsg1");
            }
            TraceUtil.trace3("Exiting");
            return false;
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private void setErrorMessage(WizardEvent wizardEvent, String errMsg) {
        wizardEvent.setSeverity(0);
        wizardEvent.setErrorMessage(errMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VSN getSelectedVSN() throws SamFSException {
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Library myLibrary = null;
        VSN myVSN = null;
        if (libraryName == null) {
            throw new SamFSException(null, -2502);
        }
        if (libraryName.equals("$STANDALONE")) {
            if (eqValue == null) {
                throw new SamFSException(null, -2504);
            }
            Drive myDrive = sysModel.getSamQFSSystemMediaManager().getStdAloneByEQ(Integer.parseInt(eqValue));
            if (myDrive == null) throw new SamFSException(null, -2503);
            myVSN = myDrive.getVSN();
        } else {
            if (libraryName.equals("<Historian>")) {
                libraryName = "Historian";
            }
            if (slotNumber == null) {
                throw new SamFSException(null, -2507);
            }
            myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libraryName);
            if (myLibrary == null) {
                throw new SamFSException(null, -2501);
            }
            try {
                myVSN = myLibrary.getVSN(Integer.parseInt(slotNumber));
            }
            catch (NumberFormatException numEx) {
                SamUtil.doPrint("NumberFormatException caught while parsing slotKey");
                throw new SamFSException(null, -2507);
            }
        }
        if (myVSN != null) return myVSN;
        throw new SamFSException(null, -2507);
    }

    private void updateWizardSteps() {
        this.pages = new int[this.getTotalNumberOfPages()];
        this.pages[0] = 0;
        if (this.fsFlag) {
            this.pages[1] = 1;
        }
        if (this.policyFlag) {
            if (this.fsFlag) {
                this.pages[2] = 2;
            } else {
                this.pages[1] = 2;
            }
        }
        if (this.ownerFlag) {
            if (this.fsFlag && this.policyFlag) {
                this.pages[3] = 3;
            } else if (this.fsFlag || this.policyFlag) {
                this.pages[2] = 3;
            } else {
                this.pages[1] = 3;
            }
        }
        this.pages[this.getTotalNumberOfPages() - 2] = 4;
        this.pages[this.getTotalNumberOfPages() - 1] = 5;
        this.initializeWizardPages(this.pages);
    }

    private int getTotalNumberOfPages() {
        int total = 3;
        if (this.fsFlag) {
            ++total;
        }
        if (this.policyFlag) {
            ++total;
        }
        if (this.ownerFlag) {
            ++total;
        }
        SamUtil.doPrint(new NonSyncStringBuffer().append("Total Number of pages in Reservation Wizard is ").append(total).toString());
        return total;
    }
}

