/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public final class LibraryFaultsSummaryModel
extends CCActionTableModel {
    private String selectedFault = null;
    private ArrayList latestRows;

    public LibraryFaultsSummaryModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/media/LibraryFaultsSummaryTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initActionButtons();
        this.initFilterMenu();
        this.initHeaders();
        this.initProductName();
        this.initSortingCriteria();
        TraceUtil.trace3("Exiting");
    }

    private void initSortingCriteria() {
        TraceUtil.trace3("Entering");
        this.setPrimarySortName("Alarm");
        this.setPrimarySortOrder("descending");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("AcknowledgeButton", "alarm.button.ack");
        this.setActionValue("DeleteButton", "alarm.button.delete");
        TraceUtil.trace3("Exiting");
    }

    private void initFilterMenu() {
        TraceUtil.trace3("Entering");
        this.setActionValue("FilterMenu", "alarm.filterOptions.header");
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("IDColumn", "alarm.heading.id");
        this.setActionValue("SeverityColumn", "alarm.heading.severity");
        this.setActionValue("TimeColumn", "alarm.heading.time");
        this.setActionValue("StateColumn", "alarm.heading.state");
        this.setActionValue("DescriptionColumn", "alarm.heading.desc");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName, String libraryNameString) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        this.latestRows = new ArrayList();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        SamUtil.doPrint(new NonSyncStringBuffer("initModelRows: libraryNameString is ").append(libraryNameString).toString());
        String libraryName = null;
        if (libraryNameString.indexOf("#") == -1) {
            libraryName = libraryNameString;
        } else {
            StringTokenizer tokens = new StringTokenizer(libraryNameString, "#");
            if (tokens.hasMoreTokens()) {
                libraryName = tokens.nextToken();
            }
        }
        SamUtil.doPrint(new NonSyncStringBuffer("libraryName (after parsing) is ").append(libraryName).toString());
        if (libraryName == null) {
            throw new SamFSException(null, -2502);
        }
        CCAlarmObject alarm = null;
        long alarmID = -1L;
        String severity = null;
        String description = null;
        String status = null;
        String severityText = null;
        GregorianCalendar time = null;
        Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libraryName);
        if (myLibrary == null) {
            throw new SamFSException(null, -2502);
        }
        Alarm[] allAlarms = myLibrary.getAssociatedAlarms();
        if (allAlarms == null) {
            return;
        }
        for (int i = 0; i < allAlarms.length; ++i) {
            switch (allAlarms[i].getSeverity()) {
                case 0: {
                    severity = "CRITICAL";
                    alarm = new CCAlarmObject(2);
                    severityText = "alarm.filterOptions.critical";
                    break;
                }
                case 1: {
                    severity = "MAJOR";
                    alarm = new CCAlarmObject(3);
                    severityText = "alarm.filterOptions.major";
                    break;
                }
                case 2: {
                    severity = "MINOR";
                    alarm = new CCAlarmObject(4);
                    severityText = "alarm.filterOptions.minor";
                    break;
                }
                default: {
                    severity = "";
                    alarm = new CCAlarmObject(5);
                    severityText = "";
                }
            }
            if (!this.selectedFault.equals(severity) && !this.selectedFault.equals("ALL")) continue;
            this.latestRows.add(new Integer(i));
            description = allAlarms[i].getDescription();
            time = allAlarms[i].getDateTimeGenerated();
            switch (allAlarms[i].getStatus()) {
                case 3: {
                    status = "alarm.status.active";
                    break;
                }
                case 4: {
                    status = "alarm.status.ack";
                }
            }
            alarmID = allAlarms[i].getAlarmID();
            if (i > 0) {
                this.appendRow();
            }
            this.setValue("Alarm", alarm);
            this.setValue("IDText", new Long(alarmID));
            this.setValue("SeverityText", severityText);
            this.setValue("StateText", status);
            this.setValue("DescriptionText", description.replaceAll("\n", "<br>"));
            this.setValue("IDHidden", new Long(alarmID));
            if (time != null) {
                this.setValue("TimeText", time.getTime());
                continue;
            }
            this.setValue("TimeText", "");
        }
        TraceUtil.trace3("Exiting");
    }

    public void setFilter(String selectedType) {
        TraceUtil.trace3("Entering");
        this.selectedFault = selectedType;
        TraceUtil.trace3("Exiting");
    }

    public ArrayList getLatestIndex() {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return this.latestRows;
    }
}

