/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class LibraryDetailsViewBean
extends CommonViewBeanBase {
    private static final String PAGE_NAME = "LibraryDetails";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/media/LibraryDetails.jsp";
    private static final int TAB_NAME = 10;
    public static final String CHILD_BREADCRUMB = "BreadCrumb";
    public static final String CHILD_ALERT = "Alert";
    public static final String LIBRARY_SUMMARY_HREF = "LibrarySummaryHref";
    public static final String CONFIRM_MESSAGES = "ConfirmMessageHiddenField";
    public static final String LIBRARY_DRIVER = "DriverHidden";
    public static final String LIBRARY_NAME = "NameHidden";
    public static final String DRIVERS = "DriversString";
    public static final String SERVER_INFO = "ServerInformation";
    private static CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    private CCBreadCrumbsModel breadCrumbsModel;
    private String libName;
    static /* synthetic */ Class class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibraryFaultsSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$VSNSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$ImportVSNViewBean;

    public LibraryDetailsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 10);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        pageTitleModel = this.createPageTitleModel();
        propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        this.registerChild(CHILD_BREADCRUMB, class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs == null ? (class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs = LibraryDetailsViewBean.class$("com.sun.web.ui.view.breadcrumb.CCBreadCrumbs")) : class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs);
        this.registerChild(LIBRARY_SUMMARY_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = LibraryDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = LibraryDetailsViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CONFIRM_MESSAGES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LibraryDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(LIBRARY_DRIVER, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LibraryDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(LIBRARY_NAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LibraryDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(DRIVERS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LibraryDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(SERVER_INFO, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LibraryDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: name is ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_BREADCRUMB)) {
            this.breadCrumbsModel = new CCBreadCrumbsModel("LibraryDetails.pageTitle");
            BreadCrumbUtil.createBreadCrumbs((ViewBean)this, name, this.breadCrumbsModel);
            child = new CCBreadCrumbs((View)this, (CCBreadCrumbsModelInterface)this.breadCrumbsModel, name);
        } else if (name.equals(LIBRARY_SUMMARY_HREF)) {
            child = new CCHref((ContainerView)this, name, null);
        } else if (name.equals(CHILD_ALERT)) {
            child = new CCAlertInline((ContainerView)this, name, null);
        } else if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else if (name.equals(CONFIRM_MESSAGES) || name.equals(LIBRARY_DRIVER) || name.equals(LIBRARY_NAME) || name.equals(DRIVERS) || name.equals(SERVER_INFO)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else {
            throw new IllegalArgumentException(new NonSyncStringBuffer("Invalid child name [").append(name).append("]").toString());
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.checkRolePrivilege();
        ((CCDropDownMenu)this.getChild("ActionMenu")).setValue((Object)"0");
        this.libName = (String)this.getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
        SamUtil.doPrint(new NonSyncStringBuffer("LibraryDetails Const': libName is ").append(this.libName).toString());
        this.loadPageTitleModel(pageTitleModel);
        this.loadPropertySheetModel(propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (pageTitleModel == null) {
            pageTitleModel = PageTitleUtil.createModel("/jsp/media/LibraryDetailsPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return pageTitleModel;
    }

    private void loadPageTitleModel(CCPageTitleModel pageTitleModel) {
        TraceUtil.trace3("Entering");
        pageTitleModel.setPageTitleText(SamUtil.getResourceString("LibraryDetails.pageTitle1", this.libName));
        TraceUtil.trace3("Exiting");
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/media/LibraryDetailsPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return propertySheetModel;
    }

    private void loadPropertySheetModel(CCPropertySheetModel propertySheetModel) {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(this.libName);
            if (myLibrary == null) {
                throw new SamFSException(null, -2502);
            }
            int[] alarmInfo = null;
            propertySheetModel.setValue("vendorValue", (Object)myLibrary.getVendor());
            propertySheetModel.setValue("productValue", (Object)myLibrary.getProductID());
            propertySheetModel.setValue("eqValue", (Object)new Integer(myLibrary.getEquipOrdinal()));
            propertySheetModel.setValue("firmwareValue", (Object)myLibrary.getFirmwareLevel());
            propertySheetModel.setValue("catalogValue", (Object)myLibrary.getCatalogLocation());
            propertySheetModel.setValue("capacityValue", (Object)new Capacity(myLibrary.getTotalCapacity(), 2).toString());
            propertySheetModel.setValue("freespaceValue", (Object)new Capacity(myLibrary.getTotalFreeSpace(), 2).toString());
            propertySheetModel.setValue("serialValue", (Object)(myLibrary.getDriverType() == 1001 ? myLibrary.getSerialNo() : ""));
            if (myLibrary.getTotalCapacity() != 0L) {
                String percent = Long.toString(100L * (myLibrary.getTotalCapacity() - myLibrary.getTotalFreeSpace()) / myLibrary.getTotalCapacity());
                propertySheetModel.setValue("spaceconsumedValue", (Object)percent);
            } else {
                propertySheetModel.setValue("spaceconsumedValue", (Object)"0");
            }
            propertySheetModel.setValue("typeValue", (Object)SamUtil.getMediaTypeString(myLibrary.getMediaType()));
            Alarm[] allAlarms = myLibrary.getAssociatedAlarms();
            propertySheetModel.setValue("noAlarm", (Object)"");
            if (allAlarms == null || allAlarms.length == 0) {
                propertySheetModel.setValue("Alarm", (Object)"");
            } else {
                alarmInfo = SamUtil.getAlarmInfo(allAlarms);
                propertySheetModel.setValue("Alarm", (Object)MediaUtil.getAlarm(alarmInfo[0]));
            }
            if (myLibrary.getDrives() != null) {
                propertySheetModel.setValue("devicesValue", (Object)new Integer(myLibrary.getDrives().length));
            } else {
                propertySheetModel.setValue("devicesValue", (Object)new Integer(0));
            }
            String[] messages = myLibrary.getMessages();
            if (messages == null || messages.length == 0) {
                propertySheetModel.setValue("statusMsgValue", (Object)"");
            } else {
                NonSyncStringBuffer strBuf = new NonSyncStringBuffer();
                for (int i = 0; i < messages.length; ++i) {
                    if (i != 0) {
                        strBuf.append("<br>");
                        continue;
                    }
                    strBuf.append(messages[i]);
                }
                propertySheetModel.setValue("statusMsgValue", (Object)strBuf.toString());
            }
            int[] statusInfoCodes = myLibrary.getDetailedStatus();
            if (statusInfoCodes == null || statusInfoCodes.length == 0) {
                propertySheetModel.setValue("statusInfoValue", (Object)"");
            } else {
                NonSyncStringBuffer strBuf = new NonSyncStringBuffer();
                for (int i = 0; i < statusInfoCodes.length; ++i) {
                    if (i != 0) {
                        strBuf.append("<br>");
                        continue;
                    }
                    if (statusInfoCodes[i] == 10017) {
                        strBuf.append(SamUtil.getResourceString(new NonSyncStringBuffer(Integer.toString(statusInfoCodes[i])).append("a").toString()));
                        continue;
                    }
                    strBuf.append(SamUtil.getResourceString(Integer.toString(statusInfoCodes[i])));
                }
                propertySheetModel.setValue("statusInfoValue", (Object)strBuf.toString());
            }
            this.loadHiddenFields(myLibrary);
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadPropertySheet", "Failed to retrieve Library information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, "LibraryDetails.error.loadpsheet", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadHiddenFields(Library myLibrary) throws SamFSException {
        ((CCHiddenField)this.getChild(CONFIRM_MESSAGES)).setValue((Object)new NonSyncStringBuffer(SamUtil.getResourceString("media.confirm.delete.library")).append("###").append(SamUtil.getResourceString("media.confirm.unload.library")).toString());
        ((CCHiddenField)this.getChild(LIBRARY_DRIVER)).setValue((Object)SamUtil.getLibraryDriverString(myLibrary.getDriverType()));
        ((CCHiddenField)this.getChild(LIBRARY_NAME)).setValue((Object)myLibrary.getName());
        ((CCHiddenField)this.getChild(DRIVERS)).setValue((Object)new NonSyncStringBuffer(SamUtil.getResourceString("library.driver.samst")).append("###").append(SamUtil.getResourceString("library.driver.acsls")).toString());
        ((CCHiddenField)this.getChild(SERVER_INFO)).setValue((Object)new NonSyncStringBuffer(this.getServerName()).append("###").append(SamUtil.getServerInfo(this.getServerName()).getSamfsServerAPIVersion()).toString());
    }

    private void checkRolePrivilege() {
        TraceUtil.trace3("Entering");
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.MEDIA_OPERATOR)) {
            ((CCButton)this.getChild("ImportButton")).setDisabled(false);
        }
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            ((CCDropDownMenu)this.getChild("ActionMenu")).setDisabled(false);
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleLibrarySummaryHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(LIBRARY_SUMMARY_HREF);
        ViewBean targetViewBean = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean);
        this.removePageSessionAttribute("SAMQFS_LIBRARY_NAME");
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetViewBean.getName()), str);
        this.forwardTo(targetViewBean);
        TraceUtil.trace3("Exiting");
    }

    public void handleAlarmsHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean targetViewBean = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibraryFaultsSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibraryFaultsSummaryViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibraryFaultsSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibraryFaultsSummaryViewBean);
        BreadCrumbUtil.breadCrumbPathForward(this.getParentViewBean(), PageInfo.getPageInfo().getPageNumber(this.getParentViewBean().getName()));
        this.forwardTo(targetViewBean);
        TraceUtil.trace3("Exiting");
    }

    public void handleViewDriveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        boolean sharedCapable = false;
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibraryDriveSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean);
        try {
            sharedCapable = MediaUtil.isDriveSharedCapable(this.getServerName(), this.libName);
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("Failed to determine if drive supports shared features!");
        }
        this.getParentViewBean().setPageSessionAttribute("SAMQFS_SHARE_CAPABLE", (Serializable)((Object)Boolean.toString(sharedCapable)));
        BreadCrumbUtil.breadCrumbPathForward(this.getParentViewBean(), PageInfo.getPageInfo().getPageNumber(this.getParentViewBean().getName()));
        ((CommonViewBeanBase)this.getParentViewBean()).forwardTo(targetView);
        TraceUtil.trace3("Existing");
    }

    public void handleViewVSNButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$VSNSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$VSNSummaryViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.VSNSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$VSNSummaryViewBean);
        BreadCrumbUtil.breadCrumbPathForward(this.getParentViewBean(), PageInfo.getPageInfo().getPageNumber(this.getParentViewBean().getName()));
        ((CommonViewBeanBase)this.getParentViewBean()).forwardTo(targetView);
        TraceUtil.trace3("Existing");
    }

    public void handleImportButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String libName = (String)this.getDisplayFieldValue(LIBRARY_NAME);
        String driver = (String)this.getDisplayFieldValue(LIBRARY_DRIVER);
        if (driver.equals(SamUtil.getResourceString("library.driver.samst"))) {
            try {
                Library myLibrary = MediaUtil.getLibraryObject(this.getServerName(), libName);
                if (driver.equals(SamUtil.getResourceString("library.driver.samst"))) {
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleImportButtonRequest", new NonSyncStringBuffer().append("Start importing in ").append(libName).toString());
                    myLibrary.importVSN();
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleImportButtonRequest", new NonSyncStringBuffer().append("Done importing ").append(libName).toString());
                    this.setSuccessAlert(this.getParentViewBean(), "LibrarySummary.action.import", libName);
                }
                this.getParentViewBean().forwardTo(this.getRequestContext());
            }
            catch (SamFSException samEx) {
                SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handleImportButtonRequest", "Failed to import VSN", this.getServerName());
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, "LibrarySummary.error.import", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
            }
        } else {
            this.getParentViewBean().setPageSessionAttribute("SAMQFS_LIBRARY_NAME", (Serializable)((Object)libName));
            ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$ImportVSNViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$ImportVSNViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.ImportVSNViewBean")) : class$com$sun$netstorage$samqfs$web$media$ImportVSNViewBean);
            BreadCrumbUtil.breadCrumbPathForward(this.getParentViewBean(), PageInfo.getPageInfo().getPageNumber(this.getParentViewBean().getName()));
            ((CommonViewBeanBase)this.getParentViewBean()).forwardTo(targetView);
        }
        TraceUtil.trace3("Existing");
    }

    public void handlePageActionsMenuHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String libName = (String)this.getDisplayFieldValue(LIBRARY_NAME);
        int value = 0;
        String op = null;
        try {
            value = Integer.parseInt((String)this.getDisplayFieldValue("ActionMenu"));
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("NumEx caught while parsing drop down selection!");
        }
        try {
            Library myLibrary = MediaUtil.getLibraryObject(this.getServerName(), libName);
            switch (value) {
                case 2: {
                    op = "LibrarySummary.action.unload";
                    LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionsMenuHrefRequest", new NonSyncStringBuffer().append("Start unloading tape in ").append(libName).toString());
                    myLibrary.unload();
                    LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionsMenuHrefRequest", new NonSyncStringBuffer().append("Done unloading tape in ").append(libName).toString());
                    this.setSuccessAlert(this.getParentViewBean(), op, libName);
                    break;
                }
                case 3: {
                    op = "LibrarySummary.action.remove";
                    LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionsMenuHrefRequest", new NonSyncStringBuffer().append("Start removing library ").append(libName).toString());
                    SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                    sysModel.getSamQFSSystemMediaManager().removeLibrary(myLibrary);
                    LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionsMenuHrefRequest", new NonSyncStringBuffer().append("Done removing library ").append(libName).toString());
                    this.setSuccessAlert(this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean), op, libName);
                    this.removePageSessionAttribute("SAMQFS_LIBRARY_NAME");
                    ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = LibraryDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean);
                    this.removePageSessionAttribute("PAGE_PATH");
                    ((CommonViewBeanBase)this.getParentViewBean()).forwardTo(targetView);
                    return;
                }
            }
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handlePageActionsMenuHrefRequest", new NonSyncStringBuffer("Failed to ").append(op).append(" ").append(libName).toString(), this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, value == 2 ? "LibrarySummary.error.unload" : "LibrarySummary.error.remove", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        ((CCDropDownMenu)this.getChild("ActionMenu")).setValue((Object)"0");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void setSuccessAlert(ViewBean vb, String msg, String item) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)vb, CHILD_ALERT, "success.summary", SamUtil.getResourceString(msg, item), this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

