/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class ChangeStatusViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "ChangeStatus";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/media/ChangeStatus.jsp";
    private CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    private static final int PAGE_LIBRARY_SUMMARY = 100;
    private static final int PAGE_LIBRARY_DRIVE_SUMMARY = 101;
    private static final int PAGE_STAND_ALONE_SUMMARY = 102;

    public ChangeStatusViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entering: child name = ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        propertySheetModel.setValue("newValue", (Object)"0");
        try {
            this.loadPropertySheetModel();
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadPropertySheetModel", "Failed to retrieve current state", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ChangeStatus.error.loadpsheet", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
            this.disableAllFields();
        }
        TraceUtil.trace3("Exiting");
    }

    private void createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/media/ChangeStatusPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/media/ChangeStatusPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    void disableAllFields() {
        TraceUtil.trace3("Entering");
        ((CCButton)this.getChild("Submit")).setDisabled(true);
        ((CCDropDownMenu)this.getChild("newValue")).setDisabled(true);
        TraceUtil.trace3("Exiting");
    }

    private void loadPropertySheetModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        this.populateStatusValue();
        TraceUtil.trace3("Exiting");
    }

    private void populateStatusValue() throws SamFSException {
        TraceUtil.trace3("Entering");
        int current_state = -1;
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        switch (this.getParentPage()) {
            case 100: {
                current_state = MediaUtil.getLibraryObject(this.getServerName(), this.getLibraryName()).getStatus();
                break;
            }
            case 101: {
                current_state = this.getSelectedLibraryDrive(sysModel, MediaUtil.getLibraryObject(this.getServerName(), this.getLibraryName())).getStatus();
                break;
            }
            case 102: {
                try {
                    current_state = sysModel.getSamQFSSystemMediaManager().getStdAloneByEQ(Integer.parseInt(this.getEQValue())).getStatus();
                    break;
                }
                catch (NumberFormatException numEx) {
                    TraceUtil.trace3(new NonSyncStringBuffer("NumberFormatException caught while ").append(" parsing EQ value").toString());
                    throw new SamFSException(null, -2503);
                }
            }
        }
        propertySheetModel.setValue("currentValue", (Object)SamUtil.getStateString(current_state));
        TraceUtil.trace3("Exiting");
    }

    private Drive getSelectedLibraryDrive(SamQFSSystemModel sysModel, Library myLibrary) throws SamFSException {
        Drive[] allDrives = myLibrary.getDrives();
        try {
            for (int i = 0; i < allDrives.length; ++i) {
                if (allDrives[i].getEquipOrdinal() != Integer.parseInt(this.getEQValue())) continue;
                return allDrives[i];
            }
            throw new SamFSException(null, -2503);
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace3("NumberFormatException caught while parsing EQ value");
            throw new SamFSException(null, -2503);
        }
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        Library myLibrary;
        TraceUtil.trace3("Entering");
        boolean hasError = false;
        int value = 0;
        Drive myDrive = null;
        try {
            value = Integer.parseInt(propertySheetModel.getValue("newValue").toString());
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("Developers' bug found in handleSubmitRequest");
            TraceUtil.trace1("Reason: " + numEx.getMessage());
        }
        SamUtil.doPrint(new NonSyncStringBuffer().append("Change Status: value is ").append(value).toString());
        try {
            switch (this.getParentPage()) {
                case 100: {
                    myLibrary = MediaUtil.getLibraryObject(this.getServerName(), this.getLibraryName());
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleSubmitRequest", new NonSyncStringBuffer().append("Start changing state of Library named ").append(this.getLibraryName()).toString());
                    SamUtil.doPrint(new NonSyncStringBuffer().append("Set Library status to ").append(value).toString());
                    myLibrary.setStatus(value);
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleChangeStatusHrefRequest", new NonSyncStringBuffer().append("Done changing state of library named").append(this.getLibraryName()).toString());
                    this.setSuccessAlert("LibrarySummary.action.changestatus", this.getLibraryName());
                    break;
                }
                case 101: {
                    myDrive = this.getSelectedLibraryDrive(SamUtil.getModel(this.getServerName()), MediaUtil.getLibraryObject(this.getServerName(), this.getLibraryName()));
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleChangeStatusHrefRequest", new NonSyncStringBuffer("Start changing status of drive EQ ").append(this.getEQValue()).toString());
                    myDrive.setStatus(value);
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleChangeStatusHrefRequest", new NonSyncStringBuffer("Done changing status of drive EQ ").append(this.getEQValue()).toString());
                    this.setSuccessAlert("LibraryDriveSummary.action.changestatus", this.getEQValue());
                    break;
                }
                case 102: {
                    myDrive = this.getStandAloneDrive();
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleChangeStatusHrefRequest", new NonSyncStringBuffer().append("Start changing status of drive EQ ").append(this.getEQValue()).toString());
                    myDrive.setStatus(value);
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleChangeStatusHrefRequest", new NonSyncStringBuffer().append("Done changing status of drive EQ ").append(this.getEQValue()).toString());
                    this.setSuccessAlert("StandAloneSummary.action.changestatus", this.getEQValue());
                }
            }
        }
        catch (SamFSException samEx) {
            hasError = true;
            TraceUtil.trace1("Failed to change library/drive state");
            this.setErrorAlertAndProcessException(samEx);
        }
        if (!hasError) {
            try {
                switch (this.getParentPage()) {
                    case 100: {
                        myLibrary = MediaUtil.getLibraryObject(this.getServerName(), this.getLibraryName());
                        if (myLibrary.getStatus() == value) break;
                        TraceUtil.trace2("Sleep 5 seconds ...");
                        Thread.sleep(5000L);
                        break;
                    }
                    case 101: {
                        myDrive = this.getSelectedLibraryDrive(SamUtil.getModel(this.getServerName()), MediaUtil.getLibraryObject(this.getServerName(), this.getLibraryName()));
                        if (myDrive.getStatus() == value) break;
                        TraceUtil.trace2("Sleep 5 seconds ...");
                        Thread.sleep(5000L);
                        break;
                    }
                    case 102: {
                        myDrive = this.getStandAloneDrive();
                        if (myDrive.getStatus() == value) break;
                        TraceUtil.trace2("Sleep 5 seconds ...");
                        Thread.sleep(5000L);
                    }
                }
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1("Failed to retrieve library state after changing it!");
                this.setErrorAlertAndProcessException(samEx);
            }
            catch (InterruptedException intEx) {
                TraceUtil.trace3("InterruptedException Caught: Reason: " + intEx.getMessage());
            }
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void setSuccessAlert(String msg, String item) {
        SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", SamUtil.getResourceString(msg, item), this.getServerName());
        this.setSubmitSuccessful(true);
    }

    private Drive getStandAloneDrive() throws SamFSException, NumberFormatException, ModelControlException {
        TraceUtil.trace3("Entering");
        Drive myDrive = null;
        try {
            myDrive = SamUtil.getModel(this.getServerName()).getSamQFSSystemMediaManager().getStdAloneByEQ(Integer.parseInt(this.getEQValue()));
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("Developer bug caught in ChangeStatus:getStandAloneDrive!");
            throw new SamFSException(null, -2504);
        }
        if (myDrive == null) {
            throw new SamFSException(null, -2504);
        }
        TraceUtil.trace3("Exiting");
        return myDrive;
    }

    private void setErrorAlertAndProcessException(SamFSException samEx) {
        SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "Failed to change state of a library/drive", this.getServerName());
        String errMsg = null;
        switch (this.getParentPage()) {
            case 100: {
                errMsg = "LibrarySummary.error.changestatus";
                break;
            }
            case 101: {
                errMsg = "LibraryDriveSummary.error.changestatus";
                break;
            }
            case 102: {
                errMsg = "StandAloneSummary.error.changestatus";
            }
        }
        SamUtil.setErrorAlert((ContainerView)this, "Alert", errMsg, samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
    }

    private String getLibraryName() {
        String libraryName = (String)this.getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
        if (libraryName == null) {
            libraryName = RequestManager.getRequest().getParameter("SAMQFS_LIBRARY_NAME");
            if (libraryName != null) {
                this.setPageSessionAttribute("SAMQFS_LIBRARY_NAME", (Serializable)((Object)libraryName));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException("Library Name not supplied");
            }
        }
        return libraryName;
    }

    private String getEQValue() {
        String eqValue = (String)this.getPageSessionAttribute("SAMQFS_EQ");
        if (eqValue == null) {
            eqValue = RequestManager.getRequest().getParameter("SAMQFS_EQ");
            if (eqValue != null) {
                this.setPageSessionAttribute("SAMQFS_EQ", (Serializable)((Object)eqValue));
            }
            if (eqValue == null) {
                throw new IllegalArgumentException("EQ value not supplied");
            }
        }
        return eqValue;
    }

    private int getParentPage() {
        Integer parentPage = (Integer)this.getPageSessionAttribute("SAMQFS_PARENT");
        if (parentPage == null) {
            String parentPageString = RequestManager.getRequest().getParameter("SAMQFS_PARENT");
            if (parentPageString != null) {
                int parent = -1;
                if (parentPageString.equals("LibrarySummaryView")) {
                    parent = 100;
                } else if (parentPageString.equals("LibraryDriveSummaryView")) {
                    parent = 101;
                } else if (parentPageString.equals("StandAloneSummaryView")) {
                    parent = 102;
                }
                this.setPageSessionAttribute("SAMQFS_PARENT", new Integer(parent));
            }
            if ((parentPage = (Integer)this.getPageSessionAttribute("SAMQFS_PARENT")) == null) {
                throw new IllegalArgumentException("Parent Page not supplied");
            }
        }
        return parentPage;
    }
}

