/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.jobs;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.jobs.CurrentScanningModel;
import com.sun.netstorage.samqfs.web.jobs.PendingScanningModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.job.ArchiveJob;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.EnableDumpJob;
import com.sun.netstorage.samqfs.web.model.job.FSDumpJob;
import com.sun.netstorage.samqfs.web.model.job.LabelJob;
import com.sun.netstorage.samqfs.web.model.job.MountJob;
import com.sun.netstorage.samqfs.web.model.job.ReleaseJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreSearchJob;
import com.sun.netstorage.samqfs.web.model.job.SamfsckJob;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import java.io.Serializable;
import javax.servlet.http.HttpSession;

public class JobsDetailsView
extends CommonTableContainerView {
    private CCPageTitleModel pageTitleModel;
    private CCPropertySheetModel propertySheetModel;
    private String jobType;
    private String jobCondition;
    private String jobIDString;
    private long jobId;
    private BaseJob jobDisplay;
    private ArchiveJob archiveJob;
    private ArchiveCopy archiveCopy;
    private FileSystem fileSystem;
    private ArchivePolicy archivePolicy;
    private String serverName;

    public JobsDetailsView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        this.serverName = (String)vb.getPageSessionAttribute("SERVER_NAME");
        TraceUtil.trace3("Got serverName from page session: " + this.serverName);
        if (this.serverName == null) {
            this.serverName = (String)RequestManager.getRequestContext().getRequest().getSession().getAttribute("SERVER_NAME");
        }
        this.pageTitleModel = this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Creating child " + name);
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        return super.createChild(name);
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/jobs/JobsDetailsPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        Object propFile = null;
        ViewBean vb = this.getParentViewBean();
        String jobIdString = (String)vb.getPageSessionAttribute("SAMQFS_JOB_ID");
        if (jobIdString == null) {
            RequestContext rc = RequestManager.getRequestContext();
            HttpSession session = rc.getRequest().getSession();
            jobIdString = (String)session.getAttribute("JOB_ID");
            this.getParentViewBean().setPageSessionAttribute("SAMQFS_JOB_ID", (Serializable)((Object)jobIdString));
        }
        TraceUtil.trace3("jobIdString is " + jobIdString);
        String[] jobIdSplit = jobIdString.split(",");
        this.jobIDString = jobIdSplit[0];
        this.jobId = Long.parseLong(this.jobIDString);
        this.jobType = jobIdSplit[1];
        this.jobCondition = jobIdSplit[2];
        if (this.jobType.equals("Jobs.jobType1")) {
            if (this.jobCondition.equals("Current")) {
                this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/ArchiveJobsCurrentPropSheet.xml");
            } else if (this.jobCondition.equals("Pending")) {
                this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/ArchiveJobsPendingPropSheet.xml");
            } else if (this.jobCondition.equals("History")) {
                this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/ArchiveJobsHistoricalPropSheet.xml");
            }
        } else if (this.jobType.equals("Jobs.jobType5")) {
            if (this.jobCondition.equals("Current")) {
                this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/ArchiveJobsCurrentScanningPropSheet.xml");
                CurrentScanningModel currentScanningInfo = new CurrentScanningModel(this.serverName, this.jobId);
                this.propertySheetModel.setModel("currentScanningInfo", (Object)currentScanningInfo);
            } else if (this.jobCondition.equals("Pending")) {
                this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/ArchiveJobsPendingScanningPropSheet.xml");
                PendingScanningModel pendingScanningInfo = new PendingScanningModel(this.serverName, this.jobId);
                this.propertySheetModel.setModel("pendingScanningInfo", (Object)pendingScanningInfo);
            }
        } else if (this.jobType.equals("Jobs.jobType3")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/ReleaseJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType4")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/MediaMountJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType6")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/SamfsckJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType7")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/TapeLabelJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType.restore")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/RestoreJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType.restoreSearch")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/RestoreSearchJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType.dump")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/DumpJobsPropSheet.xml");
        } else if (this.jobType.equals("Jobs.jobType.dumpEnable")) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/EnableDumpJobsPropSheet.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    public void loadArchiveCurrentPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        this.loadGenericArchiveValues();
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(this.archiveJob.getStartDateTime()));
        this.propertySheetModel.setValue("totFilesCopiedText", (Object)Integer.toString(this.archiveJob.getTotalNoOfFilesToBeCopied()));
        this.propertySheetModel.setValue("volumeDataText", (Object)this.archiveJob.getDataVolumeToBeCopied());
        TraceUtil.trace3("Exiting");
    }

    public void loadArchiveCurrentScanningPropSheet(long jobId) throws SamFSException {
        TraceUtil.trace3("Entering");
        CurrentScanningModel currentScanningInfo = (CurrentScanningModel)((Object)this.propertySheetModel.getModel("currentScanningInfo"));
        currentScanningInfo.initModelRows();
        TraceUtil.trace3("Exiting");
    }

    public void loadArchivePendingScanningPropSheet(long jobId) throws SamFSException {
        TraceUtil.trace3("Entering");
        PendingScanningModel pendingScanningInfo = (PendingScanningModel)((Object)this.propertySheetModel.getModel("pendingScanningInfo"));
        pendingScanningInfo.initModelRows();
        TraceUtil.trace3("Exiting");
    }

    public void loadArchivePendingPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        this.loadGenericArchiveValues();
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(this.archiveJob.getStartDateTime()));
        this.propertySheetModel.setValue("totFilesCopiedText", (Object)Integer.toString(this.archiveJob.getTotalNoOfFilesToBeCopied()));
        this.propertySheetModel.setValue("volumeDataText", (Object)this.archiveJob.getDataVolumeToBeCopied());
        TraceUtil.trace3("Exiting");
    }

    public void loadGenericArchiveValues() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.archiveJob = (ArchiveJob)this.jobDisplay;
        this.propertySheetModel.setValue("fsNameText", (Object)this.archiveJob.getFileSystemName());
        this.propertySheetModel.setValue("policyNameText", (Object)this.archiveJob.getPolicyName());
        this.propertySheetModel.setValue("copyNumText", (Object)Integer.toString(this.archiveJob.getCopyNumber()));
        this.propertySheetModel.setValue("vsnText", (Object)this.archiveJob.getVSNName());
        this.propertySheetModel.setValue("medTypeText", (Object)SamUtil.getMediaTypeString(this.archiveJob.getMediaType()));
        TraceUtil.trace3("Exiting");
    }

    public void loadReleasePropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        ReleaseJob releaseJob = (ReleaseJob)this.jobDisplay;
        this.propertySheetModel.setValue("fsNameText", (Object)releaseJob.getFileSystemName());
        this.propertySheetModel.setValue("releaseInitTimeText", (Object)SamUtil.getTimeString(releaseJob.getStartDateTime()));
        this.propertySheetModel.setValue("lwmText", (Object)releaseJob.getLWM());
        this.propertySheetModel.setValue("diskConsumedText", (Object)releaseJob.getConsumedSpacePercentage());
        TraceUtil.trace3("Exiting");
    }

    public void loadMediaMountPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        MountJob mountJob = (MountJob)this.jobDisplay;
        this.propertySheetModel.setValue("vsnNameText", (Object)mountJob.getVSNName());
        this.propertySheetModel.setValue("medTypeText", (Object)SamUtil.getMediaTypeString(mountJob.getMediaType()));
        this.propertySheetModel.setValue("libNameText", (Object)mountJob.getLibraryName());
        this.propertySheetModel.setValue("archiveStageRelatedText", (Object)(mountJob.isArchiveMount() ? "Jobs.jobType1" : "Jobs.jobType2"));
        this.propertySheetModel.setValue("processIdText", (Object)Long.toString(mountJob.getProcessId()));
        this.propertySheetModel.setValue("initUserText", (Object)mountJob.getInitiatingUsername());
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(mountJob.getStartDateTime()));
        this.propertySheetModel.setValue("timeQueueText", (Object)SamUtil.getTimeString(mountJob.getTimeInQueue()));
        TraceUtil.trace3("Exiting");
    }

    public void loadDumpPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        FSDumpJob dumpJob = (FSDumpJob)this.jobDisplay;
        this.propertySheetModel.setValue("startTimeText", (Object)SamUtil.getTimeString(dumpJob.getStartDateTime()));
        this.propertySheetModel.setValue("fsNameText", (Object)dumpJob.getFileSystemName());
        this.propertySheetModel.setValue("dumpFileText", (Object)dumpJob.getDumpFileName());
        TraceUtil.trace3("Exiting");
    }

    public void loadDumpEnablePropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        EnableDumpJob dumpEnableJob = (EnableDumpJob)this.jobDisplay;
        this.propertySheetModel.setValue("startTimeText", (Object)SamUtil.getTimeString(dumpEnableJob.getStartDateTime()));
        this.propertySheetModel.setValue("fsNameText", (Object)dumpEnableJob.getFileSystemName());
        this.propertySheetModel.setValue("dumpFileNameText", (Object)dumpEnableJob.getDumpFileName());
        TraceUtil.trace3("Exiting");
    }

    public void loadSamfsckPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        SamfsckJob job = (SamfsckJob)this.jobDisplay;
        this.propertySheetModel.setValue("fsNameText", (Object)job.getFileSystemName());
        this.propertySheetModel.setValue("initUserText", (Object)job.getInitiatingUser());
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(job.getStartDateTime()));
        TraceUtil.trace3("Exiting");
    }

    public void loadTapeLabelPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        LabelJob job = (LabelJob)this.jobDisplay;
        this.propertySheetModel.setValue("vsnText", (Object)job.getVSNName());
        this.propertySheetModel.setValue("driveText", (Object)job.getDriveName());
        this.propertySheetModel.setValue("libText", (Object)job.getLibraryName());
        TraceUtil.trace3("Exiting");
    }

    public void loadRestorePropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        RestoreJob job = (RestoreJob)this.jobDisplay;
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(job.getStartDateTime()));
        this.propertySheetModel.setValue("fsNameText", (Object)job.getFileSystemName());
        this.propertySheetModel.setValue("snapshotNameText", (Object)job.getDumpFileName());
        if (job.getFileName().equals(".")) {
            this.propertySheetModel.setValue("fileNameText", (Object)SamUtil.getResourceString("JobsDetails.restore.restoreFS"));
        } else {
            this.propertySheetModel.setValue("fileNameText", (Object)job.getFileName());
        }
        FsmVersion version45 = new FsmVersion("4.5", this.serverName);
        if (!version45.isAPICompatibleWithUI()) {
            this.propertySheetModel.setVisible("restoreToProp", false);
            this.propertySheetModel.setVisible("replaceTypeProp", false);
            this.propertySheetModel.setVisible("onlineStatusProp", false);
        } else {
            String restoreTypeStr;
            this.propertySheetModel.setValue("restoreToText", (Object)job.getRestoreToPath());
            switch (job.getReplaceType()) {
                case 1: {
                    restoreTypeStr = SamUtil.getResourceString("FSRestore.restore.replaceType.replaceAlways");
                    break;
                }
                case 2: {
                    restoreTypeStr = SamUtil.getResourceString("FSRestore.restore.replaceType.replaceWithNewer");
                    break;
                }
                default: {
                    restoreTypeStr = SamUtil.getResourceString("FSRestore.restore.replaceType.replaceNever");
                }
            }
            this.propertySheetModel.setValue("replaceTypeText", (Object)restoreTypeStr);
            int onlineStatus = job.getOnlineStatusAfterRestore();
            String onlineStatusStr = onlineStatus == 2000 ? SamUtil.getResourceString("FSRestore.restore.stageOptionOffLine") : (onlineStatus == 1000 ? SamUtil.getResourceString("FSRestore.restore.stageOptionSystemPick") : (onlineStatus == 3000 ? SamUtil.getResourceString("FSRestore.restore.stageOptionAsInDump") : (onlineStatus >= 0 && onlineStatus <= 3 ? SamUtil.getResourceString("FSRestore.restore.stageOptionArchiveCopy.copy") : SamUtil.getResourceString("FSRestore.restore.error.invalidStageOption", String.valueOf(onlineStatus)))));
            this.propertySheetModel.setValue("onlineStatusAfterRestoreText", (Object)onlineStatusStr);
        }
        this.propertySheetModel.setValue("statusText", (Object)job.getRestoreStatus(null));
        TraceUtil.trace3("Exiting");
    }

    public void loadRestoreSearchPropSheet() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.getModelInfo();
        RestoreSearchJob job = (RestoreSearchJob)this.jobDisplay;
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(job.getStartDateTime()));
        this.propertySheetModel.setValue("fsNameText", (Object)job.getFileSystemName());
        this.propertySheetModel.setValue("snapshotFileNameText", (Object)job.getDumpFileName());
        this.propertySheetModel.setValue("searchCriteriaText", (Object)job.getSearchCriteria());
        TraceUtil.trace3("Exiting");
    }

    private void getModelInfo() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        this.jobDisplay = sysModel.getSamQFSSystemJobManager().getJobById(this.jobId);
        if (this.jobDisplay == null) {
            throw new SamFSException(null, -2011);
        }
    }

    public void populateData() throws SamFSException {
        if (this.jobType.equals("Jobs.jobType1")) {
            if (this.jobCondition.equals("Current")) {
                this.loadArchiveCurrentPropSheet();
            } else if (this.jobCondition.equals("Pending")) {
                this.loadArchivePendingPropSheet();
            }
        } else if (this.jobType.equals("Jobs.jobType5")) {
            if (this.jobCondition.equals("Current")) {
                this.loadArchiveCurrentScanningPropSheet(this.jobId);
            } else if (this.jobCondition.equals("Pending")) {
                this.loadArchivePendingScanningPropSheet(this.jobId);
            }
        } else if (this.jobType.equals("Jobs.jobType3")) {
            this.loadReleasePropSheet();
        } else if (this.jobType.equals("Jobs.jobType4")) {
            this.loadMediaMountPropSheet();
        } else if (this.jobType.equals("Jobs.jobType6")) {
            this.loadSamfsckPropSheet();
        } else if (this.jobType.equals("Jobs.jobType7")) {
            this.loadTapeLabelPropSheet();
        } else if (this.jobType.equals("Jobs.jobType.restore")) {
            this.loadRestorePropSheet();
        } else if (this.jobType.equals("Jobs.jobType.restoreSearch")) {
            this.loadRestoreSearchPropSheet();
        } else if (this.jobType.equals("Jobs.jobType.dump")) {
            this.loadDumpPropSheet();
        } else if (this.jobType.equals("Jobs.jobType.dumpEnable")) {
            this.loadDumpEnablePropSheet();
        }
        this.propertySheetModel.setValue("jobTypeText", (Object)this.jobType);
        this.propertySheetModel.setValue("jobIdText", (Object)this.jobIDString);
    }
}

