/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.fs.FSUtil;
import com.sun.netstorage.samqfs.web.fs.wizards.GrowWizardImpl;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.wizard.CCWizardWindow;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class FSDetailsView
extends CommonTableContainerView {
    protected CCPageTitleModel pageTitleModel = null;
    protected CCPropertySheetModel propertySheetModel = null;
    protected String fsName;
    protected String serverName;
    protected String samfsServerAPIVersion = "1.3";
    protected int fsType = 12;
    protected boolean qfsStandalone = false;
    protected String parents = null;
    protected String vfstabFSType = "qfs";
    protected Boolean isArchived;
    public static final String HIDDEN_DYNAMIC_MENUOPTIONS = "HiddenDynamicMenuOptions";
    public static final String CHILD_HIDDEN_FS_NAME = "fsName";
    public static final String CHILD_HIDDEN_FSCK_ACTION = "SamfsckHiddenAction";
    public static final String CHILD_HIDDEN_FSCK_LOG = "SamfsckHiddenLog";
    public static final String CHILD_SAMFSCK_HREF = "SamfsckHref";
    public static final String CHILD_CANCEL_HREF = "CancelHref";
    public static final String CHILD_HIDDEN_DUMPPATH = "DumpNowHiddenPath";
    public static final String CHILD_DUMPNOW_HREF = "DumpNowHref";
    public static final String CHILD_JOBID_HREF = "JobIdHref";
    public static final String CHILD_FRWD_TO_CMDCHILD = "forwardToVb";
    protected boolean writeRole = false;
    protected CCWizardWindowModel growWizWinModel;
    public static final int FS_MENUOPTION_CHECK_FS = 1;
    public static final int FS_MENUOPTION_MOUNT = 2;
    public static final int FS_MENUOPTION_UNMOUNT = 3;
    public static final int FS_MENUOPTION_DELETE = 4;
    public static final int FS_MENUOPTION_EDIT_NFS = 5;
    public static final int FS_MENUOPTION_STOP_ARCHIVE = 6;
    public static final int FS_MENUOPTION_IDLE_ARCHIVE = 7;
    public static final int FS_MENUOPTION_RUN_ARCHIVE = 8;
    public static final int FS_MENUOPTION_SCHEDULE_DUMP = 9;
    public static final int FS_MENUOPTION_DUMP_NOW = 10;
    public static final int FS_MENUOPTION_REMOVE_SCHEDULE = 11;
    public static final int FS_MENUOPTION_RESTORE = 12;
    public static final int FS_MENUOPTION_STAGE = 13;
    public static final int FS_MENUOPTION_STOP_ARCHIVE_43 = 5;
    public static final int FS_MENUOPTION_IDLE_ARCHIVE_43 = 6;
    public static final int FS_MENUOPTION_RUN_ARCHIVE_43 = 7;
    private boolean sharedFlag = false;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$NFSDetailsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSScheduleDumpViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSRestoreViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$StageViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean;

    public FSDetailsView(View parent, String name) {
        super(parent, name);
        ServerInfo serverInfo;
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
        this.serverName = (String)vb.getPageSessionAttribute("SERVER_NAME");
        this.fsName = (String)vb.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        this.vfstabFSType = (String)vb.getPageSessionAttribute("SAMQFS_VFSTAB_FS_TYPE");
        Integer fsTypeObj = (Integer)vb.getPageSessionAttribute("SAMQFS_FS_TYPE");
        this.isArchived = (Boolean)vb.getPageSessionAttribute("SAMQFS_IS_ARCHIVED");
        Boolean bl = this.isArchived = this.isArchived == null ? Boolean.TRUE : this.isArchived;
        if (fsTypeObj != null) {
            this.fsType = fsTypeObj;
        }
        TraceUtil.trace3("Got serverName, fsName & fsType from page session: " + this.serverName + ", " + this.fsName + ", " + this.fsType + ", " + this.vfstabFSType);
        if (this.serverName == null || this.fsName == null) {
            this.serverName = (String)session.getAttribute("SERVER_NAME");
            this.fsName = (String)session.getAttribute("FS_NAME");
            vb.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)this.serverName));
            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
        }
        if (serverTable != null && this.serverName != null && (serverInfo = (ServerInfo)serverTable.get(this.serverName)) != null) {
            this.samfsServerAPIVersion = serverInfo.getSamfsServerAPIVersion();
            this.qfsStandalone = serverInfo.getServerLicenseType() == 1;
        }
        this.pageTitleModel = this.createPageTitleModel();
        this.initializeGrowWizard();
        this.propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(HIDDEN_DYNAMIC_MENUOPTIONS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_FS_NAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_FSCK_ACTION, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_FSCK_LOG, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_DUMPPATH, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_CANCEL_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSDetailsView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_SAMFSCK_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSDetailsView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_JOBID_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSDetailsView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_DUMPNOW_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSDetailsView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        this.registerChild(CHILD_FRWD_TO_CMDCHILD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSDetailsView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering with name = " + name);
        if (name.equals(CHILD_HIDDEN_FS_NAME) || name.equals(HIDDEN_DYNAMIC_MENUOPTIONS) || name.equals(CHILD_HIDDEN_FSCK_ACTION) || name.equals(CHILD_HIDDEN_DUMPPATH) || name.equals(CHILD_HIDDEN_FSCK_LOG)) {
            TraceUtil.trace3("Exiting");
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            TraceUtil.trace3("Exiting");
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            TraceUtil.trace3("Exiting");
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        if (name.equals(CHILD_CANCEL_HREF) || name.equals(CHILD_SAMFSCK_HREF) || name.equals(CHILD_JOBID_HREF) || name.equals(CHILD_DUMPNOW_HREF)) {
            TraceUtil.trace3("Exiting");
            return new CCHref((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_FRWD_TO_CMDCHILD)) {
            BasicCommandField bcf = new BasicCommandField((View)this, name);
            TraceUtil.trace3("Exiting");
            return bcf;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.setGrowWizardNames();
        TraceUtil.trace3("Exiting");
    }

    public void populateData() throws SamFSException {
        TraceUtil.trace3("Entering");
        GenericFileSystem fs2 = this.getFileSystem(this.fsName);
        if (fs2 == null) {
            this.propertySheetModel.setVisible("samfsSection", false);
            this.propertySheetModel.setVisible("archiveSection", false);
            this.propertySheetModel.setVisible("sharedSection", false);
            throw new SamFSException(null, -1000);
        }
        if (this.fsType != 13) {
            FileSystem fileSystem = (FileSystem)fs2;
            if (fileSystem.getDAUSize() == 1) {
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "FSDetails.error.populate", -1008, SamUtil.getResourceString("FSDetails.error.dauDetails"), this.serverName);
            } else if (fileSystem.getDAUSize() == 2) {
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "FSDetails.error.populate", -1008, SamUtil.getResourceString("FSDetails.error.badDevices"), this.serverName);
            }
        }
        this.loadPropertySheetModel(fs2);
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.FILESYSTEM_OPERATOR)) {
            if (this.fsType == 13) {
                this.setUFSOptions(fs2);
            } else if (this.fsType == 11 || this.qfsStandalone || this.fsType == 10 && !this.isArchived.booleanValue()) {
                this.setQFSOptions((FileSystem)fs2);
            } else {
                this.setSAMFSOptions((FileSystem)fs2);
            }
        }
        if (this.fsType == 13 && (fs2.getFSTypeName().equals("ufs") || fs2.getFSTypeName().equals("vxfs"))) {
            this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSDetails.pageTitle"));
        } else {
            this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSDetails.pageTitle1", this.fsName));
            if (!this.sharedFlag) {
                ((CCLabel)this.getChild("deviceNameLabel")).setValue((Object)"");
            }
        }
        ((CCHiddenField)this.getChild(CHILD_HIDDEN_FS_NAME)).setValue((Object)this.fsName);
        ((CCDropDownMenu)this.getChild("PageActionsMenu")).setValue((Object)"0");
        if (fs2.isHA()) {
            ((CCWizardWindow)this.getChild("SamQFSWizardGrowFSButton")).setDisabled(true);
        }
        TraceUtil.trace3("Exiting");
    }

    protected void setUFSOptions(GenericFileSystem fs2) {
        ((CCButton)this.getChild("ViewDeviceButton")).setDisabled(true);
        ((CCWizardWindow)this.getChild("SamQFSWizardGrowFSButton")).setDisabled(true);
        ((CCButton)this.getChild("EditMountOptionsButton")).setDisabled(true);
        StringBuffer menuOptions = new StringBuffer();
        if (fs2.getState() == 0) {
            if (!"/".equals(fs2.getMountPoint())) {
                menuOptions.append(2).append(',');
            }
            menuOptions.append(4).append(',');
        } else {
            menuOptions.append(1).append(',');
            if (!fs2.isHA()) {
                menuOptions.append(3).append(',');
            }
        }
        int len = menuOptions.length();
        if (len > 0 && menuOptions.charAt(len - 1) == ',') {
            menuOptions.deleteCharAt(len - 1);
        }
        ((CCHiddenField)this.getChild(HIDDEN_DYNAMIC_MENUOPTIONS)).setValue((Object)menuOptions.toString());
        this.propertySheetModel.setVisible("samfsSection", false);
        this.propertySheetModel.setVisible("archiveSection", false);
        this.propertySheetModel.setVisible("sharedSection", false);
    }

    protected void setQFSOptions(FileSystem fs2) {
        int state = fs2.getState();
        int fsShared = fs2.getShareStatus();
        boolean noDeleteFlag = false;
        if (fsShared != 0) {
            noDeleteFlag = this.checkDeleteFlag(fs2);
        }
        ((CCButton)this.getChild("ViewDeviceButton")).setDisabled(false);
        if (state == 1 && fsShared == 0) {
            ((CCWizardWindow)this.getChild("SamQFSWizardGrowFSButton")).setDisabled(false);
        } else {
            ((CCWizardWindow)this.getChild("SamQFSWizardGrowFSButton")).setDisabled(true);
        }
        ((CCButton)this.getChild("EditMountOptionsButton")).setDisabled(false);
        StringBuffer menuOptions = new StringBuffer();
        if (fsShared == 0) {
            menuOptions.append(1).append(',');
        }
        if (state == 0) {
            if (!"/".equals(fs2.getMountPoint())) {
                menuOptions.append(3).append(',');
            }
            menuOptions.append(5).append(',');
        } else {
            menuOptions.append(2).append(',');
            if (!fs2.isHA() && !noDeleteFlag) {
                menuOptions.append(4);
            }
        }
        int len = menuOptions.length();
        if (len > 0 && menuOptions.charAt(len - 1) == ',') {
            menuOptions.deleteCharAt(len - 1);
        }
        ((CCHiddenField)this.getChild(HIDDEN_DYNAMIC_MENUOPTIONS)).setValue((Object)menuOptions.toString());
        this.propertySheetModel.setVisible("archiveSection", false);
        if (fsShared == 0) {
            this.propertySheetModel.setVisible("sharedSection", false);
        }
    }

    protected void setSAMFSOptions(FileSystem fs2) {
        int len;
        int state = fs2.getState();
        int fsShared = fs2.getShareStatus();
        boolean noDeleteFlag = false;
        if (fsShared != 0) {
            noDeleteFlag = this.checkDeleteFlag(fs2);
        }
        ((CCButton)this.getChild("ViewDeviceButton")).setDisabled(false);
        if (fs2.isHA()) {
            ((CCButton)this.getChild("ViewPolicyButton")).setDisabled(true);
        } else {
            ((CCButton)this.getChild("ViewPolicyButton")).setDisabled(false);
        }
        if (state == 1 && fsShared == 0) {
            ((CCWizardWindow)this.getChild("SamQFSWizardGrowFSButton")).setDisabled(false);
        } else {
            ((CCWizardWindow)this.getChild("SamQFSWizardGrowFSButton")).setDisabled(true);
        }
        ((CCButton)this.getChild("EditMountOptionsButton")).setDisabled(false);
        StringBuffer menuOptions = new StringBuffer();
        if (fsShared == 0) {
            menuOptions.append(1).append(',');
        }
        if (state == 0) {
            if (!"/".equals(fs2.getMountPoint())) {
                menuOptions.append(3).append(',');
            }
            menuOptions.append(5).append(',');
        } else {
            menuOptions.append(2).append(',');
            if (!fs2.isHA() && !noDeleteFlag) {
                menuOptions.append(4).append(',');
            }
        }
        if (SamUtil.isVersionCurrentOrLaterThan(this.samfsServerAPIVersion, "1.3")) {
            if (!fs2.isHA()) {
                menuOptions.append(6).append(',');
                menuOptions.append(7).append(',');
                menuOptions.append(8).append(',');
            }
        } else if (!fs2.isHA()) {
            menuOptions.append(5).append(',');
            menuOptions.append(6).append(',');
            menuOptions.append(7).append(',');
        }
        if (SamUtil.isVersionCurrentOrLaterThan(this.samfsServerAPIVersion, "1.3") && state == 0) {
            menuOptions.append(9).append(',');
            menuOptions.append(10).append(',');
            FsmVersion version45 = new FsmVersion("4.5", this.serverName);
            try {
                DumpSched sched = SamUtil.getModel(this.serverName).getSamQFSSystemFSManager().getMetadataDumpSchedParams(fs2.getName());
                if (sched != null) {
                    menuOptions.append(11).append(',');
                }
                if (version45.isAPICompatibleWithUI() || sched != null) {
                    menuOptions.append(12).append(',');
                }
            }
            catch (SamFSException e) {
                // empty catch block
            }
        }
        if ((len = menuOptions.length()) > 0 && menuOptions.charAt(len - 1) == ',') {
            menuOptions.deleteCharAt(len - 1);
        }
        ((CCHiddenField)this.getChild(HIDDEN_DYNAMIC_MENUOPTIONS)).setValue((Object)menuOptions.toString());
        if (fsShared == 0) {
            this.propertySheetModel.setVisible("sharedSection", false);
        }
    }

    protected boolean checkDeleteFlag(FileSystem fs2) {
        boolean noDeleteFlag;
        block6: {
            noDeleteFlag = false;
            String metaDataHostName = fs2.getServerName();
            TraceUtil.trace3("Shared metadata server is " + metaDataHostName);
            if (metaDataHostName.equals("")) {
                noDeleteFlag = true;
            } else {
                try {
                    SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                    SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
                    SharedMember[] sharedMember = fsManager.getSharedMembers(metaDataHostName, this.fsName);
                    if (sharedMember == null || sharedMember.length <= 0) break block6;
                    for (int i = 0; i < sharedMember.length; ++i) {
                        if (!sharedMember[i].isMounted()) continue;
                        noDeleteFlag = true;
                        break;
                    }
                }
                catch (SamFSMultiHostException e) {
                    noDeleteFlag = true;
                }
                catch (SamFSException e) {
                    noDeleteFlag = true;
                }
            }
        }
        return noDeleteFlag;
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        String fsXML = this.fsType == 13 && (this.vfstabFSType.equals("ufs") || this.vfstabFSType.equals("vxfs")) ? "/jsp/fs/UFSDetailsPageTitle.xml" : (this.qfsStandalone || this.fsType == 11 || this.fsType == 10 && this.isArchived == false ? "/jsp/fs/QFSDetailsPageTitle.xml" : "/jsp/fs/FSDetailsPageTitle.xml");
        this.pageTitleModel = PageTitleUtil.createModel(fsXML);
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        int shared = 0;
        ViewBean vb = this.getParentViewBean();
        Integer sharedStatus = (Integer)vb.getPageSessionAttribute("SAMQFS_SHARED_STATUS");
        if (sharedStatus != null) {
            shared = sharedStatus;
        }
        if (shared != 0) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/SharedFSDetailsGeneralPropertySheet.xml");
            this.sharedFlag = true;
        } else {
            TraceUtil.trace3("FSDETAIL Not SHARED");
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/FSDetailsPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.propertySheetModel;
    }

    private void loadPropertySheetModel(GenericFileSystem fs2) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.propertySheetModel.clear();
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        String cap = "";
        String free = "";
        String consumed = "";
        String hwm = null;
        String point = null;
        String dau = null;
        String lwm = null;
        String timeAbove = null;
        String eq = null;
        String server = null;
        String createDate = null;
        String type = null;
        String state = null;
        String share = null;
        Object alarmType = null;
        Object alarmCount = null;
        StringBuffer alarms = new StringBuffer();
        String noAlarm = "";
        String sharedType = null;
        String deviceName = "";
        String metadataPlacement = "";
        int fsState = fs2.getState();
        long capacity = fs2.getCapacity();
        long freeSpace = fs2.getAvailableSpace();
        point = fs2.getMountPoint();
        if (fsState == 0) {
            state = "FSSummary.mount";
            int sizeUnit = 1;
            cap = new Capacity(capacity, sizeUnit).toString();
            free = new Capacity(freeSpace, sizeUnit).toString();
            consumed = Integer.toString(fs2.getConsumedSpacePercentage());
        } else {
            state = "FSSummary.unmount";
        }
        if (this.fsType == 13) {
            if (fs2.getFSTypeName().equals("ufs") || fs2.getFSTypeName().equals("vxfs")) {
                deviceName = fs2.getName();
            }
        } else {
            FileSystem fileSystem = (FileSystem)fs2;
            eq = Integer.toString(fileSystem.getEquipOrdinal());
            int fsSharedStatus = fileSystem.getShareStatus();
            switch (fsSharedStatus) {
                case 0: {
                    share = "FSSummary.unshared";
                    break;
                }
                case 4: {
                    share = "FSSummary.shared";
                    break;
                }
                case 1: {
                    share = "FSSummary.mds";
                    break;
                }
                case 2: {
                    share = "FSSummary.pmds";
                    break;
                }
                case 3: {
                    share = "FSSummary.client";
                }
            }
            switch (fileSystem.getFSType()) {
                case 0: {
                    metadataPlacement = "FSDetails.metadataPlacement.separate";
                    break;
                }
                case 1: {
                    metadataPlacement = "FSDetails.metadataPlacement.same";
                    break;
                }
                default: {
                    metadataPlacement = "filesystem.desc.unknown";
                }
            }
            dau = Integer.toString(fileSystem.getDAUSize());
            server = fileSystem.getServerName();
            timeAbove = SamUtil.getTimeString(fileSystem.getTimeAboveHWM());
            createDate = SamUtil.getTimeString(fileSystem.getDateCreated());
            FileSystemMountProperties mountPro = fileSystem.getMountProperties();
            hwm = Integer.toString(mountPro.getHWM());
            lwm = Integer.toString(mountPro.getLWM());
            if (this.sharedFlag) {
                sharedType = FSUtil.getSharedFSDescriptionString(fileSystem.getShareStatus());
            }
        }
        type = FSUtil.getFileSystemDescriptionString(fs2);
        this.propertySheetModel.setValue("typeValue", (Object)type);
        if (this.sharedFlag) {
            this.propertySheetModel.setValue("sharedFSTypeValue", sharedType);
        }
        this.propertySheetModel.setValue("mountValue", (Object)point);
        this.propertySheetModel.setValue("eqValue", (Object)eq);
        this.propertySheetModel.setValue("stateValue", (Object)state);
        this.propertySheetModel.setValue("capValue", (Object)cap);
        this.propertySheetModel.setValue("freespaceValue", (Object)free);
        this.propertySheetModel.setValue("consumedValue", (Object)consumed);
        this.propertySheetModel.setValue("shareValue", (Object)share);
        this.propertySheetModel.setValue("dauValue", (Object)dau);
        this.propertySheetModel.setValue("hwmValue", (Object)hwm);
        this.propertySheetModel.setValue("lwmValue", (Object)lwm);
        this.propertySheetModel.setValue("timeaboveValue", (Object)timeAbove);
        this.propertySheetModel.setValue("createdateValue", (Object)createDate);
        this.propertySheetModel.setValue("serverValue", (Object)server);
        this.propertySheetModel.setValue("deviceNameValue", (Object)deviceName);
        this.propertySheetModel.setValue("metadataPlacementValue", (Object)metadataPlacement);
        TraceUtil.trace3("Exiting");
    }

    private void showAlert(String op, String key) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(op, key), this.serverName);
        TraceUtil.trace3("Exiting");
    }

    private GenericFileSystem getFileSystem(String fsName) throws SamFSException {
        TraceUtil.trace3("Entering");
        GenericFileSystem filesystem = null;
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        filesystem = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
        TraceUtil.trace3("Exiting");
        return filesystem;
    }

    private void checkRolePrivilege() {
        TraceUtil.trace3("Entering");
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        String permission = (String)session.getAttribute("PERMISSION");
        if (permission.equals("WRITE")) {
            this.writeRole = true;
        }
        TraceUtil.trace3("Exiting");
    }

    private void initializeGrowWizard() {
        TraceUtil.trace3("Entering");
        ViewBean view = this.getParentViewBean();
        StringBuffer cmdChild = new StringBuffer().append(view.getQualifiedName()).append(".").append("FSDetailsView.").append(CHILD_FRWD_TO_CMDCHILD);
        this.growWizWinModel = GrowWizardImpl.createModel(cmdChild.toString());
        this.pageTitleModel.setModel("SamQFSWizardGrowFSButton", (Object)this.growWizWinModel);
        this.growWizWinModel.setValue("SamQFSWizardGrowFSButton", (Object)"FSDetails.button.grow");
        TraceUtil.trace3("Exiting");
    }

    public void handleViewDeviceButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSDevicesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean);
        ViewBean vb = this.getParentViewBean();
        BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleViewPolicyButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean);
        ViewBean vb = this.getParentViewBean();
        BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handlePageActionsMenuHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String value = (String)this.getDisplayFieldValue("PageActionsMenu");
        String op = null;
        ViewBean vb = this.getParentViewBean();
        int option = 0;
        try {
            option = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        TraceUtil.trace2("Handling DropDownMenu Option #" + option);
        if (option != 0) {
            try {
                GenericFileSystem fs2 = this.getFileSystem(this.fsName);
                if (fs2 != null) {
                    if (this.fsType == 13 && (fs2.getFSTypeName().equals("ufs") || fs2.getFSTypeName().equals("vxfs"))) {
                        ++option;
                    }
                    switch (option) {
                        case 1: {
                            return;
                        }
                        case 2: {
                            op = "FSDetails.mountfs";
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Start mounting filesystem " + this.fsName);
                            fs2.mount();
                            if (fs2.getState() == 1) {
                                throw new SamFSException(SamUtil.getResourceString("FSDetails.warning.mount.cause"), -1099);
                            }
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Done mounting filesystem " + this.fsName);
                            break;
                        }
                        case 3: {
                            op = "FSDetails.umountfs";
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Start unmounting filesystem " + this.fsName);
                            fs2.unmount();
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Done unmounting filesystem " + this.fsName);
                            break;
                        }
                        case 4: {
                            this.handleDeleteButtonRequest(fs2);
                            return;
                        }
                        case 5: {
                            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
                            BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
                            ViewBean nfsVB = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$NFSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$NFSDetailsViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.NFSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$NFSDetailsViewBean);
                            ((CommonViewBeanBase)vb).forwardTo(nfsVB);
                            return;
                        }
                        case 6: {
                            FileSystem fileSystem = (FileSystem)fs2;
                            op = "FSDetails.stoparchive";
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Start stopping archive Filesystem" + this.fsName);
                            fileSystem.stopFSArchive();
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Done stopping archive Filesystem" + this.fsName);
                            break;
                        }
                        case 7: {
                            FileSystem fileSystem = (FileSystem)fs2;
                            op = "FSDetails.idlearchive";
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Start idling archive filesystem " + this.fsName);
                            fileSystem.idleFSArchive();
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Done idling archive filesystem " + this.fsName);
                            break;
                        }
                        case 8: {
                            FileSystem fileSystem = (FileSystem)fs2;
                            op = "FSDetails.runarchive";
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Start runing archive filesystem " + this.fsName);
                            fileSystem.runFSArchive();
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Done runing archive filesystem " + this.fsName);
                            break;
                        }
                        case 9: {
                            ViewBean scheduleDumpVB = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSScheduleDumpViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSScheduleDumpViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSScheduleDumpViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSScheduleDumpViewBean);
                            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
                            BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
                            ((CommonViewBeanBase)vb).forwardTo(scheduleDumpVB);
                            return;
                        }
                        case 10: {
                            return;
                        }
                        case 11: {
                            op = "FSDetails.removeDumpSchedule";
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionMenuHrefRequest", "Start removing dump schedule for fs " + this.fsName);
                            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
                            SamQFSSystemFSManager fsManager = sysModel.getSamQFSSystemFSManager();
                            fsManager.setMetadataDumpSchedParams(this.fsName, null);
                            LogUtil.info(((Object)((Object)this)).getClass(), "handlePageViewMenuHrefRequest", "Done removing dump schedule for fs " + this.fsName);
                            break;
                        }
                        case 12: {
                            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
                            vb.setPageSessionAttribute("SAMQFS_PARENT", (Serializable)((Object)"FS_DETAILS"));
                            BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
                            ViewBean restoreVB = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSRestoreViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSRestoreViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSRestoreViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSRestoreViewBean);
                            ((CommonViewBeanBase)vb).forwardTo(restoreVB);
                            return;
                        }
                        case 13: {
                            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
                            vb.setPageSessionAttribute("SAMQFS_fs_mount_point", (Serializable)((Object)fs2.getMountPoint()));
                            BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
                            ViewBean stage = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$StageViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$StageViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.StageViewBean")) : class$com$sun$netstorage$samqfs$web$fs$StageViewBean);
                            ((CommonViewBeanBase)vb).forwardTo(stage);
                            return;
                        }
                        default: {
                            throw new SamFSException(null, -1000);
                        }
                    }
                } else {
                    throw new SamFSException(null, -1000);
                }
                this.showAlert(op, this.fsName);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handlePageActionsMenuHrefRequest()", "failed to populate data", this.serverName);
                String errorMsgs = null;
                switch (option) {
                    case 6: {
                        errorMsgs = "FSDetails.error.stoparchive";
                        break;
                    }
                    case 7: {
                        errorMsgs = "FSDetails.error.idlearchive";
                        break;
                    }
                    case 8: {
                        errorMsgs = "FSDetails.error.runarchive";
                        break;
                    }
                    case 2: {
                        errorMsgs = "FSDetails.error.mountfs";
                        break;
                    }
                    case 3: {
                        errorMsgs = "FSDetails.error.umountfs";
                    }
                }
                SamUtil.setErrorAlert((ContainerView)vb, "Alert", errorMsgs, ex.getSAMerrno(), ex.getMessage(), this.serverName);
            }
        }
        vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleSamQFSWizardGrowFSButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleEditMountOptionsButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        ViewBean targetView = null;
        try {
            FileSystem fs2 = (FileSystem)this.getFileSystem(this.fsName);
            if (fs2 == null) {
                throw new SamFSException(null, -1000);
            }
            int fsType = fs2.getFSTypeByProduct();
            int shareStatus = fs2.getShareStatus();
            String mountPageType = null;
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSMountViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean);
            block1 : switch (shareStatus) {
                case 0: {
                    switch (fsType) {
                        case 12: {
                            mountPageType = "UnsharedSAMQFS";
                            break;
                        }
                        case 11: {
                            mountPageType = "UnsharedQFS";
                            break;
                        }
                        default: {
                            mountPageType = "UnsharedSAMFS";
                        }
                    }
                    targetView.setPageSessionAttribute("SAMQFS_ARCHIVE_TYPE", (Serializable)new Integer(fs2.getArchivingType()));
                    break;
                }
                default: {
                    switch (fsType) {
                        case 12: {
                            mountPageType = "SharedSAMQFS";
                            break block1;
                        }
                    }
                    mountPageType = "SharedQFS";
                }
            }
            targetView.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
            targetView.setPageSessionAttribute("SAMQFS_MOUNT_PAGE_TYPE", (Serializable)((Object)mountPageType));
            targetView.setPageSessionAttribute("SAMQFS_SHARED_CLIENT_HOST", (Serializable)((Object)"NON_SHARED"));
            if (shareStatus != 0) {
                SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
                int sharedType = fsManager.getSharedFSType(this.serverName, this.fsName);
                if (sharedType == 0 || sharedType == 1) {
                    targetView.setPageSessionAttribute("SAMQFS_SHARED_CLIENT_HOST", (Serializable)((Object)"This Host"));
                } else {
                    targetView.setPageSessionAttribute("SAMQFS_SHARED_CLIENT_HOST", (Serializable)((Object)"Shared Client"));
                }
            }
            BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
            ((CommonViewBeanBase)vb).forwardTo(targetView);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleEditMountOptionsButtonRequest()", "failed to retrieve fs/model", this.serverName);
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", "FSDetails.error.editmount", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleDeleteButtonRequest(GenericFileSystem fileSystem) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        boolean error = false;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            if (fileSystem == null) {
                throw new SamFSException(null, -1000);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleDeleteButtonRequest", "Start deleting filesystem " + this.fsName);
            if (this.fsType != 13 && ((FileSystem)fileSystem).getShareStatus() != 0) {
                SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
                TraceUtil.trace3(new NonSyncStringBuffer("Begin shared deleting on host").append(this.serverName).append("file:").append(this.fsName).toString());
                fsManager.deleteSharedFileSystem(this.serverName, this.fsName, null);
            } else {
                sysModel.getSamQFSSystemFSManager().deleteFileSystem(fileSystem);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleDeleteButtonRequest", "Done deleting filesystem " + this.fsName);
        }
        catch (SamFSMultiHostException e) {
            SamUtil.doPrint(new NonSyncStringBuffer().append("error code is ").append(e.getSAMerrno()).toString());
            String err_msg = SamUtil.handleMultiHostException(e);
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", "FSDetails.error.delete", e.getSAMerrno(), err_msg, this.serverName);
        }
        catch (SamFSException ex) {
            error = true;
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            boolean multiMsgOccurred = false;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
                multiMsgOccurred = true;
            } else if (ex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to delete filesystem";
                errMsg = "FSDetails.error.delete";
                errCause = ex.getMessage();
            }
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleDeleteButtonRequest()", processMsg, this.serverName);
            if (multiMsgOccurred || warning) {
                ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
                if (multiMsgOccurred) {
                    SamUtil.setErrorAlert((ContainerView)targetView, "Alert", errMsg, ex.getSAMerrno(), errCause, this.serverName);
                }
                if (warning) {
                    SamUtil.setWarningAlert((ContainerView)targetView, "Alert", errMsg, errCause);
                }
                ((CommonViewBeanBase)vb).forwardTo(targetView);
                return;
            }
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", errMsg, ex.getSAMerrno(), errCause, this.serverName);
            vb.forwardTo(this.getRequestContext());
            return;
        }
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
        SamUtil.setInfoAlert((ContainerView)targetView, "Alert", "success.summary", SamUtil.getResourceString("FSDetails.deletefs", this.fsName), this.serverName);
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleForwardToVbRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleSamfsckHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        boolean checkAndRepair = false;
        String type = (String)this.getDisplayFieldValue(CHILD_HIDDEN_FSCK_ACTION);
        String loc = (String)this.getDisplayFieldValue(CHILD_HIDDEN_FSCK_LOG);
        TraceUtil.trace2("FSCK: type is " + type + ", loc is " + loc);
        try {
            SamQFSSystemModel sysModel;
            FileSystem fileSystem = (FileSystem)this.getFileSystem(this.fsName);
            if (fileSystem == null) {
                throw new SamFSException(null, -1000);
            }
            if (this.samfsServerAPIVersion.compareTo("1.2") >= 0 && (sysModel = SamUtil.getModel(this.serverName)).doesFileExist(loc)) {
                throw new SamFSException(null, -1009);
            }
            if (type.equals("both")) {
                checkAndRepair = true;
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSamfsckHrefRequest", "Start samfsck filesystem " + this.fsName);
            fileSystem.setFsckLogfileLocation(loc);
            long jobID = fileSystem.samfsck(checkAndRepair, loc);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSamfsckHrefRequest", "Done samfsck filesystem " + this.fsName + "with Job ID " + jobID);
            if (jobID < 0L) {
                SamUtil.setInfoAlert((ContainerView)vb, "Alert", "success.summary", SamUtil.getResourceString("FSSummary.samfsckresult", new String[]{this.fsName, loc}), this.serverName);
            } else {
                StringBuffer href = new StringBuffer().append("<a href=\"../fs/FSDetails?").append("FSDetails.FSDetailsView.JobIdHref=").append(jobID).append(",").append("Jobs.jobType6").append(",Current").append("\" ").append("name=\"FSDetails.FSDetailsView.").append(CHILD_JOBID_HREF).append("\" ").append("onclick=\"javascript:var f=document.FSDetailsForm;").append("if (f != null) {f.action=this.href;f.submit();").append("return false}\">").append(jobID).append("</a>");
                SamUtil.setInfoAlert((ContainerView)vb, "Alert", "success.summary", SamUtil.getResourceString("FSSummary.samfsckjob", new String[]{this.fsName, loc, href.toString()}), this.serverName);
            }
        }
        catch (SamFSException ex) {
            if (ex.getSAMerrno() == -1000) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSamfsckHrefRequest()", "can not retrieve file system", this.serverName);
            } else if (ex.getSAMerrno() == -1009) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSamfsckHrefRequest()", "Catalog file exists", this.serverName);
            }
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", "FSDetails.error.checkfs", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleDumpNowHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        String dumpPath = (String)this.getDisplayFieldValue(CHILD_HIDDEN_DUMPPATH);
        TraceUtil.trace3("DumpPath = " + dumpPath);
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleDumpNowHrefRequest", "Starting backing up metadata for fs " + this.fsName);
            long jobID = sysModel.getSamQFSSystemFSManager().startMetadataDump(this.fsName, dumpPath);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleDumpNowHrefRequest", "Done backing up metadata for fs " + this.fsName);
            if (jobID != -1L) {
                StringBuffer href = new StringBuffer();
                href.append("<a href=\"../fs/FSDetails?").append("FSDetails.FSDetailsView.JobIdHref=").append(jobID).append(",").append("Jobs.jobType.dump").append(",Current").append("\" ").append("name=\"FSDetails.FSDetailsView.").append(CHILD_JOBID_HREF).append("\" ").append("onclick=\"javascript:").append("var f=document.FSDetailsForm;").append("if (f != null) ").append("{f.action=this.href;f.submit();").append("return false}\">").append(SamUtil.getResourceString("FSRestore.jobIdLink")).append("</a>");
                SamUtil.setInfoAlert((ContainerView)vb, "Alert", "success.summary", SamUtil.getResourceString("FSSummary.dumpMetadataJobStarted", new String[]{this.fsName, String.valueOf(jobID), href.toString()}));
            } else {
                SamUtil.setInfoAlert((ContainerView)vb, "Alert", "success.summary", SamUtil.getResourceString("FSSummary.dumpMetadataJobCompleted", this.fsName));
            }
        }
        catch (SamFSException ex) {
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", "FSSummary.error.dumpNow", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleJobIdHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String jobID = this.getDisplayFieldStringValue(CHILD_JOBID_HREF);
        ViewBean vb = this.getParentViewBean();
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean = FSDetailsView.class$("com.sun.netstorage.samqfs.web.jobs.JobsDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean);
        BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
        vb.setPageSessionAttribute("SAMQFS_JOB_ID", (Serializable)((Object)jobID));
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleCancelHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void setGrowWizardNames() {
        TraceUtil.trace3("Entering");
        String modelName = "GrowWizardModel_" + HtmlUtil.getUniqueValue();
        this.growWizWinModel.setValue("GrowPageModelName", (Object)modelName);
        String implName = "GrowWizardImpl_" + HtmlUtil.getUniqueValue();
        this.growWizWinModel.setValue("wizName", (Object)implName);
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

