/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.web.model.MDSAddresses;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;

public class AdvancedNetworkConfigDisplayView
extends CommonTableContainerView {
    private static String MDS_LIST = "MDSNames";
    private static String ALL_SHARED_HOST_NAMES = "AllSharedHostNames";
    private static String FS_NAME = "FSName";
    public static final String MDS_NAME = "MDServerName";
    private CCActionTableModel tableModel = null;
    private SharedMember[] sharedMember = null;
    private String[] metadataHosts = null;
    private String MDServerName = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public AdvancedNetworkConfigDisplayView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "AdvancedNetworkConfigDisplayTable";
        try {
            this.getAllSharedMemberInformation();
        }
        catch (SamFSMultiHostException multiEx) {
            String errMsg = SamUtil.handleMultiHostException(multiEx);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "AdvancedNetworkConfig.setup.error.populate", multiEx.getSAMerrno(), SamUtil.handleMultiHostException(multiEx), this.getServerName());
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "AdvancedNetworkConfigDisplayView()", "Failed to retrieve shared members information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "AdvancedNetworkConfig.setup.error.populate", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        this.createTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren(this.tableModel);
        this.registerChild(MDS_LIST, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AdvancedNetworkConfigDisplayView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(ALL_SHARED_HOST_NAMES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AdvancedNetworkConfigDisplayView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(FS_NAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AdvancedNetworkConfigDisplayView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(MDS_NAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AdvancedNetworkConfigDisplayView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entering: name is ").append(name).toString());
        Object child = null;
        child = name.equals(MDS_LIST) || name.equals(ALL_SHARED_HOST_NAMES) || name.equals(FS_NAME) || name.equals(MDS_NAME) ? new CCHiddenField((ContainerView)this, name, null) : super.createChild(this.tableModel, name);
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            this.tableModel.setSelectionType("none");
        } else {
            ((CCButton)this.getChild("ModifyButton")).setDisabled(true);
        }
        ((CCHiddenField)this.getChild(FS_NAME)).setValue((Object)this.getFSName());
        ((CCHiddenField)this.getChild(MDS_NAME)).setValue((Object)this.MDServerName);
        TraceUtil.trace3("Exiting");
    }

    private void setSuccessAlert(String msg, String item) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(msg, item), "");
        TraceUtil.trace3("Exiting");
    }

    public void createTableModel() {
        NonSyncStringBuffer xmlBuf = new NonSyncStringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<!DOCTYPE table SYSTEM \"tags/dtd/table.dtd\">").append("<table>").append("<actions>").append("<cc name=\"ModifyButton\" ").append("tagclass=\"com.sun.web.ui.taglib.html.CCButtonTag\"> ").append("<attribute name=\"dynamic\" value=\"true\" /> ").append("<attribute name=\"disabled\" value=\"true\" /> ").append("<attribute name=\"defaultValue\" value=\"").append("AdvancedNetworkConfig.setup.button.submit\" /> ").append("<attribute name=\"onClick\" value=\"").append("return launchConfigWindow(); \" /> ").append("</cc>").append("</actions>").append((Object)this.createColumnXMLString("Host"));
        for (int i = 0; i < this.metadataHosts.length; ++i) {
            xmlBuf = xmlBuf.append((Object)this.createColumnXMLString(this.metadataHosts[i]));
        }
        xmlBuf = xmlBuf.append("</table>");
        this.tableModel = new CCActionTableModel(xmlBuf.toString());
    }

    private NonSyncStringBuffer createColumnXMLString(String item) {
        return new NonSyncStringBuffer("<column name=\"").append(item).append("_Column\" extrahtml=\"nowrap\">").append("<cc name=\"").append(item).append("_Text\" ").append("tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\" />").append("</column> ");
    }

    private void initializeTableHeaders() {
        this.tableModel.setRowSelected(false);
        this.tableModel.setActionValue("Host_Column", (Object)"AdvancedNetworkConfig.display.heading.hostname");
        for (int i = 0; i < this.metadataHosts.length; ++i) {
            this.tableModel.setActionValue(this.metadataHosts[i] + "_Column", (Object)SamUtil.getResourceString("AdvancedNetworkConfig.display.heading.interface", this.metadataHosts[i]));
        }
    }

    public void populateTableModels() throws SamFSMultiHostException, SamFSException {
        this.populateCurrentSetupTable();
    }

    public void populateCurrentSetupTable() throws SamFSMultiHostException, SamFSException {
        TraceUtil.trace3("Entering");
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        CCActionTable myTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        for (int i = 0; i < this.sharedMember.length; ++i) {
            int j;
            if (i > 0) {
                this.tableModel.appendRow();
            }
            CCCheckBox myCheckBox = (CCCheckBox)myTable.getChild("SelectionCheckbox" + i);
            myCheckBox.setTitle("");
            myCheckBox.setTitleDisabled("");
            this.tableModel.setValue("Host_Text", (Object)this.sharedMember[i].getHostName());
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
            try {
                MDSAddresses[] myAddresses = fsManager.getAdvancedNetworkConfig(this.sharedMember[i].getHostName(), this.getFSName());
                if (myAddresses == null || myAddresses.length == 0) {
                    for (j = 0; j < this.metadataHosts.length; ++j) {
                        this.tableModel.setValue(this.metadataHosts[j] + "_Text", (Object)"");
                    }
                }
                for (j = 0; j < this.metadataHosts.length; ++j) {
                    if (this.sharedMember[i].getHostName().equals(this.metadataHosts[j])) {
                        this.tableModel.setValue(this.metadataHosts[j] + "_Text", (Object)"");
                        continue;
                    }
                    this.tableModel.setValue(this.metadataHosts[j] + "_Text", (Object)this.getAddresses(myAddresses, this.metadataHosts[j]));
                }
                continue;
            }
            catch (SamFSException ex) {
                errorHostNames.add(this.sharedMember[i].getHostName());
                errorExceptions.add(ex);
                for (j = 0; j < this.metadataHosts.length; ++j) {
                    this.tableModel.setValue(this.metadataHosts[j] + "_Text", (Object)SamUtil.getResourceString("AdvancedNetworkConfig.display.notavailable"));
                }
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        TraceUtil.trace3("Exiting");
    }

    private void getAllSharedMemberInformation() throws SamFSMultiHostException, SamFSException {
        SamQFSSystemSharedFSManager fsManager = SamQFSFactory.getSamQFSAppModel().getSamQFSSystemSharedFSManager();
        SamFSMultiHostException multiEx = null;
        try {
            this.sharedMember = fsManager.getSharedMembers(this.getServerName(), this.getFSName());
        }
        catch (SamFSMultiHostException e) {
            this.sharedMember = (SharedMember[])e.getPartialResult();
            if (this.sharedMember != null) {
                TraceUtil.trace3("exception shared member length = " + Integer.toString(this.sharedMember.length));
            }
            SamUtil.doPrint(new NonSyncStringBuffer().append("error code is ").append(e.getSAMerrno()).toString());
            multiEx = e;
        }
        if (this.sharedMember == null || this.sharedMember.length == 0) {
            this.sharedMember = new SharedMember[0];
            this.metadataHosts = new String[0];
            throw multiEx;
        }
        NonSyncStringBuffer mdsHostsBuf = new NonSyncStringBuffer();
        NonSyncStringBuffer allHostsBuf = new NonSyncStringBuffer();
        block6: for (int i = 0; i < this.sharedMember.length; ++i) {
            if (allHostsBuf.length() != 0) {
                allHostsBuf.append(",");
            }
            allHostsBuf.append(this.sharedMember[i].getHostName());
            switch (this.sharedMember[i].getType()) {
                case 0: {
                    this.MDServerName = this.sharedMember[i].getHostName();
                    if (mdsHostsBuf.length() != 0) {
                        mdsHostsBuf.append(",");
                    }
                    mdsHostsBuf.append(this.sharedMember[i].getHostName());
                    continue block6;
                }
                case 1: {
                    if (mdsHostsBuf.length() != 0) {
                        mdsHostsBuf.append(",");
                    }
                    mdsHostsBuf.append(this.sharedMember[i].getHostName());
                }
            }
        }
        this.metadataHosts = mdsHostsBuf.length() == 0 ? new String[]{} : mdsHostsBuf.toString().split(",");
        ((CCHiddenField)this.getChild(MDS_LIST)).setValue((Object)mdsHostsBuf.toString());
        ((CCHiddenField)this.getChild(ALL_SHARED_HOST_NAMES)).setValue((Object)allHostsBuf.toString());
        if (multiEx != null) {
            throw multiEx;
        }
    }

    private String getAddresses(MDSAddresses[] myAddresses, String mdsName) {
        for (int i = 0; i < myAddresses.length; ++i) {
            if (!mdsName.equals(myAddresses[i].getHostName())) continue;
            String[] ipAddresses = myAddresses[i].getIPAddress();
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            for (int j = 0; j < ipAddresses.length; ++j) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(ipAddresses[j]);
            }
            return buf.toString();
        }
        return "";
    }

    private String getFSName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
    }

    private String getServerName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

