/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.VSNPoolDetailsData;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.LDSTableModel;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public final class VSNPoolDetailsModel
extends LDSTableModel {
    public VSNPoolDetailsModel(LargeDataSet data, String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.dataSet = data;
        TraceUtil.trace3("Exiting");
    }

    public void initHeaders(int mediaType) {
        TraceUtil.trace3("Entering");
        this.setActionValue("VSNName", "VSNPoolDetails.heading1");
        this.setActionValue("Usage", "common.capacity.usage");
        if (mediaType == 133) {
            this.setActionValue("Library", "archiving.diskvsn.path");
            this.setActionValue("Barcode", "archiving.diskvsn.host");
        } else {
            this.setActionValue("Library", "VSNPoolDetails.heading2");
            this.setActionValue("Barcode", "VSNPoolDetails.heading3");
        }
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(int mediaType) throws SamFSException {
        if (mediaType == 133) {
            this.initDiskPoolModelRows();
        } else {
            this.initTapePoolModelRows();
        }
    }

    public void initDiskPoolModelRows() throws SamFSException {
        TraceUtil.trace3("Entering");
        super.getModelRows();
        String serverName = ((VSNPoolDetailsData)this.dataSet).getParentViewBean().getServerName();
        for (int i = 0; i < this.currentDataSet.length; ++i) {
            if (i > 0) {
                this.appendRow();
            }
            DiskVolume vol = (DiskVolume)this.currentDataSet[i];
            this.setValue("VSNNameText", vol.getName());
            this.setValue("LibraryText", vol.getPath());
            String host = vol.getRemoteHost();
            if (host == null || host.length() == 0) {
                host = SamUtil.getResourceString("archiving.currentserver", serverName);
            }
            this.setValue("BarcodeText", host);
            long capacity = vol.getCapacityKB();
            long free = vol.getAvailableSpaceKB();
            int percentUsed = PolicyUtil.getPercentUsage(capacity, free);
            String imagePath = "/samqfsui/images/samqfs_blank.gif";
            if (percentUsed != -1) {
                imagePath = "/samqfsui/images/usagebar/".concat(Integer.toString(percentUsed)).concat(".gif");
            }
            this.setValue("UsageImage", imagePath);
            String capacityText = "(".concat(new Capacity(capacity, 1).toString()).concat(")");
            this.setValue("CapacityText", capacityText);
        }
        TraceUtil.trace3("Exiting");
    }

    public void initTapePoolModelRows() throws SamFSException {
        TraceUtil.trace3("Entering");
        super.getModelRows();
        boolean containsReservedVSN = false;
        for (int i = 0; i < this.currentDataSet.length; ++i) {
            if (i > 0) {
                this.appendRow();
            }
            VSN vsn = (VSN)this.currentDataSet[i];
            String vsnName = vsn.getVSN();
            if (vsn.isReserved()) {
                containsReservedVSN = true;
                vsnName = vsnName.concat(" ").concat("&#8224");
            }
            this.setValue("VSNNameText", vsnName);
            if (vsn.getLibrary() != null) {
                this.setValue("LibraryText", vsn.getLibrary().getName());
            }
            this.setValue("BarcodeText", vsn.getBarcode());
            long capacity = vsn.getCapacity();
            long free = vsn.getAvailableSpace();
            if (vsn.getLibrary() == null) {
                this.setValue("VSNHref", "$STANDALONE;" + Integer.toString(vsn.getDrive().getEquipOrdinal()));
            } else {
                this.setValue("VSNHref", vsn.getLibrary().getName() + ";" + Integer.toString(vsn.getSlotNumber()));
            }
            int percentUsed = PolicyUtil.getPercentUsage(capacity, free);
            String imagePath = "/samqfsui/images/samqfs_blank.gif";
            if (percentUsed != -1) {
                imagePath = "/samqfsui/images/usagebar/".concat(Integer.toString(percentUsed)).concat(".gif");
            }
            this.setValue("UsageImage", imagePath);
            String capacityText = "(".concat(new Capacity(capacity, 2).toString()).concat(")");
            this.setValue("CapacityText", capacityText);
        }
        RequestManager.getRequestContext().getRequest().setAttribute("vsnPoolContainsAReservedVSN", (Object)containsReservedVSN);
        TraceUtil.trace3("Exiting");
    }
}

