/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public final class VSNPoolDetailsData
implements LargeDataSet {
    public static final String[] headings = new String[]{"VSNPoolDetails.heading1", "VSNPoolDetails.heading2", "VSNPoolDetails.heading3", "VSNPoolDetails.heading4", "VSNPoolDetails.heading5"};
    private CommonViewBeanBase parentViewBean = null;

    public VSNPoolDetailsData(CommonViewBeanBase parentViewBean) {
        TraceUtil.initTrace();
        this.parentViewBean = parentViewBean;
    }

    public Object[] getData(int start, int num, String sortName, String sortOrder) throws SamFSException {
        TraceUtil.trace3("Entering");
        String serverName = this.parentViewBean.getServerName();
        String poolName = (String)this.parentViewBean.getPageSessionAttribute("SAMQFS_vsn_pool_name");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        VSNPool vsnpool = sysModel.getSamQFSSystemArchiveManager43().getVSNPool(poolName);
        if (vsnpool == null) {
            throw new SamFSException(null, -2010);
        }
        int sortby = 8;
        if (sortName != null) {
            if ("VSNNameText".compareTo(sortName) == 0) {
                sortby = 8;
            } else if ("FreeSpaceText".compareTo(sortName) == 0) {
                sortby = 9;
            }
        }
        boolean ascending = true;
        if (sortOrder != null && "descending".compareTo(sortOrder) == 0) {
            ascending = false;
        }
        Integer mediaType = (Integer)this.parentViewBean.getPageSessionAttribute("SAMQFS_vsn_pool_media_type");
        Object[] vsns = null;
        vsns = mediaType == 133 ? vsnpool.getMemberDiskVolumes(start, num, sortby, ascending) : vsnpool.getMemberVSNs(start, num, sortby, ascending);
        if (vsns == null) {
            return new Object[0];
        }
        TraceUtil.trace3("Exiting");
        return vsns;
    }

    public int getTotalRecords() throws SamFSException {
        TraceUtil.trace3("Entering");
        String serverName = this.parentViewBean.getServerName();
        String poolName = (String)this.parentViewBean.getPageSessionAttribute("SAMQFS_vsn_pool_name");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        VSNPool vsnpool = sysModel.getSamQFSSystemArchiveManager43().getVSNPool(poolName);
        if (vsnpool == null) {
            throw new SamFSException(null, -2010);
        }
        TraceUtil.trace3("Exiting");
        return vsnpool.getNoOfVSNsInPool();
    }

    public CommonViewBeanBase getParentViewBean() {
        return this.parentViewBean;
    }
}

