/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.web.util.SamUtil;

public class ReservationMethodHelper {
    public static final int RM_SET = 1;
    public static final int RM_OWNER = 2;
    public static final int RM_FS = 4;
    public static final int RM_DIR = 8;
    public static final int RM_USER = 16;
    public static final int RM_GROUP = 32;
    private int set = 0;
    private int fs = 0;
    private int attributes = 0;

    public void setValue(int rm) {
        rm = rm > 0 ? rm : 0;
        this.set = rm & 1;
        this.fs = rm & 4;
        int temp = rm - this.set - this.fs;
        this.attributes = temp > 0 ? (temp == 2 ? 0 : temp) : 0;
    }

    public int getValue() {
        return this.set | this.fs | this.attributes;
    }

    public int getSet() {
        return this.set;
    }

    public void setSet(int set) {
        this.set = set;
    }

    public int getFS() {
        return this.fs;
    }

    public void setFS(int fs2) {
        this.fs = fs2;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public void setAttributes(int attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        if (this.set != 0) {
            buffer.append(SamUtil.getResourceString("archiving.reservation.method.policy")).append(" | ");
        }
        if (this.fs != 0) {
            buffer.append(SamUtil.getResourceString("archiving.reservation.method.fs")).append(" | ");
        }
        switch (this.attributes) {
            case 8: {
                buffer.append(SamUtil.getResourceString("archiving.reservation.method.dir")).append(" | ");
                break;
            }
            case 16: {
                buffer.append(SamUtil.getResourceString("archiving.reservation.method.user")).append(" | ");
                break;
            }
            case 32: {
                buffer.append(SamUtil.getResourceString("archiving.reservation.method.group")).append(" | ");
                break;
            }
        }
        String temp = buffer.toString().trim();
        if (temp.length() > 0) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }
}

