/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.CriteriaDetailsCopyTiledView;
import com.sun.netstorage.samqfs.web.archive.CriteriaDetailsFSTiledView;
import com.sun.netstorage.samqfs.web.archive.MultiTableViewBase;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;

public class CriteriaDetailsView
extends MultiTableViewBase {
    public static final String COPY_TABLE = "CriteriaDetailsCopySettingsTable";
    public static final String FS_TABLE = "CriteriaDetailsFSTable";
    public static final String COPY_TILED_VIEW = "CopySettingsTiledView";
    public static final String FS_TILED_VIEW = "FSTiledView";
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsCopyTiledView;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsFSTiledView;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean;

    public CriteriaDetailsView(View parent, Map models, String name) {
        super(parent, models, name);
        TraceUtil.trace3("Entering");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(COPY_TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsCopyTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsCopyTiledView = CriteriaDetailsView.class$("com.sun.netstorage.samqfs.web.archive.CriteriaDetailsCopyTiledView")) : class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsCopyTiledView);
        this.registerChild(FS_TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsFSTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsFSTiledView = CriteriaDetailsView.class$("com.sun.netstorage.samqfs.web.archive.CriteriaDetailsFSTiledView")) : class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsFSTiledView);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(COPY_TILED_VIEW)) {
            return new CriteriaDetailsCopyTiledView((View)this, this.getTableModel(COPY_TABLE), name);
        }
        if (name.equals(FS_TILED_VIEW)) {
            return new CriteriaDetailsFSTiledView((View)this, this.getTableModel(FS_TABLE), name);
        }
        if (name.equals(COPY_TABLE)) {
            return this.createTable(name, COPY_TILED_VIEW);
        }
        if (name.equals(FS_TABLE)) {
            return this.createTable(name, FS_TILED_VIEW);
        }
        CCActionTableModel model = super.isChildSupported(name);
        if (model != null) {
            return model.createChild((View)this, name);
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    private void initializeTableHeaders() {
        CCActionTableModel model = this.getTableModel(COPY_TABLE);
        model.setActionValue("CopyNumber", (Object)"archiving.policy.copy.number");
        model.setActionValue("ArchiveAge", (Object)"archiving.archiveage");
        model.setActionValue("UnarchiveAge", (Object)"archiving.unarchiveage");
        model.setActionValue("ReleaseOptions", (Object)"archiving.releaseoptions");
        model = this.getTableModel(FS_TABLE);
        model.setActionValue("AddFS", (Object)"archiving.add");
        model.setActionValue("RemoveFS", (Object)"archiving.remove");
        model.setActionValue("ViewPolicies", (Object)"archiving.policy.viewpolicies");
        model.setActionValue("FSName", (Object)"archiving.fs.name");
        model.setActionValue("MountPoint", (Object)"archiving.fs.mountpoint");
    }

    public void populateTableModels() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        Integer ci = (Integer)parent.getPageSessionAttribute("SAMQFS_criteria_number");
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        try {
            CCActionTableModel model = this.getTableModel(COPY_TABLE);
            ArchivePolicy thePolicy = SamUtil.getModel(serverName).getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            if (thePolicy == null) {
                throw new SamFSException(null, -2000);
            }
            ArchivePolCriteria criteria = thePolicy.getArchivePolCriteria(ci);
            if (thePolicy.getPolicyType() == 1002) {
                ArchivePolCriteriaCopy[] copies = criteria.getArchivePolCriteriaCopies();
                model.clear();
                for (int i = 0; i < copies.length; ++i) {
                    if (i > 0) {
                        model.appendRow();
                    }
                    model.setValue("CopyNumberText", (Object)SamUtil.getResourceString("archiving.copynumber", Integer.toString(copies[i].getArchivePolCriteriaCopyNumber())));
                    model.setValue("CopyNumberHidden", (Object)Integer.toString(copies[i].getArchivePolCriteriaCopyNumber()));
                    if (copies[i].getArchiveAge() >= 0L) {
                        model.setValue("ArchiveAgeText", (Object)Long.toString(copies[i].getArchiveAge()));
                    }
                    model.setValue("ArchiveAgeUnits", (Object)Integer.toString(copies[i].getArchiveAgeUnit()));
                    if (copies[i].getUnarchiveAge() >= 0L) {
                        model.setValue("UnarchiveAgeText", (Object)Long.toString(copies[i].getUnarchiveAge()));
                    }
                    model.setValue("UnarchiveAgeUnits", (Object)Integer.toString(copies[i].getUnarchiveAgeUnit()));
                    String releaseOptions = SelectableGroupHelper.NOVAL;
                    if (!copies[i].isNoRelease()) {
                        releaseOptions = copies[i].isRelease() ? "true" : "false";
                    }
                    model.setValue("ReleaseOptionsText", (Object)releaseOptions);
                }
            }
            model = this.getTableModel(FS_TABLE);
            model.clear();
            FileSystem[] fs2 = null;
            String fsDeletable = "false";
            if (criteria.getArchivePolCriteriaProperties().isGlobal()) {
                fs2 = SamUtil.getModel(serverName).getSamQFSSystemFSManager().getAllFileSystems();
                CCStaticTextField field = (CCStaticTextField)parent.getChild("globalCriteriaText");
                field.setValue((Object)"archiving.criteria.globalcriteria.text");
                CCButton addButton = (CCButton)this.getChild("AddFS");
                addButton.setDisabled(true);
                fsDeletable = "false";
            } else {
                fs2 = criteria.getFileSystemsForCriteria();
                String string = fsDeletable = fs2.length > 1 ? "true" : "false";
            }
            if (fs2 == null) {
                fs2 = new FileSystem[]{};
            }
            for (int i = 0; i < fs2.length; ++i) {
                if (i > 0) {
                    model.appendRow();
                }
                model.setValue("FSNameHref", (Object)fs2[i].getName());
                model.setValue("FSNameText", (Object)fs2[i].getName());
                model.setValue("FSNameHidden", (Object)fs2[i].getName());
                model.setValue("MountPointText", (Object)fs2[i].getMountPoint());
                buffer.append(fs2[i].getName()).append(",");
                model.setRowSelected(false);
            }
            CCHiddenField hf = (CCHiddenField)parent.getChild("fsDeletable");
            hf.setValue((Object)fsDeletable);
            hf = (CCHiddenField)parent.getChild("fsList");
            hf.setValue((Object)buffer.toString());
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "populateTableModels", "Unable to populate tables", serverName);
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModels", "Unable to populate tables", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", SamUtil.getResourceString("-2020"), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        this.initializeTableHeaders();
        CCButton button = (CCButton)this.getChild("RemoveFS");
        button.setDisabled(true);
        button = (CCButton)this.getChild("ViewPolicies");
        button.setDisabled(true);
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.FILESYSTEM_OPERATOR)) {
            button = (CCButton)this.getChild("AddFS");
            button.setDisabled(true);
            CCActionTableModel model = this.getTableModel(FS_TABLE);
            model.setSelectionType("none");
        }
    }

    public List saveCopySettings(ArchivePolCriteria criteria) {
        ArrayList<String> errors = new ArrayList<String>();
        String serverName = ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
        CCActionTable table = (CCActionTable)this.getChild(COPY_TABLE);
        try {
            table.restoreStateData();
        }
        catch (ModelControlException mce) {
            SamUtil.processException((Exception)((Object)mce), ((Object)((Object)this)).getClass(), "saveCopySettings", "unable to restore model state data", serverName);
        }
        CCActionTableModel model = (CCActionTableModel)table.getModel();
        int rowCount = model.getNumRows();
        ArchivePolCriteriaCopy criteriaCopy = null;
        for (int i = 0; i < rowCount; ++i) {
            model.setRowIndex(i);
            String s = (String)model.getValue("CopyNumberHidden");
            long archiveAge = -1L;
            int archiveAgeUnit = -1;
            long unarchiveAge = -1L;
            int unarchiveAgeUnit = -1;
            boolean copyValid = true;
            String archiveAgeStr = (String)model.getValue("ArchiveAgeText");
            String string = archiveAgeStr = archiveAgeStr != null ? archiveAgeStr.trim() : "";
            if (!archiveAgeStr.equals("")) {
                try {
                    archiveAge = Long.parseLong(archiveAgeStr);
                    if (archiveAge < 0L) {
                        copyValid = false;
                        errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                    }
                }
                catch (NumberFormatException nfe) {
                    copyValid = false;
                    errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                }
            } else {
                copyValid = false;
                errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.missing", SamUtil.getResourceString("archiving.copynumber", s)));
            }
            String archiveAgeUnitStr = (String)model.getValue("ArchiveAgeUnits");
            if (SelectableGroupHelper.NOVAL.equals(archiveAgeUnitStr)) {
                copyValid = false;
                errors.add(SamUtil.getResourceString("archiving.criteriacopy.archiveage.unit", SamUtil.getResourceString("archiving.copynumber", s)));
            } else {
                archiveAgeUnit = Integer.parseInt(archiveAgeUnitStr);
            }
            String unarchiveAgeStr = (String)model.getValue("UnarchiveAgeText");
            String unarchiveAgeUnitStr = (String)model.getValue("UnarchiveAgeUnits");
            String string2 = unarchiveAgeStr = unarchiveAgeStr != null ? unarchiveAgeStr.trim() : "";
            if (!unarchiveAgeStr.equals("")) {
                try {
                    unarchiveAge = Long.parseLong(unarchiveAgeStr);
                    if (unarchiveAge < 0L) {
                        copyValid = false;
                        errors.add(SamUtil.getResourceString("archiving.criteriacopy.unarchiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                    }
                }
                catch (NumberFormatException nfe) {
                    copyValid = false;
                    errors.add(SamUtil.getResourceString("archiving.criteriacopy.unarchiveage.negative", SamUtil.getResourceString("archiving.copynumber", s)));
                }
                if (SelectableGroupHelper.NOVAL.equals(unarchiveAgeUnitStr)) {
                    copyValid = false;
                    errors.add(SamUtil.getResourceString("archiving.criteriacopy.unarchiveage.unit", SamUtil.getResourceString("archiving.copynumber", s)));
                } else {
                    unarchiveAgeUnit = Integer.parseInt(unarchiveAgeUnitStr);
                }
            } else if (!SelectableGroupHelper.NOVAL.equals(unarchiveAgeUnitStr)) {
                copyValid = false;
                errors.add(SamUtil.getResourceString("archiving.criteriacopy.unarchiveagevalue.missing", SamUtil.getResourceString("archiving.copynumber", s)));
            }
            String releaseOptionsStr = (String)model.getValue("ReleaseOptionsText");
            if (!copyValid) continue;
            int copyNumber2 = Integer.parseInt(s);
            criteriaCopy = PolicyUtil.getArchivePolCriteriaCopy(criteria, copyNumber2);
            criteriaCopy.setArchiveAge(archiveAge);
            criteriaCopy.setArchiveAgeUnit(archiveAgeUnit);
            criteriaCopy.setUnarchiveAge(unarchiveAge);
            criteriaCopy.setUnarchiveAgeUnit(unarchiveAgeUnit);
            if (SelectableGroupHelper.NOVAL.equals(releaseOptionsStr)) {
                criteriaCopy.setRelease(false);
                continue;
            }
            if (releaseOptionsStr.equals("true")) {
                criteriaCopy.setRelease(true);
                criteriaCopy.setNoRelease(false);
                continue;
            }
            if (!releaseOptionsStr.equals("false")) continue;
            criteriaCopy.setRelease(false);
            criteriaCopy.setNoRelease(true);
        }
        return errors;
    }

    public void handleAddFSRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleRemoveFSRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        Integer criteriaNumber = (Integer)parent.getPageSessionAttribute("SAMQFS_criteria_number");
        String fsName = parent.getDisplayFieldStringValue("fsname");
        try {
            ArchivePolicy thePolicy = SamUtil.getModel(serverName).getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            if (thePolicy == null) {
                throw new SamFSException(null, -2000);
            }
            ArchivePolCriteria criteria = thePolicy.getArchivePolCriteria(criteriaNumber);
            criteria.deleteFileSystemForCriteria(fsName);
            criteria.getArchivePolicy().updatePolicy();
            SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString("archiving.criteria.fsdelete.success", new String[]{fsName}), serverName);
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "handleRemoveFSRequest", "Unable to remove fs from criteria", serverName);
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException sme) {
            SamUtil.processException((Exception)((Object)sme), ((Object)((Object)this)).getClass(), "handleRemoveFSRequest", "Unable to remove fs from criteria", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error", sme.getSAMerrno(), "ArchiveConfig.error.detail", serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleRemoveFSRequest", "Unable to remove fs from criteria", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", SamUtil.getResourceString("archiving.criteria.fsdelete.failure", new String[]{fsName}), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleViewPoliciesRequest(RequestInvocationEvent evt) throws ServletException, IOException {
        CommonViewBeanBase source = (CommonViewBeanBase)this.getParentViewBean();
        String fsName = source.getDisplayFieldStringValue("fsname");
        source.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)fsName));
        ViewBean target = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean = CriteriaDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean);
        BreadCrumbUtil.breadCrumbPathForward((ViewBean)source, PageInfo.getPageInfo().getPageNumber(source.getName()));
        source.forwardTo(target);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

