/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.DriveLimitsTiledView;
import com.sun.netstorage.samqfs.web.archive.MediaParametersTiledView;
import com.sun.netstorage.samqfs.web.archive.MultiTableViewBase;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCHiddenField;
import java.util.Map;

public class ArchiveSetUpView
extends MultiTableViewBase {
    public static String MEDIA_PARAMETERS_TABLE = "MediaParametersTable";
    public static String DRIVE_LIMITS_TABLE = "DriveLimitsTable";
    public static String MEDIA_PARAMETERS_TILED_VIEW = "MediaParametersTiledView";
    public static String DRIVE_LIMITS_TILED_VIEW = "DriveLimitsTiledView";
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$MediaParametersTiledView;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$DriveLimitsTiledView;

    public ArchiveSetUpView(View parent, Map models, String name) {
        super(parent, models, name);
        TraceUtil.trace3("Entering");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(MEDIA_PARAMETERS_TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$MediaParametersTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$MediaParametersTiledView = ArchiveSetUpView.class$("com.sun.netstorage.samqfs.web.archive.MediaParametersTiledView")) : class$com$sun$netstorage$samqfs$web$archive$MediaParametersTiledView);
        this.registerChild(DRIVE_LIMITS_TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$DriveLimitsTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$DriveLimitsTiledView = ArchiveSetUpView.class$("com.sun.netstorage.samqfs.web.archive.DriveLimitsTiledView")) : class$com$sun$netstorage$samqfs$web$archive$DriveLimitsTiledView);
        super.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Creating child " + name);
        if (name.equals(MEDIA_PARAMETERS_TILED_VIEW)) {
            return new MediaParametersTiledView((View)this, this.getTableModel(MEDIA_PARAMETERS_TABLE), name);
        }
        if (name.equals(DRIVE_LIMITS_TILED_VIEW)) {
            return new DriveLimitsTiledView((View)this, this.getTableModel(DRIVE_LIMITS_TABLE), name);
        }
        if (name.equals(MEDIA_PARAMETERS_TABLE)) {
            return this.createTable(name, MEDIA_PARAMETERS_TILED_VIEW);
        }
        if (name.equals(DRIVE_LIMITS_TABLE)) {
            return this.createTable(name, DRIVE_LIMITS_TILED_VIEW);
        }
        CCActionTableModel m = super.isChildSupported(name);
        if (m != null) {
            return super.isChildSupported(name).createChild((View)this, name);
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    private void initializeTableHeaders() {
        TraceUtil.trace3("Entering");
        CCActionTableModel model = this.getTableModel(MEDIA_PARAMETERS_TABLE);
        model.setActionValue("MediaTypeCol", (Object)"ArchiveSetup.mediaParameters.mediaType");
        model.setActionValue("MaxArchiveFileSizeCol", (Object)"ArchiveSetup.mediaParameters.maxArchiveFileSize");
        model.setActionValue("MinSizeForOverflowCol", (Object)"ArchiveSetup.mediaParameters.minSizeForOverflow");
        model.setActionValue("ArchiveBufferSizeCol", (Object)"ArchiveSetup.mediaParameters.archiveBufferSize");
        model.setActionValue("ArchiveBufferLockCol", (Object)"ArchiveSetup.mediaParameters.archiveBufferLock");
        model.setActionValue("StageBufferSizeCol", (Object)"ArchiveSetup.mediaParameters.stageBufferSize");
        model.setActionValue("StageBufferLockCol", (Object)"ArchiveSetup.mediaParameters.stageBufferLock");
        model.setTitle("ArchiveSetup.mediaParameters.tabletitle");
        model = this.getTableModel(DRIVE_LIMITS_TABLE);
        model.setActionValue("LibraryNameCol", (Object)"ArchiveSetup.driveLimits.libraryName");
        model.setActionValue("MaxDrivesForArchiveCol", (Object)"ArchiveSetup.driveLimits.maxDrivesForArchive");
        model.setActionValue("MaxDrivesForStageCol", (Object)"ArchiveSetup.driveLimits.maxDrivesForStage");
        model.setTitle("ArchiveSetup.driveLimits.tabletitle");
        TraceUtil.trace3("Exiting");
    }

    public void populateTableModels(GlobalArchiveDirective globalDir) {
        TraceUtil.trace3("Entering");
        String serverName = ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
        SamFSException exception = null;
        boolean hasException = false;
        try {
            if (globalDir != null) {
                BufferDirective[] bufferDirectives = globalDir.getBufferSize();
                BufferDirective[] archMax = globalDir.getMaxFileSize();
                BufferDirective[] ovflmin = globalDir.getMinFileSizeForOverflow();
                SamUtil.doPrint(new NonSyncStringBuffer().append("archive buffer directives length = ").append(bufferDirectives.length).append("arch max directive length = ").append(archMax.length).append("overflow length = ").append(ovflmin.length).toString());
                SamUtil.doPrint(new NonSyncStringBuffer().append("media parameters table length is ").append(bufferDirectives.length).toString());
                CCActionTableModel model = this.getTableModel(MEDIA_PARAMETERS_TABLE);
                model.clear();
                for (int i = 0; i < bufferDirectives.length; ++i) {
                    int type;
                    String media;
                    if (i > 0) {
                        model.appendRow();
                    }
                    media = (media = SamUtil.getMediaTypeString(type = bufferDirectives[i].getMediaType())) != null ? media.trim() : "";
                    SamUtil.doPrint(new NonSyncStringBuffer().append("initModelRows(): media is ").append(media).toString());
                    model.setValue("MediaType", (Object)media);
                    model.setValue("MediaTypeHiddenField", (Object)media);
                    CCHiddenField hiddenMediaType = (CCHiddenField)this.getParentViewBean().getChild("mediaTypes");
                    StringBuffer buf = new StringBuffer();
                    String exist = (String)hiddenMediaType.getValue();
                    if (exist != null && !exist.trim().equals("")) {
                        buf.append(exist).append("###").append(media);
                    } else {
                        buf.append(media);
                    }
                    hiddenMediaType.setValue((Object)buf.toString());
                }
                CCHiddenField hiddenMediaLen = (CCHiddenField)this.getParentViewBean().getChild("mediaNumber");
                hiddenMediaLen.setValue((Object)String.valueOf(model.getNumRows()));
                DriveDirective[] driveDirectives = globalDir.getDriveDirectives();
                model = this.getTableModel(DRIVE_LIMITS_TABLE);
                model.clear();
                for (int i = 0; i < driveDirectives.length; ++i) {
                    if (i > 0) {
                        model.appendRow();
                    }
                    String name = driveDirectives[i].getLibraryName();
                    Library lib = SamUtil.getModel(serverName).getSamQFSSystemMediaManager().getLibraryByName(name);
                    Drive[] drives = lib.getDrives();
                    model.setValue("LibraryName", (Object)name);
                    String driveCount = Integer.toString(drives.length);
                    model.setValue("LibraryHiddenField", (Object)name);
                    model.setValue("MaxDrives", (Object)driveCount);
                    model.setValue("MaxDrivesErrMsg", (Object)SamUtil.getResourceString("ArchiveSetup.error.driverange", new String[]{driveCount}));
                }
                CCHiddenField field = (CCHiddenField)this.getParentViewBean().getChild("libNumber");
                field.setValue((Object)String.valueOf(model.getNumRows()));
            }
        }
        catch (SamFSException sfe) {
            exception = sfe;
            hasException = true;
            SamUtil.processException((Exception)((Object)exception), ((Object)((Object)this)).getClass(), "populateTableModels", "Unable to populate tables", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        TraceUtil.trace3("Exiting");
    }

    public boolean saveArchiveSizeMediaParameters(String type, BufferDirective[] buffers) throws SamFSException {
        boolean cfg_changed = false;
        TraceUtil.trace3("Entering");
        CCActionTableModel model = this.getTableModel(MEDIA_PARAMETERS_TABLE);
        int size = buffers.length;
        int tableSize = Integer.parseInt((String)((CCHiddenField)this.getParentViewBean().getChild("mediaNumber")).getValue());
        TraceUtil.trace3("tableSize = " + tableSize + "size = " + size);
        for (int i = 0; i < tableSize && size > 0; ++i) {
            model.setRowIndex(i);
            long fileSize = -1L;
            String mediaTypeHidden = (String)((CCHiddenField)this.getParentViewBean().getChild("mediaTypes")).getValue();
            String[] typeArray = mediaTypeHidden.split("###");
            String mediaType = i < typeArray.length ? typeArray[i] : "";
            mediaType = mediaType != null ? mediaType.trim() : "";
            TraceUtil.trace3(new NonSyncStringBuffer().append("Media Type (from hidden field) is ").append(mediaType).toString());
            String sizeStr = null;
            String sizeUnitStr = null;
            int sizeUnit = -1;
            if (type.equals("MaxArchiveFileSize")) {
                sizeStr = (String)model.getValue("MaxArchiveFileSize");
                sizeUnitStr = (String)model.getValue("MaxArchiveFileSizeUnit");
            } else if (type.equals("MinSizeForOverflow")) {
                sizeStr = (String)model.getValue("MinSizeForOverflow");
                sizeUnitStr = (String)model.getValue("MinSizeForOverflowUnit");
            }
            sizeStr = sizeStr != null ? sizeStr.trim() : "";
            sizeUnitStr = sizeUnitStr != null ? sizeUnitStr.trim() : "";
            TraceUtil.trace3("sizeStr = " + sizeStr);
            TraceUtil.trace3("sizeUnitStr = " + sizeUnitStr);
            sizeUnit = sizeUnitStr != "" && !sizeUnitStr.equals(SelectableGroupHelper.NOVAL) ? Integer.parseInt(sizeUnitStr) : 0;
            try {
                fileSize = sizeStr.equals("") ? -1L : Long.parseLong(sizeStr);
            }
            catch (NumberFormatException nfex) {
                fileSize = -1L;
            }
            TraceUtil.trace3("file size = " + fileSize + " unit = " + sizeUnit);
            BufferDirective buffer = null;
            for (int j = 0; j < size; ++j) {
                int mtype = buffers[j].getMediaType();
                String mString = SamUtil.getMediaTypeString(mtype);
                TraceUtil.trace3("mString = " + mString);
                if (!mString.equals(mediaType)) continue;
                buffer = buffers[j];
                TraceUtil.trace3("Found a match");
            }
            if (buffer == null || fileSize == buffer.getSize()) continue;
            TraceUtil.trace3("Setting file size in bytes");
            long sizeBytes = -1L;
            if (fileSize != -1L) {
                sizeBytes = SamQFSUtil.getSizeInBytes(fileSize, sizeUnit);
            }
            TraceUtil.trace3("File size in bytes = " + sizeBytes);
            buffer.setSize(sizeBytes);
            cfg_changed = true;
        }
        TraceUtil.trace3("Exiting");
        return cfg_changed;
    }

    public boolean saveBufferMediaParameters(String type, BufferDirective[] buffers) throws SamFSException {
        boolean cfg_changed = false;
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Type = " + type);
        CCActionTableModel model = this.getTableModel(MEDIA_PARAMETERS_TABLE);
        int size = buffers.length;
        int tableSize = Integer.parseInt((String)((CCHiddenField)this.getParentViewBean().getChild("mediaNumber")).getValue());
        TraceUtil.trace3("tableSize = " + tableSize + "size = " + size);
        for (int i = 0; i < tableSize && size > 0; ++i) {
            model.setRowIndex(i);
            int bufferSize = -1;
            String bufferSizeStr = null;
            String lock = null;
            String mediaTypeHidden = (String)((CCHiddenField)this.getParentViewBean().getChild("mediaTypes")).getValue();
            String[] typeArray = mediaTypeHidden.split("###");
            String mediaType = i < typeArray.length ? typeArray[i] : "";
            mediaType = mediaType != null ? mediaType.trim() : "";
            TraceUtil.trace3(new NonSyncStringBuffer().append("Media Type (from hidden field) is ").append(mediaType).toString());
            if (type.equals("archive")) {
                bufferSizeStr = (String)model.getValue("ArchiveBufferSize");
                lock = (String)model.getValue("ArchiveBufferLock");
            } else if (type.equals("stage")) {
                bufferSizeStr = (String)model.getValue("StageBufferSize");
                lock = (String)model.getValue("StageBufferLock");
            }
            bufferSizeStr = bufferSizeStr != null ? bufferSizeStr.trim() : "";
            lock = lock != null ? lock.trim() : "";
            try {
                bufferSize = bufferSizeStr.equals("") ? -1 : Integer.parseInt(bufferSizeStr);
            }
            catch (NumberFormatException nfex) {
                bufferSize = -1;
            }
            TraceUtil.trace3("Buffer size = " + bufferSize);
            BufferDirective buffer = null;
            for (int j = 0; j < size; ++j) {
                int mtype = buffers[j].getMediaType();
                String mString = SamUtil.getMediaTypeString(mtype);
                if (!mString.equals(mediaType)) continue;
                buffer = buffers[j];
            }
            if (buffer == null) continue;
            if ((long)bufferSize != buffer.getSize()) {
                buffer.setSize(bufferSize);
                cfg_changed = true;
            }
            if (lock != null && lock.equals("true")) {
                if (buffer.isLocked()) continue;
                buffer.setLocked(true);
                cfg_changed = true;
                continue;
            }
            if (lock == null || !lock.equals("false") || !buffer.isLocked()) continue;
            buffer.setLocked(false);
            cfg_changed = true;
        }
        TraceUtil.trace3("Exiting");
        return cfg_changed;
    }

    public boolean saveDriveLimits(String type, DriveDirective[] drives) throws SamFSException {
        boolean cfg_changed = false;
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Type = " + type);
        int size = drives.length;
        CCActionTableModel model = this.getTableModel(DRIVE_LIMITS_TABLE);
        int tableSize = Integer.parseInt((String)((CCHiddenField)this.getParentViewBean().getChild("libNumber")).getValue());
        for (int i = 0; i < tableSize && size > 0; ++i) {
            model.setRowIndex(i);
            int maxDrives = -1;
            String maxDrivesStr = null;
            if (type.equals("archive")) {
                maxDrivesStr = (String)model.getValue("MaxDrivesForArchive");
            } else if (type.equals("stage")) {
                maxDrivesStr = (String)model.getValue("MaxDrivesForStage");
            }
            String string = maxDrivesStr = maxDrivesStr != null ? maxDrivesStr.trim() : "";
            if (!maxDrivesStr.equals("")) {
                try {
                    maxDrives = Integer.parseInt(maxDrivesStr.trim());
                }
                catch (NumberFormatException nfex) {
                    maxDrives = -1;
                }
            }
            TraceUtil.trace3("Max drives for " + type + " : " + maxDrives);
            String library = (String)model.getValue("LibraryHiddenField");
            library = library != null ? library.trim() : "";
            TraceUtil.trace3("Library = " + library);
            DriveDirective drive = null;
            for (int j = 0; j < size; ++j) {
                if (library == "" || !library.equals(drives[j].getLibraryName())) continue;
                drive = drives[j];
            }
            if (drive == null || maxDrives == drive.getCount()) continue;
            TraceUtil.trace3("Setting drive count to " + maxDrives);
            drive.setCount(maxDrives);
            cfg_changed = true;
        }
        TraceUtil.trace3("Exiting");
        return cfg_changed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

