/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.job.ArCopyJob;
import com.sun.netstorage.samqfs.mgmt.arc.job.ArFindJob;
import com.sun.netstorage.samqfs.mgmt.fs.SamfsckJob;
import com.sun.netstorage.samqfs.mgmt.media.LabelJob;
import com.sun.netstorage.samqfs.mgmt.media.MountJob;
import com.sun.netstorage.samqfs.mgmt.rel.ReleaserJob;
import com.sun.netstorage.samqfs.mgmt.stg.job.StagerJob;

public abstract class Job {
    public static final short STATE_CURRENT = 0;
    public static final short STATE_PENDING = 1;
    public static final short STATE_HISTORY = 2;
    public static final short TYPE_ARCOPY = 0;
    public static final short TYPE_ARFIND = 1;
    public static final short TYPE_STAGE = 2;
    public static final short TYPE_RELEASE = 3;
    public static final short TYPE_MOUNT = 5;
    public static final short TYPE_SAMFSCK = 8;
    public static final short TYPE_LABEL = 9;
    public static final short TYPE_DUMPFS = 10;
    public static final short TYPE_ENABLEDUMP = 11;
    public static final short TYPE_RESTORE = 12;
    public static final short TYPE_SEARCHDUMP = 13;
    protected short type;
    protected short state;
    protected long id;
    protected long pid = -1L;

    protected Job(short s, short s2, long l, long l2) {
        this.type = s;
        this.state = s2;
        this.id = l;
        this.pid = l2;
    }

    protected Job(short s, short s2, long l) {
        this(s, s2, l, -1L);
    }

    public short getType() {
        return this.type;
    }

    public short getState() {
        return this.state;
    }

    public long getID() {
        return this.id;
    }

    protected void setID(long l) {
        this.id = l;
    }

    protected void setPID(int n) {
        this.pid = n;
    }

    public int terminate(Ctx ctx) throws SamFSException {
        System.out.println("terminate() type:" + this.type + ",state:" + this.state + ",pid:" + this.pid);
        if (this.state == 2) {
            throw new SamFSException("Cannot terminate jobs in this state");
        }
        switch (this.type) {
            case 2: 
            case 5: {
                this.cancel(ctx);
                break;
            }
            default: {
                if (this.state == 1 || this.pid < 0L) {
                    return -1;
                }
                Job.terminateProcess(ctx, this.pid, this.type);
            }
        }
        return 0;
    }

    protected void cancel(Ctx ctx) throws SamFSException {
        throw new SamFSException("Don't know how to cancel this type of job");
    }

    protected static native void terminateProcess(Ctx var0, long var1, short var3) throws SamFSException;

    public static Job[] getJobs(Ctx ctx, short s) throws SamFSException {
        switch (s) {
            case 1: {
                return ArFindJob.getAll(ctx);
            }
            case 0: {
                return ArCopyJob.getAll(ctx);
            }
            case 2: {
                return StagerJob.getAll(ctx);
            }
            case 3: {
                return ReleaserJob.getAll(ctx);
            }
            case 5: {
                return MountJob.getAll(ctx);
            }
            case 8: {
                return SamfsckJob.getAll(ctx);
            }
            case 9: {
                return LabelJob.getAll(ctx);
            }
        }
        return null;
    }

    public static native String[] getAllActivities(Ctx var0, int var1, String var2) throws SamFSException;

    public static native void cancelActivity(Ctx var0, String var1, String var2) throws SamFSException;

    public String toString() {
        String string = "[" + this.type + "," + this.state + "," + this.id + "]";
        return string;
    }
}

