/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.remotefilechooser;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.RemoteFile;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCFileChooserModel;
import java.io.File;
import java.io.FileFilter;
import java.util.Properties;

public class RemoteFileChooserModel
extends CCFileChooserModel {
    protected int pageSize = 50;
    protected int maxPageSize = 100;
    protected int max_entries = 1000;
    protected int currentPage = 0;
    protected int totalPages = 0;
    protected int totalItems = 0;
    protected String filterString = null;
    protected String fieldName = null;
    protected String parentRefreshCmd = null;
    protected String onCloseScript = null;
    protected String cachedDir = null;
    protected String cachedFilterString = "*";
    protected String cachedSortField = null;
    protected File[] cachedFiles = null;
    public static String FILE_AND_FOLDER_CHOOSER = "both";
    protected String chooserType = null;
    protected SamQFSSystemFSManager fsManager;

    public RemoteFileChooserModel(String serverName) {
        this(serverName, 0);
    }

    public RemoteFileChooserModel(String serverName, int pageSize) {
        this.setServerName(serverName);
        if (pageSize > 0 && pageSize < this.maxPageSize) {
            this.pageSize = pageSize;
        }
        TraceUtil.initTrace();
    }

    public SamQFSSystemFSManager getFSManager() throws SamFSException {
        if (this.fsManager == null) {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            this.fsManager = sysModel.getSamQFSSystemFSManager();
            TraceUtil.trace3("Got handle to fsManager for " + this.getServerName());
        }
        return this.fsManager;
    }

    public void clearCachedDir() {
        this.cachedDir = null;
    }

    public int getMaxEntries() {
        return this.max_entries;
    }

    public boolean canRead(String directory) {
        TraceUtil.trace3("checking if we can read file/dir: " + directory);
        return directory.startsWith(this.getHomeDirectory());
    }

    public void setFilterString(String filterString) {
        TraceUtil.trace3("setting filter string to " + filterString);
        this.filterString = filterString;
    }

    public String getFilterString() {
        TraceUtil.trace3("returning filter string " + this.filterString);
        return this.filterString;
    }

    public FileFilter instantiateFilter(String filterString) {
        TraceUtil.trace3("returning filter with filter string " + filterString);
        this.filterString = filterString;
        return super.instantiateFilter(filterString);
    }

    public FileFilter getFileFilter() {
        TraceUtil.trace3("getFileFilter() being called ");
        return super.getFileFilter();
    }

    public File[] getFiles(String directory) {
        String filterStr;
        TraceUtil.trace3("getting files from dir " + directory);
        if (directory == null) {
            directory = this.getHomeDirectory();
        }
        if ((filterStr = this.getFilterString()) == null) {
            filterStr = "*";
        }
        if (this.cachedDir == null || !this.cachedDir.equals(directory) || !this.cachedFilterString.equals(filterStr)) {
            Properties props = new Properties();
            props.setProperty("filename", filterStr);
            try {
                Filter filter = new Filter(2, props);
                this.cachedFiles = this.getDirEntries(this.max_entries, directory, filter);
                this.totalItems = this.cachedFiles.length;
                this.totalPages = (this.totalItems + this.pageSize - 1) / this.pageSize;
                this.currentPage = 0;
                this.cachedDir = directory;
                this.cachedFilterString = filterStr;
                this.cachedSortField = null;
                TraceUtil.trace3("Got " + this.totalItems + " files!");
            }
            catch (Exception ex) {
                this.cachedDir = null;
                TraceUtil.trace1("Couldnot get remote files in getFiles()\n" + ex);
                return null;
            }
        }
        File[] files = this.getFiles(this.currentPage * this.pageSize, this.pageSize, this.getSortField());
        return files;
    }

    public File[] getFiles(int start, int size, String sortField) {
        TraceUtil.trace3("getting files start = " + start + ", size = " + size + ", sortField = " + sortField);
        int total = this.cachedFiles.length;
        int num = size;
        if (this.cachedSortField == null || !this.cachedSortField.equals(sortField)) {
            this.sort(this.cachedFiles);
            this.cachedSortField = sortField;
        }
        if (total < start + size) {
            num = total - start;
        }
        File[] tmpFiles = new File[num];
        for (int i = 0; i < num; ++i) {
            tmpFiles[i] = this.cachedFiles[start + i];
        }
        return tmpFiles;
    }

    public RemoteFile[] getDirEntries(int maxEntries, String dirPath, Filter filter) throws SamFSException {
        String mountPoint;
        if (SamQFSFactory.isSimulatorMode() && (mountPoint = this.checkForSimulatedMountPoint(dirPath)) != null) {
            dirPath = this.stripSimulatedMountPoint(dirPath, mountPoint);
        }
        return this.getFSManager().getDirEntries(maxEntries, dirPath, filter);
    }

    public boolean isFile(String absolutePath) throws SamFSException {
        return this.isFileDirectory(true, absolutePath);
    }

    public boolean isDirectory(String absolutePath) throws SamFSException {
        return this.isFileDirectory(false, absolutePath);
    }

    private boolean isFileDirectory(boolean checkFile, String absolutePath) throws SamFSException {
        String mountPoint;
        if (SamQFSFactory.isSimulatorMode() && (mountPoint = this.checkForSimulatedMountPoint(absolutePath)) != null) {
            absolutePath = this.stripSimulatedMountPoint(absolutePath, mountPoint);
        }
        String savedFilter = this.getFilterString();
        File f = new File(absolutePath);
        this.setFilterString(f.getName());
        File[] files = this.getFiles(f.getParent());
        this.setFilterString(savedFilter);
        if (files == null || files.length == 0) {
            TraceUtil.trace1("Could not get info about remote directory/file " + absolutePath);
            throw new SamFSException(SamUtil.getResourceString("filechooser.error.badPath"));
        }
        if (checkFile) {
            return files[0].isFile();
        }
        return files[0].isDirectory();
    }

    private String checkForSimulatedMountPoint(String dirPath) throws SamFSException {
        boolean bFound = false;
        FileSystem[] fileSystems = this.getFSManager().getAllFileSystems();
        String mountPoint = null;
        if (fileSystems != null) {
            for (int i = 0; i < fileSystems.length; ++i) {
                mountPoint = fileSystems[i].getMountPoint();
                if (!dirPath.startsWith(mountPoint)) continue;
                bFound = true;
                break;
            }
        }
        return bFound ? mountPoint : null;
    }

    private String stripSimulatedMountPoint(String path, String mountPoint) {
        path = path.length() > mountPoint.length() ? path.substring(mountPoint.length()) : "/";
        return path;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        if (page >= 0 && page <= this.totalPages) {
            this.currentPage = page;
        }
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int num) {
        this.totalItems = num;
    }

    public int getFirstRow() {
        return this.currentPage * this.pageSize + 1;
    }

    public int getLastRow() {
        return (this.currentPage + 1) * this.pageSize;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getParentRefreshCmd() {
        return this.parentRefreshCmd;
    }

    public void setParentRefreshCmd(String cmd) {
        this.parentRefreshCmd = cmd;
    }

    public String getOnClose() {
        return this.onCloseScript;
    }

    public void setOnClose(String script) {
        this.onCloseScript = script;
    }

    public void addSelectedFile(String file) {
        TraceUtil.trace3("adding file: " + file);
        super.addSelectedFile(file);
    }

    public String getType() {
        return this.chooserType;
    }

    public void setType(String type) {
        TraceUtil.trace3("Setting type to " + type);
        this.chooserType = !type.equals("file") && !type.equals("folder") && !type.equals(FILE_AND_FOLDER_CHOOSER) ? "file" : type;
        TraceUtil.trace3("Set type to " + this.chooserType);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.chooserType == "file") {
            buffer.append("Selected File(s): \n");
        } else if (this.chooserType == FILE_AND_FOLDER_CHOOSER) {
            buffer.append("Selected File/Folder(s): \n");
        } else {
            buffer.append("Selected Folder(s): \n");
        }
        String dir = this.getCurrentDirectory();
        String[] fileList = this.getSelectedFiles();
        for (int i = 0; i < fileList.length; ++i) {
            buffer.append(dir).append(File.separator).append(fileList[i]).append("\n");
        }
        return buffer.toString();
    }
}

