/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.media;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;

public class StripedGroupImpl
extends BaseDeviceImpl
implements StripedGroup {
    private String name = null;
    private DiskCache[] members = null;
    private long capacity = -1L;
    private long availableSpace = -1L;
    private int consumedSpace = -1;

    public StripedGroupImpl() {
    }

    public StripedGroupImpl(String name, DiskCache[] members) throws SamFSException {
        if (name == null || name == new String() || members == null) {
            throw new SamFSException("INVALID_STRIPED_GROUP_NAME_OR_MEMBER");
        }
        this.name = name;
        this.members = members;
        this.capacity = 0L;
        this.availableSpace = 0L;
        for (int i = 0; i < members.length; ++i) {
            this.capacity += members[i].getCapacity();
            this.availableSpace += members[i].getAvailableSpace();
        }
        this.consumedSpace = (int)((this.capacity - this.availableSpace) * 100L / this.capacity);
    }

    public String getName() {
        return this.name;
    }

    public int getDiskCacheType() {
        int type = -1;
        if (this.members != null) {
            type = this.members[0].getDiskCacheType();
        }
        return type;
    }

    public DiskCache[] getMembers() {
        return this.members;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public int getConsumedSpacePercentage() {
        return this.consumedSpace;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name: " + this.name + "\n");
        buf.append("Disk Cache Information: " + this.name + "\n");
        if (this.members != null) {
            try {
                for (int i = 0; i < this.members.length; ++i) {
                    buf.append(this.members[i].toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("---- \n");
        buf.append("Capacity: " + this.capacity + "\n");
        buf.append("Available Space: " + this.availableSpace + "\n");
        buf.append("Consumed Space: " + this.consumedSpace + "% \n");
        return buf.toString();
    }
}

