/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.mt;

import com.sun.netstorage.samqfs.web.model.impl.mt.MethodInfo;
import com.sun.netstorage.samqfs.web.model.impl.mt.ThreadListener;
import java.lang.reflect.InvocationTargetException;

public class ThreadPoolMember
extends Thread {
    protected ThreadListener listener;
    protected boolean stop;
    protected boolean started = false;
    protected boolean skipwait = false;
    protected int id;
    protected MethodInfo method;
    protected Object metResult;
    protected Throwable metException;

    ThreadPoolMember(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public Object getResult() {
        return this.metResult;
    }

    public Throwable getThrowable() {
        return this.metException;
    }

    public void setThrowable(Throwable t) {
        this.metException = t;
    }

    void resetException() {
        this.metException = null;
    }

    void resetResult() {
        this.metResult = null;
    }

    void setListener(ThreadListener tListener) {
        this.listener = tListener;
    }

    public synchronized void startMethod(MethodInfo meth) {
        this.method = meth;
        this.notify();
        if (!this.started) {
            this.skipwait = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.stop = false;
        ThreadPoolMember threadPoolMember = this;
        synchronized (threadPoolMember) {
            this.started = true;
            while (!this.stop) {
                try {
                    if (!this.skipwait) {
                        this.wait();
                    } else {
                        this.skipwait = false;
                    }
                }
                catch (InterruptedException ie) {
                    this.stop = true;
                    System.out.println(this.getName() + " interrupted.");
                }
                if (!this.stop) {
                    try {
                        this.metResult = this.method.execute();
                    }
                    catch (InvocationTargetException te) {
                        this.setThrowable(te.getCause());
                        System.out.println(this.getName() + " target exception: " + te.getCause());
                    }
                    catch (Exception e) {
                        this.setThrowable(e);
                        System.out.println(this.getName() + " error: " + e);
                    }
                    this.listener.done(this);
                }
                if (!this.isInterrupted()) continue;
                this.stop = true;
            }
        }
    }
}

