/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.mt;

import com.sun.netstorage.samqfs.web.model.impl.mt.Barrier;
import com.sun.netstorage.samqfs.web.model.impl.mt.MethodDB;
import com.sun.netstorage.samqfs.web.model.impl.mt.MethodInfo;
import com.sun.netstorage.samqfs.web.model.impl.mt.ThreadListener;
import com.sun.netstorage.samqfs.web.model.impl.mt.ThreadPoolMember;
import java.util.Vector;

public class ThreadPool {
    protected final int size;
    protected ThreadPoolMember[] allThreads;
    protected Vector activeThreads;
    protected Vector availThreads;

    public ThreadPool(int initialSize) {
        this.size = initialSize;
        this.allThreads = new ThreadPoolMember[this.size];
        this.activeThreads = new Vector(this.size);
        this.availThreads = new Vector(this.size);
        for (int id = 0; id < this.size; ++id) {
            ThreadPoolMember t;
            this.allThreads[id] = t = new ThreadPoolMember(id);
            this.availThreads.add(t);
        }
    }

    public void init() {
        System.out.println("initializing thread pool");
        for (int i = 0; i < this.allThreads.length; ++i) {
            this.allThreads[i].start();
        }
        try {
            MethodDB.init(new String[]{"com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemFSManagerImpl"});
        }
        catch (Exception e) {
            System.out.println("cannot initialize MethodDB: " + e);
        }
    }

    public int getSize() {
        return this.size;
    }

    public ThreadPoolMember getNewThread(ThreadListener tListener) {
        return this.getNewThread(tListener, null);
    }

    public ThreadPoolMember getNewThread(ThreadListener tListener, String newName) {
        if (this.availThreads.size() == 0) {
            return null;
        }
        ThreadPoolMember t = (ThreadPoolMember)this.availThreads.remove(0);
        this.activeThreads.add(t);
        t.setListener(tListener);
        if (newName != null) {
            t.setName(newName);
        }
        return t;
    }

    public void releaseThreadToPool(ThreadPoolMember t) {
        t.resetException();
        t.resetResult();
        this.activeThreads.remove(t);
        this.availThreads.add(t);
    }

    public void releaseAllToPool() {
        for (int i = this.activeThreads.size() - 1; i >= 0; --i) {
            ThreadPoolMember t = (ThreadPoolMember)this.activeThreads.elementAt(i);
            this.releaseThreadToPool(t);
        }
    }

    public void destroy() {
        for (int i = 0; i < this.allThreads.length; ++i) {
            this.allThreads[i].interrupt();
        }
    }

    public static void main(String[] args) {
        ThreadPool tp = new ThreadPool(3);
        tp.init();
        try {
            MethodDB.init(new String[]{"java.io.PrintStream"});
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe);
            System.exit(-1);
        }
        Barrier bar = new Barrier();
        ThreadPoolMember tpmA = tp.getNewThread(bar);
        ThreadPoolMember tpmB = tp.getNewThread(bar, "mythread");
        ThreadPoolMember tpmC = tp.getNewThread(bar);
        bar.addThread(tpmA);
        bar.addThread(tpmB);
        bar.addThread(tpmC);
        try {
            tpmA.startMethod(new MethodInfo("println", System.out, new Object[]{"hi.tmpA"}));
            tpmB.startMethod(new MethodInfo("println", System.out, new Object[]{"hi.tmpB"}));
            tpmC.startMethod(new MethodInfo("println", System.out, new Object[]{"hi.tmpC"}));
        }
        catch (NoSuchMethodException nsme) {
            System.out.println(nsme);
            System.exit(-1);
        }
        System.out.println("Waiting for all to finish Step1...");
        bar.waitForAll();
        System.out.println("step1 done.");
        bar.reset();
        try {
            tpmA.startMethod(new MethodInfo("println", System.out, new Object[]{"hi again.tmpA"}));
            tpmB.startMethod(new MethodInfo("println", System.out, new Object[]{"hi again.tmpB"}));
            tpmC.startMethod(new MethodInfo("println", System.out, new Object[]{"hi again.tmpC"}));
        }
        catch (NoSuchMethodException nsme) {
            System.out.println(nsme);
            System.exit(-1);
        }
        System.out.println("Waiting for all to finish Step2...");
        bar.waitForAll();
        System.out.println("step2 done.");
        tp.releaseAllToPool();
        System.out.println("All threads released to pool.");
        tp.destroy();
        System.out.println("Pool destroyed.");
    }
}

