/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.fs;

import com.sun.netstorage.samqfs.mgmt.fs.MountOptions;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountPropsBase;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class FileSystemMountPropertiesImpl
extends FileSystemMountPropsBase
implements FileSystemMountProperties {
    protected MountOptions opt = null;
    private static final int UNIT_DEF_PAR_REL = 1;
    private static final int UNIT_DEF_MAX_PAR_REL = 2;
    private static final int UNIT_PAR_STG = 3;
    private static final int UNIT_STG_WIN = 4;
    private static final int UNIT_RD_AHD = 5;
    private static final int UNIT_WR_BHD = 6;
    private static final int UNIT_WR_THR = 7;
    private static final int UNIT_FL_BHD = 8;
    private static final int UNIT_STG_FL_BHD = 9;
    private static final int UNIT_WALGN_RD_MIN = 10;
    private static final int UNIT_MALGN_RD_MIN = 11;
    private static final int UNIT_WALGN_WR_MIN = 12;
    private static final int UNIT_MALGN_WR_MIN = 13;
    private static final int UNIT_MIN_BLK_ALLOC = 14;
    private static final int UNIT_MAX_BLK_ALLOC = 15;

    public FileSystemMountPropertiesImpl() {
        this.opt = new MountOptions(80, 60, 1, false);
        this.setup();
    }

    public FileSystemMountPropertiesImpl(MountOptions opt) {
        if (opt != null) {
            this.opt = opt;
            this.setup();
        }
    }

    public MountOptions getJniMountOptions() {
        return this.opt;
    }

    public void setJniMountOptions(MountOptions opt) {
        if (opt != null) {
            this.opt = opt;
            this.setup();
        }
    }

    public void setHWM(int hwm) {
        this.hwm = hwm;
        if (this.opt != null) {
            if (hwm == -1) {
                this.opt.resetHWM();
            } else {
                this.opt.setHWM((short)hwm);
            }
        }
    }

    public void setLWM(int lwm) {
        this.lwm = lwm;
        if (this.opt != null) {
            if (lwm == -1) {
                this.opt.resetLWM();
            } else {
                this.opt.setLWM((short)lwm);
            }
        }
    }

    public void setStripeWidth(int width) {
        this.stripeWidth = width;
        if (this.opt != null) {
            if (width == -1) {
                this.opt.resetStripeWidth();
            } else {
                this.opt.setStripeWidth((short)width);
            }
        }
    }

    public void setTrace(boolean traceOn) {
        this.traceOn = traceOn;
        if (this.opt != null) {
            this.opt.setTrace(traceOn);
        }
    }

    public void setMountInBackground(boolean mountInBackground) {
        this.mountInBackground = mountInBackground;
        if (this.opt != null) {
            this.opt.setMountInBackground(mountInBackground);
        }
    }

    public void setNoOfMountRetries(int noOfRetries) {
        this.noOfMountRetries = noOfRetries;
        if (this.opt != null) {
            if (noOfRetries == -1) {
                this.opt.resetNoOfMountRetries();
            } else {
                this.opt.setNoOfMountRetries((short)noOfRetries);
            }
        }
    }

    public void setMetadataRefreshRate(int rate) {
        this.metadataRefreshRate = rate;
        if (this.opt != null) {
            if (rate == -1) {
                this.opt.resetMedataRefreshRate();
            } else {
                this.opt.setMetadataRefreshRate(rate);
            }
        }
    }

    public void setMinBlockAllocation(long noOfBlocks) {
        this.minBlockAllocation = noOfBlocks;
        if (this.opt != null) {
            if (noOfBlocks != -1L) {
                long tmpSize;
                if (this.minBlockAllocationUnit != -1 && (tmpSize = SamQFSUtil.convertSize(noOfBlocks, this.minBlockAllocationUnit, 1)) != -1L) {
                    this.opt.setMinBlockAllocation(tmpSize);
                }
            } else {
                this.opt.resetMinBlockAllocation();
            }
        }
    }

    public void setMinBlockAllocationUnit(int unit) {
        this.minBlockAllocationUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.minBlockAllocation != -1L && (tmpSize = SamQFSUtil.convertSize(this.minBlockAllocation, unit, 1)) != -1L) {
                    this.opt.setMinBlockAllocation(tmpSize);
                }
            } else {
                this.opt.resetMinBlockAllocation();
            }
        }
    }

    public void setMaxBlockAllocation(long noOfBlocks) {
        this.maxBlockAllocation = noOfBlocks;
        if (this.opt != null) {
            if (noOfBlocks != -1L) {
                long tmpSize;
                if (this.maxBlockAllocationUnit != -1 && (tmpSize = SamQFSUtil.convertSize(noOfBlocks, this.maxBlockAllocationUnit, 1)) != -1L) {
                    this.opt.setMaxBlockAllocation(tmpSize);
                }
            } else {
                this.opt.resetMaxBlockAllocation();
            }
        }
    }

    public void setMaxBlockAllocationUnit(int unit) {
        this.maxBlockAllocationUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.maxBlockAllocation != -1L && (tmpSize = SamQFSUtil.convertSize(this.maxBlockAllocation, unit, 1)) != -1L) {
                    this.opt.setMaxBlockAllocation(tmpSize);
                }
            } else {
                this.opt.resetMaxBlockAllocation();
            }
        }
    }

    public void setReadLeaseDuration(int duration) {
        this.readLeaseDuration = duration;
        if (this.opt != null) {
            if (duration == -1) {
                this.opt.resetReadLeaseDuration();
            } else {
                this.opt.setReadLeaseDuration(duration);
            }
        }
    }

    public void setWriteLeaseDuration(int duration) {
        this.writeLeaseDuration = duration;
        if (this.opt != null) {
            if (duration == -1) {
                this.opt.resetWriteLeaseDuration();
            } else {
                this.opt.setWriteLeaseDuration(duration);
            }
        }
    }

    public void setAppendLeaseDuration(int duration) {
        this.appendLeaseDuration = duration;
        if (this.opt != null) {
            if (duration == -1) {
                this.opt.resetAppendLeaseDuration();
            } else {
                this.opt.setAppendLeaseDuration(duration);
            }
        }
    }

    public void setMaxConcurrentStreams(int noOfStreams) {
        this.maxConcurrentStreams = noOfStreams;
        if (this.opt != null) {
            if (noOfStreams == -1) {
                this.opt.resetMaxConcurrentStreams();
            } else {
                this.opt.setMaxConcurrentStreams(noOfStreams);
            }
        }
    }

    public void setLeaseTimeout(int leaseTimeout) {
        this.leaseTimeout = leaseTimeout;
        if (this.opt != null) {
            if (leaseTimeout == -1) {
                this.opt.resetLeaseTimeout();
            } else {
                this.opt.setLeaseTimeout(leaseTimeout);
            }
        }
    }

    public void setMultiHostWrite(boolean write) {
        this.multiHostWrite = write;
        if (this.opt != null) {
            this.opt.setMultiHostWrite(write);
        }
    }

    public void setConsistencyChecking(boolean consistencyChecking) {
        this.consistencyChecking = consistencyChecking;
        if (this.opt != null) {
            this.opt.setConsistencyChecking(consistencyChecking);
        }
    }

    public void setDefaultPartialReleaseSize(int size) {
        this.defaultPartialReleaseSize = size;
        if (this.opt != null) {
            if (size != -1) {
                long tmpSize;
                if (this.defaultPartialReleaseSizeUnit != -1 && (tmpSize = SamQFSUtil.convertSize(size, this.defaultPartialReleaseSizeUnit, 1)) != -1L) {
                    this.opt.setDefaultPartialReleaseSize((int)tmpSize);
                }
            } else {
                this.opt.resetDefaultPartialReleaseSize();
            }
        }
    }

    public void setDefaultPartialReleaseSizeUnit(int unit) {
        this.defaultPartialReleaseSizeUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.defaultPartialReleaseSize != -1 && (tmpSize = SamQFSUtil.convertSize(this.defaultPartialReleaseSize, unit, 1)) != -1L) {
                    this.opt.setDefaultPartialReleaseSize((int)tmpSize);
                }
            } else {
                this.opt.resetDefaultPartialReleaseSize();
            }
        }
    }

    public void setDefaultMaxPartialReleaseSize(int size) {
        this.defaultMaxPartialReleaseSize = size;
        if (this.opt != null) {
            if (size != -1) {
                long tmpSize;
                if (this.defaultMaxPartialReleaseSizeUnit != -1 && (tmpSize = SamQFSUtil.convertSize(size, this.defaultMaxPartialReleaseSizeUnit, 1)) != -1L) {
                    this.opt.setDefaultMaxPartialReleaseSize((int)tmpSize);
                }
            } else {
                this.opt.resetDefaultMaxPartialReleaseSize();
            }
        }
    }

    public void setDefaultMaxPartialReleaseSizeUnit(int unit) {
        this.defaultMaxPartialReleaseSizeUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.defaultMaxPartialReleaseSize != -1 && (tmpSize = SamQFSUtil.convertSize(this.defaultMaxPartialReleaseSize, unit, 1)) != -1L) {
                    this.opt.setDefaultMaxPartialReleaseSize((int)tmpSize);
                }
            } else {
                this.opt.resetDefaultMaxPartialReleaseSize();
            }
        }
    }

    public void setPartialStageSize(long size) {
        this.partialStageSize = size;
        if (this.opt != null) {
            if (size != -1L) {
                long tmpSize;
                if (this.partialStageSizeUnit != -1 && (tmpSize = SamQFSUtil.convertSize(size, this.partialStageSizeUnit, 1)) != -1L) {
                    this.opt.setPartialStageSize(tmpSize);
                }
            } else {
                this.opt.resetPartialStageSize();
            }
        }
    }

    public void setPartialStageSizeUnit(int unit) {
        this.partialStageSizeUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.partialStageSize != -1L && (tmpSize = SamQFSUtil.convertSize(this.partialStageSize, unit, 1)) != -1L) {
                    this.opt.setPartialStageSize(tmpSize);
                }
            } else {
                this.opt.resetPartialStageSize();
            }
        }
    }

    public void setNoOfStageRetries(int number) {
        this.noOfStageRetries = number;
        if (this.opt != null) {
            if (number == -1) {
                this.opt.resetNoOfStageRetries();
            } else {
                this.opt.setNoOfStageRetries(number);
            }
        }
    }

    public void setStageWindowSize(long size) {
        this.stageWindowSize = size;
        if (this.opt != null) {
            if (size != -1L) {
                long tmpSize;
                if (this.stageWindowSizeUnit != -1 && (tmpSize = SamQFSUtil.convertSize(size, this.stageWindowSizeUnit, 1)) != -1L) {
                    this.opt.setStageWindowSize(tmpSize);
                }
            } else {
                this.opt.resetStageWindowSize();
            }
        }
    }

    public void setStageWindowSizeUnit(int unit) {
        this.stageWindowSizeUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.stageWindowSize != -1L && (tmpSize = SamQFSUtil.convertSize(this.stageWindowSize, unit, 1)) != -1L) {
                    this.opt.setStageWindowSize(tmpSize);
                }
            } else {
                this.opt.resetStageWindowSize();
            }
        }
    }

    public void setArchiverAutoRun(boolean auto) {
        this.archiverAutoRun = auto;
        if (this.opt != null) {
            this.opt.setArchiverAutoRun(auto);
        }
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
        if (this.opt != null) {
            this.opt.setArchive(archive);
        }
    }

    public void setReadOnlyMount(boolean readOnly) {
        this.readOnlyMount = readOnly;
        if (this.opt != null) {
            this.opt.setReadOnlyMount(readOnly);
        }
    }

    public void setNoSetUID(boolean noSetUID) {
        this.noSetUID = noSetUID;
        if (this.opt != null) {
            this.opt.setNoSetUID(noSetUID);
        }
    }

    public void setQuickWrite(boolean quickWrite) {
        this.quickWrite = quickWrite;
        if (this.opt != null) {
            this.opt.setQuickWrite(quickWrite);
        }
    }

    public void setReadAhead(long readAhead) {
        this.readAhead = readAhead;
        if (this.opt != null) {
            if (readAhead != -1L) {
                long tmpSize;
                if (this.readAheadUnit != -1 && (tmpSize = SamQFSUtil.convertSize(readAhead, this.readAheadUnit, 1)) != -1L) {
                    this.opt.setReadAhead(tmpSize);
                }
            } else {
                this.opt.resetReadAhead();
            }
        }
    }

    public void setReadAheadUnit(int unit) {
        this.readAheadUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.readAhead != -1L && (tmpSize = SamQFSUtil.convertSize(this.readAhead, unit, 1)) != -1L) {
                    this.opt.setReadAhead(tmpSize);
                }
            } else {
                this.opt.resetReadAhead();
            }
        }
    }

    public void setWriteBehind(long writeBehind) {
        this.writeBehind = writeBehind;
        if (this.opt != null) {
            if (writeBehind != -1L) {
                long tmpSize;
                if (this.writeBehindUnit != -1 && (tmpSize = SamQFSUtil.convertSize(writeBehind, this.writeBehindUnit, 1)) != -1L) {
                    this.opt.setWriteBehind(tmpSize);
                }
            } else {
                this.opt.resetWriteBehind();
            }
        }
    }

    public void setWriteBehindUnit(int unit) {
        this.writeBehindUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.writeBehind != -1L && (tmpSize = SamQFSUtil.convertSize(this.writeBehind, unit, 1)) != -1L) {
                    this.opt.setWriteBehind(tmpSize);
                }
            } else {
                this.opt.resetWriteBehind();
            }
        }
    }

    public void setWriteThrottle(long writeThrottle) {
        this.writeThrottle = writeThrottle;
        if (this.opt != null) {
            if (writeThrottle != -1L) {
                long tmpSize;
                if (this.writeThrottleUnit != -1 && (tmpSize = SamQFSUtil.convertSize(writeThrottle, this.writeThrottleUnit, 1)) != -1L) {
                    this.opt.setWriteThrottle(tmpSize);
                }
            } else {
                this.opt.resetWriteThrottle();
            }
        }
    }

    public void setWriteThrottleUnit(int unit) {
        this.writeThrottleUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.writeThrottle != -1L && (tmpSize = SamQFSUtil.convertSize(this.writeThrottle, unit, 1)) != -1L) {
                    this.opt.setWriteThrottle(tmpSize);
                }
            } else {
                this.opt.resetWriteThrottle();
            }
        }
    }

    public void setFlushBehind(int flushBehind) {
        this.flushBehind = flushBehind;
        if (this.opt != null) {
            if (flushBehind != -1) {
                long tmpSize;
                if (this.flushBehindUnit != -1 && (tmpSize = SamQFSUtil.convertSize(flushBehind, this.flushBehindUnit, 1)) != -1L) {
                    this.opt.setFlushBehind((int)tmpSize);
                }
            } else {
                this.opt.resetFlushBehind();
            }
        }
    }

    public void setFlushBehindUnit(int unit) {
        this.flushBehindUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.flushBehind != -1 && (tmpSize = SamQFSUtil.convertSize(this.flushBehind, unit, 1)) != -1L) {
                    this.opt.setFlushBehind((int)tmpSize);
                }
            } else {
                this.opt.resetFlushBehind();
            }
        }
    }

    public void setStageFlushBehind(int flushBehind) {
        this.stageFlushBehind = flushBehind;
        if (this.opt != null) {
            if (this.stageFlushBehind != -1) {
                long tmpSize;
                if (this.stageFlushBehindUnit != -1 && (tmpSize = SamQFSUtil.convertSize(this.stageFlushBehind, this.stageFlushBehindUnit, 1)) != -1L) {
                    this.opt.setStageFlushBehind((int)tmpSize);
                }
            } else {
                this.opt.resetStageFlushBehind();
            }
        }
    }

    public void setStageFlushBehindUnit(int unit) {
        this.stageFlushBehindUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.stageFlushBehind != -1 && (tmpSize = SamQFSUtil.convertSize(this.stageFlushBehind, unit, 1)) != -1L) {
                    this.opt.setStageFlushBehind((int)tmpSize);
                }
            } else {
                this.opt.resetStageFlushBehind();
            }
        }
    }

    public void setSynchronizedMetadata(boolean sync) {
        this.synchronizedMetadata = sync;
        short val = 0;
        if (sync) {
            val = 1;
        }
        if (this.opt != null) {
            this.opt.setSynchronizedMetadata(val);
        }
    }

    public void setMetadataStripeWidth(int width) {
        this.metadataStripeWidth = width;
        if (this.opt != null) {
            if (width == -1) {
                this.opt.resetMetadataStripeWidth();
            } else {
                this.opt.setMetadataStripeWidth(width);
            }
        }
    }

    public void setSoftRAID(boolean softRAID) {
        this.softRAID = softRAID;
        if (this.opt != null) {
            this.opt.setSoftRAID(softRAID);
        }
    }

    public void setForceDirectIO(boolean forceDirectIO) {
        this.forceDirectIO = forceDirectIO;
        if (this.opt != null) {
            this.opt.setForceDirectIO(forceDirectIO);
        }
    }

    public void setForceNFSAsync(boolean forceNFSAsync) {
        this.forceNFSAsync = forceNFSAsync;
        if (this.opt != null) {
            this.opt.setForceNFSAsync(forceNFSAsync);
        }
    }

    public void setConsecutiveReads(int number) {
        this.consecutiveReads = number;
        if (this.opt != null) {
            if (number == -1) {
                this.opt.resetConsecutiveReads();
            } else {
                this.opt.setConsecutiveReads(number);
            }
        }
    }

    public void setWellAlignedReadMin(int readMin) {
        this.wellAlignedReadMin = readMin;
        if (this.opt != null) {
            if (readMin != -1) {
                long tmpSize;
                if (this.wellAlignedReadMinUnit != -1 && (tmpSize = SamQFSUtil.convertSize(readMin, this.wellAlignedReadMinUnit, 1)) != -1L) {
                    this.opt.setWellAlignedReadMin((int)tmpSize);
                }
            } else {
                this.opt.resetWellAlignedReadMin();
            }
        }
    }

    public void setWellAlignedReadMinUnit(int unit) {
        this.wellAlignedReadMinUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.wellAlignedReadMin != -1 && (tmpSize = SamQFSUtil.convertSize(this.wellAlignedReadMin, unit, 1)) != -1L) {
                    this.opt.setWellAlignedReadMin((int)tmpSize);
                }
            } else {
                this.opt.resetWellAlignedReadMin();
            }
        }
    }

    public void setMisAlignedReadMin(int readMin) {
        this.misAlignedReadMin = readMin;
        if (this.opt != null) {
            if (readMin != -1) {
                long tmpSize;
                if (this.misAlignedReadMinUnit != -1 && (tmpSize = SamQFSUtil.convertSize(readMin, this.misAlignedReadMinUnit, 1)) != -1L) {
                    this.opt.setMisAlignedReadMin((int)tmpSize);
                }
            } else {
                this.opt.resetMisAlignedReadMin();
            }
        }
    }

    public void setMisAlignedReadMinUnit(int unit) {
        this.misAlignedReadMinUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.misAlignedReadMin != -1 && (tmpSize = SamQFSUtil.convertSize(this.misAlignedReadMin, unit, 1)) != -1L) {
                    this.opt.setMisAlignedReadMin((int)tmpSize);
                }
            } else {
                this.opt.resetMisAlignedReadMin();
            }
        }
    }

    public void setConsecutiveWrites(int number) {
        this.consecutiveWrites = number;
        if (this.opt != null) {
            if (number == -1) {
                this.opt.resetConsecutiveWrites();
            } else {
                this.opt.setConsecutiveWrites(number);
            }
        }
    }

    public void setWellAlignedWriteMin(int writeMin) {
        this.wellAlignedWriteMin = writeMin;
        if (this.opt != null) {
            if (writeMin != -1) {
                long tmpSize;
                if (this.wellAlignedWriteMinUnit != -1 && (tmpSize = SamQFSUtil.convertSize(writeMin, this.wellAlignedWriteMinUnit, 1)) != -1L) {
                    this.opt.setWellAlignedWriteMin((int)tmpSize);
                }
            } else {
                this.opt.resetWellAlignedWriteMin();
            }
        }
    }

    public void setWellAlignedWriteMinUnit(int unit) {
        this.wellAlignedWriteMinUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.wellAlignedWriteMin != -1 && (tmpSize = SamQFSUtil.convertSize(this.wellAlignedWriteMin, unit, 1)) != -1L) {
                    this.opt.setWellAlignedWriteMin((int)tmpSize);
                }
            } else {
                this.opt.resetWellAlignedWriteMin();
            }
        }
    }

    public void setMisAlignedWriteMin(int writeMin) {
        this.misAlignedWriteMin = writeMin;
        if (this.opt != null) {
            if (writeMin != -1) {
                long tmpSize;
                if (this.misAlignedWriteMinUnit != -1 && (tmpSize = SamQFSUtil.convertSize(writeMin, this.misAlignedWriteMinUnit, 1)) != -1L) {
                    this.opt.setMisAlignedWriteMin((int)tmpSize);
                }
            } else {
                this.opt.resetMisAlignedWriteMin();
            }
        }
    }

    public void setMisAlignedWriteMinUnit(int unit) {
        this.misAlignedWriteMinUnit = unit;
        if (this.opt != null) {
            if (unit != -1) {
                long tmpSize;
                if (this.misAlignedWriteMin != -1 && (tmpSize = SamQFSUtil.convertSize(this.misAlignedWriteMin, unit, 1)) != -1L) {
                    this.opt.setMisAlignedWriteMin((int)tmpSize);
                }
            } else {
                this.opt.resetMisAlignedWriteMin();
            }
        }
    }

    public void setDirectIOZeroing(boolean directIOZeroing) {
        this.directIOZeroing = directIOZeroing;
        if (this.opt != null) {
            this.opt.setDirectIOZeroing(directIOZeroing);
        }
    }

    private void setup() {
        Object byteVal = null;
        this.hwm = this.opt.getHWM();
        this.lwm = this.opt.getLWM();
        this.stripeWidth = this.opt.getStripeWidth();
        this.traceOn = this.opt.isTrace();
        this.mountInBackground = this.opt.isMountInBackground();
        this.noOfMountRetries = this.opt.getNoOfMountRetries();
        this.metadataRefreshRate = this.opt.getMetadataRefreshRate();
        this.minBlockAllocation = this.opt.getMinBlockAllocation();
        this.minBlockAllocationUnit = 1;
        this.setUpUnit(14, this.minBlockAllocation);
        this.maxBlockAllocation = this.opt.getMaxBlockAllocation();
        this.maxBlockAllocationUnit = 1;
        this.setUpUnit(15, this.maxBlockAllocation);
        this.readLeaseDuration = this.opt.getReadLeaseDuration();
        this.writeLeaseDuration = this.opt.getWriteLeaseDuration();
        this.appendLeaseDuration = this.opt.getAppendLeaseDuration();
        this.maxConcurrentStreams = this.opt.getMaxConcurrentStreams();
        this.leaseTimeout = this.opt.getLeaseTimeout();
        this.multiHostWrite = this.opt.isMultiHostWrite();
        this.consistencyChecking = this.opt.isConsistencyChecking();
        this.defaultPartialReleaseSize = this.opt.getDefaultPartialReleaseSize();
        this.defaultPartialReleaseSizeUnit = 1;
        this.setUpUnit(1, this.defaultPartialReleaseSize);
        this.defaultMaxPartialReleaseSize = this.opt.getDefaultMaxPartialReleaseSize();
        this.defaultMaxPartialReleaseSizeUnit = 1;
        this.setUpUnit(2, this.defaultMaxPartialReleaseSize);
        this.partialStageSize = this.opt.getPartialStageSize();
        this.partialStageSizeUnit = 1;
        this.setUpUnit(3, this.partialStageSize);
        this.noOfStageRetries = this.opt.getNoOfStageRetries();
        this.stageWindowSize = this.opt.getStageWindowSize();
        this.stageWindowSizeUnit = 1;
        this.setUpUnit(4, this.stageWindowSize);
        this.archiverAutoRun = this.opt.isArchiverAutoRun();
        this.readOnlyMount = this.opt.isReadOnlyMount();
        this.noSetUID = this.opt.isNoSetUID();
        this.quickWrite = this.opt.isQuickWrite();
        this.readAhead = this.opt.getReadAhead();
        this.readAheadUnit = 1;
        this.setUpUnitLong(5, this.readAhead);
        this.writeBehind = this.opt.getWriteBehind();
        this.writeBehindUnit = 1;
        this.setUpUnitLong(6, this.writeBehind);
        this.writeThrottle = this.opt.getWriteThrottle();
        this.writeThrottleUnit = 1;
        this.setUpUnitLong(7, this.writeThrottle);
        this.flushBehind = this.opt.getFlushBehind();
        this.flushBehindUnit = 1;
        this.setUpUnit(8, this.flushBehind);
        this.stageFlushBehind = this.opt.getStageFlushBehind();
        this.stageFlushBehindUnit = 1;
        this.setUpUnit(9, this.stageFlushBehind);
        short val = this.opt.isSynchronizedMetadata();
        if (val == 1) {
            this.synchronizedMetadata = true;
        }
        this.metadataStripeWidth = this.opt.getMetadataStripeWidth();
        this.softRAID = this.opt.isSoftRAID();
        this.forceDirectIO = this.opt.isForceDirectIO();
        this.forceNFSAsync = this.opt.isForceNFSAsync();
        this.directIOZeroing = this.opt.isDirectIOZeroing();
        this.consecutiveReads = this.opt.getConsecutiveReads();
        this.wellAlignedReadMin = this.opt.getWellAlignedReadMin();
        this.wellAlignedReadMinUnit = 1;
        this.setUpUnit(10, this.wellAlignedReadMin);
        this.misAlignedReadMin = this.opt.getMisAlignedReadMin();
        this.misAlignedReadMinUnit = 1;
        this.setUpUnit(11, this.misAlignedReadMin);
        this.consecutiveWrites = this.opt.getConsecutiveWrites();
        this.wellAlignedWriteMin = this.opt.getWellAlignedWriteMin();
        this.wellAlignedWriteMinUnit = 1;
        this.setUpUnit(12, this.wellAlignedWriteMin);
        this.misAlignedWriteMin = this.opt.getMisAlignedWriteMin();
        this.misAlignedWriteMinUnit = 1;
        this.setUpUnit(13, this.misAlignedWriteMin);
    }

    private String getBytesFromKB(long kb) {
        long val = kb * 1024L;
        String retVal = null;
        if (val >= 0L) {
            try {
                retVal = new Long(val).toString();
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return retVal;
    }

    private void setUpUnit(int field, long fieldVal) {
        String byteVal;
        if (fieldVal > 0L && SamQFSUtil.isValidString(byteVal = this.getBytesFromKB(fieldVal))) {
            String size = SamQFSUtil.stringToFsize(byteVal);
            switch (field) {
                case 14: {
                    this.minBlockAllocation = SamQFSUtil.getLongVal(size);
                    this.minBlockAllocationUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 15: {
                    this.maxBlockAllocation = SamQFSUtil.getLongVal(size);
                    this.maxBlockAllocationUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 1: {
                    this.defaultPartialReleaseSize = SamQFSUtil.getIntegerVal(size);
                    this.defaultPartialReleaseSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 2: {
                    this.defaultMaxPartialReleaseSize = SamQFSUtil.getIntegerVal(size);
                    this.defaultMaxPartialReleaseSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 3: {
                    this.partialStageSize = SamQFSUtil.getIntegerVal(size);
                    this.partialStageSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 4: {
                    this.stageWindowSize = SamQFSUtil.getIntegerVal(size);
                    this.stageWindowSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 8: {
                    this.flushBehind = SamQFSUtil.getIntegerVal(size);
                    this.flushBehindUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 9: {
                    this.stageFlushBehind = SamQFSUtil.getIntegerVal(size);
                    this.stageFlushBehindUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 10: {
                    this.wellAlignedReadMin = SamQFSUtil.getIntegerVal(size);
                    this.wellAlignedReadMinUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 11: {
                    this.misAlignedReadMin = SamQFSUtil.getIntegerVal(size);
                    this.misAlignedReadMinUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 12: {
                    this.wellAlignedWriteMin = SamQFSUtil.getIntegerVal(size);
                    this.wellAlignedWriteMinUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 13: {
                    this.misAlignedWriteMin = SamQFSUtil.getIntegerVal(size);
                    this.misAlignedWriteMinUnit = SamQFSUtil.getSizeUnitInteger(size);
                }
            }
        }
    }

    private void setUpUnitLong(int field, long fieldVal) {
        String byteVal;
        if (fieldVal > 0L && SamQFSUtil.isValidString(byteVal = this.getBytesFromKB(fieldVal))) {
            String size = SamQFSUtil.stringToFsize(byteVal);
            switch (field) {
                case 5: {
                    this.readAhead = SamQFSUtil.getLongVal(size);
                    this.readAheadUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 6: {
                    this.writeBehind = SamQFSUtil.getLongVal(size);
                    this.writeBehindUnit = SamQFSUtil.getSizeUnitInteger(size);
                    break;
                }
                case 7: {
                    this.writeThrottle = SamQFSUtil.getLongVal(size);
                    this.writeThrottleUnit = SamQFSUtil.getSizeUnitInteger(size);
                }
            }
        }
    }
}

