/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.ArFSDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.web.model.archive43.FSArchiveDirective;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class FSArchiveDirectiveImpl
implements FSArchiveDirective {
    private ArFSDirective jniArFSDirective = null;
    private SamQFSSystemModelImpl model = null;
    private String fsName = new String();
    private String archLogfile = new String();
    private long interval = -1L;
    private int unit = -1;
    private int archMethod = -1;
    private boolean intrvTouched = false;

    public FSArchiveDirectiveImpl(SamQFSSystemModelImpl model, ArFSDirective jniArFSDirective) {
        this.model = model;
        this.jniArFSDirective = jniArFSDirective;
        if (model == null || jniArFSDirective == null) {
            throw new IllegalArgumentException();
        }
        this.fsName = jniArFSDirective.getFSName();
        this.archLogfile = jniArFSDirective.getLogPath();
        long sec = jniArFSDirective.getInterval();
        if (sec >= 0L) {
            String tmp = SamQFSUtil.longToInterval(sec);
            this.interval = SamQFSUtil.getLongValSecond(tmp);
            this.unit = SamQFSUtil.getTimeUnitInteger(tmp);
        }
        this.archMethod = SamQFSUtil.getLogicScanType(jniArFSDirective.getExamineMethod());
    }

    public ArFSDirective getJniArFSDirective() {
        return this.jniArFSDirective;
    }

    public String getFileSystemName() {
        return this.fsName;
    }

    public String getFSArchiveLogfile() {
        return this.archLogfile;
    }

    public void setFSArchiveLogfile(String logfile) {
        this.archLogfile = logfile;
        if (SamQFSUtil.isValidString(logfile)) {
            this.jniArFSDirective.setLogPath(logfile);
        } else {
            this.jniArFSDirective.resetLogPath();
        }
    }

    public long getFSInterval() {
        return this.interval;
    }

    public void setFSInterval(long interval) {
        this.interval = interval;
        this.intrvTouched = true;
    }

    public int getFSIntervalUnit() {
        return this.unit;
    }

    public void setFSIntervalUnit(int unit) {
        this.unit = unit;
        this.intrvTouched = true;
    }

    public int getFSArchiveScanMethod() {
        return this.archMethod;
    }

    public void setFSArchiveScanMethod(int method) {
        this.archMethod = method;
        if (method != -1) {
            this.jniArFSDirective.setExamineMethod(SamQFSUtil.getJniScanType(method));
        } else {
            this.jniArFSDirective.resetExamineMethod();
        }
    }

    public void changeFSDirective() throws SamFSException {
        if (this.intrvTouched) {
            if (this.interval != -1L && this.unit != -1) {
                this.jniArFSDirective.setInterval(SamQFSUtil.convertToSecond(this.interval, this.unit));
            } else {
                this.jniArFSDirective.resetInterval();
            }
        }
        if (SamQFSUtil.isValidString(this.jniArFSDirective.getLogPath())) {
            FileUtil.createFile((Ctx)this.model.getJniContext(), (String)this.jniArFSDirective.getLogPath());
        }
        Archiver.setArFSDirective((Ctx)this.model.getJniContext(), (ArFSDirective)this.jniArFSDirective);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FS name: " + this.fsName + "\n");
        buf.append("Archive Logfile: " + this.archLogfile + "\n");
        buf.append("Interval: " + this.interval + "\n");
        buf.append("Interval Unit: " + this.unit + "\n");
        buf.append("Archive Scan Method: " + this.archMethod + "\n");
        return buf.toString();
    }
}

