/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class ArchivePolCriteriaPropImpl
implements ArchivePolCriteriaProp {
    private ArchivePolCriteria archPolCriteria = null;
    private Criteria criteria = null;
    private boolean global = false;
    private String startingDir = new String();
    private long minSize = -1L;
    private int minSizeUnit = -1;
    private long maxSize = -1L;
    private int maxSizeUnit = -1;
    private String namePattern = new String();
    private String owner = new String();
    private String group = new String();
    private int stageAttribs = -1;
    private int releaseAttribs = -1;
    private long accessAge = -1L;
    private int accessAgeUnit = -1;

    public ArchivePolCriteriaPropImpl(ArchivePolCriteria archPolCriteria, Criteria criteria) {
        this.archPolCriteria = archPolCriteria;
        this.criteria = criteria;
        if (criteria != null) {
            String size;
            if (criteria.getFilesysName().equals("global properties")) {
                this.global = true;
            }
            this.startingDir = criteria.getRootDir();
            String tmp = criteria.getMinSize();
            if (SamQFSUtil.isValidString(tmp) && !tmp.equals("0")) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.minSize = SamQFSUtil.getLongVal(size);
                this.minSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if (SamQFSUtil.isValidString(tmp = criteria.getMaxSize()) && !tmp.equals("0")) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.maxSize = SamQFSUtil.getLongVal(size);
                this.maxSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.namePattern = criteria.getRegExp();
            this.owner = criteria.getUser();
            this.group = criteria.getGroup();
            this.stageAttribs = SamQFSUtil.convertStageAttribFromJni(criteria.getStageAttr());
            this.releaseAttribs = SamQFSUtil.convertReleaseAttribFromJni(criteria.getReleaseAttr());
            this.accessAge = criteria.getAccessAge();
            long sec = criteria.getAccessAge();
            if (sec >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.accessAge = SamQFSUtil.getLongValSecond(tmp);
                this.accessAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
        } else {
            this.criteria = new Criteria("unknown", "unknown");
        }
    }

    public ArchivePolCriteria getArchivePolCriteria() {
        return this.archPolCriteria;
    }

    public void setArchivePolCriteria(ArchivePolCriteria archPolCriteria) {
        this.archPolCriteria = archPolCriteria;
    }

    public Criteria getJniCriteria() {
        return this.criteria;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getStartingDir() {
        return this.startingDir;
    }

    public void setStartingDir(String startingDir) {
        if (SamQFSUtil.isValidString(startingDir)) {
            this.startingDir = startingDir;
            this.criteria.setRootDir(startingDir);
        } else {
            this.startingDir = new String();
            this.criteria.resetRootDir();
        }
    }

    public long getMinSize() {
        return this.minSize;
    }

    public void setMinSize(long minSize) {
        this.minSize = minSize;
        if (minSize != -1L && this.minSizeUnit != -1) {
            String unit = SamQFSUtil.getUnitString(this.minSizeUnit);
            this.criteria.setMinSize(SamQFSUtil.fsizeToString(new Long(minSize).toString() + unit));
        } else {
            this.criteria.resetMinSize();
        }
    }

    public long getMinSizeInBytes() {
        long size = -1L;
        if (this.minSizeUnit != -1 && this.minSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.minSize, this.minSizeUnit);
        }
        return size;
    }

    public int getMinSizeUnit() {
        return this.minSizeUnit;
    }

    public void setMinSizeUnit(int sizeUnit) {
        this.minSizeUnit = sizeUnit;
        if (this.minSize != -1L && this.minSizeUnit != -1) {
            String unit = SamQFSUtil.getUnitString(this.minSizeUnit);
            this.criteria.setMinSize(SamQFSUtil.fsizeToString(new Long(this.minSize).toString() + unit));
        } else {
            this.criteria.resetMinSize();
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        if (maxSize != -1L && this.maxSizeUnit != -1) {
            String unit = SamQFSUtil.getUnitString(this.maxSizeUnit);
            this.criteria.setMaxSize(SamQFSUtil.fsizeToString(new Long(maxSize).toString() + unit));
        } else {
            this.criteria.resetMaxSize();
        }
    }

    public long getMaxSizeInBytes() {
        long size = -1L;
        if (this.maxSizeUnit != -1 && this.maxSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.maxSize, this.maxSizeUnit);
        }
        return size;
    }

    public int getMaxSizeUnit() {
        return this.maxSizeUnit;
    }

    public void setMaxSizeUnit(int maxSizeUnit) {
        this.maxSizeUnit = maxSizeUnit;
        if (this.maxSize != -1L && maxSizeUnit != -1) {
            String unit = SamQFSUtil.getUnitString(maxSizeUnit);
            this.criteria.setMaxSize(SamQFSUtil.fsizeToString(new Long(this.maxSize).toString() + unit));
        } else {
            this.criteria.resetMaxSize();
        }
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(String namePattern) {
        if (SamQFSUtil.isValidString(namePattern)) {
            this.namePattern = namePattern;
            this.criteria.setRegExp(namePattern);
        } else {
            this.namePattern = new String();
            this.criteria.resetRegExp();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        if (SamQFSUtil.isValidString(owner)) {
            this.owner = owner;
            this.criteria.setUser(owner);
        } else {
            this.owner = new String();
            this.criteria.resetUser();
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        if (SamQFSUtil.isValidString(group)) {
            this.group = group;
            this.criteria.setGroup(group);
        } else {
            this.group = new String();
            this.criteria.resetGroup();
        }
    }

    public int getStageAttributes() {
        return this.stageAttribs;
    }

    public void setStageAttributes(int attribs) {
        this.stageAttribs = attribs;
        if (attribs == -1 || attribs == 10004) {
            this.criteria.resetStageAttr();
        } else {
            this.criteria.setStageAttr(SamQFSUtil.convertStageAttribToJni(attribs));
        }
    }

    public int getReleaseAttributes() {
        return this.releaseAttribs;
    }

    public void setReleaseAttributes(int attribs) {
        this.releaseAttribs = attribs;
        if (attribs == -1 || attribs == 10009) {
            this.criteria.resetReleaseAttr();
        } else {
            this.criteria.setReleaseAttr(SamQFSUtil.convertReleaseAttribToJni(attribs));
        }
    }

    public long getAccessAge() {
        return this.accessAge;
    }

    public void setAccessAge(long accessAge) {
        this.accessAge = accessAge;
        if (accessAge != -1L && this.accessAgeUnit != -1) {
            this.criteria.setAccessAge((int)SamQFSUtil.convertToSecond(accessAge, this.accessAgeUnit));
        } else {
            this.criteria.resetAccessAge();
        }
    }

    public int getAccessAgeUnit() {
        return this.accessAgeUnit;
    }

    public void setAccessAgeUnit(int accessAgeUnit) {
        this.accessAgeUnit = accessAgeUnit;
        if (this.accessAge != -1L && accessAgeUnit != -1) {
            this.criteria.setAccessAge((int)SamQFSUtil.convertToSecond(this.accessAge, accessAgeUnit));
        } else {
            this.criteria.resetAccessAge();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolCriteria == null) {
            buf.append("Policy criteria is null for this property object.\n");
        }
        buf.append("Starting Dir: " + this.startingDir + "\n");
        buf.append("Min Size: " + this.minSize + "\n");
        buf.append("Min Size Unit: " + this.minSizeUnit + "\n");
        buf.append("Max Size: " + this.maxSize + "\n");
        buf.append("Max Size Unit: " + this.maxSizeUnit + "\n");
        buf.append("Name Pattern: " + this.namePattern + "\n");
        buf.append("Owner: " + this.owner + "\n");
        buf.append("Group: " + this.group + "\n");
        buf.append("Stage Attributes: " + this.stageAttribs + "\n");
        buf.append("Release Attributes: " + this.releaseAttribs + "\n");
        buf.append("Access Age: " + this.accessAge + "\n");
        buf.append("Access Age Unit: " + this.accessAgeUnit + "\n");
        return buf.toString();
    }
}

