/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.ArFSDirective;
import com.sun.netstorage.samqfs.mgmt.arc.ArGlobalDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVol;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.mgmt.arc.VSNOp;
import com.sun.netstorage.samqfs.mgmt.arc.VSNPool;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive.LegacySetInfo;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveFileParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.GlobalArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.LegacySetInfoImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.VSNPoolImpl;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSSystemArchiveManagerImpl
implements SamQFSSystemArchiveManager {
    private SamQFSSystemModelImpl theModel;
    private static String ARCHIVER_DUMP_FILE = "/archiver.cmd.dump";
    private boolean archiveSaveToFileOn = false;
    private HashMap vsnPoolMap = new HashMap();
    private HashMap policyMap = new HashMap();

    public SamQFSSystemArchiveManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public GlobalArchiveDirective getGlobalDirective() throws SamFSException {
        ArGlobalDirective dir = Archiver.getArGlobalDirective((Ctx)this.theModel.getJniContext());
        return new GlobalArchiveDirectiveImpl(this.theModel, dir);
    }

    public void setGlobalDirective(GlobalArchiveDirective global) throws SamFSException {
        global.changeGlobalDirective();
        if (!SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        }
    }

    public boolean isValidGroup(String groupName) throws SamFSException {
        boolean valid = Archiver.isValidGroup((Ctx)this.theModel.getJniContext(), (String)groupName);
        return valid;
    }

    public String[] getAllArchivePolicyNames() throws SamFSException {
        String[] names = Archiver.getCriteriaNames((Ctx)this.theModel.getJniContext());
        if (names == null) {
            names = new String[]{};
        }
        return names;
    }

    public ArchivePolicy[] getAllArchivePolicies() throws SamFSException {
        this.createPoliciesFromBackEnd();
        return this.policyMap.values().toArray(new ArchivePolicy[0]);
    }

    public ArchivePolicy getArchivePolicy(String policyName) throws SamFSException {
        return (ArchivePolicy)this.policyMap.get(policyName);
    }

    public ArchivePolicy getDefaultArchivePolicy() throws SamFSException {
        ArFSDirective fsDir = Archiver.getDefaultArFSDirective((Ctx)this.theModel.getJniContext());
        Criteria cr = null;
        Copy cp = null;
        if (fsDir != null && fsDir.getCriteria() != null && fsDir.getCriteria().length > 0) {
            cr = fsDir.getCriteria()[0];
        }
        if (cr != null) {
            cp = cr.getCopies()[0];
        }
        CopyParams cparam = Archiver.getDefaultCopyParams((Ctx)this.theModel.getJniContext());
        ArchivePolicyImpl policy = new ArchivePolicyImpl();
        ArchiveFileParamsImpl params = new ArchiveFileParamsImpl(policy, cr);
        ArchiveCopyImpl[] copies = new ArchiveCopyImpl[4];
        ArchiveVSNMapImpl[] maps = new ArchiveVSNMapImpl[4];
        policy.setFileCharacteristics(params);
        params.setArchivePolicy(policy);
        for (int i = 0; i < 4; ++i) {
            copies[i] = new ArchiveCopyImpl(policy, null, i + 1, cp, new CopyParams(null, cparam));
            maps[i] = new ArchiveVSNMapImpl();
            copies[i].setArchiveVSNMap(maps[i]);
            maps[i].setModel(this.theModel);
            maps[i].setArchiveCopy(copies[i]);
            copies[i].setArchivePolicy(policy);
            policy.addArchiveCopy(copies[i]);
        }
        return policy;
    }

    public ArchivePolicy createArchivePolicy(String policyName, String startingDir, ArchiveFileParams param, ArchiveCopy[] copies, FileSystem[] filesystems) throws SamFSException {
        String path;
        String host;
        String dvsn;
        ArchiveCopyImpl cp;
        int i;
        ArchivePolicy existingPol;
        if (!SamQFSUtil.isValidString(policyName)) {
            throw new SamFSException("logic.invalidPolName");
        }
        if (this.policyMap.size() == 0) {
            this.getAllArchivePolicies();
        }
        if ((existingPol = this.getArchivePolicy(policyName)) != null) {
            throw new SamFSException("logic.existingPol");
        }
        if (filesystems == null || filesystems.length == 0) {
            throw new SamFSException("logic.oneFSNeededForPol");
        }
        ArrayList<ArchiveCopy> copy = new ArrayList<ArchiveCopy>();
        if (copies != null && !policyName.equals("no_archive")) {
            for (int i2 = 0; i2 < copies.length; ++i2) {
                copy.add(copies[i2]);
            }
        }
        boolean incorrectDiskVol = false;
        for (i = 0; i < copy.size(); ++i) {
            cp = (ArchiveCopyImpl)copy.get(i);
            if (SamQFSUtil.isValidString(cp.getDiskArchiveVSN())) {
                dvsn = cp.getDiskArchiveVSN();
                host = cp.getDiskArchiveVSNHost();
                path = cp.getDiskArchiveVSNPath();
                incorrectDiskVol = SamQFSUtil.isDifferentDiskVolInfoPresent(dvsn, host, path, this.theModel.getJniContext());
            }
            if (!incorrectDiskVol) continue;
            throw new SamFSException("logic.differentDiskVolExists");
        }
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
        }
        if (!SamQFSUtil.isValidString(this.theModel.getDumpPath()) || !this.theModel.getServerAPIVersion().equals("1.0")) {
            for (i = 0; i < copy.size(); ++i) {
                cp = (ArchiveCopyImpl)copy.get(i);
                if (!SamQFSUtil.isValidString(cp.getDiskArchiveVSN())) continue;
                dvsn = cp.getDiskArchiveVSN();
                host = cp.getDiskArchiveVSNHost();
                path = cp.getDiskArchiveVSNPath();
                SamQFSUtil.createDiskVolInfo(dvsn, host, path, this.theModel.getJniContext());
            }
        }
        this.theModel.getJniContext().setDumpPath(null);
        this.theModel.getJniContext().setReadPath(null);
        ArchivePolicyImpl policy = new ArchivePolicyImpl();
        policy.setPolicyName(policyName);
        policy.setModel(this.theModel);
        ((ArchiveFileParamsImpl)param).setArchivePolicy(policy);
        policy.setFileCharacteristics(param);
        for (int i3 = 0; i3 < copy.size(); ++i3) {
            ArchiveCopyImpl cp2 = (ArchiveCopyImpl)copy.get(i3);
            cp2.setArchivePolicy(policy);
        }
        policy.setCopyArrayList(copy);
        boolean resetCtx = false;
        GlobalArchiveDirective gDir = this.getGlobalDirective();
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            long intervalGbl = gDir.getInterval();
            int intervalUnitGbl = gDir.getIntervalUnit();
            if (intervalGbl <= 0L) {
                intervalGbl = 60L;
            }
            if (intervalUnitGbl <= 0) {
                intervalUnitGbl = 5;
            }
            gDir.setInterval(intervalGbl);
            gDir.setIntervalUnit(intervalUnitGbl);
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            this.setGlobalDirective(gDir);
            String readPath = this.theModel.getDumpPath();
            if (this.theModel.getServerAPIVersion().equals("1.0")) {
                readPath = readPath + "/archiver.cmd.dump";
            }
            this.theModel.getJniContext().setReadPath(readPath);
            resetCtx = true;
            this.archiveSaveToFileOn = true;
        }
        if (filesystems != null) {
            for (int i4 = 0; i4 < filesystems.length; ++i4) {
                policy.addFileSystemForPolicy(filesystems[i4]);
            }
        }
        for (int i5 = 0; i5 < copy.size(); ++i5) {
            ArchiveCopyImpl cp3 = (ArchiveCopyImpl)copy.get(i5);
            ArchiveVSNMap map = cp3.getArchiveVSNMap();
            CopyParams cParam = cp3.getJniCopyParams();
            if (!SamQFSUtil.isValidString(cp3.getDiskArchiveVSN()) && map != null) {
                ((ArchiveVSNMapImpl)map).update();
            }
            Archiver.setCopyParams((Ctx)this.theModel.getJniContext(), (CopyParams)cParam);
        }
        if (!SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        }
        this.policyMap.put(policyName, policy);
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
            this.theModel.getJniContext().setReadPath(null);
        }
        this.archiveSaveToFileOn = false;
        this.theModel.getDataStore().clearSavedPolicy();
        return policy;
    }

    public boolean isArchiveSaveToFileOn() {
        return this.archiveSaveToFileOn;
    }

    public void deleteArchivePolicy(ArchivePolicy pol) throws SamFSException {
        String[] fsNames;
        if (pol == null) {
            throw new SamFSException("logic.invalidPol");
        }
        ArchivePolicyImpl policy = (ArchivePolicyImpl)pol;
        ArchiveCopy[] copies = policy.getArchiveCopies();
        if (copies != null) {
            for (int i = 0; i < copies.length; ++i) {
                CopyParams cParam = ((ArchiveCopyImpl)copies[i]).getJniCopyParams();
                Archiver.resetCopyParams((Ctx)this.theModel.getJniContext(), (String)cParam.getName());
                ArchiveVSNMapImpl map = (ArchiveVSNMapImpl)copies[i].getArchiveVSNMap();
                if (map == null) continue;
                map.removeJniMap();
            }
        }
        if ((fsNames = policy.getAllFileSystemNamesForPolicy()) != null && fsNames.length > 0) {
            for (int i = 0; i < fsNames.length; ++i) {
                policy.deleteFileSystemForPolicy(fsNames[i], true);
            }
        }
        this.policyMap.remove(policy.getPolicyName());
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
    }

    public void convertLegacyPolicy(ArchivePolicy pol) throws SamFSException {
        int j;
        int i;
        LegacySetInfo[] info = null;
        if (pol != null) {
            info = pol.getLegacySetInfo();
        }
        if (info == null || info.length <= 1) {
            throw new SamFSException("logic.notLegacyPol");
        }
        String curName = pol.getPolicyName();
        ArrayList<String> newPolNamesList = new ArrayList<String>();
        for (int i2 = 0; i2 < info.length; ++i2) {
            String name = info[i2].getCurrentlySuggestedName();
            if (name == null || name == new String()) {
                throw new SamFSException("logic.invalidPolNameInSet");
            }
            int index = newPolNamesList.indexOf(name);
            if (index != -1) {
                throw new SamFSException("logic.nonuniquePolNameInSet");
            }
            newPolNamesList.add(name);
        }
        LegacySetInfoImpl[] lcInfo = new LegacySetInfoImpl[info.length];
        for (int i3 = 0; i3 < info.length; ++i3) {
            lcInfo[i3] = (LegacySetInfoImpl)info[i3];
        }
        CopyParams[] cParams = Archiver.getCopyParamsForSet((Ctx)this.theModel.getJniContext(), (String)curName);
        VSNMap[] maps = VSNOp.getMaps((Ctx)this.theModel.getJniContext());
        ArrayList<VSNMap> mapsList = new ArrayList<VSNMap>();
        if (maps != null && maps.length > 0) {
            for (i = 0; i < maps.length; ++i) {
                if (!maps[i].getCopyName().startsWith(curName)) continue;
                mapsList.add(maps[i]);
            }
        }
        for (i = 0; i < lcInfo.length; ++i) {
            ArrayList list = lcInfo[i].getCriteriaList();
            for (j = 0; j < list.size(); ++j) {
                Criteria[] oldCr;
                String fsName = ((Criteria)list.get(j)).getFilesysName();
                ArFSDirective dir = Archiver.getArFSDirective((Ctx)this.theModel.getJniContext(), (String)fsName);
                if (dir == null || (oldCr = dir.getCriteria()) == null || oldCr.length <= 0) continue;
                Criteria[] newCr = new Criteria[oldCr.length];
                for (int k = 0; k < oldCr.length; ++k) {
                    if (oldCr[k].getSetName().equals(curName)) {
                        Criteria c = SamQFSUtil.createCriteriaNewName(lcInfo[i].getCurrentlySuggestedName(), oldCr[k]);
                        if (c.sameAs((Criteria)list.get(j))) {
                            newCr[k] = c;
                            continue;
                        }
                        newCr[k] = oldCr[k];
                        continue;
                    }
                    newCr[k] = oldCr[k];
                }
                dir.setCriteria(newCr);
                Archiver.setArFSDirective((Ctx)this.theModel.getJniContext(), (ArFSDirective)dir);
            }
        }
        if (cParams != null && cParams.length > 0) {
            for (i = 0; i < cParams.length; ++i) {
                if (cParams[i] == null) continue;
                for (int j2 = 0; j2 < newPolNamesList.size(); ++j2) {
                    String newCopyNumber = cParams[i].getName().replaceFirst(curName, (String)newPolNamesList.get(j2));
                    CopyParams cp = SamQFSUtil.createCopyParams(newCopyNumber, cParams[i]);
                    try {
                        Archiver.setCopyParams((Ctx)this.theModel.getJniContext(), (CopyParams)cp);
                        continue;
                    }
                    catch (Exception e) {
                        this.theModel.processException(e);
                    }
                }
            }
        }
        for (i = 0; i < mapsList.size(); ++i) {
            VSNMap map = (VSNMap)mapsList.get(i);
            for (j = 0; j < newPolNamesList.size(); ++j) {
                String newCopyNumber = map.getCopyName().replaceFirst(curName, (String)newPolNamesList.get(j));
                VSNMap newMap = SamQFSUtil.createVSNMap(newCopyNumber, map);
                try {
                    VSNOp.addMap((Ctx)this.theModel.getJniContext(), (VSNMap)newMap);
                    continue;
                }
                catch (Exception e) {
                    this.theModel.processException(e);
                }
            }
        }
        this.getAllArchivePolicies();
        pol = null;
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
    }

    public String[] getAllPoolNames() throws SamFSException {
        VSNPool[] pools = VSNOp.getPools((Ctx)this.theModel.getJniContext());
        String[] names = new String[]{};
        if (pools != null) {
            names = new String[pools.length];
            for (int i = 0; i < pools.length; ++i) {
                names[i] = pools[i].getName();
            }
        }
        return names;
    }

    public com.sun.netstorage.samqfs.web.model.archive.VSNPool[] getAllVSNPools() throws SamFSException {
        this.createPoolsFromBackEnd();
        return this.vsnPoolMap.values().toArray(new com.sun.netstorage.samqfs.web.model.archive.VSNPool[0]);
    }

    public com.sun.netstorage.samqfs.web.model.archive.VSNPool getVSNPool(String poolName) throws SamFSException {
        return (com.sun.netstorage.samqfs.web.model.archive.VSNPool)this.vsnPoolMap.get(poolName);
    }

    public com.sun.netstorage.samqfs.web.model.archive.VSNPool createVSNPool(String poolName, int mediaType, String vsnExpr) throws SamFSException {
        String[] exprs = SamQFSUtil.getStringsFromCommaStream(vsnExpr);
        VSNPool jniPool = new VSNPool(poolName, SamQFSUtil.getMediaTypeString(mediaType), exprs);
        VSNOp.addPool((Ctx)this.theModel.getJniContext(), (VSNPool)jniPool);
        VSNPoolImpl pool = new VSNPoolImpl(this.theModel, jniPool);
        this.vsnPoolMap.put(poolName, pool);
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        return pool;
    }

    public void updateVSNPool(String poolName) throws SamFSException {
        com.sun.netstorage.samqfs.web.model.archive.VSNPool pool = this.getVSNPool(poolName);
        if (pool != null) {
            ((VSNPoolImpl)pool).update();
        }
    }

    public boolean isPoolInUse(String poolName) throws SamFSException {
        boolean inUse = false;
        String copy = VSNOp.getCopyUsingPool((Ctx)this.theModel.getJniContext(), (String)poolName);
        if (SamQFSUtil.isValidString(copy)) {
            inUse = true;
        }
        return inUse;
    }

    public void deleteVSNPool(com.sun.netstorage.samqfs.web.model.archive.VSNPool pool) throws SamFSException {
        if (pool != null) {
            this.deleteVSNPool(pool.getPoolName());
        }
    }

    public void deleteVSNPool(String poolName) throws SamFSException {
        if (poolName != null) {
            VSNOp.removePool((Ctx)this.theModel.getJniContext(), (String)poolName);
            this.vsnPoolMap.remove(poolName);
        }
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
    }

    private void createPoliciesFromBackEnd() throws SamFSException {
        ArchivePolicyImpl policy;
        String key;
        Criteria cr;
        ArrayList list;
        int i;
        Criteria[] c = Archiver.getCriteria((Ctx)this.theModel.getJniContext());
        if (c == null) {
            SamQFSUtil.doPrint("null array returned for criteria list.");
        } else if (c.length == 0) {
            SamQFSUtil.doPrint("array length 0 returned for criteria list.");
        }
        HashMap<String, ArrayList<Criteria>> map = new HashMap<String, ArrayList<Criteria>>();
        if (c != null && c.length > 0) {
            for (int j = 0; j < c.length; ++j) {
                ArrayList<Criteria> cList = (ArrayList<Criteria>)map.get(c[j].getSetName());
                if (cList == null) {
                    cList = new ArrayList<Criteria>();
                    cList.add(c[j]);
                    map.put(c[j].getSetName(), cList);
                    continue;
                }
                cList.add(c[j]);
            }
        }
        ArrayList<ArrayList> current = new ArrayList<ArrayList>();
        ArrayList<ArrayList> legacy = new ArrayList<ArrayList>();
        String[] keys = map.keySet().toArray(new String[0]);
        if (keys != null && keys.length > 0) {
            for (int i2 = 0; i2 < keys.length; ++i2) {
                ArrayList list2 = (ArrayList)map.get(keys[i2]);
                ArrayList returnedList = SamQFSUtil.createClusters(list2.toArray(new Criteria[0]));
                if (returnedList.size() > 1) {
                    legacy.add(returnedList);
                    continue;
                }
                if (returnedList.size() != 1) continue;
                current.add(returnedList);
            }
        }
        HashMap<String, ArrayList<CopyParams>> copyMap = new HashMap<String, ArrayList<CopyParams>>();
        CopyParams[] params = Archiver.getCopyParams((Ctx)this.theModel.getJniContext());
        if (params != null && params.length > 0) {
            for (int i3 = 0; i3 < params.length; ++i3) {
                String criteriaName = SamQFSUtil.getCriteriaName(params[i3].getName());
                ArrayList<CopyParams> list3 = (ArrayList<CopyParams>)copyMap.get(criteriaName);
                if (list3 == null) {
                    list3 = new ArrayList<CopyParams>();
                    list3.add(params[i3]);
                    copyMap.put(criteriaName, list3);
                    continue;
                }
                list3.add(params[i3]);
            }
        }
        HashMap<String, ArrayList<VSNMap>> vsnAssocMap = new HashMap<String, ArrayList<VSNMap>>();
        VSNMap[] maps = VSNOp.getMaps((Ctx)this.theModel.getJniContext());
        if (maps != null && maps.length > 0) {
            for (int i4 = 0; i4 < maps.length; ++i4) {
                String criteriaName = SamQFSUtil.getCriteriaName(maps[i4].getCopyName());
                ArrayList<VSNMap> list4 = (ArrayList<VSNMap>)vsnAssocMap.get(criteriaName);
                if (list4 == null) {
                    list4 = new ArrayList<VSNMap>();
                    list4.add(maps[i4]);
                    vsnAssocMap.put(criteriaName, list4);
                    continue;
                }
                list4.add(maps[i4]);
            }
        }
        this.policyMap.clear();
        for (i = 0; i < legacy.size(); ++i) {
            list = (ArrayList)legacy.get(i);
            cr = (Criteria)((ArrayList)list.get(0)).get(0);
            key = cr.getSetName();
            policy = new ArchivePolicyImpl(this.theModel, list, (ArrayList)copyMap.get(key), (ArrayList)vsnAssocMap.get(key));
            this.policyMap.put(key, policy);
        }
        for (i = 0; i < current.size(); ++i) {
            list = (ArrayList)current.get(i);
            policy = new ArchivePolicyImpl(this.theModel, list, (ArrayList)copyMap.get(key = (cr = (Criteria)((ArrayList)list.get(0)).get(0)).getSetName()), (ArrayList)vsnAssocMap.get(key));
            ArchiveCopy[] cp = policy.getArchiveCopies();
            if (cp != null && cp.length > 0) {
                for (int k = 0; k < cp.length; ++k) {
                    String dvsn = cp[k].getDiskArchiveVSN();
                    if (!SamQFSUtil.isValidString(dvsn)) continue;
                    DiskVol vol = DiskVol.get((Ctx)this.theModel.getJniContext(), (String)dvsn);
                    if (SamQFSUtil.isValidString(vol.getHost())) {
                        cp[k].setDiskArchiveVSNHost(vol.getHost());
                    }
                    if (!SamQFSUtil.isValidString(vol.getPath())) continue;
                    cp[k].setDiskArchiveVSNPath(vol.getPath());
                }
            }
            this.policyMap.put(key, policy);
        }
    }

    private void createPoolsFromBackEnd() throws SamFSException {
        this.vsnPoolMap.clear();
        SamQFSUtil.doPrint("jni call for pool.");
        VSNPool[] jniPools = VSNOp.getPools((Ctx)this.theModel.getJniContext());
        if (jniPools == null) {
            SamQFSUtil.doPrint("jni returned null array");
        } else {
            SamQFSUtil.doPrint("length: " + new Integer(jniPools.length).toString());
        }
        if (jniPools != null && jniPools.length > 0) {
            for (int i = 0; i < jniPools.length; ++i) {
                VSNPoolImpl pool = new VSNPoolImpl(this.theModel, jniPools[i]);
                this.vsnPoolMap.put(pool.getPoolName(), pool);
            }
        }
    }
}

