/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemJobManager;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import java.util.GregorianCalendar;
import java.util.Properties;

public class RestoreDumpFile {
    protected static final String KEY_STATE = "status";
    protected static final String KEY_SIZE = "size";
    protected static final String KEY_CREATED = "created";
    protected static final String KEY_MODIFIED = "modified";
    protected static final String KEY_LOCKED = "locked";
    protected static final String KEY_COMPRESSED = "compressed";
    protected static final String KEY_INDEXED = "indexed";
    protected static final String KEY_NUMENTRIES = "numnodes";
    public static final String STATE_OFFLINE = "offline";
    public static final String STATE_COMPRESSED = "compressed";
    public static final String STATE_DECOMPRESSING = "decompressing";
    public static final String STATE_INDEXING = "indexing";
    public static final String STATE_UNINDEXED = "unindexed";
    public static final String STATE_AVAIL = "available";
    protected String stateStr;
    protected String size;
    protected boolean isSelected;
    protected String fileName;
    protected GregorianCalendar createdTime;
    protected GregorianCalendar modTime;
    protected Boolean isLocked = null;
    protected Boolean isCompressed = null;
    protected Boolean isIndexed = null;
    protected Integer numEntries = null;
    private boolean isIndexing = false;
    private int indexingCnt = 0;
    private long enableDumpJobId = -1L;

    public RestoreDumpFile(String fileName, Properties fileProps) throws SamFSException {
        int compressedInt;
        this.fileName = fileName;
        this.stateStr = fileProps.getProperty(KEY_STATE);
        this.size = fileProps.getProperty(KEY_SIZE);
        String crTimeStr = fileProps.getProperty(KEY_CREATED);
        if (crTimeStr == null) {
            this.createdTime = null;
        } else {
            this.createdTime = new GregorianCalendar();
            this.createdTime.setTimeInMillis(1000L * ConversionUtil.strToLongVal(crTimeStr));
        }
        String modTimeStr = fileProps.getProperty(KEY_MODIFIED);
        if (modTimeStr == null) {
            this.modTime = null;
        } else {
            this.modTime = new GregorianCalendar();
            this.modTime.setTimeInMillis(1000L * ConversionUtil.strToLongVal(modTimeStr));
        }
        String compressedStr = fileProps.getProperty("compressed");
        this.isCompressed = compressedStr == null ? null : ((compressedInt = ConversionUtil.strToIntVal(compressedStr)) > 0 ? Boolean.TRUE : Boolean.FALSE);
        this.isLocked = this.propertyValueToBoolean(fileProps.getProperty(KEY_LOCKED));
        this.isIndexed = this.propertyValueToBoolean(fileProps.getProperty(KEY_INDEXED));
        String numEntriesStr = fileProps.getProperty(KEY_NUMENTRIES);
        this.numEntries = numEntriesStr == null ? null : new Integer(ConversionUtil.strToIntVal(numEntriesStr));
    }

    public RestoreDumpFile(String fileName, String state, String size, GregorianCalendar createdTime, GregorianCalendar modTime, Boolean isLocked, Boolean isCompressed, Boolean isIndexed, Integer numEntries) {
        this.isSelected = false;
        this.fileName = fileName;
        this.stateStr = state;
        this.size = size;
        this.createdTime = (GregorianCalendar)createdTime.clone();
        this.modTime = (GregorianCalendar)modTime.clone();
        this.isLocked = isLocked;
        this.isCompressed = isCompressed;
        this.isIndexed = isIndexed;
        this.numEntries = numEntries;
    }

    private Boolean propertyValueToBoolean(String propertyVal) {
        if (propertyVal == null) {
            return null;
        }
        if (propertyVal.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isAvailable() {
        return this.stateStr.equals(STATE_AVAIL);
    }

    public boolean isIndexed() {
        if (this.isIndexed == null) {
            if (this.stateStr == null) {
                return false;
            }
            return this.stateStr.compareTo(STATE_AVAIL) == 0;
        }
        return this.isIndexed;
    }

    public boolean isCompressed() {
        if (this.isCompressed == null) {
            if (this.stateStr == null) {
                return true;
            }
            return this.stateStr.equals("compressed");
        }
        return this.isCompressed;
    }

    public boolean isLocked() {
        if (this.isLocked == null) {
            return false;
        }
        return this.isLocked;
    }

    public void setIsLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public boolean isProcessing() {
        if (this.stateStr == null) {
            return false;
        }
        return this.stateStr.equals(STATE_DECOMPRESSING) || this.stateStr.equals(STATE_INDEXING);
    }

    public String getSize() {
        return this.size;
    }

    public boolean getIsSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String getFileName() {
        return this.fileName;
    }

    public GregorianCalendar getCreatedTime() {
        return this.createdTime;
    }

    public GregorianCalendar getModTime() {
        return this.modTime;
    }

    public Integer getNumEntries() {
        return this.numEntries;
    }

    public String toString() {
        long created = this.createdTime == null ? -1L : this.createdTime.getTimeInMillis() / 1000L;
        long modif = this.modTime == null ? -1L : this.modTime.getTimeInMillis() / 1000L;
        NonSyncStringBuffer s = new NonSyncStringBuffer().append(this.fileName).append(": ").append(KEY_STATE).append("=").append(this.stateStr).append(",").append(KEY_SIZE).append("=").append(this.size).append(",").append(KEY_CREATED).append("=").append(created).append(",").append(KEY_MODIFIED).append("=").append(modif);
        if (this.isLocked != null) {
            s.append(",").append(KEY_LOCKED).append("=").append(this.isLocked.toString());
        }
        if (this.isCompressed != null) {
            s.append(",").append("compressed").append("=").append(this.isCompressed.toString());
        }
        if (this.isIndexed != null) {
            s.append(",").append(KEY_INDEXED).append("=").append(this.isIndexed.toString());
        }
        if (this.numEntries != null) {
            s.append(",").append(KEY_NUMENTRIES).append("=").append(this.numEntries.toString());
        }
        return s.toString();
    }

    public boolean getIsIndexing() {
        return this.isIndexing;
    }

    public void startMakingAvailable(long jobId) {
        this.enableDumpJobId = jobId;
        this.isIndexing = true;
        this.indexingCnt = 2;
        this.stateStr = STATE_INDEXING;
    }

    public long getEnableDumpJobId() {
        return this.enableDumpJobId;
    }

    public void changeNextState() throws SamFSException {
        if (!this.isIndexing) {
            return;
        }
        if (this.indexingCnt > 0) {
            --this.indexingCnt;
        } else {
            this.stateStr = STATE_AVAIL;
            this.isIndexing = false;
            this.isIndexed = Boolean.TRUE;
            this.isCompressed = Boolean.FALSE;
            SamQFSSystemJobManager jobMgr = SamUtil.getModel().getSamQFSSystemJobManager();
            BaseJob theJob = jobMgr.getJobById(this.enableDumpJobId);
            if (theJob != null) {
                jobMgr.cancelJob(theJob);
            }
            this.enableDumpJobId = -1L;
        }
    }

    public void makeUnindexed() {
        this.stateStr = STATE_UNINDEXED;
        this.isIndexed = Boolean.FALSE;
    }
}

