/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.io.Serializable;
import java.security.InvalidParameterException;

public class DumpSchedRetention
implements Serializable {
    public static final String UNIT_DAYS = "D";
    public static final String UNIT_WEEKS = "W";
    public static final String UNIT_MONTHS = "M";
    public static final String UNIT_YEARS = "Y";
    protected int value = 0;
    protected String unit = "";

    private DumpSchedRetention() {
    }

    public DumpSchedRetention(int value, String unit) {
        this.setValue(value);
        this.setUnit(unit);
    }

    public DumpSchedRetention(String serverString) {
        this.setFromServerString(serverString);
    }

    public void setValue(int value) {
        if (value <= 0) {
            TraceUtil.trace1("Retention value is " + value + ", but must be > 0.");
            throw new InvalidParameterException();
        }
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setUnit(String unit) {
        if (!(unit.equals(UNIT_DAYS) || unit.equals(UNIT_WEEKS) || unit.equals(UNIT_MONTHS) || unit.equals(UNIT_YEARS))) {
            TraceUtil.trace1("Invalid retention unit:  " + unit);
            throw new InvalidParameterException();
        }
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getServerString() {
        NonSyncStringBuffer buf = new NonSyncStringBuffer().append(this.value).append(this.unit);
        return buf.toString();
    }

    public void setFromServerString(String str) {
        int val = 0;
        try {
            val = Integer.parseInt(str.substring(0, str.length() - 1));
        }
        catch (NumberFormatException e) {
            TraceUtil.trace1("Server retention string is invalid: " + str + ".  Must be a number followed by a unit, e.g., \"7D\"");
            throw new InvalidParameterException();
        }
        this.setValue(val);
        this.setUnit(str.substring(str.length() - 1));
    }

    public String toString() {
        return this.getServerString();
    }
}

