/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardDeviceSelectionPageView;
import com.sun.netstorage.samqfs.web.fs.wizards.GrowWizardImplData;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpSession;

public class GrowWizardImpl
extends SamWizardImpl {
    public static final String WIZARDPAGEMODELNAME = "GrowPageModelName";
    public static final String WIZARDPAGEMODELNAME_PREFIX = "GrowWizardModel";
    public static final String WIZARDIMPLNAME = "GrowWizardImpl";
    public static final String WIZARDIMPLNAME_PREFIX = "GrowWizardImpl";
    public static final String WIZARDCLASSNAME = "com.sun.netstorage.samqfs.web.fs.wizards.GrowWizardImpl";
    public static final String FSTYPE_KEY = "fsTypeKey";
    public static final String FSTYPE_FS = "fs";
    public static final String FSTYPE_QFS = "qfs";
    private DiskCache[] allAllocatableDevices = null;
    private ArrayList selectedDataDevicesList = null;
    private ArrayList selectedMetaDevicesList = null;
    private ArrayList selectedStripedGroupDevicesList = null;
    private FileSystem fileSystemHandle = null;
    private String fsType = "fs";
    private boolean boolDumpOn = false;
    private boolean fs = false;
    private boolean boolSaveToFile = false;
    private String dumpPath = null;
    private boolean wizardInitialized = false;
    private int availableGroups = 0;
    private int numStripedGroups = -1;
    private String samfsServerAPIVersion = "1.1";
    private String OLD_NUM_STRIPED_GROUPS = "OLD_NUM_STRIPED_GROUPS";
    protected String serverName = null;
    protected String fsName = null;

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace2("in create()");
        return new GrowWizardImpl(requestContext);
    }

    public GrowWizardImpl(RequestContext requestContext) {
        super(requestContext, WIZARDPAGEMODELNAME);
        this.initializeWizard(requestContext);
        this.initializeWizardControl(requestContext);
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return GrowWizardImpl.getWizardWindowModel("GrowWizardImpl", "FSWizard.grow.title", WIZARDCLASSNAME, cmdChild);
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        if (this.pages[page] == 2) {
            this.wizardModel.setValue("stripedGroupNumber", new Integer(page - 2));
            TraceUtil.trace2("This is striped group # " + (page - 2));
        }
        if (this.wizardInitialized) {
            this.wizardModel.setValue("ERROR", "No");
        }
        return super.getPageClass(pageId);
    }

    public String[] getFutureSteps(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String[] futureSteps = null;
        int howMany = this.pages.length - page - 1;
        futureSteps = new String[howMany];
        for (int i = 0; i < howMany; ++i) {
            int futureStep = page + 1 + i;
            int futurePage = this.pages[futureStep];
            futureSteps[i] = futurePage == 2 ? SamUtil.getResourceString(this.stepText[futurePage], new String[]{Integer.toString(futureStep - 2)}) : this.stepText[futurePage];
        }
        return futureSteps;
    }

    public String getStepText(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String text = null;
        text = this.pages[page] == 2 ? SamUtil.getResourceString(this.stepText[this.pages[page]], new String[]{Integer.toString(page - 2)}) : this.stepText[this.pages[page]];
        return text;
    }

    public String getStepTitle(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String title = null;
        title = this.pages[page] == 2 ? SamUtil.getResourceString(this.pageTitle[this.pages[page]], new String[]{Integer.toString(page - 2)}) : this.pageTitle[this.pages[page]];
        return title;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        String pageId = wizardEvent.getPageId();
        TraceUtil.trace2("Entered with pageID = " + pageId);
        super.nextStep(wizardEvent);
        this.wizardInitialized = true;
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 0: {
                return this.processMetaDataDevicesPage(wizardEvent);
            }
            case 1: {
                return this.processStripedGroupNumberPage(wizardEvent);
            }
            case 2: {
                return this.processStripedGroupDevicesPage(wizardEvent);
            }
            case 3: {
                return this.processDataDevicesPage(wizardEvent);
            }
            case 4: {
                return this.processDumpPage(wizardEvent);
            }
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        String pageId = wizardEvent.getPageId();
        TraceUtil.trace2("Entered with pageID = " + pageId);
        if (!super.finishStep(wizardEvent)) {
            return true;
        }
        DiskCache[] metadataDevices = this.getSelectedDeviceArray(this.selectedMetaDevicesList);
        DiskCache[] dataDevices = this.getSelectedDeviceArray(this.selectedDataDevicesList);
        StripedGroup[] stripedGroups = null;
        try {
            stripedGroups = this.getSelectedStripedGroupsArray(this.selectedStripedGroupDevicesList);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", "Failed to create striped groups", this.serverName);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.grow.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
            return true;
        }
        SamQFSSystemModel sysModel = null;
        try {
            sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            FileSystem fileSystem = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
            if (fileSystem == null) {
                throw new SamFSException(null, -1000);
            }
            if (this.boolSaveToFile) {
                sysModel.setDumpPath(this.dumpPath);
            }
            sysModel.getSamQFSSystemFSManager().growFileSystem(fileSystem, metadataDevices, dataDevices, stripedGroups);
            this.wizardModel.setValue("Finish_result", "successful");
            LogUtil.info(this.getClass(), "finishStep", "Done growing FS " + this.fsName);
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("FSSummary.growfs", this.fsName));
            TraceUtil.trace2("Done growing FS " + this.fsName);
            return true;
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", "Failed to grow fs", this.serverName);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.grow.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
            return true;
        }
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        this.wizardModel.setValue("ERROR", "No");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            sysModel.getDataStore().clearAvailableAllocatableUnits();
            sysModel.getDataStore().clearTemporaryStripedGroups();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "cancelStep()", "Failed to clear selected allocatableUnits", this.serverName);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("Detail_msgs", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
        }
        this.wizardModel.clear();
        return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
        TraceUtil.trace2("Clearing out wizard model...");
        this.wizardModel.clear();
        TraceUtil.trace2("Done!");
    }

    private boolean processMetaDataDevicesPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processMetaDataDevicesPage.., ");
        boolean result = true;
        FSWizardDeviceSelectionPageView view = (FSWizardDeviceSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("DeviceSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processMetaDataDevicesPage()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        CCActionTableModel dataModel = (CCActionTableModel)dataTable.getModel();
        Integer[] selectedRows = dataModel.getSelectedRows();
        TraceUtil.trace2("Number of selected rows are : " + selectedRows.length);
        if (selectedRows.length < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.grow.error.metadata");
            return false;
        }
        int availableLuns = (Integer)this.wizardModel.getValue("AvailableLuns");
        if (selectedRows.length > availableLuns) {
            this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
            return false;
        }
        String deviceSelected = null;
        Object device = null;
        if (this.selectedMetaDevicesList == null) {
            this.selectedMetaDevicesList = new ArrayList();
        }
        this.selectedMetaDevicesList.clear();
        for (int i = 0; i < selectedRows.length; ++i) {
            dataModel.setRowIndex(selectedRows[i].intValue());
            deviceSelected = (String)dataModel.getValue("HiddenDevicePath");
            this.selectedMetaDevicesList.add(deviceSelected);
        }
        this.wizardModel.setValue("SelectedMetaDevices", this.selectedMetaDevicesList);
        Collections.sort(this.selectedMetaDevicesList);
        if (this.samfsServerAPIVersion.compareTo("1.1") >= 0) {
            int size = this.selectedMetaDevicesList.size();
            String[] dataLUNs = new String[size];
            for (int i = 0; i < size; ++i) {
                dataLUNs[i] = (String)this.selectedMetaDevicesList.get(i);
            }
            SamQFSSystemModel sysModel = null;
            String[] overlapLUNs = null;
            try {
                sysModel = SamUtil.getModel(this.serverName);
                if (sysModel == null) {
                    throw new SamFSException(null, -2001);
                }
                overlapLUNs = sysModel.getSamQFSSystemFSManager().checkSlicesForOverlaps(dataLUNs);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectMetaDataDeviceStep()", "Failed to check metadata LUNs for overlaps", this.serverName);
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("Detail_msgs", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
                return false;
            }
            if (overlapLUNs != null && overlapLUNs.length > 0) {
                StringBuffer badLUNs = new StringBuffer(SamUtil.getResourceString("FSWizard.error.overlapMetadataLUNs"));
                badLUNs.append("<br>");
                for (int i = 0; i < overlapLUNs.length; ++i) {
                    badLUNs.append(overlapLUNs[i]).append("<br>");
                }
                TraceUtil.trace2(badLUNs.toString());
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", badLUNs.toString());
                this.wizardModel.setValue("ERROR_CODE", "1007");
                this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
                this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
                return false;
            }
        }
        StringBuffer deviceList = new StringBuffer();
        for (int i = 0; i < this.selectedMetaDevicesList.size(); ++i) {
            deviceList.append((String)this.selectedMetaDevicesList.get(i)).append("<br>");
        }
        this.wizardModel.setValue("MetadataField", deviceList.toString());
        return result;
    }

    private boolean processDataDevicesPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processDataDevicesPage.., ");
        FSWizardDeviceSelectionPageView view = (FSWizardDeviceSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("DeviceSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        CCActionTableModel dataModel = (CCActionTableModel)dataTable.getModel();
        Integer[] selectedRows = dataModel.getSelectedRows();
        TraceUtil.trace2("Number of selected rows are : " + selectedRows.length);
        String deviceSelected = null;
        Object device = null;
        if (this.selectedDataDevicesList == null) {
            this.selectedDataDevicesList = new ArrayList();
        }
        this.selectedDataDevicesList.clear();
        for (int i = 0; i < selectedRows.length; ++i) {
            dataModel.setRowIndex(selectedRows[i].intValue());
            deviceSelected = (String)dataModel.getValue("HiddenDevicePath");
            this.selectedDataDevicesList.add(deviceSelected);
        }
        this.wizardModel.setValue("SelectedDataDevices", this.selectedDataDevicesList);
        if (selectedRows.length < 1) {
            if (this.fsType == FSTYPE_QFS) {
                this.wizardModel.setValue("DataField", "");
                return true;
            }
            this.setWizardAlert(wizardEvent, "FSWizard.grow.error.data");
            return false;
        }
        int availableLuns = (Integer)this.wizardModel.getValue("AvailableLuns");
        if (this.fsType == FSTYPE_QFS) {
            int metaDevices = this.selectedMetaDevicesList.size();
            if (selectedRows.length > availableLuns - metaDevices) {
                this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
                return false;
            }
        } else if (selectedRows.length > availableLuns) {
            this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
            return false;
        }
        Collections.sort(this.selectedDataDevicesList);
        if (this.samfsServerAPIVersion.compareTo("1.1") >= 0) {
            int size = this.selectedDataDevicesList.size();
            String[] dataLUNs = new String[size];
            for (int i = 0; i < size; ++i) {
                dataLUNs[i] = (String)this.selectedDataDevicesList.get(i);
            }
            SamQFSSystemModel sysModel = null;
            String[] overlapLUNs = null;
            try {
                sysModel = SamUtil.getModel(this.serverName);
                if (sysModel == null) {
                    throw new SamFSException(null, -2001);
                }
                overlapLUNs = sysModel.getSamQFSSystemFSManager().checkSlicesForOverlaps(dataLUNs);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed to check data LUNs for overlaps", this.serverName);
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("Detail_msgs", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
                return false;
            }
            if (overlapLUNs != null && overlapLUNs.length > 0) {
                StringBuffer badLUNs = new StringBuffer(SamUtil.getResourceString("FSWizard.error.overlapDataLUNs"));
                badLUNs.append("<br>");
                for (int i = 0; i < overlapLUNs.length; ++i) {
                    badLUNs.append(overlapLUNs[i]).append("<br>");
                }
                TraceUtil.trace2(badLUNs.toString());
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", badLUNs.toString());
                this.wizardModel.setValue("ERROR_CODE", "1007");
                this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
                this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
                return false;
            }
        }
        StringBuffer deviceList = new StringBuffer();
        for (int i = 0; i < this.selectedDataDevicesList.size(); ++i) {
            deviceList.append((String)this.selectedDataDevicesList.get(i)).append("<br>");
        }
        this.wizardModel.setValue("DataField", deviceList.toString());
        return true;
    }

    private boolean processStripedGroupDevicesPage(WizardEvent wizardEvent) {
        ArrayList thisGroupDevices;
        int usedLuns;
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processStripedGroupDevicesPage.., ");
        FSWizardDeviceSelectionPageView view = (FSWizardDeviceSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("DeviceSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        CCActionTableModel dataModel = (CCActionTableModel)dataTable.getModel();
        Integer[] selectedRows = dataModel.getSelectedRows();
        int groupNum = (Integer)this.wizardModel.getValue("stripedGroupNumber");
        if (selectedRows.length < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.grow.error.data");
            return false;
        }
        int availableLuns = (Integer)this.wizardModel.getValue("AvailableLuns");
        int metaLuns = this.selectedMetaDevicesList.size();
        int totalStripeLuns = 0;
        if (this.selectedStripedGroupDevicesList != null) {
            for (int j = 0; j < groupNum; ++j) {
                ArrayList groupDevices = (ArrayList)this.selectedStripedGroupDevicesList.get(j);
                totalStripeLuns += groupDevices.size();
            }
        }
        if ((usedLuns = metaLuns + totalStripeLuns + selectedRows.length) > availableLuns) {
            this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
            return false;
        }
        TraceUtil.trace2("Number of selected rows are : " + selectedRows.length);
        String deviceSelected = null;
        Object device = null;
        if (this.selectedStripedGroupDevicesList == null) {
            this.selectedStripedGroupDevicesList = new ArrayList();
        }
        if (this.selectedStripedGroupDevicesList.size() <= groupNum) {
            thisGroupDevices = new ArrayList();
            this.selectedStripedGroupDevicesList.add(groupNum, thisGroupDevices);
        } else {
            thisGroupDevices = (ArrayList)this.selectedStripedGroupDevicesList.get(groupNum);
        }
        thisGroupDevices.clear();
        long groupDeviceSize = -1L;
        boolean deviceError = false;
        for (int i = 0; i < selectedRows.length; ++i) {
            dataModel.setRowIndex(selectedRows[i].intValue());
            deviceSelected = (String)dataModel.getValue("HiddenDevicePath");
            DiskCache disk = this.getDiskCacheObject(deviceSelected);
            if (groupDeviceSize < 0L) {
                groupDeviceSize = disk.getCapacity();
            }
            if (groupDeviceSize != disk.getCapacity()) {
                deviceError = true;
            }
            thisGroupDevices.add(deviceSelected);
        }
        this.wizardModel.setValue("SelectedStripedGroupDevices", this.selectedStripedGroupDevicesList);
        if (deviceError) {
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", "FSWizard.error.stripedGroup.deviceSizeError");
            this.wizardModel.setValue("ERROR_CODE", "1007");
            this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
            this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
            return false;
        }
        Collections.sort(thisGroupDevices);
        if (this.samfsServerAPIVersion.compareTo("1.1") >= 0) {
            int size = thisGroupDevices.size();
            String[] dataLUNs = new String[size];
            for (int i = 0; i < size; ++i) {
                dataLUNs[i] = (String)thisGroupDevices.get(i);
            }
            SamQFSSystemModel sysModel = null;
            String[] overlapLUNs = null;
            try {
                sysModel = SamUtil.getModel(this.serverName);
                if (sysModel == null) {
                    throw new SamFSException(null, -2001);
                }
                overlapLUNs = sysModel.getSamQFSSystemFSManager().checkSlicesForOverlaps(dataLUNs);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectStripedGroupStep()", "Failed to check striped group for overlaps", this.serverName);
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("Detail_msgs", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
                return false;
            }
            if (overlapLUNs != null && overlapLUNs.length > 0) {
                StringBuffer badLUNs = new StringBuffer(SamUtil.getResourceString("FSWizard.error.overlapDataLUNs"));
                badLUNs.append("<br>");
                for (int i = 0; i < overlapLUNs.length; ++i) {
                    badLUNs.append(overlapLUNs[i]).append("<br>");
                }
                TraceUtil.trace2(badLUNs.toString());
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", badLUNs.toString());
                this.wizardModel.setValue("ERROR_CODE", "1007");
                this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
                this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
                return false;
            }
        }
        StringBuffer deviceList = new StringBuffer();
        for (int j = 0; j < this.selectedStripedGroupDevicesList.size(); ++j) {
            ArrayList groupDevices = (ArrayList)this.selectedStripedGroupDevicesList.get(j);
            deviceList.append(SamUtil.getResourceString("FSWizard.new.stripedGroup.deviceListing", new String[]{Integer.toString(j)})).append("<br>");
            for (int i = 0; i < groupDevices.size(); ++i) {
                deviceList.append("&nbsp;&nbsp;&nbsp;").append((String)groupDevices.get(i)).append("<br>");
            }
        }
        this.wizardModel.setValue("DataField", deviceList.toString());
        this.wizardModel.setValue("ERROR", "No");
        return true;
    }

    private boolean processStripedGroupNumberPage(WizardEvent wizardEvent) {
        int oldNum;
        Integer oldNumGroups;
        String numGroups = (String)this.wizardModel.getWizardValue("numOfStripedGroupTextField");
        if (numGroups != null) {
            try {
                this.numStripedGroups = Integer.parseInt(numGroups);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this.numStripedGroups < 0 || this.numStripedGroups > this.availableGroups) {
            this.setWizardAlert(wizardEvent, SamUtil.getResourceString("FSWizard.grow.error.numStripedGroup", new String[]{Integer.toString(this.availableGroups)}));
            return false;
        }
        this.generateWizardPages(this.numStripedGroups);
        this.initializeWizardPages(this.pages);
        if (this.numStripedGroups == 0) {
            this.wizardModel.setValue("DataField", "");
        }
        if ((oldNumGroups = (Integer)this.wizardModel.getValue(this.OLD_NUM_STRIPED_GROUPS)) != null && (oldNum = oldNumGroups.intValue()) > this.numStripedGroups && this.selectedStripedGroupDevicesList != null) {
            int oldSize;
            TraceUtil.trace2("Clearing out striped group devices");
            for (int i = oldSize = this.selectedStripedGroupDevicesList.size(); i > this.numStripedGroups; --i) {
                this.selectedStripedGroupDevicesList.remove(i - 1);
            }
            this.wizardModel.setValue("SelectedStripedGroupDevices", this.selectedStripedGroupDevicesList);
        }
        this.wizardModel.setValue(this.OLD_NUM_STRIPED_GROUPS, new Integer(this.numStripedGroups));
        return true;
    }

    private boolean processDumpPage(WizardEvent wizardEvent) {
        TraceUtil.trace2("Entered");
        if (this.boolDumpOn) {
            String target = (String)this.wizardModel.getValue("selectSaveRadioButton");
            if (target != null && target.equals("Savetofile")) {
                this.boolSaveToFile = true;
                this.dumpPath = this.getDumpPathLocation();
                if (this.dumpPath == null) {
                    TraceUtil.trace2("dumpPath is null");
                    return false;
                }
                this.wizardModel.setValue("DumpField", SamUtil.getResourceString("FSWizard.grow.saveToFile", new String[]{this.dumpPath}));
            } else {
                this.wizardModel.setValue("DumpField", "FSWizard.grow.commit");
            }
        }
        this.wizardModel.setValue("ERROR", "No");
        return true;
    }

    private String getDumpPathLocation() {
        String path = (String)this.wizardModel.getValue("location");
        if (path == null || path.length() < 1) {
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", SamUtil.getResourceString("FSGrow.errMsg2"));
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
            this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.grow.error.path");
            return null;
        }
        if (!SamUtil.isValidNonSpecialCharString(path)) {
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", SamUtil.getResourceString("FSGrow.errMsg3"));
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
            this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.grow.error.path");
            return null;
        }
        return path;
    }

    private void getFileSystemHandle() throws SamFSException {
        TraceUtil.trace3("Entering");
        int availableLuns = -1;
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        this.fileSystemHandle = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
        if (this.fileSystemHandle == null) {
            throw new SamFSException(null, -1000);
        }
        this.fsType = FSTYPE_FS;
        if (this.fileSystemHandle.getFSType() == 0) {
            this.fsType = FSTYPE_QFS;
        }
        this.wizardModel.setValue(FSTYPE_KEY, this.fsType);
        if (this.fsType == FSTYPE_FS) {
            int dataDeviceLuns = this.fileSystemHandle.getDataDevices().length;
            availableLuns = 252 - dataDeviceLuns;
        }
        StripedGroup[] group = this.fileSystemHandle.getStripedGroups();
        int stripedDeviceLuns = 0;
        if (group != null && group.length > 0) {
            this.availableGroups = 126 - group.length;
            this.numStripedGroups = 0;
            for (int i = 0; i < group.length; ++i) {
                stripedDeviceLuns += group[i].getMembers().length;
            }
            TraceUtil.trace2("group length = " + group.length);
            TraceUtil.trace2("available num of groups = " + this.availableGroups);
        }
        if (this.fsType == FSTYPE_QFS) {
            int metaDeviceLuns = this.fileSystemHandle.getMetadataDevices().length;
            int dataDevicesLuns = 0;
            DiskCache[] dataDevices = this.fileSystemHandle.getDataDevices();
            if (dataDevices != null && dataDevices.length > 0) {
                dataDevicesLuns = dataDevices.length;
            }
            availableLuns = 252 - metaDeviceLuns - dataDevicesLuns - stripedDeviceLuns;
        }
        this.wizardModel.setValue("AvailableStripedGroups", new Integer(this.availableGroups));
        this.wizardModel.setValue("AvailableLuns", new Integer(availableLuns));
    }

    private DiskCache[] getSelectedDeviceArray(ArrayList selectedDevicePaths) {
        if (selectedDevicePaths == null) {
            return new DiskCache[0];
        }
        int numDevices = selectedDevicePaths.size();
        DiskCache[] selectedDevices = new DiskCache[numDevices];
        Iterator iter = selectedDevicePaths.iterator();
        int i = 0;
        while (iter.hasNext()) {
            selectedDevices[i] = this.getDiskCacheObject((String)iter.next());
            ++i;
        }
        return selectedDevices;
    }

    private StripedGroup[] getSelectedStripedGroupsArray(ArrayList groupList) throws SamFSException {
        if (groupList == null) {
            return new StripedGroup[0];
        }
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        int numGroups = groupList.size();
        StripedGroup[] stripedGroups = new StripedGroup[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            ArrayList groupDevices = (ArrayList)groupList.get(i);
            DiskCache[] disks = this.getSelectedDeviceArray(groupDevices);
            stripedGroups[i] = sysModel.getSamQFSSystemFSManager().createStripedGroup("", disks);
        }
        return stripedGroups;
    }

    private DiskCache getDiskCacheObject(String devicePath) {
        for (int i = 0; i < this.allAllocatableDevices.length; ++i) {
            if (!this.allAllocatableDevices[i].getDevicePath().equals(devicePath)) continue;
            return this.allAllocatableDevices[i];
        }
        TraceUtil.trace1("Selection device does not exist in Current Devicelist");
        return null;
    }

    private void populateDevicesInWizardModel() throws SamFSException {
        DiskCache[] devices = (DiskCache[])this.wizardModel.getValue("AllAllocatableDevices");
        if (devices != null) {
            return;
        }
        if (this.allAllocatableDevices == null) {
            TraceUtil.trace2("DeviceList is Null., Getting devices from sysmodel");
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel != null) {
                this.allAllocatableDevices = sysModel.getSamQFSSystemFSManager().discoverAvailableAllocatableUnits(null);
            }
        }
        this.wizardModel.setValue("AllAllocatableDevices", this.allAllocatableDevices);
    }

    private void setExceptionInModel(SamFSException ex) {
        this.wizardModel.setValue("ERROR", "Yes");
        this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
        this.wizardModel.setValue("ERROR_CODE", Integer.toString(ex.getSAMerrno()));
    }

    private void setWizardAlert(WizardEvent wizardEvent, String message) {
        wizardEvent.setSeverity(0);
        wizardEvent.setErrorMessage(message);
    }

    private void initializeWizard(RequestContext requestContext) {
        TraceUtil.trace2("Initializing wizard...");
        this.wizardName = "GrowWizardImpl";
        this.wizardTitle = "FSWizard.grow.title";
        this.pageClass = GrowWizardImplData.pageClass;
        this.pageTitle = GrowWizardImplData.pageTitle;
        this.stepHelp = GrowWizardImplData.stepHelp;
        this.stepText = GrowWizardImplData.stepText;
        this.stepInstruction = GrowWizardImplData.stepInstruction;
        this.cancelMsg = GrowWizardImplData.cancelmsg;
        this.fsName = requestContext.getRequest().getParameter("fsNameParam");
        this.serverName = requestContext.getRequest().getParameter("serverNameParam");
        this.wizardModel.setValue("fs_name", this.fsName);
        this.wizardModel.setValue("SERVER_NAME", this.serverName);
        TraceUtil.trace2("fsNameParam = " + this.fsName + ", serverNameParam = " + this.serverName);
        try {
            ServerInfo serverInfo;
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -1004);
            }
            this.boolDumpOn = appModel.isDumpOn();
            if (this.boolDumpOn) {
                this.wizardModel.setValue("DUMP", "on");
            } else {
                this.wizardModel.setValue("DUMP", "off");
            }
            this.populateDevicesInWizardModel();
            this.getFileSystemHandle();
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
            if (serverTable != null && this.serverName != null && (serverInfo = (ServerInfo)serverTable.get(this.serverName)) != null) {
                this.samfsServerAPIVersion = serverInfo.getSamfsServerAPIVersion();
                TraceUtil.trace2("got samfsServerAPIVersion from cache: " + this.samfsServerAPIVersion);
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "initializeWizard()", "Failed to initialize growfs wizard", this.serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(ex.getSAMerrno()));
        }
        TraceUtil.trace2("samfsServerAPIVersion = " + this.samfsServerAPIVersion);
        this.wizardModel.setValue("SamServerAPIVersion", this.samfsServerAPIVersion);
        this.generateWizardPages(this.numStripedGroups);
        this.setShowResultsPage(true);
        this.initializeWizardPages(this.pages);
        this.wizardModel.setValue("DumpField", "FSWizard.grow.commit");
        TraceUtil.trace2("wizard initialized!");
    }

    private void generateWizardPages(int stripedGroups) {
        int totalPages = 2;
        if (this.fsType == FSTYPE_QFS) {
            ++totalPages;
        }
        if (stripedGroups < 0) {
            ++totalPages;
        } else {
            ++totalPages;
            totalPages += stripedGroups;
        }
        if (this.boolDumpOn) {
            ++totalPages;
        }
        this.pages = new int[totalPages];
        int pageCount = 0;
        if (this.fsType == FSTYPE_QFS) {
            this.pages[pageCount++] = 0;
        }
        if (stripedGroups < 0) {
            this.pages[pageCount++] = 3;
        } else {
            this.pages[pageCount++] = 1;
            for (int i = 0; i < stripedGroups; ++i) {
                this.pages[pageCount++] = 2;
            }
        }
        if (this.boolDumpOn) {
            this.pages[pageCount++] = 4;
        }
        this.pages[pageCount++] = 5;
        this.pages[pageCount] = 6;
    }
}

