/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotContentsData;
import com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotContentsModel;
import com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotContentsTiledView;
import com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotSummaryTable;
import com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotSummaryTiledView;
import com.sun.netstorage.samqfs.web.fs.FSRestoreViewBean;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemJobManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.RestoreDumpFile;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserModel;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCClientSniffer;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;

public class FSRestoreView
extends RequestHandlingViewBase {
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_JOBID_HREF = "jobIdHref";
    private static CCPageTitleModel pageTitleModel = null;
    private CCPropertySheetModel propertySheetModel = null;
    private CCActionTableModel snapshotSummaryTableModel = null;
    private FSRestoreSnapshotContentsModel snapshotContentsTableModel = null;
    private RemoteFileChooserModel selectSnapshotPathModel = null;
    private RemoteFileChooserModel restorePathModel = null;
    public static final String SECTION_SS_SUMMARY = "snapshotSummary";
    public static final String SECTION_SS_CONTENTS = "snapshotContents";
    public static final String SECTION_RESTORE = "restoreFile";
    public static final String PROPERTY_CURRENT_PATH = "currentPath";
    public static final String PROPERTY_CURRENT_SS_PATH = "currentSnapshotPath";
    public static final String CHILD_SNAPSHOT_CONTENTS = "snapshotContents";
    public static final String CHILD_CUR_SS_PATH_VALUE = "currentSnapshotPathValue";
    public static final String CHILD_SELECT_SS_PATH = "selectSnapshotPath";
    public static final String CHILD_RESTORE_FILE = "restoreFile";
    public static final String CHILD_CUR_PATH_LABEL = "currentPathLabel";
    public static final String CHILD_CUR_PATH_VALUE = "currentPathValue";
    public static final String CHILD_CUR_PATH_HIDDEN = "currentPathHidden";
    public static final String PROPERTY_FILTER = "filterSearchApplied";
    public static final String CHILD_FILTER_CRITERIA_LABEL = "filterSearchCriteriaLabel";
    public static final String CHILD_FILTER_CRITERIA_VALUE = "filterSearchCriteriaValue";
    public static final String CHILD_FILTER_CLEAR = "filterCriteriaClear";
    public static final String CHILD_MAX_ENTRIES = "maxEntriesValue";
    public static final String CHILD_POPUP_HIDDEN = "popupReturnValueHidden";
    public static final String CHILD_RESTORE_TYPE_PROMPT = "restoreTypePromptText";
    public static final String CHILD_ENTIRE_FS_STAGE_OPTIONS = "entireFileSystemStageOptions";
    public static final String CHILD_POST_SELECT_SS_PATH_CMD = "postSelectSnapshotPathCmd";
    public static final String CHILD_SS_RETENTION_CMD = "snapshotRetentionCmd";
    public static final String CHILD_CHANGE_DIR_SUBMIT_CMD = "changeDirSubmitCmd";
    public static final String CHILD_FILTER_SUBMIT_CMD = "filterSubmitCmd";
    public static final String CHILD_SEARCH_SUBMIT_CMD = "searchSubmitCmd";
    public static final String CHILD_POST_RESTORE_PATH_CMD = "postSelectRestorePathCmd";
    public static final String COL_SS_FILE_NAME = "colFileName";
    public static final String COL_SS_FILE_DATE = "colFileDate";
    public static final String COL_SS_FILE_SIZE = "colFileSize";
    public static final String COL_SS_NUM_ENTRIES = "colNumEntries";
    public static final String COL_SS_INDEXED = "colIndexed";
    public static final String COL_SS_COMPRESSED = "colCompressed";
    public static final String COL_SS_RETENTION = "colRetention";
    public static final String CHILD_SS_ALERT = "snapshotSummaryAlert";
    public static final String CHILD_SS_ACTION_TABLE = "snapshotSummaryTable";
    public static final String CHILD_SS_TILED_VIEW = "snapshotSummaryTableTiledView";
    public static final String CHILD_SS_FILE_NAME_TEXT = "fileNameText";
    public static final String CHILD_SS_FILE_NAME_LINK_STATIC = "fileNameLinkStatic";
    public static final String CHILD_SS_FILE_NAME_VALUE = "fileNameValue";
    public static final String CHILD_SS_FILE_DATE_TEXT = "fileDateText";
    public static final String CHILD_SS_FILE_SIZE_TEXT = "fileSizeText";
    public static final String CHILD_SS_NUM_ENTRIES_TEXT = "numEntriesText";
    public static final String CHILD_SS_INDEXED = "indexedText";
    public static final String CHILD_SS_COMPRESSED = "compressedText";
    public static final String CHILD_SS_SNAPSHOT_STATUS = "snapshotStatus";
    public static final String CHILD_SS_RETENTION_BOX = "retentionBox";
    public static final String CHILD_SS_RETENTION_VALUE = "retentionValue";
    public static final String CHILD_SS_RETENTION_ROW_IDX = "retainPermanentRowIdx";
    public static final String CHILD_SS_CREATE_INDEX_PROMPT = "createIndexPrompt";
    public static final String CHILD_SS_DELETE_INDEX_PROMPT = "deleteIndexPrompt";
    public static final String CHILD_SS_DELETE_DUMP_PROMPT = "deleteDumpPrompt";
    public static final String SS_STATUS_INDEXED = "indexed";
    public static final String SS_STATUS_PROCESSING = "processing";
    public static final String SS_STATUS_UNINDEXED = "unindexed";
    public static final String CHILD_SS_DELETE_SS = "deleteDump";
    public static final String COL_SC_ENTRY_NAME = "colEntryName";
    public static final String COL_SC_MODE = "colMode";
    public static final String COL_SC_SIZE = "colSize";
    public static final String COL_SC_OWNER = "colOwner";
    public static final String COL_SC_GROUP = "colGroup";
    public static final String COL_SC_DATE_MOD = "colDateMod";
    public static final String COL_SC_DATE_CREATE = "colDateCreate";
    public static final String COL_SC_DAMAGED = "colDamaged";
    public static final String COL_SC_ONLINE = "colOnline";
    public static final String CHILD_SC_ALERT = "snapshotContentsAlert";
    public static final String CHILD_SC_ACTION_TABLE = "snapshotContentsTable";
    public static final String CHILD_SC_TILED_VIEW = "snapshotContentsTableTiledView";
    public static final String CHILD_SC_TABLE_MODE = "snapshotContentsTableMode";
    public static final String TABLE_MODE_SEARCH = "search";
    public static final String TABLE_MODE_SEARCHING = "searchInProgress";
    public static final String TABLE_MODE_BROWSE = "browse";
    public static final String CHILD_SC_UP_ONE_LEVEL = "upOneLevel";
    public static final String CHILD_SC_GO_TO_DIRECTORY = "goToDirectory";
    public static final String CHILD_SC_FILTER_SEARCH = "filterSearch";
    public static final String CHILD_SC_TOGGLE_MODE = "toggleMode";
    public static final String CHILD_SC_ENTRY_NAME_TEXT = "entryNameText";
    public static final String CHILD_SC_ENTRY_NAME_LINK_STATIC = "entryNameLinkStatic";
    public static final String CHILD_SC_ENTRY_NAME_VALUE = "entryNameValue";
    public static final String CHILD_SC_ENTRY_NAME_ICON = "entryNameIcon";
    public static final String CHILD_SC_ENTRY_NAME_ICON_LINKABLE = "entryNameIconLinkable";
    public static final String CHILD_SC_MODE_TEXT = "modeText";
    public static final String CHILD_SC_SIZE_TEXT = "sizeText";
    public static final String CHILD_SC_OWNER_TEXT = "ownerText";
    public static final String CHILD_SC_GROUP_TEXT = "groupText";
    public static final String CHILD_SC_DATE_MOD_TEXT = "dateModText";
    public static final String CHILD_SC_DATE_CREATE_TEXT = "dateCreateText";
    public static final String CHILD_SC_DAMAGED_TEXT = "damagedText";
    public static final String CHILD_SC_ONLINE_TEXT = "onlineText";
    public static final String CHILD_SC_ENTRY_STAGE_OPTIONS = "entryStageOptions";
    public static final String CHILD_SC_UNPAGINATED_PROMPT = "unpaginatedTablePrompt";
    private static final String DIR_ICON_SRC = "/samqfsui/images/folder.gif";
    private static final String FILE_ICON_SRC = "/samqfsui/images/file.gif";
    private static final String BLANK_ICON_SRC = "/samqfsui/com_sun_web_ui/images/other/dot.gif";
    private long searchOrRestoreJobId = -1L;
    private boolean searchModeOn = false;
    private String curBrowsePath = "";
    private Filter curSearchCriteria = null;
    private Filter filter = null;
    private int maxEntries = 0;
    public static final String CHILD_RESTORE_ALERT = "restoreAlert";
    public static final String CHILD_RESTORE_TYPE = "restoreTypeValue";
    public static final String RESTORE_TYPE_FS = "filesystem";
    public static final String RESTORE_TYPE_FILE = "file";
    public static final String CHILD_FILE_TO_RESTORE = "fileToRestoreHidden";
    public static final String CHILD_RESTORE_PATH = "restoreToPathnameValue";
    public static final String CHILD_REPLACETYPE_PROP = "replaceTypeProp";
    public static final String CHILD_REPLACETYPE_VALUE = "replaceTypeValue";
    public static final String CHILD_STAGE_OPTIONS = "stageOptionsValue";
    public static final String STAGE_OPTION_DONT_STAGE = "dontStage";
    public static final String STAGE_OPTION_SYSTEM_PICK = "systemPick";
    public static final String STAGE_OPTION_ASINDUMP = "asInDump";
    public static final String STAGE_OPTION_COPY0 = "copy0";
    public static final String STAGE_OPTION_COPY1 = "copy1";
    public static final String STAGE_OPTION_COPY2 = "copy2";
    public static final String STAGE_OPTION_COPY3 = "copy3";
    public static final String CHILD_ENTIRE_FS_PROMPT = "restoreEntireFSPrompt";
    public static final String CHILD_RESTORE = "restore";
    public static final String CHILD_SS_ROOT_NOTATION = "snapshotRootNotation";
    public static final String CHILD_MOUNT_POINT = "fsMountPoint";
    public static final String SNAPSHOT_FILE_NAME = "snapshotFileName";
    public static final String SEARCH_MODE_ON = "searchModeOn";
    public static final String CURRENT_SNAPSHOT_PATH = "currentSnapshotPath";
    public static final String CURRENT_BROWSE_PATH = "currentBrowsePath";
    public static final String SEARCH_CRITERIA = "searchCriteria";
    public static final String MAX_ENTRIES = "maxEntriesRetrieved";
    public static final String CURRENT_FILTER = "currentFilter";
    public static final String FIRST_SEARCH = "firstSearch";
    public static final String[] PAGE_ATTRS = new String[]{"snapshotFileName", "searchModeOn", "currentSnapshotPath", "currentBrowsePath", "searchCriteria", "maxEntriesRetrieved", "currentFilter", "firstSearch"};
    private FsmVersion version45 = null;
    public static final int DEFAULT_MAX_ENTRIES_VALUE = 500;
    private String fileSystemName = "";
    private String snapshotFileName;
    private String snapshotDirectory;
    private String serverName;
    private SamQFSSystemModel sysModel;
    private SamQFSSystemFSManager fsMgr;
    private FSRestoreViewBean vb;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTiledView;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotContentsTiledView;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTable;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean;

    public FSRestoreView(View parent, String name) {
        super(parent, name);
        TraceUtil.trace3("Entering");
        this.vb = (FSRestoreViewBean)this.getParentViewBean();
        this.serverName = this.vb.getServerName();
        try {
            this.sysModel = SamUtil.getModel(this.serverName);
        }
        catch (SamFSException e) {
            TraceUtil.trace1("Unable to obtain system model for server " + this.serverName, e);
            SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "FSRestoreView constructor", "Unable to get system model", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSRestore.error.failedPageDisplay", e.getSAMerrno(), e.getMessage(), this.serverName);
        }
        this.fsMgr = this.sysModel.getSamQFSSystemFSManager();
        this.fileSystemName = (String)this.vb.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        this.version45 = new FsmVersion("4.5", this.serverName);
        pageTitleModel = PageTitleUtil.createModel("/jsp/fs/FSRestorePageTitle.xml");
        pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSRestore.pageTitle", this.fileSystemName));
        this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/FSRestorePropSheet.xml");
        this.createSummaryTableModel();
        this.createContentsTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    private String getMountPoint() throws SamFSException {
        return this.fsMgr.getFileSystem(this.fileSystemName).getMountPoint();
    }

    private void createSummaryTableModel() {
        String xmlFile = null;
        xmlFile = this.version45.isAPICompatibleWithUI() ? "jsp/fs/FSRestoreSnapshotSummaryTable.xml" : "jsp/fs/FSRestoreSnapshotSummaryTable44.xml";
        this.snapshotSummaryTableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.propertySheetModel.setModel(CHILD_SS_ACTION_TABLE, (Object)this.snapshotSummaryTableModel);
    }

    private void createContentsTableModel() {
        String xmlFile = null;
        xmlFile = this.version45.isAPICompatibleWithUI() ? "jsp/fs/FSRestoreSnapshotContentsTable.xml" : "jsp/fs/FSRestoreSnapshotContentsTable44.xml";
        this.snapshotContentsTableModel = new FSRestoreSnapshotContentsModel(RequestManager.getRequestContext().getServletContext(), xmlFile, new FSRestoreSnapshotContentsData(this.fsMgr));
        this.propertySheetModel.setModel(CHILD_SC_ACTION_TABLE, (Object)this.snapshotContentsTableModel);
    }

    private void createSSPathFileChooserModel() {
        TraceUtil.trace3("Entering");
        if (this.selectSnapshotPathModel == null) {
            this.selectSnapshotPathModel = new RemoteFileChooserModel(this.serverName, 50);
            this.selectSnapshotPathModel.setFileListBoxHeight(15);
            this.selectSnapshotPathModel.setHomeDirectory("/");
            this.selectSnapshotPathModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.selectSnapshotPathModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.selectSnapshotPathModel.setPopupMode(true);
        }
        TraceUtil.trace3("Exiting");
    }

    private void createRestorePathFileChooserModel() {
        TraceUtil.trace3("Entering");
        if (this.restorePathModel == null) {
            this.restorePathModel = new RemoteFileChooserModel(this.serverName, 50);
            this.restorePathModel.setFileListBoxHeight(15);
            this.restorePathModel.setHomeDirectory("/");
            this.restorePathModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.restorePathModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.restorePathModel.setPopupMode(true);
        }
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSRestoreView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_SS_TILED_VIEW, class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTiledView == null ? (class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTiledView = FSRestoreView.class$("com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotSummaryTiledView")) : class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTiledView);
        this.registerChild(CHILD_SC_TILED_VIEW, class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotContentsTiledView == null ? (class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotContentsTiledView = FSRestoreView.class$("com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotContentsTiledView")) : class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotContentsTiledView);
        this.registerChild(CHILD_JOBID_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSRestoreView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_SS_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSRestoreView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_SC_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSRestoreView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_RESTORE_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSRestoreView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_POPUP_HIDDEN, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSRestoreView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_RESTORE_TYPE_PROMPT, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSRestoreView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_ENTIRE_FS_STAGE_OPTIONS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSRestoreView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_POST_SELECT_SS_PATH_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSRestoreView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_SS_RETENTION_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSRestoreView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_CHANGE_DIR_SUBMIT_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSRestoreView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_FILTER_SUBMIT_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSRestoreView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_SEARCH_SUBMIT_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSRestoreView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_POST_RESTORE_PATH_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSRestoreView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_SELECT_SS_PATH, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSRestoreView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CHILD_RESTORE_PATH, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSRestoreView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CHILD_SS_ACTION_TABLE, class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTable == null ? (class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTable = FSRestoreView.class$("com.sun.netstorage.samqfs.web.fs.FSRestoreSnapshotSummaryTable")) : class$com$sun$netstorage$samqfs$web$fs$FSRestoreSnapshotSummaryTable);
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering with name" + name);
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            child.setValue((Object)"info");
            return child;
        }
        if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            Object child;
            if (name.equals(CHILD_SS_ALERT) || name.equals(CHILD_SC_ALERT) || name.equals(CHILD_RESTORE_ALERT)) {
                child = new CCAlertInline((ContainerView)this, name, null);
            } else if (name.equals(CHILD_SELECT_SS_PATH)) {
                this.createSSPathFileChooserModel();
                child = new RemoteFileChooserControl((ContainerView)this, this.selectSnapshotPathModel, name);
            } else if (name.equals(CHILD_RESTORE_PATH)) {
                this.createRestorePathFileChooserModel();
                child = new RemoteFileChooserControl((ContainerView)this, this.restorePathModel, name);
            } else {
                child = name.equals(CHILD_SS_ACTION_TABLE) ? new FSRestoreSnapshotSummaryTable((ContainerView)this, (CCActionTableModelInterface)this.snapshotSummaryTableModel, name) : PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
            }
            if (name.equals(CHILD_SS_ACTION_TABLE)) {
                FSRestoreSnapshotSummaryTable ssTable = (FSRestoreSnapshotSummaryTable)((Object)child);
                ssTable.setTiledView((ContainerView)this.getChild(CHILD_SS_TILED_VIEW));
            } else if (name.equals(CHILD_SC_ACTION_TABLE)) {
                CCActionTable ssTable = (CCActionTable)child;
                ssTable.setTiledView((ContainerView)this.getChild(CHILD_SC_TILED_VIEW));
            }
            return child;
        }
        if (name.equals(CHILD_SS_TILED_VIEW)) {
            return new FSRestoreSnapshotSummaryTiledView((View)this, this.snapshotSummaryTableModel, name);
        }
        if (name.equals(CHILD_SC_TILED_VIEW)) {
            return new FSRestoreSnapshotContentsTiledView((View)this, this.snapshotContentsTableModel, name);
        }
        if (name.equals(CHILD_POPUP_HIDDEN) || name.equals(CHILD_RESTORE_TYPE_PROMPT) || name.equals(CHILD_ENTIRE_FS_STAGE_OPTIONS)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_CHANGE_DIR_SUBMIT_CMD) || name.equals(CHILD_POST_SELECT_SS_PATH_CMD) || name.equals(CHILD_POST_RESTORE_PATH_CMD) || name.equals(CHILD_SS_RETENTION_CMD) || name.equals(CHILD_FILTER_SUBMIT_CMD) || name.equals(CHILD_SEARCH_SUBMIT_CMD)) {
            return new BasicCommandField((View)this, name);
        }
        if (name.equals(CHILD_JOBID_HREF)) {
            return new CCHref((ContainerView)this, name, null);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        try {
            TraceUtil.trace3("Loading snapshot summary section.");
            this.loadSnapshotSummary();
            TraceUtil.trace3("Loading snapshot contents section.");
            this.loadSnapshotContents(false);
            TraceUtil.trace3("Loading restore section.");
            this.loadRestoreSection();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "beginDisplay()", "Unable to get load restore page", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSRestore.error.failedPageDisplay", ex.getSAMerrno(), ex.getMessage(), this.serverName);
            this.propertySheetModel.setVisible(SECTION_SS_SUMMARY, false);
            this.propertySheetModel.setVisible("snapshotContents", false);
            this.propertySheetModel.setVisible("restoreFile", false);
        }
        TraceUtil.trace3("Exiting");
    }

    public void loadSnapshotSummary() throws ModelControlException, SamFSException {
        RestoreDumpFile[] dumpFiles;
        this.snapshotSummaryTableModel.clear();
        this.snapshotSummaryTableModel.setActionValue(COL_SS_FILE_NAME, (Object)"FSRestore.snapshotSummary.colFileName");
        this.snapshotSummaryTableModel.setActionValue(COL_SS_FILE_DATE, (Object)"FSRestore.snapshotSummary.colFileDate");
        this.snapshotSummaryTableModel.setActionValue(COL_SS_FILE_SIZE, (Object)"FSRestore.snapshotSummary.colFileSize");
        this.snapshotSummaryTableModel.setActionValue(COL_SS_NUM_ENTRIES, (Object)"FSRestore.snapshotSummary.colNumEntries");
        this.snapshotSummaryTableModel.setActionValue(COL_SS_INDEXED, (Object)"FSRestore.snapshotSummary.colIndexed");
        this.snapshotSummaryTableModel.setActionValue(COL_SS_COMPRESSED, (Object)"FSRestore.snapshotSummary.colCompressed");
        if (this.version45.isAPICompatibleWithUI()) {
            this.snapshotSummaryTableModel.setActionValue(COL_SS_RETENTION, (Object)"FSRestore.snapshotSummary.colRetention");
        }
        this.setDisplayFieldValue(CHILD_SS_CREATE_INDEX_PROMPT, SamUtil.getResourceString("FSRestore.snapshotSummary.createIndexPrompt"));
        this.setDisplayFieldValue(CHILD_SS_DELETE_INDEX_PROMPT, SamUtil.getResourceString("FSRestore.snapshotSummary.deleteIndexPrompt"));
        this.setDisplayFieldValue(CHILD_SS_DELETE_DUMP_PROMPT, SamUtil.getResourceString("FSRestore.snapshotSummary.deleteDumpPrompt"));
        DumpSched schedule = this.fsMgr.getMetadataDumpSchedParams(this.fileSystemName);
        this.snapshotDirectory = (String)this.vb.getPageSessionAttribute("currentSnapshotPath");
        if (this.snapshotDirectory == null) {
            this.snapshotDirectory = schedule != null ? schedule.getLocation() : this.fsMgr.getFileSystem(this.fileSystemName).getMountPoint();
            this.vb.setPageSessionAttribute("currentSnapshotPath", (Serializable)((Object)this.snapshotDirectory));
            this.vb.setPageSessionAttribute(SNAPSHOT_FILE_NAME, null);
        }
        RemoteFileChooserControl chooser = (RemoteFileChooserControl)this.getChild(CHILD_SELECT_SS_PATH);
        chooser.setDisplayFieldValue("pathHidden", this.snapshotDirectory);
        this.setDisplayFieldValue(CHILD_CUR_SS_PATH_VALUE, this.snapshotDirectory);
        this.snapshotSummaryTableModel.setTitle(SamUtil.getResourceString("FSRestore.snapshotSummary.tableTitle", this.snapshotDirectory));
        CCButton deleteDump = (CCButton)this.getChild(CHILD_SS_DELETE_SS);
        if (!this.version45.isAPICompatibleWithUI()) {
            deleteDump.setVisible(false);
            this.propertySheetModel.setVisible("currentSnapshotPath", false);
        }
        if ((dumpFiles = this.fsMgr.getAvailableDumpFiles(this.fileSystemName, this.snapshotDirectory)).length == 0) {
            SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "FSRestore.snapshotSummary.info.noDumpFilesSummary", SamUtil.getResourceString("FSRestore.snapshotSummary.info.noDumpFilesDetail", this.snapshotDirectory));
            return;
        }
        this.snapshotFileName = (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME);
        DateFormat dfmt = DateFormat.getDateTimeInstance(3, 3);
        CCActionTable child = (CCActionTable)this.getChild(CHILD_SS_ACTION_TABLE);
        CCRadioButton radioButton = (CCRadioButton)child.getChild("SelectionRadiobutton");
        radioButton.setTitle("");
        radioButton.setTitleDisabled("");
        child.restoreStateData();
        int maxRows = 25;
        int pageNum = this.snapshotSummaryTableModel.getPage();
        if (pageNum < 1) {
            pageNum = 1;
        }
        int lastRow = maxRows * pageNum;
        int firstRow = lastRow - maxRows + 1;
        for (int i = 0; i < dumpFiles.length; ++i) {
            RestoreDumpFile dumpFile = dumpFiles[i];
            this.snapshotSummaryTableModel.appendRow();
            if (this.snapshotFileName == null) {
                if (i + 1 >= firstRow && i + 1 <= lastRow && dumpFile.isAvailable()) {
                    this.snapshotFileName = dumpFile.getFileName();
                    this.vb.setPageSessionAttribute(SNAPSHOT_FILE_NAME, (Serializable)((Object)this.snapshotFileName));
                    this.snapshotSummaryTableModel.setRowSelected(true);
                }
            } else if (this.snapshotFileName.equals(dumpFile.getFileName())) {
                this.snapshotSummaryTableModel.setRowSelected(true);
            }
            if (dumpFile.isProcessing()) {
                this.snapshotSummaryTableModel.setValue(CHILD_SS_INDEXED, (Object)SamUtil.getResourceString("FSRestore.snapshotSummary.status.processing"));
                this.snapshotSummaryTableModel.setValue(CHILD_SS_COMPRESSED, (Object)SamUtil.getResourceString("FSRestore.snapshotSummary.status.processing"));
            } else {
                if (dumpFile.isIndexed()) {
                    this.snapshotSummaryTableModel.setValue(CHILD_SS_INDEXED, (Object)SamUtil.getResourceString("samqfsui.yes"));
                } else {
                    this.snapshotSummaryTableModel.setValue(CHILD_SS_INDEXED, (Object)SamUtil.getResourceString("samqfsui.no"));
                }
                if (dumpFile.isCompressed()) {
                    this.snapshotSummaryTableModel.setValue(CHILD_SS_COMPRESSED, (Object)SamUtil.getResourceString("samqfsui.yes"));
                } else {
                    this.snapshotSummaryTableModel.setValue(CHILD_SS_COMPRESSED, (Object)SamUtil.getResourceString("samqfsui.no"));
                }
            }
            if (dumpFile.isAvailable()) {
                this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_NAME_LINK_STATIC, (Object)dumpFile.getFileName());
                this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_NAME_TEXT, (Object)"");
                this.snapshotSummaryTableModel.setValue(CHILD_SS_SNAPSHOT_STATUS, (Object)SS_STATUS_INDEXED);
            } else {
                this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_NAME_LINK_STATIC, (Object)"");
                this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_NAME_TEXT, (Object)dumpFile.getFileName());
                if (dumpFile.isProcessing()) {
                    this.snapshotSummaryTableModel.setValue(CHILD_SS_SNAPSHOT_STATUS, (Object)SS_STATUS_PROCESSING);
                } else {
                    this.snapshotSummaryTableModel.setValue(CHILD_SS_SNAPSHOT_STATUS, (Object)SS_STATUS_UNINDEXED);
                }
            }
            this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_NAME_VALUE, (Object)dumpFile.getFileName());
            this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_DATE_TEXT, (Object)dfmt.format(dumpFile.getModTime().getTime()));
            Capacity dumpFileSize = new Capacity(ConversionUtil.strToLongVal(dumpFile.getSize()), 0);
            this.snapshotSummaryTableModel.setValue(CHILD_SS_FILE_SIZE_TEXT, (Object)dumpFileSize);
            if (!this.version45.isAPICompatibleWithUI()) continue;
            if (dumpFile.getNumEntries() != null) {
                this.snapshotSummaryTableModel.setValue(CHILD_SS_NUM_ENTRIES_TEXT, (Object)dumpFile.getNumEntries().toString());
            } else {
                this.snapshotSummaryTableModel.setValue(CHILD_SS_NUM_ENTRIES_TEXT, (Object)"");
            }
            this.snapshotSummaryTableModel.setValue(CHILD_SS_RETENTION_VALUE, (Object)Boolean.toString(dumpFile.isLocked()));
        }
        if (this.version45.isAPICompatibleWithUI()) {
            CCCheckBox retainBox = (CCCheckBox)this.getChild(CHILD_SS_RETENTION_BOX);
            retainBox.setCheckedValue((Object)Boolean.toString(true));
        }
    }

    public void loadSnapshotContents(boolean recursiveCall) throws SamFSException, ModelControlException {
        this.loadSnapshotContentsNonTable();
        this.loadSnapshotContentsTable(recursiveCall);
    }

    /*
     * WARNING - void declaration
     */
    private void loadSnapshotContentsNonTable() {
        if (this.snapshotFileName != null) {
            this.propertySheetModel.setValue("snapshotContents", (Object)SamUtil.getResourceString("FSRestore.snapshotContents.sectionTitle", this.snapshotFileName));
        } else {
            this.propertySheetModel.setValue("snapshotContents", (Object)SamUtil.getResourceString("FSRestore.snapshotContents.sectionTitleShort"));
        }
        Boolean searchModeOnBool = (Boolean)this.vb.getPageSessionAttribute(SEARCH_MODE_ON);
        if (searchModeOnBool != null && searchModeOnBool.booleanValue() && this.snapshotFileName != null) {
            this.searchModeOn = true;
        }
        this.curSearchCriteria = (Filter)this.vb.getPageSessionAttribute(SEARCH_CRITERIA);
        this.filter = (Filter)this.vb.getPageSessionAttribute(CURRENT_FILTER);
        CCButton clearFilter = (CCButton)this.getChild(CHILD_FILTER_CLEAR);
        if (this.searchModeOn) {
            this.propertySheetModel.setVisible(PROPERTY_CURRENT_PATH, false);
            clearFilter.setVisible(false);
            this.setDisplayFieldValue(CHILD_FILTER_CRITERIA_LABEL, SamUtil.getResourceString("FSRestore.snapshotContents.searchCriteria"));
            if (this.curSearchCriteria != null) {
                this.setDisplayFieldValue(CHILD_FILTER_CRITERIA_VALUE, this.curSearchCriteria.getDisplayString());
            }
        }
        this.curBrowsePath = "";
        if (!this.searchModeOn) {
            this.propertySheetModel.setVisible(PROPERTY_CURRENT_PATH, true);
            this.curBrowsePath = (String)this.vb.getPageSessionAttribute(CURRENT_BROWSE_PATH);
            if (this.snapshotFileName == null) {
                this.curBrowsePath = "";
            }
            if (this.curBrowsePath == null) {
                this.curBrowsePath = this.fsMgr.getDumpFileTopLevelDirectory(this.fileSystemName, this.snapshotDirectory, this.snapshotFileName);
                this.vb.setPageSessionAttribute(CURRENT_BROWSE_PATH, (Serializable)((Object)this.curBrowsePath));
            }
            this.setDisplayFieldValue(CHILD_CUR_PATH_VALUE, this.getDisplaySSContentPath(this.curBrowsePath));
            this.setDisplayFieldValue(CHILD_CUR_PATH_HIDDEN, this.curBrowsePath);
            this.setDisplayFieldValue(CHILD_FILTER_CRITERIA_LABEL, SamUtil.getResourceString("FSRestore.snapshotContents.filterApplied"));
            if (this.filter != null) {
                this.setDisplayFieldValue(CHILD_FILTER_CRITERIA_VALUE, this.filter.getDisplayString());
            } else {
                this.propertySheetModel.setVisible(PROPERTY_FILTER, false);
            }
        }
        this.maxEntries = this.getMaxEntries();
        CCTextField maxEntriesValue = (CCTextField)this.getChild(CHILD_MAX_ENTRIES);
        maxEntriesValue.setValue((Object)String.valueOf(this.maxEntries));
        this.propertySheetModel.setValue(CHILD_SC_UNPAGINATED_PROMPT, (Object)SamUtil.getResourceString("FSRestore.snapshotContents.unpaginatedPrompt"));
        CCButton restore = (CCButton)this.getChild(CHILD_RESTORE);
        CCRadioButton restoreType = (CCRadioButton)this.getChild(CHILD_RESTORE_TYPE);
        CCDropDownMenu replaceType = (CCDropDownMenu)this.getChild(CHILD_REPLACETYPE_VALUE);
        replaceType.setValue((Object)String.valueOf(0));
        CCDropDownMenu stageOptions = (CCDropDownMenu)this.getChild(CHILD_STAGE_OPTIONS);
        this.searchOrRestoreJobId = this.isSearchOrRestoreRunningNow();
        if (this.searchOrRestoreJobId > 0L) {
            String jobIdHrefHtml = "";
            try {
                BaseJob job = this.sysModel.getSamQFSSystemJobManager().getJobById(this.searchOrRestoreJobId);
                if (job == null) {
                    jobIdHrefHtml = String.valueOf(this.searchOrRestoreJobId);
                } else {
                    void var11_12;
                    String jobTypeStr;
                    int jobType = job.getType();
                    if (jobType == 23) {
                        jobTypeStr = "Jobs.jobType.restore";
                    } else if (jobType == 22) {
                        jobTypeStr = "Jobs.jobType.restoreSearch";
                    } else {
                        throw new SamFSException("Unrecognized job type: " + String.valueOf(jobType));
                    }
                    jobIdHrefHtml = this.getJobIdHrefTag(this.searchOrRestoreJobId, (String)var11_12);
                }
            }
            catch (SamFSException e) {
                SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "loadSnapshotContents()", "Failed to get search or restore job info.", this.serverName);
                TraceUtil.trace1("Can't create job id link in alert", e);
                jobIdHrefHtml = String.valueOf(this.searchOrRestoreJobId);
            }
            CCAlertInline alertChild = (CCAlertInline)this.getChild(CHILD_SC_ALERT);
            if (alertChild.getSummary() == null && this.searchModeOn) {
                SamUtil.setInfoAlert((ContainerView)this, CHILD_SC_ALERT, SamUtil.getResourceString("FSRestore.snapshotContents.searchAlert.summary"), SamUtil.getResourceString("FSRestore.snapshotContents.searchAlert.detail", new String[]{String.valueOf(this.searchOrRestoreJobId), jobIdHrefHtml, this.getRefreshHtml("snapshotContents")}), this.serverName);
            }
            if ((alertChild = (CCAlertInline)this.getChild(CHILD_RESTORE_ALERT)).getSummary() == null) {
                SamUtil.setInfoAlert((ContainerView)this, CHILD_RESTORE_ALERT, SamUtil.getResourceString("FSRestore.snapshotContents.searchAlert.summary"), SamUtil.getResourceString("FSRestore.snapshotContents.searchAlert.detail", new String[]{String.valueOf(this.searchOrRestoreJobId), jobIdHrefHtml, this.getRefreshHtml("restoreFile")}), this.serverName);
            }
            restore.setDisabled(true);
            restoreType.setDisabled(true);
            replaceType.setDisabled(true);
            stageOptions.setDisabled(true);
        } else {
            restore.setDisabled(false);
            restoreType.setDisabled(false);
            replaceType.setDisabled(false);
            stageOptions.setDisabled(false);
        }
    }

    private void loadSnapshotContentsTable(boolean recursiveCall) throws SamFSException, ModelControlException {
        NonSyncStringBuffer onClickHandler;
        if (this.curBrowsePath.length() == 0) {
            this.snapshotContentsTableModel.setTitle(SamUtil.getResourceString("FSRestore.snapshotContents.tableTitle"));
        } else {
            this.snapshotContentsTableModel.setTitle(SamUtil.getResourceString("FSRestore.snapshotContents.tableTitleWithPath", this.getDisplaySSContentPath(this.curBrowsePath)));
        }
        this.snapshotContentsTableModel.clear();
        this.snapshotContentsTableModel.setActionValue(COL_SC_ENTRY_NAME, "FSRestore.snapshotContents.colEntryName");
        this.snapshotContentsTableModel.setActionValue(COL_SC_MODE, "FSRestore.snapshotContents.colMode");
        this.snapshotContentsTableModel.setActionValue(COL_SC_SIZE, "FSRestore.snapshotContents.colSize");
        this.snapshotContentsTableModel.setActionValue(COL_SC_OWNER, "FSRestore.snapshotContents.colOwner");
        this.snapshotContentsTableModel.setActionValue(COL_SC_GROUP, "FSRestore.snapshotContents.colGroup");
        this.snapshotContentsTableModel.setActionValue(COL_SC_DATE_MOD, "FSRestore.snapshotContents.colDateMod");
        this.snapshotContentsTableModel.setActionValue(COL_SC_DATE_CREATE, "FSRestore.snapshotContents.colDateCreate");
        if (this.version45.isAPICompatibleWithUI()) {
            this.snapshotContentsTableModel.setActionValue(COL_SC_DAMAGED, "FSRestore.snapshotContents.colDamaged");
            this.snapshotContentsTableModel.setActionValue(COL_SC_ONLINE, "FSRestore.snapshotContents.colOnline");
        }
        CCActionTable scTable = (CCActionTable)this.getChild(CHILD_SC_ACTION_TABLE);
        CCRadioButton radioButton = (CCRadioButton)scTable.getChild("SelectionRadiobutton");
        radioButton.setTitle("");
        radioButton.setTitleDisabled("");
        CCButton upOne = (CCButton)this.getChild(CHILD_SC_UP_ONE_LEVEL);
        CCButton goToDir = (CCButton)this.getChild(CHILD_SC_GO_TO_DIRECTORY);
        CCButton filterSearch = (CCButton)this.getChild(CHILD_SC_FILTER_SEARCH);
        CCButton toggleMode = (CCButton)this.getChild(CHILD_SC_TOGGLE_MODE);
        toggleMode.setDisabled(false);
        if (this.searchModeOn) {
            upOne.setDisabled(true);
            goToDir.setDisabled(true);
            filterSearch.setDisplayLabel(SamUtil.getResourceString("FSRestore.snapshotContents.newSearch"));
            if (this.searchOrRestoreJobId <= 0L) {
                filterSearch.setDisabled(false);
                onClickHandler = new NonSyncStringBuffer().append("onClick=\"return showFilterSettingsPopup(").append("'FSRestoreForm', ").append("'FSRestore.FSRestoreView.popupReturnValueHidden', ").append("'FSRestore.FSRestoreView.searchSubmitCmd=#").append("snapshotContents").append("', ").append("'FSRestore.searchSnapshot.pageTitle', ").append("'FSRestore.searchSnapshot.promptText', ").append("'");
                if (this.curSearchCriteria == null) {
                    this.curSearchCriteria = this.version45.isAPICompatibleWithUI() ? new Filter(2) : new Filter(1);
                }
                try {
                    onClickHandler.append(this.curSearchCriteria.writeEncodedString());
                }
                catch (UnsupportedEncodingException e) {
                    TraceUtil.trace1("Can't read search criteria encoded string", e);
                }
                onClickHandler.append("');\"");
                filterSearch.setExtraHtml(onClickHandler.toString());
            } else {
                filterSearch.setDisabled(true);
            }
            toggleMode.setDisplayLabel(SamUtil.getResourceString("FSRestore.snapshotContents.toggleBrowse"));
        } else {
            if (this.curBrowsePath.equals(this.fsMgr.getDumpFileTopLevelDirectory(this.fileSystemName, this.snapshotDirectory, this.snapshotFileName))) {
                upOne.setDisabled(true);
            } else {
                upOne.setDisabled(false);
            }
            goToDir.setDisabled(false);
            filterSearch.setDisplayLabel(SamUtil.getResourceString("FSRestore.snapshotContents.filter"));
            filterSearch.setDisabled(false);
            onClickHandler = new NonSyncStringBuffer().append("onClick=\"return showFilterSettingsPopup(").append("'FSRestoreForm', ").append("'FSRestore.FSRestoreView.popupReturnValueHidden', ").append("'FSRestore.FSRestoreView.filterSubmitCmd=#").append("snapshotContents").append("', ").append("'FSRestore.filterSnapshot.pageTitle', ").append("'FSRestore.filterSnapshot.promptText', ").append("'");
            if (this.filter == null) {
                this.filter = this.version45.isAPICompatibleWithUI() ? new Filter(2) : new Filter(1);
            }
            try {
                onClickHandler.append(this.filter.writeEncodedString());
            }
            catch (UnsupportedEncodingException e) {
                TraceUtil.trace1("Can't read filter encoded string", e);
            }
            onClickHandler.append("');\"");
            filterSearch.setExtraHtml(onClickHandler.toString());
            toggleMode.setDisplayLabel(SamUtil.getResourceString("FSRestore.snapshotContents.toggleSearch"));
        }
        RestoreFile[] restoreFiles = null;
        if (this.snapshotFileName == null) {
            upOne.setDisabled(true);
            goToDir.setDisabled(true);
            filterSearch.setDisabled(true);
            toggleMode.setDisabled(true);
        } else {
            try {
                scTable.restoreStateData();
                if (this.searchModeOn) {
                    if (this.searchOrRestoreJobId <= 0L) {
                        restoreFiles = this.snapshotContentsTableModel.getSearchResults(this.fileSystemName);
                    }
                } else {
                    restoreFiles = this.snapshotContentsTableModel.getDumpFileContents(this.fileSystemName, this.snapshotDirectory, this.snapshotFileName, this.curBrowsePath, this.filter, this.maxEntries);
                }
            }
            catch (SamFSException e) {
                if (recursiveCall) {
                    throw e;
                }
                SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "loadSnapshotContents", "Unable to retrieve snapshot contents.  Could be an invalid directory.", this.serverName);
                if (!this.searchModeOn) {
                    SamUtil.setErrorAlert((ContainerView)this, CHILD_SC_ALERT, SamUtil.getResourceString("FSRestore.snapshotContents.error.cantGetContents", this.curBrowsePath), e.getSAMerrno(), e.getMessage(), this.serverName);
                    this.vb.setPageSessionAttribute(CURRENT_BROWSE_PATH, null);
                    this.loadSnapshotContents(true);
                    return;
                }
                SamUtil.setErrorAlert((ContainerView)this, CHILD_SC_ALERT, SamUtil.getResourceString("FSRestore.snapshotContents.error.cantGetSearch", this.curBrowsePath), e.getSAMerrno(), e.getMessage(), this.serverName);
                return;
            }
        }
        if (restoreFiles == null) {
            restoreFiles = new RestoreFile[]{};
        }
        if (restoreFiles.length == 0 && this.searchModeOn) {
            Boolean firstSearch = (Boolean)this.vb.getPageSessionAttribute(FIRST_SEARCH);
            if (this.searchOrRestoreJobId > 0L) {
                this.snapshotContentsTableModel.setEmpty(SamUtil.getResourceString("FSRestore.searchSnapshot.emptyTable.inProgress"));
            } else if (firstSearch == null || firstSearch.booleanValue()) {
                this.snapshotContentsTableModel.setEmpty(SamUtil.getResourceString("FSRestore.searchSnapshot.emptyTable.notStarted"));
            } else {
                this.snapshotContentsTableModel.setEmpty(SamUtil.getResourceString("FSRestore.searchSnapshot.emptyTable.complete"));
            }
        }
        int startIdx = this.snapshotContentsTableModel.getFirstRow() - 1;
        int endIdx = this.snapshotContentsTableModel.getLastRow() - 1;
        if (endIdx >= restoreFiles.length) {
            endIdx = restoreFiles.length - 1;
        }
        for (int i = startIdx; i <= endIdx; ++i) {
            RestoreFile restoreFile = restoreFiles[i];
            this.snapshotContentsTableModel.appendRow();
            CCClientSniffer sniff = new CCClientSniffer(this.getRequestContext().getRequest());
            String blankIcon = "";
            if (sniff.isIe()) {
                blankIcon = BLANK_ICON_SRC;
            }
            if (restoreFile.isDirectory()) {
                if (!this.searchModeOn) {
                    this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_ICON_LINKABLE, DIR_ICON_SRC);
                    this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_ICON, blankIcon);
                } else {
                    this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_ICON_LINKABLE, blankIcon);
                    this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_ICON, DIR_ICON_SRC);
                }
            } else {
                this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_ICON, FILE_ICON_SRC);
                this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_ICON_LINKABLE, blankIcon);
            }
            String fileName = this.searchModeOn ? restoreFile.getAbsolutePath() : restoreFile.getFileName();
            if (restoreFile.isDirectory() && !this.searchModeOn) {
                this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_LINK_STATIC, fileName);
                this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_TEXT, "");
            } else {
                this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_LINK_STATIC, "");
                this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_TEXT, fileName);
            }
            this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_NAME_VALUE, fileName);
            this.snapshotContentsTableModel.setValue(CHILD_SC_MODE_TEXT, restoreFile.getProtection());
            DateFormat dfmt = DateFormat.getDateTimeInstance(3, 3);
            if (restoreFile.getCreationTime() != null) {
                this.snapshotContentsTableModel.setValue(CHILD_SC_DATE_CREATE_TEXT, dfmt.format(restoreFile.getCreationTime().getTime()));
            }
            if (restoreFile.getModTime() != null) {
                this.snapshotContentsTableModel.setValue(CHILD_SC_DATE_MOD_TEXT, dfmt.format(restoreFile.getModTime().getTime()));
            }
            this.snapshotContentsTableModel.setValue(CHILD_SC_GROUP_TEXT, restoreFile.getGroup());
            this.snapshotContentsTableModel.setValue(CHILD_SC_OWNER_TEXT, restoreFile.getUser());
            Capacity fileSize = new Capacity(ConversionUtil.strToLongVal(restoreFile.getSize()), 0);
            this.snapshotContentsTableModel.setValue(CHILD_SC_SIZE_TEXT, fileSize);
            if (this.version45.isAPICompatibleWithUI()) {
                Boolean isDamaged = restoreFile.getIsDamaged();
                if (isDamaged != null) {
                    if (isDamaged.booleanValue()) {
                        this.snapshotContentsTableModel.setValue(CHILD_SC_DAMAGED_TEXT, SamUtil.getResourceString("samqfsui.yes"));
                    } else {
                        this.snapshotContentsTableModel.setValue(CHILD_SC_DAMAGED_TEXT, SamUtil.getResourceString("samqfsui.no"));
                    }
                } else {
                    this.snapshotContentsTableModel.setValue(CHILD_SC_DAMAGED_TEXT, SamUtil.getResourceString(""));
                }
            }
            if (this.version45.isAPICompatibleWithUI()) {
                Boolean isOnline = restoreFile.getIsOnline();
                if (isOnline != null) {
                    if (isOnline.booleanValue()) {
                        this.snapshotContentsTableModel.setValue(CHILD_SC_ONLINE_TEXT, SamUtil.getResourceString("samqfsui.yes"));
                    } else {
                        this.snapshotContentsTableModel.setValue(CHILD_SC_ONLINE_TEXT, SamUtil.getResourceString("samqfsui.no"));
                    }
                } else {
                    this.snapshotContentsTableModel.setValue(CHILD_SC_ONLINE_TEXT, SamUtil.getResourceString(""));
                }
            }
            String[] archCopies = restoreFile.getArchCopies();
            NonSyncStringBuffer archCopiesStr = new NonSyncStringBuffer();
            archCopiesStr.append(FSRestoreView.getStageOptionDisplay(restoreFile, 2000)).append("\t").append(STAGE_OPTION_DONT_STAGE).append("\n").append(FSRestoreView.getStageOptionDisplay(restoreFile, 1000)).append("\t").append(STAGE_OPTION_SYSTEM_PICK).append("\n");
            if (this.version45.isAPICompatibleWithUI()) {
                archCopiesStr.append(FSRestoreView.getStageOptionDisplay(restoreFile, 3000)).append("\t").append(STAGE_OPTION_ASINDUMP).append("\n");
            }
            for (int j = 0; j < archCopies.length; ++j) {
                if (archCopies[j] == null || archCopies[j].length() <= 0) continue;
                archCopiesStr.append(FSRestoreView.getStageOptionDisplay(restoreFile, j)).append("\t");
                switch (j) {
                    case 0: {
                        archCopiesStr.append(STAGE_OPTION_COPY0);
                        break;
                    }
                    case 1: {
                        archCopiesStr.append(STAGE_OPTION_COPY1);
                        break;
                    }
                    case 2: {
                        archCopiesStr.append(STAGE_OPTION_COPY2);
                        break;
                    }
                    case 3: {
                        archCopiesStr.append(STAGE_OPTION_COPY3);
                    }
                }
                archCopiesStr.append("\n");
            }
            this.snapshotContentsTableModel.setValue(CHILD_SC_ENTRY_STAGE_OPTIONS, archCopiesStr.toString());
        }
        this.snapshotContentsTableModel.setRowSelected(false);
    }

    public void loadRestoreSection() throws SamFSException {
        this.setDisplayFieldValue(CHILD_RESTORE_TYPE_PROMPT, SamUtil.getResourceString("FSRestore.restore.type.prompt"));
        this.setDisplayFieldValue(CHILD_ENTIRE_FS_PROMPT, SamUtil.getResourceString("FSRestore.restore.entireFSPrompt"));
        this.setDisplayFieldValue(CHILD_SS_ROOT_NOTATION, SamUtil.getResourceString("FSRestore.snapshotContents.currentPath.rootNotation"));
        this.setDisplayFieldValue(CHILD_MOUNT_POINT, this.getMountPoint());
        if (!this.version45.isAPICompatibleWithUI()) {
            this.propertySheetModel.setVisible(CHILD_REPLACETYPE_PROP, false);
        }
        NonSyncStringBuffer stageOpts = new NonSyncStringBuffer().append(FSRestoreView.getStageOptionDisplay(null, 2000)).append("\t").append(STAGE_OPTION_DONT_STAGE).append("\n").append(FSRestoreView.getStageOptionDisplay(null, 1000)).append("\t").append(STAGE_OPTION_SYSTEM_PICK).append("\n");
        if (this.version45.isAPICompatibleWithUI()) {
            stageOpts.append(FSRestoreView.getStageOptionDisplay(null, 3000)).append("\t").append(STAGE_OPTION_ASINDUMP).append("\n");
        }
        this.setDisplayFieldValue(CHILD_ENTIRE_FS_STAGE_OPTIONS, stageOpts.toString());
    }

    private String getDisplaySSContentPath(String browsePath) {
        if (browsePath != null & browsePath.startsWith(".")) {
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            String notation = SamUtil.getResourceString("FSRestore.snapshotContents.currentPath.rootNotation");
            buf.append(notation).append(browsePath.substring(1));
            return buf.toString();
        }
        return browsePath;
    }

    private int getMaxEntries() {
        int maxEntries = 500;
        String maxEntriesStr = (String)this.vb.getPageSessionAttribute(MAX_ENTRIES);
        if (maxEntriesStr != null) {
            try {
                maxEntries = Integer.parseInt(maxEntriesStr);
            }
            catch (NumberFormatException e) {
                TraceUtil.trace1("An error occurred while parsing max entries value.", e);
            }
        }
        return maxEntries;
    }

    public static String getStageOptionDisplay(RestoreFile file, int stageOption) {
        boolean useAll = false;
        if (file == null || file.isDirectory()) {
            useAll = true;
        }
        if (stageOption == 2000) {
            return SamUtil.getResourceString(useAll ? "FSRestore.restore.stageOptionOffLine.all" : "FSRestore.restore.stageOptionOffLine");
        }
        if (stageOption == 1000) {
            return SamUtil.getResourceString(useAll ? "FSRestore.restore.stageOptionSystemPick.all" : "FSRestore.restore.stageOptionSystemPick");
        }
        if (stageOption == 3000) {
            return SamUtil.getResourceString(useAll ? "FSRestore.restore.stageOptionAsInDump.all" : "FSRestore.restore.stageOptionAsInDump");
        }
        if (file != null && stageOption >= 0 && stageOption <= 3) {
            String[] archCopies = file.getArchCopies();
            if (stageOption < archCopies.length) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer().append(SamUtil.getResourceString(useAll ? "FSRestore.restore.stageOptionArchiveCopy.all" : "FSRestore.restore.stageOptionArchiveCopy")).append(archCopies[stageOption]);
                return buf.toString();
            }
            return SamUtil.getResourceString("FSREstore.restore.error.invalidStageOption", String.valueOf(stageOption));
        }
        return SamUtil.getResourceString("FSREstore.restore.error.invalidStageOption", String.valueOf(stageOption));
    }

    private long isSearchOrRestoreRunningNow() {
        long jobId = -1L;
        try {
            SamQFSSystemJobManager jobMgr = this.sysModel.getSamQFSSystemJobManager();
            BaseJob[] jobs = jobMgr.getJobsByType(22);
            if (jobs != null && jobs.length > 0) {
                jobId = jobs[0].getJobId();
            } else {
                jobs = jobMgr.getJobsByType(23);
                if (jobs != null && jobs.length > 0) {
                    jobId = jobs[0].getJobId();
                }
            }
        }
        catch (SamFSException e) {
            SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "isSearchOrRestoreRunningNow()", "Unable to get job by job id.", this.serverName);
        }
        return jobId;
    }

    public void handleJobIdHrefRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String jobID = this.getDisplayFieldStringValue(CHILD_JOBID_HREF);
        this.vb.setPageSessionAttribute("SAMQFS_JOB_ID", (Serializable)((Object)jobID));
        CommonViewBeanBase targetView = (CommonViewBeanBase)this.getViewBean(class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean = FSRestoreView.class$("com.sun.netstorage.samqfs.web.jobs.JobsDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$jobs$JobsDetailsViewBean);
        BreadCrumbUtil.breadCrumbPathForward((ViewBean)this.vb, PageInfo.getPageInfo().getPageNumber(this.vb.getName()));
        this.vb.forwardToWithAttributes(targetView, PAGE_ATTRS);
        TraceUtil.trace3("Exiting");
    }

    public void handleCreateIndexRequest(RequestInvocationEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        try {
            String dumpFileName = this.getSelectedSnapshotFileName();
            if (dumpFileName != null) {
                String ssPath = (String)this.vb.getPageSessionAttribute("currentSnapshotPath");
                long jobId = this.fsMgr.enableDumpFileForUse(this.fileSystemName, ssPath, dumpFileName);
                BaseJob job = null;
                if (jobId > 0L) {
                    job = this.sysModel.getSamQFSSystemJobManager().getJobById(jobId);
                }
                if (job != null) {
                    String hrefHtml = this.getJobIdHrefTag(jobId, "Jobs.jobType.dumpEnable");
                    SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("FSRestore.snapshotSummary.createIndex.startAlert", new String[]{dumpFileName, String.valueOf(jobId), hrefHtml}), this.serverName);
                } else {
                    SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("FSRestore.snapshotSummary.createIndex.doneAlert", dumpFileName), this.serverName);
                }
            }
            this.snapshotSummaryTableModel.setRowSelected(false);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleCreateIndexRequest()", "Failed to index the snapshot file", this.serverName);
            TraceUtil.trace1("Exception enabling file for use:  " + ex.getMessage());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSRestore.error.failedPageDisplay", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleDeleteIndexRequest(RequestInvocationEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        try {
            String dumpFileName = this.getSelectedSnapshotFileName();
            if (dumpFileName != null) {
                this.fsMgr.cleanDump(this.fileSystemName, (String)this.vb.getPageSessionAttribute("currentSnapshotPath"), dumpFileName);
                String curSnapshot = (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME);
                if (curSnapshot.equals(dumpFileName)) {
                    this.vb.setPageSessionAttribute(SNAPSHOT_FILE_NAME, null);
                }
            }
            this.snapshotSummaryTableModel.setRowSelected(false);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleDeleteIndexRequest()", "Failed to unindex the snapshot file", this.serverName);
            TraceUtil.trace1("Exception enabling file for use:  " + ex.getMessage());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSRestore.error.failedPageDisplay", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleDeleteDumpRequest(RequestInvocationEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        try {
            String dumpFileName = this.getSelectedSnapshotFileName();
            if (dumpFileName != null) {
                String ssPath = (String)this.vb.getPageSessionAttribute("currentSnapshotPath");
                this.fsMgr.deleteDump(this.fileSystemName, ssPath, dumpFileName);
                String curSnapshot = (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME);
                if (curSnapshot != null && curSnapshot.equals(dumpFileName)) {
                    this.vb.setPageSessionAttribute(SNAPSHOT_FILE_NAME, null);
                }
            }
            this.snapshotSummaryTableModel.setRowSelected(false);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleDeleteDumpRequest()", "Failed to delete the snapshot file", this.serverName);
            TraceUtil.trace1("Exception deleting snapshot file:  " + ex.getMessage());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSRestore.error.failedPageDisplay", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleBrowseRequest(RequestInvocationEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        String dumpFileName = this.getSelectedSnapshotFileName();
        this.vb.setPageSessionAttribute(SNAPSHOT_FILE_NAME, (Serializable)((Object)dumpFileName));
        this.vb.setPageSessionAttribute(SEARCH_MODE_ON, Boolean.FALSE);
        this.vb.setPageSessionAttribute(FIRST_SEARCH, Boolean.TRUE);
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleSnapshotRetentionCmdRequest(RequestInvocationEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        String rowIdxStr = this.getDisplayFieldStringValue(CHILD_SS_RETENTION_ROW_IDX);
        CCActionTable child = (CCActionTable)this.getChild(CHILD_SS_ACTION_TABLE);
        child.restoreStateData();
        int rowIdx = -1;
        try {
            rowIdx = Integer.parseInt(rowIdxStr);
        }
        catch (NumberFormatException e) {
            TraceUtil.trace1("Invalid row index for 'retain permanently' check box:  " + rowIdxStr);
        }
        if (rowIdx == -1) {
            this.vb.forwardTo(this.getRequestContext());
            return;
        }
        this.snapshotSummaryTableModel.setRowIndex(rowIdx);
        String dumpFileName = (String)this.snapshotSummaryTableModel.getValue(CHILD_SS_FILE_NAME_VALUE);
        String retainValueStr = (String)this.snapshotSummaryTableModel.getValue(CHILD_SS_RETENTION_VALUE);
        Boolean retainValueBool = new Boolean(retainValueStr);
        try {
            String ssPath = (String)this.vb.getPageSessionAttribute("currentSnapshotPath");
            this.fsMgr.setIsDumpRetainedPermanently(this.fileSystemName, ssPath, dumpFileName, retainValueBool);
        }
        catch (SamFSException e) {
            SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "handleSnapshotRetentionCmdRequest()", "Failed to set the delete permanently value", this.serverName);
            TraceUtil.trace1("Exception setting retain permanently:  " + e.getMessage());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSRestore.snapshotSummary.error.retainPermanently", e.getSAMerrno(), e.getMessage(), this.serverName);
        }
        String alertMsg = "";
        alertMsg = retainValueBool != false ? SamUtil.getResourceString("FSRestore.snapshotSummary.success.retainedPermanently", dumpFileName) : SamUtil.getResourceString("FSRestore.snapshotSummary.success.notRetainedPermanently", dumpFileName);
        SamUtil.setInfoAlert((ContainerView)this, CHILD_SS_ALERT, "success.summary", alertMsg, this.serverName);
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private String getSelectedSnapshotFileName() throws ModelControlException {
        TraceUtil.trace3("Entering");
        CCActionTable child = (CCActionTable)this.getChild(CHILD_SS_ACTION_TABLE);
        child.restoreStateData();
        Integer[] indexes = this.snapshotSummaryTableModel.getSelectedRows();
        String dumpFileName = null;
        if (indexes.length > 0) {
            this.snapshotSummaryTableModel.setRowIndex(indexes[0].intValue());
            dumpFileName = (String)this.snapshotSummaryTableModel.getValue(CHILD_SS_FILE_NAME_VALUE);
        }
        TraceUtil.trace3("Exiting");
        return dumpFileName;
    }

    public void handleUpOneLevelRequest(RequestInvocationEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        String curPath = (String)this.vb.getPageSessionAttribute(CURRENT_BROWSE_PATH);
        File pathFile = new File(curPath);
        String newPath = pathFile.getParent();
        if (newPath == null) {
            newPath = this.fsMgr.getDumpFileTopLevelDirectory(this.fileSystemName, (String)this.vb.getPageSessionAttribute("currentSnapshotPath"), (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME));
        }
        if (newPath != null) {
            this.vb.setPageSessionAttribute(CURRENT_BROWSE_PATH, (Serializable)((Object)newPath));
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleChangeDirSubmitCmdRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String topLevelDir = "";
        topLevelDir = this.fsMgr.getDumpFileTopLevelDirectory(this.fileSystemName, (String)this.vb.getPageSessionAttribute("currentSnapshotPath"), (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME));
        String newDir = this.getDisplayFieldStringValue(CHILD_POPUP_HIDDEN);
        if (newDir != null) {
            if (newDir.length() == 0) {
                newDir = topLevelDir;
            } else {
                if (!newDir.startsWith(topLevelDir + "/")) {
                    newDir = newDir.startsWith("/") ? topLevelDir + newDir : topLevelDir + "/" + newDir;
                }
                if (newDir.endsWith("/")) {
                    newDir = newDir.substring(0, newDir.length() - 1);
                }
            }
            this.vb.setPageSessionAttribute(CURRENT_BROWSE_PATH, (Serializable)((Object)newDir));
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handlePostSelectSnapshotPathCmdRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        RemoteFileChooserControl chooser = (RemoteFileChooserControl)this.getChild(CHILD_SELECT_SS_PATH);
        String newDir = (String)chooser.getDisplayFieldValue("pathHidden");
        if (newDir != null) {
            if (newDir.endsWith("/") && newDir.length() > 1) {
                newDir = newDir.substring(0, newDir.length() - 1);
            }
            this.vb.setPageSessionAttribute("currentSnapshotPath", (Serializable)((Object)newDir));
            this.vb.setPageSessionAttribute(SNAPSHOT_FILE_NAME, null);
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handlePostSelectRestorePathCmdRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        RemoteFileChooserControl chooser = (RemoteFileChooserControl)this.getChild(CHILD_RESTORE_PATH);
        NonSyncStringBuffer newDir = new NonSyncStringBuffer().append(chooser.getDisplayFieldStringValue("browsetextfield"));
        if (newDir.length() > 0 && newDir.charAt(newDir.length() - 1) != '/') {
            newDir.append("/");
        }
        String fullPath = this.getDisplayFieldStringValue(CHILD_FILE_TO_RESTORE);
        File file = new File(fullPath);
        String name = file.getName();
        newDir.append(name);
        chooser.setDisplayFieldValue("browsetextfield", newDir.toString());
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleFilterSubmitCmdRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String filterStr = this.getDisplayFieldStringValue(CHILD_POPUP_HIDDEN);
        if (filterStr != null && filterStr.length() > 0) {
            try {
                Filter newFilter = Filter.getFilterFromEncodedString(filterStr);
                this.vb.setPageSessionAttribute(CURRENT_FILTER, newFilter);
            }
            catch (Exception e) {
                TraceUtil.trace1("Failed to reconstitute return value from filter popup.", e);
            }
        } else {
            this.vb.setPageSessionAttribute(CURRENT_FILTER, null);
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleFilterCriteriaClearRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        this.vb.setPageSessionAttribute(CURRENT_FILTER, null);
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleSearchSubmitCmdRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String searchStr = this.getDisplayFieldStringValue(CHILD_POPUP_HIDDEN);
        String dumpFileName = (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME);
        String dumpFileDir = (String)this.vb.getPageSessionAttribute("currentSnapshotPath");
        if (dumpFileName != null && searchStr != null && searchStr.length() > 0) {
            try {
                Filter newSearch = Filter.getFilterFromEncodedString(searchStr);
                this.vb.setPageSessionAttribute(SEARCH_CRITERIA, newSearch);
                long jobId = this.fsMgr.searchDumpFileContents(this.fileSystemName, dumpFileDir, dumpFileName, newSearch, this.getMaxEntries());
                BaseJob job = null;
                if (jobId > 0L) {
                    job = this.sysModel.getSamQFSSystemJobManager().getJobById(jobId);
                }
                if (job != null) {
                    String hrefHtml = this.getJobIdHrefTag(jobId, "Jobs.jobType.restoreSearch");
                    SamUtil.setInfoAlert((ContainerView)this, CHILD_SC_ALERT, "success.summary", SamUtil.getResourceString("FSRestore.snapshotContents.success.searchWithJob", new String[]{String.valueOf(jobId), hrefHtml, this.getRefreshHtml("snapshotContents")}), this.serverName);
                } else {
                    SamUtil.setInfoAlert((ContainerView)this, CHILD_SC_ALERT, "success.summary", SamUtil.getResourceString("FSRestore.snapshotContents.success.search"), this.serverName);
                }
                this.vb.setPageSessionAttribute(FIRST_SEARCH, new Boolean(false));
            }
            catch (SamFSException e) {
                SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "handleSearchSubmitCmdRequest()", "Failed to submit search", this.serverName);
                SamUtil.setErrorAlert((ContainerView)this, CHILD_SC_ALERT, "FSRestore.snapshotContents.error.failedStartSearch", e.getSAMerrno(), e.getMessage(), this.serverName);
            }
            catch (UnsupportedEncodingException e) {
                TraceUtil.trace1("Failed to reconstitute return value from search popup.", e);
            }
        } else {
            this.vb.setPageSessionAttribute(SEARCH_CRITERIA, null);
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleToggleModeRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        Boolean searchModeOnBool = (Boolean)this.vb.getPageSessionAttribute(SEARCH_MODE_ON);
        if (searchModeOnBool != null && searchModeOnBool.booleanValue()) {
            this.vb.setPageSessionAttribute(SEARCH_MODE_ON, Boolean.FALSE);
            this.setDisplayFieldValue(CHILD_SC_TABLE_MODE, TABLE_MODE_BROWSE);
        } else {
            this.vb.setPageSessionAttribute(SEARCH_MODE_ON, Boolean.TRUE);
            if (this.isSearchOrRestoreRunningNow() > 0L) {
                this.setDisplayFieldValue(CHILD_SC_TABLE_MODE, TABLE_MODE_SEARCHING);
            } else {
                this.setDisplayFieldValue(CHILD_SC_TABLE_MODE, TABLE_MODE_SEARCH);
            }
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleChangeMaxEntriesRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String maxEntryValue = this.getDisplayFieldStringValue(CHILD_MAX_ENTRIES);
        try {
            int maxEntryValueInt = Integer.parseInt(maxEntryValue);
            if (maxEntryValueInt <= 0) {
                SamFSException samEx = new SamFSException();
                SamUtil.setErrorAlert((ContainerView)this, CHILD_SC_ALERT, SamUtil.getResourceStringWithoutL10NArgs("FSRestore.snapshotContents.error.badMaxEntriesValue", new String[]{maxEntryValue}), samEx.getSAMerrno(), samEx.getMessage(), this.serverName);
            } else {
                this.vb.setPageSessionAttribute(MAX_ENTRIES, (Serializable)((Object)maxEntryValue));
            }
        }
        catch (NumberFormatException e) {
            SamFSException samEx = new SamFSException();
            SamUtil.setErrorAlert((ContainerView)this, CHILD_SC_ALERT, SamUtil.getResourceString("FSRestore.snapshotContents.error.badMaxEntriesValue", maxEntryValue), samEx.getSAMerrno(), samEx.getMessage(), this.serverName);
        }
        this.resetContentsTable();
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleRestoreRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        try {
            String stageOption;
            RemoteFileChooserControl chooser;
            String restoreFilePath;
            if (this.isSearchOrRestoreRunningNow() > 0L) {
                SamUtil.setWarningAlert((ContainerView)this, CHILD_RESTORE_ALERT, "FSRestore.restore.error.failedRestoreRequest", "FSRestore.restore.error.jobAlreadyRunning");
                this.vb.forwardTo(this.getRequestContext());
                return;
            }
            String dumpFile = (String)this.vb.getPageSessionAttribute(SNAPSHOT_FILE_NAME);
            String dumpFileDir = (String)this.vb.getPageSessionAttribute("currentSnapshotPath");
            String restoreType = this.getDisplayFieldStringValue(CHILD_RESTORE_TYPE);
            RestoreFile file = null;
            if (restoreType.equals(RESTORE_TYPE_FILE)) {
                String fileName = this.getDisplayFieldStringValue(CHILD_FILE_TO_RESTORE);
                if (fileName == null || fileName.length() == 0) {
                    throw new SamFSException(SamUtil.getResourceString("FSRestore.restore.error.noFileSelected"));
                }
                file = this.fsMgr.getRestoreFile(this.fileSystemName, dumpFileDir, dumpFile, fileName);
                if (file == null) {
                    throw new SamFSException(SamUtil.getResourceString("FSRestore.restore.error.failedGetRestoreFile"));
                }
            } else {
                file = this.fsMgr.getEntireFSRestoreFile();
                if (file == null) {
                    throw new SamFSException(SamUtil.getResourceString("FSRestore.restore.error.failedGetRestoreFile"));
                }
            }
            if ((restoreFilePath = (chooser = (RemoteFileChooserControl)this.getChild(CHILD_RESTORE_PATH)).getDisplayFieldStringValue("browsetextfield")) == null || restoreFilePath.length() == 0) {
                throw new SamFSException(SamUtil.getResourceString("FSRestore.restore.error.noRestorePath"));
            }
            file.setRestorePath(restoreFilePath);
            String replaceTypeStr = null;
            int replaceType = 0;
            if (this.version45.isAPICompatibleWithUI()) {
                replaceTypeStr = this.getDisplayFieldStringValue(CHILD_REPLACETYPE_VALUE);
                try {
                    replaceType = Integer.parseInt(replaceTypeStr);
                }
                catch (NumberFormatException e) {
                    throw new SamFSException("Invalid value for replace type: " + replaceTypeStr);
                }
            }
            if ((stageOption = this.getDisplayFieldStringValue(CHILD_STAGE_OPTIONS)).equals(STAGE_OPTION_SYSTEM_PICK)) {
                file.setStageCopy(1000);
            } else if (stageOption.equals(STAGE_OPTION_ASINDUMP)) {
                file.setStageCopy(3000);
            } else if (stageOption.equals(STAGE_OPTION_COPY0)) {
                file.setStageCopy(0);
            } else if (stageOption.equals(STAGE_OPTION_COPY1)) {
                file.setStageCopy(1);
            } else if (stageOption.equals(STAGE_OPTION_COPY2)) {
                file.setStageCopy(2);
            } else if (stageOption.equals(STAGE_OPTION_COPY3)) {
                file.setStageCopy(3);
            } else {
                file.setStageCopy(2000);
            }
            long jobId = this.fsMgr.restoreFiles(this.fileSystemName, dumpFileDir, dumpFile, replaceType, new RestoreFile[]{file});
            BaseJob job = null;
            if (jobId > 0L) {
                job = this.sysModel.getSamQFSSystemJobManager().getJobById(jobId);
            }
            if (job != null) {
                String hrefHtml = this.getJobIdHrefTag(jobId, "Jobs.jobType.restore");
                String alertMsg = "";
                String restoreWhat = "";
                if (restoreType.equals(RESTORE_TYPE_FS)) {
                    alertMsg = "FSRestore.restore.successWithJobFileSystem";
                    restoreWhat = dumpFile;
                } else {
                    alertMsg = "FSRestore.restore.successWithJob";
                    restoreWhat = this.getDisplaySSContentPath(file.getAbsolutePath());
                }
                SamUtil.setInfoAlert((ContainerView)this, CHILD_RESTORE_ALERT, "success.summary", SamUtil.getResourceString(alertMsg, new String[]{restoreWhat, restoreFilePath, String.valueOf(jobId), hrefHtml, this.getRefreshHtml("restoreFile")}), this.serverName);
            } else {
                String alertMsg = "";
                String restoreWhat = "";
                if (restoreType.equals(RESTORE_TYPE_FS)) {
                    alertMsg = "FSRestore.restore.successFileSystem";
                    restoreWhat = dumpFile;
                } else {
                    alertMsg = "FSRestore.restore.success";
                    restoreWhat = this.getDisplaySSContentPath(file.getAbsolutePath());
                }
                SamUtil.setInfoAlert((ContainerView)this, CHILD_RESTORE_ALERT, "success.summary", SamUtil.getResourceString(alertMsg, new String[]{restoreWhat, restoreFilePath}), this.serverName);
            }
        }
        catch (SamFSException e) {
            SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "handleRestoreRequest()", "Failed to submit the restore request.", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_RESTORE_ALERT, "FSRestore.restore.error.failedRestoreRequest", e.getSAMerrno(), e.getMessage(), this.serverName);
        }
        this.vb.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private String getJobIdHrefTag(long jobId, String jobType) {
        NonSyncStringBuffer href = new NonSyncStringBuffer().append("<a href=\"../fs/FSRestore?").append("FSRestore.FSRestoreView.").append(CHILD_JOBID_HREF).append("=").append(jobId).append(",").append(jobType).append(",Current\" ").append("name=\"FSRestore.FSRestoreView.").append(CHILD_JOBID_HREF).append("\" ").append("onclick=\"javascript:var f=document.FSRestoreForm;").append("if (f != null) {f.action=this.href;f.submit();").append("return false}\">").append(SamUtil.getResourceString("FSRestore.jobIdLink")).append("</a>");
        return href.toString();
    }

    private String getRefreshHtml(String anchorName) {
        NonSyncStringBuffer href = new NonSyncStringBuffer().append("<div class=\"").append("AlrtLnkDiv").append("\"><a href=\"../fs/FSRestore?FSRestore.").append("RefreshHref").append("=\" ").append("name=\"FSRestore.").append("RefreshHref").append("\" ").append("onclick=\"javascript:var f=document.FSRestoreForm;").append("if (f != null) ").append("{f.action = this.href + '#").append(anchorName).append("';f.submit(); return false;}\">").append(SamUtil.getResourceString("FSRestore.snapshotContents.searchAlert.refresh")).append("</a></div>");
        return href.toString();
    }

    private void showInfoAlert(String message, String parameter) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString(message, parameter), this.serverName);
        TraceUtil.trace3("Exiting");
    }

    public void resetContentsTable() {
        CCActionTable tableChild = (CCActionTable)this.getChild(CHILD_SC_ACTION_TABLE);
        try {
            tableChild.resetStateData();
        }
        catch (ModelControlException e) {
            TraceUtil.trace1("Failed to set state data on contents table", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

