/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.io.IOException;
import javax.servlet.ServletException;

public class FSMountView
extends RequestHandlingViewBase {
    private static final String CHILD_PROPERTY_SHEET = "PropertySheet";
    private CCPropertySheetModel propertySheetModel = null;
    private boolean directIO = false;
    static /* synthetic */ Class class$com$sun$web$ui$view$propertysheet$CCPropertySheet;

    public FSMountView(View parent, String name) {
        super(parent, name);
        TraceUtil.trace3("Entering");
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_PROPERTY_SHEET, class$com$sun$web$ui$view$propertysheet$CCPropertySheet == null ? (class$com$sun$web$ui$view$propertysheet$CCPropertySheet = FSMountView.class$("com.sun.web.ui.view.propertysheet.CCPropertySheet")) : class$com$sun$web$ui$view$propertysheet$CCPropertySheet);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering");
        if (name.equals(CHILD_PROPERTY_SHEET)) {
            return new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
        }
        if (this.propertySheetModel.isChildSupported(name)) {
            return this.propertySheetModel.createChild((View)this, name);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        TraceUtil.trace2("PageType = " + this.getPageType());
        if (this.propertySheetModel == null) {
            String psXml = "";
            psXml = this.getPageType().equals("SharedQFS") ? "/jsp/fs/FSMountSharedQfsPropertySheet.xml" : (this.getPageType().equals("SharedSAMQFS") ? "/jsp/fs/FSMountSharedSamqfsPropertySheet.xml" : (this.getPageType().equals("UnsharedQFS") ? "/jsp/fs/FSMountUnsharedQfsPropertySheet.xml" : (this.getPageType().equals("UnsharedSAMQFS") ? "/jsp/fs/FSMountUnsharedSamqfsPropertySheet.xml" : "/jsp/fs/FSMountUnsharedSamfsPropertySheet.xml")));
            this.propertySheetModel = PropertySheetUtil.createModel(psXml);
        }
        TraceUtil.trace3("Exiting");
        return this.propertySheetModel;
    }

    public void loadPropertySheetModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.propertySheetModel.clear();
        String sharedMetaClient = (String)this.getParentViewBean().getPageSessionAttribute("SHARED_METADATA_CLIENT");
        SamQFSSystemModel model = null;
        model = sharedMetaClient != null ? SamUtil.getModel(sharedMetaClient) : SamUtil.getModel(this.getServerName());
        FileSystem fs2 = model.getSamQFSSystemFSManager().getFileSystem(this.getFSName());
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        FileSystemMountProperties properties = fs2.getMountProperties();
        int mountState = fs2.getState();
        this.loadBasicProperties(properties);
        this.loadGeneralProperties(properties, mountState);
        this.loadPerformanceProperties(properties);
        this.loadIODiscoveryProperties(properties);
        if (this.isArchive()) {
            this.loadArchiveProperties(properties);
        } else if (this.getPageType().equals("SharedQFS")) {
            this.loadSharedQFSProperties(properties, mountState);
        } else if (this.getPageType().equals("SharedSAMQFS")) {
            this.loadArchiveProperties(properties);
            this.loadSharedQFSProperties(properties, mountState);
        }
        if (this.directIO) {
            ((CCTextField)this.getChild("consecreadValue")).setDisabled(true);
            ((CCTextField)this.getChild("wellreadminValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("wellreadminUnit")).setDisabled(true);
            ((CCTextField)this.getChild("misreadminValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("misreadminUnit")).setDisabled(true);
            ((CCTextField)this.getChild("consecwriteValue")).setDisabled(true);
            ((CCTextField)this.getChild("wellwriteminValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("wellwriteminUnit")).setDisabled(true);
            ((CCTextField)this.getChild("miswriteminValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("miswriteminUnit")).setDisabled(true);
            ((CCRadioButton)this.getChild("dioszeroValue")).setDisabled(true);
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadBasicProperties(FileSystemMountProperties properties) {
        if (this.getPageType().equals("SharedSAMQFS") || this.getPageType().equals("UnsharedSAMQFS") || this.getPageType().equals("UnsharedSAMFS")) {
            int hwmValue = properties.getHWM();
            this.propertySheetModel.setValue("hwmValue", (Object)Integer.toString(hwmValue));
            int lwmValue = properties.getLWM();
            this.propertySheetModel.setValue("lwmValue", (Object)Integer.toString(lwmValue));
        }
        int stripeValue = properties.getStripeWidth();
        String stripeValStr = "";
        if (stripeValue != -1) {
            stripeValStr = Integer.toString(stripeValue);
        }
        this.propertySheetModel.setValue("stripeValue", (Object)stripeValStr);
        String trace = "yes";
        if (!properties.isTrace()) {
            trace = "no";
        }
        this.propertySheetModel.setValue("traceValue", (Object)trace);
        if (this.getSharedClientType().equals("Shared Client")) {
            ((CCTextField)this.getChild("stripeValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("traceValue")).setDisabled(true);
        }
    }

    private void loadGeneralProperties(FileSystemMountProperties properties, int mountState) {
        String mountReadonly = "no";
        if (properties.isReadOnlyMount()) {
            mountReadonly = "yes";
        }
        this.propertySheetModel.setValue("mountreadonlyValue", (Object)mountReadonly);
        if (mountState == 0) {
            ((CCRadioButton)this.getChild("mountreadonlyValue")).setDisabled(true);
        }
        String nouid = "no";
        if (properties.isNoSetUID()) {
            nouid = "yes";
        }
        this.propertySheetModel.setValue("nouidValue", (Object)nouid);
        if (this.is44() && this.getPageType().equals("UnsharedSAMFS") || this.getSharedClientType().equals("Shared Client")) {
            ((CCRadioButton)this.getChild("quickwriteValue")).setDisabled(true);
        } else {
            this.propertySheetModel.setValue("quickwriteValue", (Object)(properties.isQuickWrite() ? "yes" : "no"));
        }
        if (this.getSharedClientType().equals("Shared Client")) {
            ((CCRadioButton)this.getChild("nouidValue")).setDisabled(true);
        }
    }

    private void loadPerformanceProperties(FileSystemMountProperties properties) {
        long readaheadValue = properties.getReadAhead();
        this.propertySheetModel.setValue("readaheadValue", (Object)Long.toString(readaheadValue));
        int readaHeadUnitValue = properties.getReadAheadUnit();
        this.propertySheetModel.setValue("readaheadUnit", (Object)SamUtil.getSizeUnitString(readaHeadUnitValue));
        long writebehindValue = properties.getWriteBehind();
        this.propertySheetModel.setValue("writebehindValue", (Object)Long.toString(writebehindValue));
        int writeBehindUnitValue = properties.getWriteBehindUnit();
        this.propertySheetModel.setValue("writebehindUnit", (Object)SamUtil.getSizeUnitString(writeBehindUnitValue));
        long writethroValue = properties.getWriteThrottle();
        this.propertySheetModel.setValue("writethroValue", (Object)Long.toString(writethroValue));
        int writeThroUnitValue = properties.getWriteThrottleUnit();
        this.propertySheetModel.setValue("writethroUnit", (Object)SamUtil.getSizeUnitString(writeThroUnitValue));
        long flushbehindValue = properties.getFlushBehind();
        this.propertySheetModel.setValue("flushbehindValue", (Object)Long.toString(flushbehindValue));
        int flushBehindUnitValue = properties.getFlushBehindUnit();
        this.propertySheetModel.setValue("flushbehindUnit", (Object)SamUtil.getSizeUnitString(flushBehindUnitValue));
        if (!this.getPageType().equals("UnsharedQFS") && !this.getPageType().equals("SharedQFS")) {
            long stageflushValue = properties.getStageFlushBehind();
            this.propertySheetModel.setValue("stageflushValue", (Object)Long.toString(stageflushValue));
            int stageFlushUnitValue = properties.getStageFlushBehindUnit();
            this.propertySheetModel.setValue("stageflushUnit", (Object)SamUtil.getSizeUnitString(stageFlushUnitValue));
        }
        String softWare = "off";
        if (properties.isSoftRAID()) {
            softWare = "on";
        }
        this.propertySheetModel.setValue("softwareValue", (Object)softWare);
        String force = "off";
        this.directIO = false;
        if (properties.isForceDirectIO()) {
            force = "on";
            this.directIO = true;
        }
        this.propertySheetModel.setValue("forceValue", (Object)force);
        this.propertySheetModel.setValue("forceNFSAsyncValue", (Object)(properties.isForceNFSAsync() ? "on" : "off"));
        if (this.getSharedClientType().equals("Shared Client")) {
            ((CCTextField)this.getChild("readaheadValue")).setDisabled(true);
            ((CCTextField)this.getChild("writebehindValue")).setDisabled(true);
            ((CCTextField)this.getChild("writethroValue")).setDisabled(true);
            ((CCTextField)this.getChild("flushbehindValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("softwareValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("forceValue")).setDisabled(true);
        }
    }

    private void loadIODiscoveryProperties(FileSystemMountProperties properties) {
        int consecReadValue = properties.getConsecutiveReads();
        this.propertySheetModel.setValue("consecreadValue", (Object)Integer.toString(consecReadValue));
        long wellreadMinValue = properties.getWellAlignedReadMin();
        this.propertySheetModel.setValue("wellreadminValue", (Object)Long.toString(wellreadMinValue));
        int wellreadMinUnitValue = properties.getWellAlignedReadMinUnit();
        this.propertySheetModel.setValue("wellreadminUnit", (Object)SamUtil.getSizeUnitString(wellreadMinUnitValue));
        long misreadMinValue = properties.getMisAlignedReadMin();
        this.propertySheetModel.setValue("misreadminValue", (Object)Long.toString(misreadMinValue));
        int misreadMinUnitValue = properties.getMisAlignedReadMinUnit();
        this.propertySheetModel.setValue("misreadminUnit", (Object)SamUtil.getSizeUnitString(misreadMinUnitValue));
        int consecWriteValue = properties.getConsecutiveWrites();
        this.propertySheetModel.setValue("consecwriteValue", (Object)Integer.toString(consecWriteValue));
        long wellwriteMinValue = properties.getWellAlignedWriteMin();
        this.propertySheetModel.setValue("wellwriteminValue", (Object)Long.toString(wellwriteMinValue));
        int wellwriteMinUnitValue = properties.getWellAlignedWriteMinUnit();
        this.propertySheetModel.setValue("wellwriteminUnit", (Object)SamUtil.getSizeUnitString(wellwriteMinUnitValue));
        long miswriteMinValue = properties.getMisAlignedWriteMin();
        this.propertySheetModel.setValue("miswriteminValue", (Object)Long.toString(miswriteMinValue));
        int miswriteMinUnitValue = properties.getMisAlignedWriteMinUnit();
        this.propertySheetModel.setValue("miswriteminUnit", (Object)SamUtil.getSizeUnitString(miswriteMinUnitValue));
        this.propertySheetModel.setValue("dioszeroValue", (Object)(properties.isDirectIOZeroing() ? "yes" : "no"));
        if (this.getSharedClientType().equals("Shared Client")) {
            ((CCTextField)this.getChild("consecreadValue")).setDisabled(true);
            ((CCTextField)this.getChild("wellreadminValue")).setDisabled(true);
            ((CCTextField)this.getChild("misreadminValue")).setDisabled(true);
            ((CCTextField)this.getChild("consecwriteValue")).setDisabled(true);
            ((CCTextField)this.getChild("wellwriteminValue")).setDisabled(true);
            ((CCTextField)this.getChild("miswriteminValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("dioszeroValue")).setDisabled(true);
        }
    }

    private void loadArchiveProperties(FileSystemMountProperties properties) {
        int partReleaseValue = properties.getDefaultPartialReleaseSize();
        this.propertySheetModel.setValue("partreleaseValue", (Object)Integer.toString(partReleaseValue));
        int partRelUnitValue = properties.getDefaultPartialReleaseSizeUnit();
        this.propertySheetModel.setValue("partreleaseUnit", (Object)SamUtil.getSizeUnitString(partRelUnitValue));
        int maxPartValue = properties.getDefaultMaxPartialReleaseSize();
        this.propertySheetModel.setValue("maxpartValue", (Object)Integer.toString(maxPartValue));
        int maxPartUnitValue = properties.getDefaultMaxPartialReleaseSizeUnit();
        this.propertySheetModel.setValue("maxpartUnit", (Object)SamUtil.getSizeUnitString(maxPartUnitValue));
        long partStageValue = properties.getPartialStageSize();
        this.propertySheetModel.setValue("partstageValue", (Object)Long.toString(partStageValue));
        int partStageUnitValue = properties.getPartialStageSizeUnit();
        this.propertySheetModel.setValue("partstageUnit", (Object)SamUtil.getSizeUnitString(partStageUnitValue));
        int stageRetriesValue = properties.getNoOfStageRetries();
        this.propertySheetModel.setValue("stageretriesValue", (Object)Integer.toString(stageRetriesValue));
        long stageWindowValue = properties.getStageWindowSize();
        this.propertySheetModel.setValue("stagewindowValue", (Object)Long.toString(stageWindowValue));
        int stageWindowUnitSize = properties.getStageWindowSizeUnit();
        this.propertySheetModel.setValue("stagewindowUnit", (Object)SamUtil.getSizeUnitString(stageWindowUnitSize));
        String autorun = "no";
        if (properties.isArchiverAutoRun()) {
            autorun = "yes";
        }
        this.propertySheetModel.setValue("questionValue", (Object)autorun);
        String hostName = (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
        TraceUtil.trace3("set page session for hostName " + hostName);
        ServerInfo serverInfo = null;
        if (hostName == null) {
            TraceUtil.trace1("Error retrieving server name!");
        } else {
            try {
                serverInfo = SamUtil.getServerInfo(hostName);
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1("Error retrieving system license!");
            }
        }
        if (serverInfo != null && serverInfo.getServerLicenseType() == 1) {
            ((CCTextField)this.getChild("partreleaseValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("partreleaseUnit")).setDisabled(true);
            ((CCTextField)this.getChild("maxpartValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("maxpartUnit")).setDisabled(true);
            ((CCTextField)this.getChild("partstageValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("partstageUnit")).setDisabled(true);
            ((CCTextField)this.getChild("stageretriesValue")).setDisabled(true);
            ((CCTextField)this.getChild("stagewindowValue")).setDisabled(true);
            ((CCDropDownMenu)this.getChild("stagewindowUnit")).setDisabled(true);
            ((CCRadioButton)this.getChild("questionValue")).setDisabled(true);
        }
    }

    private void loadSharedQFSProperties(FileSystemMountProperties properties, int mountState) {
        String mountBackground = "no";
        if (properties.isMountInBackground()) {
            mountBackground = "yes";
        }
        this.propertySheetModel.setValue("mountBackgroundValue", (Object)mountBackground);
        int mountretriesValue = properties.getNoOfMountRetries();
        this.propertySheetModel.setValue("mountretriesValue", (Object)Integer.toString(mountretriesValue));
        int metarefreshValue = properties.getMetadataRefreshRate();
        this.propertySheetModel.setValue("metarefreshValue", (Object)Integer.toString(metarefreshValue));
        String minBlock = "";
        long minblockValue = properties.getMinBlockAllocation();
        if (minblockValue != -1L) {
            minBlock = Long.toString(minblockValue);
        }
        this.propertySheetModel.setValue("minblockValue", (Object)minBlock);
        int minblockUnit = properties.getMinBlockAllocationUnit();
        this.propertySheetModel.setValue("minblockUnit", (Object)SamUtil.getSizeUnitString(minblockUnit));
        String maxBlock = "";
        long maxblockValue = properties.getMaxBlockAllocation();
        if (maxblockValue != -1L) {
            maxBlock = Long.toString(maxblockValue);
        }
        this.propertySheetModel.setValue("maxblockValue", (Object)maxBlock);
        int maxblockUnit = properties.getMaxBlockAllocationUnit();
        this.propertySheetModel.setValue("maxblockUnit", (Object)SamUtil.getSizeUnitString(maxblockUnit));
        int readleaseValue = properties.getReadLeaseDuration();
        this.propertySheetModel.setValue("readleaseValue", (Object)Integer.toString(readleaseValue));
        int writeleaseValue = properties.getWriteLeaseDuration();
        this.propertySheetModel.setValue("writeleaseValue", (Object)Integer.toString(writeleaseValue));
        int appendleaseValue = properties.getAppendLeaseDuration();
        this.propertySheetModel.setValue("appendleaseValue", (Object)Integer.toString(appendleaseValue));
        int maxstreamValue = properties.getMaxConcurrentStreams();
        this.propertySheetModel.setValue("maxstreamValue", (Object)Integer.toString(maxstreamValue));
        String multihost = "no";
        if (properties.isMultiHostWrite()) {
            multihost = "yes";
        }
        this.propertySheetModel.setValue("multihostValue", (Object)multihost);
        String sync = "no";
        if (properties.isSynchronizedMetadata()) {
            sync = "yes";
        }
        this.propertySheetModel.setValue("syncValue", (Object)sync);
        if (!this.is44()) {
            this.propertySheetModel.setValue("cattrValue", (Object)(properties.isConsistencyChecking() ? "yes" : "no"));
        } else {
            ((CCRadioButton)this.getChild("cattrValue")).setDisabled(true);
        }
        int metaStripeValue = properties.getMetadataStripeWidth();
        this.propertySheetModel.setValue("metastripeValue", (Object)Integer.toString(metaStripeValue));
        int leaseTimeoValue = properties.getLeaseTimeout();
        this.propertySheetModel.setValue("leaseTimeoValue", (Object)Integer.toString(leaseTimeoValue));
        if (this.getSharedClientType().equals("Shared Client")) {
            ((CCRadioButton)this.getChild("mountBackgroundValue")).setDisabled(true);
            ((CCTextField)this.getChild("mountretriesValue")).setDisabled(true);
            ((CCTextField)this.getChild("metarefreshValue")).setDisabled(true);
            ((CCTextField)this.getChild("minblockValue")).setDisabled(true);
            ((CCTextField)this.getChild("maxblockValue")).setDisabled(true);
            ((CCTextField)this.getChild("readleaseValue")).setDisabled(true);
            ((CCTextField)this.getChild("writeleaseValue")).setDisabled(true);
            ((CCTextField)this.getChild("appendleaseValue")).setDisabled(true);
            ((CCTextField)this.getChild("maxstreamValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("multihostValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("syncValue")).setDisabled(true);
            ((CCRadioButton)this.getChild("cattrValue")).setDisabled(true);
            ((CCTextField)this.getChild("metastripeValue")).setDisabled(true);
            ((CCTextField)this.getChild("leaseTimeoValue")).setDisabled(true);
        }
        if (mountState == 0) {
            ((CCRadioButton)this.getChild("mountBackgroundValue")).setDisabled(true);
            ((CCTextField)this.getChild("mountretriesValue")).setDisabled(true);
            ((CCTextField)this.getChild("maxstreamValue")).setDisabled(true);
        }
    }

    public void handleSaveButtonRequest(RequestInvocationEvent event, String host) throws ServletException, IOException, SamFSException {
        TraceUtil.trace3("Entering");
        FileSystem fs2 = null;
        String exceHost = null;
        if (host == null) {
            exceHost = (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
            TraceUtil.trace3("set page session for exechost " + exceHost);
            SamQFSSystemModel sysModel = SamUtil.getModel(exceHost);
            fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(this.getFSName());
        } else {
            exceHost = host;
            SamQFSSystemModel model = SamUtil.getModel(host);
            fs2 = model.getSamQFSSystemFSManager().getFileSystem(this.getFSName());
        }
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        FileSystemMountProperties properties = fs2.getMountProperties();
        int mountState = fs2.getState();
        LogUtil.info(((Object)((Object)this)).getClass(), "handleSaveButtonRequest", "Starting save the mount options ");
        this.saveBasicProperties(properties);
        this.saveGeneralProperties(properties, mountState);
        if (!this.getSharedClientType().equals("Shared Client")) {
            this.savePerformanceProperties(properties);
        }
        if (!this.getSharedClientType().equals("Shared Client") && !this.directIO) {
            this.saveIODiscoveryProperties(properties);
        }
        if (this.isArchive()) {
            this.saveArchiveProperties(properties);
        } else if (this.getPageType().equals("SharedQFS")) {
            if (!this.getSharedClientType().equals("Shared Client")) {
                this.saveSharedQFSProperties(properties, mountState);
            }
        } else if (this.getPageType().equals("SharedSAMQFS") && !this.getSharedClientType().equals("Shared Client")) {
            this.saveArchiveProperties(properties);
            this.saveSharedQFSProperties(properties, mountState);
        }
        if (host == null && this.getSharedClientType().equals("Shared Server") || host != null && !this.getSharedClientType().equals("Shared Client")) {
            TraceUtil.trace3("Begining editing SharedMountOptions");
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
            if (host != null) {
                fsManager.setSharedMountOptions(host, this.getFSName(), properties);
            } else {
                fsManager.setSharedMountOptions(exceHost, this.getFSName(), properties);
            }
        } else {
            fs2.changeMountOptions();
        }
        TraceUtil.trace3("Exiting");
    }

    private void saveBasicProperties(FileSystemMountProperties properties) {
        TraceUtil.trace3("Entering");
        if (this.getPageType().equals("SharedSAMQFS") || this.getPageType().equals("UnsharedSAMQFS") || this.getPageType().equals("UnsharedSAMFS")) {
            String hwmString = ((String)this.getDisplayFieldValue("hwmValue")).trim();
            if (hwmString.length() > 0) {
                int hwm = Integer.parseInt(hwmString);
                if (hwm != properties.getHWM()) {
                    properties.setHWM(hwm);
                }
            } else {
                properties.setHWM(-1);
            }
            String lwmString = ((String)this.getDisplayFieldValue("lwmValue")).trim();
            if (lwmString.length() > 0) {
                int lwm = Integer.parseInt(lwmString);
                if (lwm != properties.getLWM()) {
                    properties.setLWM(lwm);
                }
            } else {
                properties.setLWM(-1);
            }
        }
        if (!this.getSharedClientType().equals("Shared Client")) {
            String stripeString = ((String)this.getDisplayFieldValue("stripeValue")).trim();
            if (stripeString.length() > 0) {
                int stripe = Integer.parseInt(stripeString);
                if (stripe != properties.getStripeWidth()) {
                    properties.setStripeWidth(stripe);
                }
            } else {
                properties.setStripeWidth(-1);
            }
            String trace = (String)this.getDisplayFieldValue("traceValue");
            if ("yes".equals(trace)) {
                if (!properties.isTrace()) {
                    properties.setTrace(true);
                }
            } else if (properties.isTrace()) {
                properties.setTrace(false);
            }
        }
        TraceUtil.trace3("Exiting");
    }

    private void saveSharedQFSProperties(FileSystemMountProperties properties, int mountState) {
        String metadataStripeStr;
        String sync;
        String multihost;
        String readleaseStr;
        String maxblockStr;
        String metarefreshStr;
        if (mountState != 0) {
            String mntretriesStr;
            String mntbck = (String)this.getDisplayFieldValue("mountBackgroundValue");
            if ("yes".equals(mntbck)) {
                if (!properties.isMountInBackground()) {
                    properties.setMountInBackground(true);
                }
            } else if (properties.isMountInBackground()) {
                properties.setMountInBackground(false);
            }
            if ((mntretriesStr = ((String)this.getDisplayFieldValue("mountretriesValue")).trim()).length() > 0) {
                int mountretries = Integer.parseInt(mntretriesStr);
                if (mountretries != properties.getNoOfMountRetries()) {
                    properties.setNoOfMountRetries(mountretries);
                }
            } else {
                properties.setNoOfMountRetries(-1);
            }
        }
        if ((metarefreshStr = ((String)this.getDisplayFieldValue("metarefreshValue")).trim()).length() > 0) {
            int metarefresh = Integer.parseInt(metarefreshStr);
            if (metarefresh != properties.getMetadataRefreshRate()) {
                properties.setMetadataRefreshRate(metarefresh);
            }
        } else {
            properties.setMetadataRefreshRate(-1);
        }
        String minblockStr = ((String)this.getDisplayFieldValue("minblockValue")).trim();
        if (minblockStr.length() > 0) {
            long minblock = Long.parseLong(minblockStr);
            if (minblock != properties.getMinBlockAllocation()) {
                properties.setMinBlockAllocation(minblock);
            }
        } else {
            properties.setMinBlockAllocation(-1L);
        }
        int minblockUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("minblockUnit"));
        if (minblockUnit != properties.getMinBlockAllocationUnit()) {
            properties.setMinBlockAllocationUnit(minblockUnit);
        }
        if ((maxblockStr = ((String)this.getDisplayFieldValue("maxblockValue")).trim()).length() > 0) {
            long maxblock = Long.parseLong(maxblockStr);
            if (maxblock != properties.getMaxBlockAllocation()) {
                properties.setMaxBlockAllocation(maxblock);
            }
        } else {
            properties.setMaxBlockAllocation(-1L);
        }
        int maxblockUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("maxblockUnit"));
        if (maxblockUnit != properties.getMaxBlockAllocationUnit()) {
            properties.setMaxBlockAllocationUnit(maxblockUnit);
        }
        if ((readleaseStr = ((String)this.getDisplayFieldValue("readleaseValue")).trim()).length() > 0) {
            int readlease = Integer.parseInt(readleaseStr);
            if (readlease != properties.getReadLeaseDuration()) {
                properties.setReadLeaseDuration(readlease);
            }
        } else {
            properties.setReadLeaseDuration(-1);
        }
        String writeleaseStr = ((String)this.getDisplayFieldValue("writeleaseValue")).trim();
        if (writeleaseStr.length() > 0) {
            int writelease = Integer.parseInt(writeleaseStr);
            if (writelease != properties.getWriteLeaseDuration()) {
                properties.setWriteLeaseDuration(writelease);
            }
        } else {
            properties.setWriteLeaseDuration(-1);
        }
        String appendleaseStr = ((String)this.getDisplayFieldValue("appendleaseValue")).trim();
        if (appendleaseStr.length() > 0) {
            int appendlease = Integer.parseInt(appendleaseStr);
            if (appendlease != properties.getAppendLeaseDuration()) {
                properties.setAppendLeaseDuration(appendlease);
            }
        } else {
            properties.setAppendLeaseDuration(-1);
        }
        if (mountState != 0) {
            String maxstreamStr = ((String)this.getDisplayFieldValue("maxstreamValue")).trim();
            if (maxstreamStr.length() > 0) {
                int maxstream = Integer.parseInt(maxstreamStr);
                if (maxstream != properties.getMaxConcurrentStreams()) {
                    properties.setMaxConcurrentStreams(maxstream);
                }
            } else {
                properties.setMaxConcurrentStreams(-1);
            }
        }
        if ("yes".equals(multihost = (String)this.getDisplayFieldValue("multihostValue"))) {
            if (!properties.isMultiHostWrite()) {
                properties.setMultiHostWrite(true);
            }
        } else if (properties.isMultiHostWrite()) {
            properties.setMultiHostWrite(false);
        }
        if ("yes".equals(sync = (String)this.getDisplayFieldValue("syncValue"))) {
            if (!properties.isSynchronizedMetadata()) {
                properties.setSynchronizedMetadata(true);
            }
        } else if (properties.isSynchronizedMetadata()) {
            properties.setSynchronizedMetadata(false);
        }
        if (!this.is44()) {
            String cattr = (String)this.getDisplayFieldValue("cattrValue");
            if ("yes".equals(cattr)) {
                if (!properties.isConsistencyChecking()) {
                    properties.setConsistencyChecking(true);
                }
            } else if (properties.isConsistencyChecking()) {
                properties.setConsistencyChecking(false);
            }
        }
        if ((metadataStripeStr = ((String)this.getDisplayFieldValue("metastripeValue")).trim()).length() > 0) {
            int metadataStripe = Integer.parseInt(metadataStripeStr);
            if (metadataStripe != properties.getMetadataStripeWidth()) {
                properties.setMetadataStripeWidth(metadataStripe);
            }
        } else {
            properties.setMetadataStripeWidth(-1);
        }
        String leaseTimeoValue = ((String)this.getDisplayFieldValue("leaseTimeoValue")).trim();
        if (leaseTimeoValue.length() > 0) {
            int leaseTimeo = Integer.parseInt(leaseTimeoValue);
            if (leaseTimeo != properties.getLeaseTimeout()) {
                properties.setLeaseTimeout(leaseTimeo);
            }
        } else {
            properties.setLeaseTimeout(-1);
        }
    }

    private void saveGeneralProperties(FileSystemMountProperties properties, int mountState) {
        if (mountState != 0) {
            String mountReadonly = (String)this.getDisplayFieldValue("mountreadonlyValue");
            if ("yes".equals(mountReadonly)) {
                if (!properties.isReadOnlyMount()) {
                    properties.setReadOnlyMount(true);
                }
            } else if (properties.isReadOnlyMount()) {
                properties.setReadOnlyMount(false);
            }
        }
        if (!this.getSharedClientType().equals("Shared Client")) {
            String noSetuid = (String)this.getDisplayFieldValue("nouidValue");
            if ("yes".equals(noSetuid)) {
                if (!properties.isNoSetUID()) {
                    properties.setNoSetUID(true);
                }
            } else if (properties.isNoSetUID()) {
                properties.setNoSetUID(false);
            }
        }
        if (!this.is44() || !this.getPageType().equals("UnsharedSAMFS") && !this.getSharedClientType().equals("Shared Client")) {
            String quickWrite = (String)this.getDisplayFieldValue("quickwriteValue");
            if ("yes".equals(quickWrite)) {
                if (!properties.isQuickWrite()) {
                    properties.setQuickWrite(true);
                }
            } else if (properties.isQuickWrite()) {
                properties.setQuickWrite(false);
            }
        }
    }

    private void savePerformanceProperties(FileSystemMountProperties properties) {
        String forceio;
        String raid;
        String flushbehindStr;
        String writethrottleStr;
        String writebehindStr;
        String readaheadStr = ((String)this.getDisplayFieldValue("readaheadValue")).trim();
        if (readaheadStr.length() > 0) {
            long readahead = Long.parseLong(readaheadStr);
            if (readahead != properties.getReadAhead()) {
                properties.setReadAhead(readahead);
            }
        } else {
            properties.setReadAhead(-1L);
        }
        int readaheadUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("readaheadUnit"));
        if (readaheadUnit != properties.getReadAheadUnit()) {
            properties.setReadAheadUnit(readaheadUnit);
        }
        if ((writebehindStr = ((String)this.getDisplayFieldValue("writebehindValue")).trim()).length() > 0) {
            long writebehind = Long.parseLong(writebehindStr);
            if (writebehind != properties.getWriteBehind()) {
                properties.setWriteBehind(writebehind);
            }
        } else {
            properties.setWriteBehind(-1L);
        }
        int writebehindUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("writebehindUnit"));
        if (writebehindUnit != properties.getWriteBehindUnit()) {
            properties.setWriteBehindUnit(writebehindUnit);
        }
        if ((writethrottleStr = ((String)this.getDisplayFieldValue("writethroValue")).trim()).length() > 0) {
            long writethrottle = Long.parseLong(writethrottleStr);
            if (writethrottle != properties.getWriteThrottle()) {
                properties.setWriteThrottle(writethrottle);
            }
        } else {
            properties.setWriteThrottle(-1L);
        }
        int writethroUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("writethroUnit"));
        if (writethroUnit != properties.getWriteThrottleUnit()) {
            properties.setWriteThrottleUnit(writethroUnit);
        }
        if ((flushbehindStr = ((String)this.getDisplayFieldValue("flushbehindValue")).trim()).length() > 0) {
            int flushbehind = Integer.parseInt(flushbehindStr);
            if (flushbehind != properties.getFlushBehind()) {
                properties.setFlushBehind(flushbehind);
            }
        } else {
            properties.setFlushBehind(-1);
        }
        int flushbehindUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("flushbehindUnit"));
        if (flushbehindUnit != properties.getFlushBehindUnit()) {
            properties.setFlushBehindUnit(flushbehindUnit);
        }
        if (!this.getPageType().equals("SharedQFS") && !this.getPageType().equals("UnsharedQFS")) {
            String stageflushStr = ((String)this.getDisplayFieldValue("stageflushValue")).trim();
            if (stageflushStr.length() > 0) {
                int stageflush = Integer.parseInt(stageflushStr);
                if (stageflush != properties.getStageFlushBehind()) {
                    properties.setStageFlushBehind(stageflush);
                }
            } else {
                properties.setStageFlushBehind(-1);
            }
            int stageflushUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("stageflushUnit"));
            if (stageflushUnit != properties.getStageFlushBehindUnit()) {
                properties.setStageFlushBehindUnit(stageflushUnit);
            }
        }
        if ("on".equals(raid = (String)this.getDisplayFieldValue("softwareValue"))) {
            if (!properties.isSoftRAID()) {
                properties.setSoftRAID(true);
            }
        } else if (properties.isSoftRAID()) {
            properties.setSoftRAID(false);
        }
        if ("on".equals(forceio = (String)this.getDisplayFieldValue("forceValue"))) {
            this.directIO = true;
            if (!properties.isForceDirectIO()) {
                properties.setForceDirectIO(true);
            }
        } else {
            this.directIO = false;
            if (properties.isForceDirectIO()) {
                properties.setForceDirectIO(false);
            }
        }
        String forceNFSAsync = (String)this.getDisplayFieldValue("forceNFSAsyncValue");
        properties.setForceNFSAsync("on".equals(forceNFSAsync));
    }

    private void saveIODiscoveryProperties(FileSystemMountProperties properties) {
        String dioszero;
        String miswriteminStr;
        String wellwriteminStr;
        String misreadminStr;
        TraceUtil.trace2("Saving IO Discovery Properties...");
        String consecreadStr = ((String)this.getDisplayFieldValue("consecreadValue")).trim();
        if (consecreadStr.length() > 0) {
            int consecread = Integer.parseInt(consecreadStr);
            if (consecread != properties.getConsecutiveReads()) {
                properties.setConsecutiveReads(consecread);
            }
        } else {
            properties.setConsecutiveReads(-1);
        }
        String consecwriteStr = ((String)this.getDisplayFieldValue("consecwriteValue")).trim();
        if (consecwriteStr.length() > 0) {
            int consecwrite = Integer.parseInt(consecwriteStr);
            if (consecwrite != properties.getConsecutiveWrites()) {
                properties.setConsecutiveWrites(consecwrite);
            }
        } else {
            properties.setConsecutiveWrites(-1);
        }
        String wellreadminStr = ((String)this.getDisplayFieldValue("wellreadminValue")).trim();
        if (wellreadminStr.length() > 0) {
            int wellreadmin = Integer.parseInt(wellreadminStr);
            if (wellreadmin != properties.getWellAlignedReadMin()) {
                properties.setWellAlignedReadMin(wellreadmin);
            }
        } else {
            properties.setWellAlignedReadMin(-1);
        }
        int wellreadminUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("wellreadminUnit"));
        if (wellreadminUnit != properties.getWellAlignedReadMinUnit()) {
            properties.setWellAlignedReadMinUnit(wellreadminUnit);
        }
        if ((misreadminStr = ((String)this.getDisplayFieldValue("misreadminValue")).trim()).length() > 0) {
            int misreadmin = Integer.parseInt(misreadminStr);
            if (misreadmin != properties.getMisAlignedReadMin()) {
                properties.setMisAlignedReadMin(misreadmin);
            }
        } else {
            properties.setMisAlignedReadMin(-1);
        }
        int misreadminUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("misreadminUnit"));
        if (misreadminUnit != properties.getMisAlignedReadMinUnit()) {
            properties.setMisAlignedReadMinUnit(misreadminUnit);
        }
        if ((wellwriteminStr = ((String)this.getDisplayFieldValue("wellwriteminValue")).trim()).length() > 0) {
            int wellwritemin = Integer.parseInt(wellwriteminStr);
            if (wellwritemin != properties.getWellAlignedWriteMin()) {
                properties.setWellAlignedWriteMin(wellwritemin);
            }
        } else {
            properties.setWellAlignedWriteMin(-1);
        }
        int wellwriteminUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("wellwriteminUnit"));
        if (wellwriteminUnit != properties.getWellAlignedWriteMinUnit()) {
            properties.setWellAlignedWriteMinUnit(wellwriteminUnit);
        }
        if ((miswriteminStr = ((String)this.getDisplayFieldValue("miswriteminValue")).trim()).length() > 0) {
            int miswritemin = Integer.parseInt(miswriteminStr);
            if (miswritemin != properties.getMisAlignedWriteMin()) {
                properties.setMisAlignedWriteMin(miswritemin);
            }
        } else {
            properties.setMisAlignedWriteMin(-1);
        }
        int miswriteminUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("miswriteminUnit"));
        if (miswriteminUnit != properties.getMisAlignedWriteMinUnit()) {
            properties.setMisAlignedWriteMinUnit(miswriteminUnit);
        }
        if ("yes".equals(dioszero = (String)this.getDisplayFieldValue("dioszeroValue"))) {
            if (!properties.isDirectIOZeroing()) {
                properties.setDirectIOZeroing(true);
            }
        } else if (properties.isDirectIOZeroing()) {
            properties.setDirectIOZeroing(false);
        }
    }

    private void saveArchiveProperties(FileSystemMountProperties properties) {
        String runArchive;
        String stagetryStr;
        String partialStageStr;
        String maxpartialRelStr;
        String partialRelStr = ((String)this.getDisplayFieldValue("partreleaseValue")).trim();
        if (partialRelStr.length() > 0) {
            int partialRel = Integer.parseInt(partialRelStr);
            if (partialRel != properties.getDefaultPartialReleaseSize()) {
                properties.setDefaultPartialReleaseSize(partialRel);
            }
        } else {
            properties.setDefaultPartialReleaseSize(-1);
        }
        int partreleaseUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("partreleaseUnit"));
        if (partreleaseUnit != properties.getDefaultPartialReleaseSizeUnit()) {
            properties.setDefaultPartialReleaseSizeUnit(partreleaseUnit);
        }
        if ((maxpartialRelStr = ((String)this.getDisplayFieldValue("maxpartValue")).trim()).length() > 0) {
            int maxpartialRel = Integer.parseInt(maxpartialRelStr);
            if (maxpartialRel != properties.getDefaultMaxPartialReleaseSize()) {
                properties.setDefaultMaxPartialReleaseSize(maxpartialRel);
            }
        } else {
            properties.setDefaultMaxPartialReleaseSize(-1);
        }
        int maxpartUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("maxpartUnit"));
        if (maxpartUnit != properties.getDefaultMaxPartialReleaseSizeUnit()) {
            properties.setDefaultMaxPartialReleaseSizeUnit(maxpartUnit);
        }
        if ((partialStageStr = ((String)this.getDisplayFieldValue("partstageValue")).trim()).length() > 0) {
            long partialStage = Long.parseLong(partialStageStr);
            if (partialStage != properties.getPartialStageSize()) {
                properties.setPartialStageSize(partialStage);
            }
        } else {
            properties.setPartialStageSize(-1L);
        }
        int partstageUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("partstageUnit"));
        if (partstageUnit != properties.getPartialStageSizeUnit()) {
            properties.setPartialStageSizeUnit(partstageUnit);
        }
        if ((stagetryStr = ((String)this.getDisplayFieldValue("stageretriesValue")).trim()).length() > 0) {
            int stagetry = Integer.parseInt(stagetryStr);
            if (stagetry != properties.getNoOfStageRetries()) {
                properties.setNoOfStageRetries(stagetry);
            }
        } else {
            properties.setNoOfStageRetries(-1);
        }
        String windowStr = ((String)this.getDisplayFieldValue("stagewindowValue")).trim();
        if (windowStr.length() > 0) {
            long window = Long.parseLong(windowStr);
            if (window != properties.getStageWindowSize()) {
                properties.setStageWindowSize(window);
            }
        } else {
            properties.setStageWindowSize(-1L);
        }
        int stagewindowUnit = SamUtil.getSizeUnit((String)this.getDisplayFieldValue("stagewindowUnit"));
        if (stagewindowUnit != properties.getStageWindowSizeUnit()) {
            properties.setStageWindowSizeUnit(stagewindowUnit);
        }
        if ("yes".equals(runArchive = (String)this.getDisplayFieldValue("questionValue"))) {
            if (!properties.isArchiverAutoRun()) {
                properties.setArchiverAutoRun(true);
            }
        } else if (properties.isArchiverAutoRun()) {
            properties.setArchiverAutoRun(false);
        }
    }

    private String getFSName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
    }

    private String getPageType() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_MOUNT_PAGE_TYPE");
    }

    private String getSharedClientType() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_SHARED_CLIENT_HOST");
    }

    private String getServerName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
    }

    private boolean isArchive() {
        Integer type = (Integer)this.getParentViewBean().getPageSessionAttribute("SAMQFS_ARCHIVE_TYPE");
        if (type == null) {
            return false;
        }
        return type == 2;
    }

    private boolean is44() {
        try {
            ServerInfo serverInfo = SamUtil.getServerInfo(this.getServerName());
            return !SamUtil.isVersionCurrentOrLaterThan(serverInfo.getSamfsServerAPIVersion(), "1.4");
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("Failed to retrieve server version number!");
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

