/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.fs.FSAddPoliciesView;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class FSAddPoliciesViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "FSAddPolicies";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/fs/FSAddPolicies.jsp";
    private static final String CHILD_CONTAINER_VIEW = "FSAddPoliciesView";
    public static final String CHILD_ALERT = "Alert";
    private CCPageTitleModel pageTitleModel = null;
    public static final String CHILD_COMMAND_ADD_POLICIES_HREF = "AddPoliciesHref";
    public static final String CHILD_COMMAND_CANCEL_HREF = "CancelHref";
    public static final String CHILD_ADD_POLICIES_HIDDEN_FIELD = "AddPoliciesHiddenField";
    private boolean error = false;
    public static final String CHILD_STATICTEXT = "StaticText";
    public static final String ADDED_CRITERIA = "addedPolicyCriteria";
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSAddPoliciesView;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean;

    public FSAddPoliciesViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(CHILD_CONTAINER_VIEW, class$com$sun$netstorage$samqfs$web$fs$FSAddPoliciesView == null ? (class$com$sun$netstorage$samqfs$web$fs$FSAddPoliciesView = FSAddPoliciesViewBean.class$("com.sun.netstorage.samqfs.web.fs.FSAddPoliciesView")) : class$com$sun$netstorage$samqfs$web$fs$FSAddPoliciesView);
        this.registerChild(CHILD_COMMAND_ADD_POLICIES_HREF, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = FSAddPoliciesViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(CHILD_COMMAND_CANCEL_HREF, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = FSAddPoliciesViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(CHILD_ADD_POLICIES_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = FSAddPoliciesViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSAddPoliciesViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_STATICTEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = FSAddPoliciesViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(ADDED_CRITERIA, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSAddPoliciesViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering with name = " + name);
        if (name.equals(ADDED_CRITERIA)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (super.isChildSupported(name)) {
            TraceUtil.trace3("Exiting");
            return super.createChild(name);
        }
        if (name.equals(CHILD_CONTAINER_VIEW)) {
            TraceUtil.trace3("Exiting");
            return new FSAddPoliciesView((View)this, name);
        }
        if (name.equals(CHILD_STATICTEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_COMMAND_ADD_POLICIES_HREF)) {
            CCStaticTextField child = null;
            ViewBean vb = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean = FSAddPoliciesViewBean.class$("com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean);
            child = new CCStaticTextField((ContainerView)this, name, (Object)((CommonTableContainerView)vb.getChild("FSArchivePoliciesView")).getChild("AddCriteriaHref").getQualifiedName());
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_COMMAND_CANCEL_HREF)) {
            CCStaticTextField child = null;
            ViewBean vb = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean = FSAddPoliciesViewBean.class$("com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean);
            child = new CCStaticTextField((ContainerView)this, name, (Object)((CommonTableContainerView)vb.getChild("FSArchivePoliciesView")).getChild(CHILD_COMMAND_CANCEL_HREF).getQualifiedName());
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_ADD_POLICIES_HIDDEN_FIELD)) {
            CCStaticTextField child = null;
            ViewBean vb = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean = FSAddPoliciesViewBean.class$("com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesViewBean);
            child = new CCStaticTextField((ContainerView)this, name, (Object)((CommonTableContainerView)vb.getChild("FSArchivePoliciesView")).getChild("AddCriteriaHiddenField").getQualifiedName());
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            TraceUtil.trace3("Exiting");
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/fs/FSAddPolicyCriteriaPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    public String getFSName() {
        TraceUtil.trace3("Entering");
        String fsName = (String)this.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        if (fsName == null) {
            fsName = RequestManager.getRequest().getParameter("fsNameParam");
            this.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)fsName));
        }
        TraceUtil.trace3("Exiting");
        return fsName;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        String fsName = this.getFSName();
        String serverName = this.getServerName();
        FSAddPoliciesView view = (FSAddPoliciesView)this.getChild(CHILD_CONTAINER_VIEW);
        try {
            view.populateData();
        }
        catch (SamFSException ex) {
            this.error = true;
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "beginDisplay()", "Unable to populate archive policy criteria data", serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSAddPolicyCriteria.error.failedPopulate", ex.getSAMerrno(), ex.getMessage(), serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String serverName = this.getServerName();
        String fsName = this.getFSName();
        String policyCriteriaString = (String)this.getDisplayFieldValue(ADDED_CRITERIA);
        TraceUtil.trace2("Got new policy criteria: " + policyCriteriaString);
        StringTokenizer tokens = new StringTokenizer(policyCriteriaString, ",");
        int count = tokens.countTokens();
        String[] policyNames = new String[count];
        int[] criteriaNumbers = new int[count];
        for (int i = 0; i < count; ++i) {
            String token = tokens.nextToken();
            int index = token.indexOf(58);
            policyNames[i] = token.substring(0, index);
            criteriaNumbers[i] = Integer.parseInt(token.substring(index + 1));
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(fsName);
            if (fs2 == null) {
                throw new SamFSException(null, -1000);
            }
            ArchivePolCriteria[] policyCriteria = new ArchivePolCriteria[count];
            for (int i = 0; i < count; ++i) {
                ArchivePolicy policy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyNames[i]);
                if (policy == null) {
                    throw new SamFSException(null, -1001);
                }
                policyCriteria[i] = policy.getArchivePolCriteria(criteriaNumbers[i]);
                if (policyCriteria[i] != null) continue;
                throw new SamFSException(null, -1001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleAddCriteriaHrefRequest", "Start adding policy criteria");
            fs2.addPolCriteria(policyCriteria);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleAddCriteriaHrefRequest", "Done adding policy criteria");
            SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", "FSArchivePolicies.msg.addPolicyCriteria", serverName);
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException ex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (ex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
                this.setSubmitSuccessful(true);
            } else {
                processMsg = "Failed to add policy criteria";
                errMsg = "FSArchivePolicies.error.addPolicyCriteria";
                errCause = ex.getMessage();
            }
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleAddCriteriaHrefRequest()", processMsg, serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, errMsg, ex.getSAMerrno(), errCause, serverName);
            }
            SamUtil.setWarningAlert((ContainerView)this, CHILD_ALERT, errMsg, errCause);
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

