/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.DiskVSNHostBean;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class PolicyUtil {
    public static final String ARCHIVE_MANAGER = "SamQFSSystemArchiveManager43";
    public static final String CRITERIA = "CurrentArchivePolCriteria";
    public static final String CRITERIA_COPY = "CurrentArchivePolCriterialCopy";
    public static final String POLICY = "CurrentArchivePolicy";
    public static final String ALL_POOLS = "all_archive_vsn_pools";
    public static long BYTE = 1L;
    public static long KB = 1024L;
    public static long MB = KB * 1024L;
    public static long GB = MB * 1024L;
    public static long TB = GB * 1024L;
    public static long PB = TB * 1024L;
    public static long SIZELIMIT = 8000000L;
    public static int SIZELIMIT_UNIT = 4;
    public static long SECOND = 1L;
    public static long MINUTE = SECOND * 60L;
    public static long HOUR = MINUTE * 60L;
    public static long DAY = HOUR * 24L;
    public static long WEEK = DAY * 7L;
    public static long[] SIZE_VALUES = new long[]{SECOND, MINUTE, HOUR, DAY, WEEK};
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$PolicyUtil;

    public static SamQFSSystemArchiveManager43 getArchiveManager(String serverName) throws SamFSException {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        SamQFSSystemArchiveManager43 archiveManager = (SamQFSSystemArchiveManager43)request.getAttribute(ARCHIVE_MANAGER);
        if (archiveManager != null) {
            return archiveManager;
        }
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        archiveManager = sysModel.getSamQFSSystemArchiveManager43();
        if (archiveManager == null) {
            throw new SamFSException(null, -2002);
        }
        request.setAttribute(ARCHIVE_MANAGER, (Object)archiveManager);
        return archiveManager;
    }

    public static void resetArchiveManager(CommonViewBeanBase vb) {
        String serverName = vb.getServerName();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            sysModel.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), class$com$sun$netstorage$samqfs$web$archive$PolicyUtil == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicyUtil = PolicyUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicyUtil")) : class$com$sun$netstorage$samqfs$web$archive$PolicyUtil, "resetArchiveManager", "Error resetting the archive manager", serverName);
            SamUtil.setWarningAlert((ContainerView)vb, "Alert", "ArchiveConfig.error.summary", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), class$com$sun$netstorage$samqfs$web$archive$PolicyUtil == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicyUtil = PolicyUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicyUtil")) : class$com$sun$netstorage$samqfs$web$archive$PolicyUtil, "resetArchiveManager", "error resetting the archive manager", serverName);
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", "ArchiveConfig.error.summary", smme.getSAMerrno(), "ArchiveConfig.error.detail", serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), class$com$sun$netstorage$samqfs$web$archive$PolicyUtil == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicyUtil = PolicyUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicyUtil")) : class$com$sun$netstorage$samqfs$web$archive$PolicyUtil, "resetArchiveManager", "Error resetting the archive manager", serverName);
            SamUtil.setErrorAlert((ContainerView)vb, "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
    }

    public static ArchiveVSNMap getAllsetsCopyVSNMap(ArchiveCopy theCopy, String serverName) throws SamFSException {
        SamQFSSystemModel model = SamUtil.getModel(serverName);
        ArchivePolicy allsetsPolicy = model.getSamQFSSystemArchiveManager43().getArchivePolicy("allsets");
        ArchiveVSNMap vsnMap = null;
        if (theCopy.getArchivePolicy().getPolicyType() != 1004) {
            ArchiveCopy matchingAllsetsCopy = allsetsPolicy.getArchiveCopy(theCopy.getCopyNumber());
            vsnMap = matchingAllsetsCopy.getArchiveVSNMap();
        }
        if (vsnMap == null) {
            vsnMap = allsetsPolicy.getArchiveCopy(5).getArchiveVSNMap();
        }
        if (vsnMap == null) {
            throw new SamFSException(null, -2007);
        }
        return vsnMap;
    }

    public static final ArchivePolCriteriaCopy getArchivePolCriteriaCopy(ArchivePolCriteria theCriteria, int copyNumber2) {
        ArchivePolCriteriaCopy[] copies = theCriteria.getArchivePolCriteriaCopies();
        boolean found = false;
        ArchivePolCriteriaCopy theCopy = null;
        for (int i = 0; i < copies.length && !found; ++i) {
            if (copyNumber2 != copies[i].getArchivePolCriteriaCopyNumber()) continue;
            found = true;
            theCopy = copies[i];
        }
        return theCopy;
    }

    public static boolean policyExists(String serverName, String policyName) {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        boolean exists = false;
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemModel sysModel = appModel.getSamQFSSystemModel(serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            SamQFSSystemArchiveManager43 archiveManager = sysModel.getSamQFSSystemArchiveManager43();
            if (archiveManager == null) {
                throw new SamFSException(null, -2002);
            }
            if (archiveManager.getArchivePolicy(policyName) != null) {
                exists = true;
            }
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), class$com$sun$netstorage$samqfs$web$archive$PolicyUtil == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicyUtil = PolicyUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicyUtil")) : class$com$sun$netstorage$samqfs$web$archive$PolicyUtil, "policyExists", "unable to determine policy's existence", serverName);
        }
        TraceUtil.trace3("Exiting");
        return exists;
    }

    public static String[] getSamQFSHosts() throws SamFSException {
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        appModel.updateDownServers();
        SamQFSSystemModel[] allModels = appModel.getAllSamQFSSystemModels();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < allModels.length; ++i) {
            if (allModels[i].isDown()) continue;
            list.add(allModels[i].getHostname());
        }
        String[] hosts = new String[list.size()];
        hosts = list.toArray(hosts);
        return hosts;
    }

    public static DiskVSNHostBean getSamQFSServerInfo() throws SamFSException {
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        appModel.updateDownServers();
        SamQFSSystemModel[] allModels = appModel.getAllSamQFSSystemModels();
        boolean hasOlderServer = false;
        ArrayList<String> hosts = new ArrayList<String>();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        for (int i = 0; i < allModels.length; ++i) {
            if (allModels[i].isDown()) continue;
            hosts.add(allModels[i].getHostname());
            if ("1.3".compareTo(allModels[i].getServerAPIVersion()) <= 0) {
                buffer.append(allModels[i].getHostname()).append(";");
                continue;
            }
            hasOlderServer = true;
        }
        String[] hostArray = new String[hosts.size()];
        hostArray = hosts.toArray(hostArray);
        String hostString = buffer.toString();
        if (hostString.length() > 0 && hostString.lastIndexOf(";") != -1) {
            hostString = hostString.substring(0, hostString.lastIndexOf(";"));
        }
        return new DiskVSNHostBean(hostArray, hostString, hasOlderServer);
    }

    public static String getSortMethodString(int sm) {
        String result = "";
        switch (sm) {
            case 10: {
                result = SamUtil.getResourceString("archiving.sort.method.age");
                break;
            }
            case 9: {
                result = SamUtil.getResourceString("archiving.sort.method.none");
                break;
            }
            case 8: {
                result = SamUtil.getResourceString("archiving.sort.method.notset");
                break;
            }
            case 11: {
                result = SamUtil.getResourceString("archiving.sort.method.path");
                break;
            }
            case 12: {
                result = SamUtil.getResourceString("archiving.sort.method.priority");
                break;
            }
            case 13: {
                result = SamUtil.getResourceString("archiving.sort.method.size");
            }
        }
        return result;
    }

    public static String getReservationMethodString(int res) {
        String result = "";
        switch (res) {
            case 16: {
                result = SamUtil.getResourceString("archiving.reservation.method.dir");
                break;
            }
            case 14: {
                result = SamUtil.getResourceString("archiving.reservation.method.fs");
                break;
            }
            case 18: {
                result = SamUtil.getResourceString("archiving.reservation.method.group");
                break;
            }
            case 15: {
                result = SamUtil.getResourceString("archiving.reservation.method.policy");
                break;
            }
            case 17: {
                result = SamUtil.getResourceString("archiving.reservation.method.user");
            }
        }
        return result;
    }

    public static String getOfflineCopyMethodString(int oc) {
        String result = "";
        switch (oc) {
            case 5: {
                result = SamUtil.getResourceString("archiving.offlinecopy.method.direct");
                break;
            }
            case 4: {
                result = SamUtil.getResourceString("archiving.offlinecopy.method.none");
                break;
            }
            case 3: {
                result = SamUtil.getResourceString("archiving.offlinecopy.method.notset");
                break;
            }
            case 6: {
                result = SamUtil.getResourceString("archiving.offlinecopy.method.stageahead");
                break;
            }
            case 7: {
                result = SamUtil.getResourceString("archiving.offlinecopy.method.stageall");
            }
        }
        return result;
    }

    public static String getArchivingTypeString(String type) {
        if (type.equals("tape")) {
            return SamUtil.getResourceString("archiving.type.tape");
        }
        if (type.equals("disk")) {
            return SamUtil.getResourceString("archiving.type.disk");
        }
        return SamUtil.getResourceString("archiving.type.none");
    }

    public static String getTimeUnitAsString(int value) {
        switch (value) {
            case 5: {
                return SamUtil.getResourceString("ArchiveSetup.seconds");
            }
            case 6: {
                return SamUtil.getResourceString("ArchiveSetup.minutes");
            }
            case 7: {
                return SamUtil.getResourceString("ArchiveSetup.hours");
            }
            case 8: {
                return SamUtil.getResourceString("ArchiveSetup.days");
            }
            case 9: {
                return SamUtil.getResourceString("ArchiveSetup.weeks");
            }
        }
        return SamUtil.getResourceString("ArchiveSetup.seconds");
    }

    public static boolean isValidNamePattern(String namePattern) {
        int index = namePattern.length();
        for (int i = 0; i < index; ++i) {
            char a = namePattern.charAt(i);
            if (a != '*') continue;
            if (i == 0) {
                return false;
            }
            char p = namePattern.charAt(i - 1);
            if (p == '\\') continue;
            return false;
        }
        return true;
    }

    public static boolean isGroupValid(String group, String serverName) {
        boolean result = false;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            result = sysModel.getSamQFSSystemArchiveManager43().isValidGroup(group);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), class$com$sun$netstorage$samqfs$web$archive$PolicyUtil == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicyUtil = PolicyUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicyUtil")) : class$com$sun$netstorage$samqfs$web$archive$PolicyUtil, "isGroupValid", "validate group");
        }
        return result;
    }

    public static boolean isUserValid(String user, String serverName) {
        boolean result = false;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            result = sysModel.getSamQFSSystemArchiveManager43().isValidUser(user);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), class$com$sun$netstorage$samqfs$web$archive$PolicyUtil == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicyUtil = PolicyUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicyUtil")) : class$com$sun$netstorage$samqfs$web$archive$PolicyUtil, "isUserValid", "validate user");
        }
        return result;
    }

    public static final boolean isMaxGreaterThanMin(long minVal, int minUnit, long maxVal, int maxUnit) {
        boolean result = false;
        if (PolicyUtil.getBigSize(maxVal, maxUnit).compareTo(PolicyUtil.getBigSize(minVal, minUnit)) >= 0) {
            result = true;
        }
        return result;
    }

    public static final long getUnitByteValue(int unit) {
        switch (unit) {
            case 0: {
                return BYTE;
            }
            case 1: {
                return KB;
            }
            case 2: {
                return MB;
            }
            case 3: {
                return GB;
            }
            case 4: {
                return TB;
            }
            case 41: {
                return PB;
            }
        }
        return BYTE;
    }

    public static String getStagingOptionString(int optionValue) {
        String optionString = "";
        switch (optionValue) {
            case 10001: {
                optionString = "archiving.criteria.staging.associative";
                break;
            }
            case 10002: {
                optionString = "archiving.criteria.staging.never";
                break;
            }
            case 10003: {
                optionString = "archiving.criteria.staging.defaults";
            }
        }
        return SamUtil.getResourceString(optionString);
    }

    public static String getReleasingOptionString(int optionValue) {
        String optionString = "";
        switch (optionValue) {
            case 10005: {
                optionString = "archiving.criteria.releasing.never";
                break;
            }
            case 10006: {
                optionString = "archiving.criteria.releasing.partial";
                break;
            }
            case 10007: {
                optionString = "archiving.criteria.releasing.onecopy";
                break;
            }
            case 10008: {
                optionString = "archiving.criteria.releasing.defaults";
            }
        }
        return SamUtil.getResourceString(optionString);
    }

    public static BigInteger getBigSize(long size, int unit) {
        BigInteger newsize = new BigInteger(new Long(size).toString());
        switch (unit) {
            case 0: {
                break;
            }
            case 1: {
                newsize = newsize.multiply(new BigInteger(new Long(KB).toString()));
                break;
            }
            case 2: {
                newsize = newsize.multiply(new BigInteger(new Long(MB).toString()));
                break;
            }
            case 3: {
                newsize = newsize.multiply(new BigInteger(new Long(GB).toString()));
                break;
            }
            case 4: {
                newsize = newsize.multiply(new BigInteger(new Long(TB).toString()));
                break;
            }
            case 41: {
                newsize = newsize.multiply(new BigInteger(new Long(PB).toString()));
                break;
            }
        }
        return newsize;
    }

    public static boolean isOverFlow(long size, int sizeunit) {
        boolean isoverflow = false;
        if (PolicyUtil.getBigSize(size, sizeunit).compareTo(PolicyUtil.getBigSize(SIZELIMIT, SIZELIMIT_UNIT)) > 0) {
            isoverflow = true;
        }
        return isoverflow;
    }

    public static boolean isValidSize(long size, int unit) {
        if (size <= 0L) {
            return false;
        }
        return !PolicyUtil.isOverFlow(size, unit);
    }

    public static boolean isValidTime(long time, int unit) {
        if (time <= 0L) {
            return false;
        }
        return !PolicyUtil.isTimeOverFlow(time, unit);
    }

    public static boolean isTimeOverFlow(long time, int unit) {
        int index = unit - 5;
        if (index < 0 || index > 9) {
            return false;
        }
        BigInteger value = new BigInteger(new Long(time).toString());
        int result = (value = value.multiply(new BigInteger(Long.toString(SIZE_VALUES[index])))).compareTo(new BigInteger("2147483646"));
        return result > 0;
    }

    public static String getPolicyTypeString(ArchivePolicy policy) {
        String type = "";
        switch (policy.getPolicyType()) {
            case 1001: {
                type = "archiving.policy.type.default";
                break;
            }
            case 1003: {
                type = "archiving.policy.type.noarchive";
                break;
            }
            case 1004: {
                type = "archiving.policy.type.settabledefaults";
                break;
            }
            case 1002: {
                type = "archiving.policy.type.custom";
                break;
            }
        }
        return type;
    }

    public static String getArchiveAgeString(ArchivePolCriteria criteria) throws SamFSException {
        ArchivePolCriteriaCopy[] copy = criteria.getArchivePolCriteriaCopies();
        if (copy == null || copy.length == 0) {
            return "";
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        for (int i = 0; i < copy.length; ++i) {
            buf.append(SamUtil.getResourceString("archiving.copynumber", Integer.toString(copy[i].getArchivePolCriteriaCopyNumber()))).append(": ").append(copy[i].getArchiveAge()).append(" ").append(SamUtil.getTimeUnitL10NString(copy[i].getArchiveAgeUnit())).append("<br>");
        }
        String result = buf.toString();
        return result;
    }

    public static final String getMediaTypeString(ArchivePolCriteria criteria) throws SamFSException {
        ArchivePolCriteriaCopy[] copy = criteria.getArchivePolCriteriaCopies();
        if (copy == null || copy.length == 0) {
            return "";
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        for (int i = 0; i < copy.length; ++i) {
            buf.append(SamUtil.getResourceString("archiving.copynumber", Integer.toString(copy[i].getArchivePolCriteriaCopyNumber()))).append(": ");
            ArchiveVSNMap vsnMap = criteria.getArchivePolicy().getArchiveCopy(copy[i].getArchivePolCriteriaCopyNumber()).getArchiveVSNMap();
            int mediaType = vsnMap != null ? vsnMap.getArchiveMediaType() : -1;
            String mediaTypeString = "";
            mediaTypeString = mediaType < 0 ? SamUtil.getResourceString("common.mediatype.unknown") : (mediaType == 133 ? SamUtil.getResourceString("common.mediatype.disk") : SamUtil.getResourceString("common.mediatype.tape"));
            buf.append(mediaTypeString).append("<br>");
        }
        String result = buf.toString();
        return result;
    }

    public static String getVSNString(String[] vsns) {
        if (vsns == null || vsns.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean longEnough = false;
        int length = 60;
        for (int i = 0; i < vsns.length && !longEnough; ++i) {
            if (buf.length() + vsns[i].length() >= length) {
                longEnough = true;
                continue;
            }
            buf.append(vsns[i]).append(", ");
        }
        if (buf.length() > 0 && buf.lastIndexOf(",") != -1) {
            buf.deleteCharAt(buf.lastIndexOf(","));
        }
        if (!longEnough) {
            buf.append("(").append(vsns.length).append(")");
        } else {
            buf.append("... (").append(vsns.length).append(")");
        }
        return buf.toString();
    }

    public static String getPolicyFSString(ArchivePolicy policy) throws SamFSException {
        ArrayList<String> fsList = new ArrayList<String>();
        ArchivePolCriteria[] criteria = policy.getArchivePolCriteria();
        for (int i = 0; i < criteria.length; ++i) {
            FileSystem[] filesystems = criteria[i].getFileSystemsForCriteria();
            for (int j = 0; j < filesystems.length; ++j) {
                String fsName = filesystems[j].getName();
                if (fsList.contains(fsName)) continue;
                fsList.add(fsName);
            }
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        Iterator it = fsList.iterator();
        while (it.hasNext()) {
            buffer.append((String)it.next()).append(", ");
        }
        String temp = buffer.toString();
        int index = temp.lastIndexOf(", ");
        if (index > 0) {
            return temp.substring(0, index);
        }
        return "";
    }

    public static String getSizeString(long size, int unit) {
        String result = "";
        if (size > 0L) {
            result = result.concat(NumberFormat.getInstance().format(size)).concat(" ").concat(SamUtil.getSizeUnitL10NString(unit));
        }
        return result;
    }

    public static VSNPool[] getAllVSNPools(String serverName) throws SamFSException {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        VSNPool[] allPools = (VSNPool[])request.getAttribute(ALL_POOLS);
        if (allPools == null || allPools.length == 0) {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            allPools = sysModel.getSamQFSSystemArchiveManager43().getAllVSNPools();
            request.setAttribute(ALL_POOLS, (Object)allPools);
        }
        return allPools;
    }

    public static String[] getVSNPoolNames(int mediaType, String serverName) throws SamFSException {
        String[] vsnPoolNames = null;
        VSNPool[] allPools = PolicyUtil.getAllVSNPools(serverName);
        if (mediaType == -999) {
            vsnPoolNames = new String[allPools.length];
            for (int i = 0; i < allPools.length; ++i) {
                vsnPoolNames[i] = allPools[i].getPoolName();
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < allPools.length; ++i) {
                if (allPools[i].getMediaType() != mediaType) continue;
                list.add(allPools[i].getPoolName());
            }
            vsnPoolNames = new String[list.size()];
            vsnPoolNames = list.toArray(vsnPoolNames);
        }
        if (vsnPoolNames == null) {
            vsnPoolNames = new String[]{};
        }
        return vsnPoolNames;
    }

    public static String encodePoolMediaTypeString(String serverName) throws SamFSException {
        NonSyncStringBuffer buf;
        SamQFSSystemModel model = SamUtil.getModel(serverName);
        int[] mediaTypes = model.getSamQFSSystemMediaManager().getAvailableArchiveMediaTypes();
        HashMap<String, NonSyncStringBuffer> map = new HashMap<String, NonSyncStringBuffer>();
        for (int i = 0; i < mediaTypes.length; ++i) {
            String key = Integer.toString(mediaTypes[i]);
            buf = new NonSyncStringBuffer();
            buf.append(key).append("=").append("--");
            map.put(key, buf);
        }
        VSNPool[] pool = PolicyUtil.getAllVSNPools(serverName);
        for (int i = 0; i < pool.length; ++i) {
            String key = Integer.toString(pool[i].getMediaType());
            NonSyncStringBuffer buf2 = (NonSyncStringBuffer)map.get(key);
            if (buf2 == null) continue;
            buf2.append(",").append(pool[i].getPoolName());
        }
        Iterator it = map.values().iterator();
        buf = new NonSyncStringBuffer();
        while (it.hasNext()) {
            buf.append(((NonSyncStringBuffer)it.next()).toString()).append(";");
        }
        String result = buf.toString();
        if (result != null && result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static int getPercentUsage(long c, long f) {
        if (c <= 0L || f < 0L) {
            return -1;
        }
        double capacity = c;
        double free = f;
        return 100 - (int)(free / capacity * 100.0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ReleaseOptions {
        public static final int SPACE_REQUIRED = 0;
        public static final int IMMEDIATELY = 2;
        public static final int WAIT_FOR_ALL = 4;
    }
}

