/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.DiskVSNHostBean;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserModel;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import javax.servlet.ServletException;

public class NewDiskVSNViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "NewDiskVSN";
    private static final String DEFAULT_URL = "/jsp/archive/NewDiskVSN.jsp";
    public static final String NAME_LABEL = "vsnNameLabel";
    public static final String NAME = "vsnName";
    public static final String HOST_LABEL = "vsnHostLabel";
    public static final String HOST = "vsnHost";
    public static final String PATH_LABEL = "vsnPathLabel";
    public static final String FILE_CHOOSER = "filechooser";
    public static final String REQUIRED_MESSAGE = "allRequiredLabel";
    public static final String BROWSE_RULES = "browsingRules";
    public static final String CREATE_PATH = "createPath";
    public static final String RFC_HOSTS = "RFCCapableHosts";
    public static final String PAGE_TITLE = "pageTitle";
    private CCPageTitleModel ptModel = null;
    private RemoteFileChooserModel fcModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCDropDownMenu;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCCheckBox;

    public NewDiskVSNViewBean() {
        super(PAGE_NAME, DEFAULT_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createPageTitleModel();
        this.createFileChooserModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(NAME_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(HOST_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(PATH_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(NAME, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(HOST, class$com$sun$web$ui$view$html$CCDropDownMenu == null ? (class$com$sun$web$ui$view$html$CCDropDownMenu = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCDropDownMenu")) : class$com$sun$web$ui$view$html$CCDropDownMenu);
        this.registerChild(REQUIRED_MESSAGE, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(BROWSE_RULES, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(RFC_HOSTS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(FILE_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = NewDiskVSNViewBean.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CREATE_PATH, class$com$sun$web$ui$view$html$CCCheckBox == null ? (class$com$sun$web$ui$view$html$CCCheckBox = NewDiskVSNViewBean.class$("com.sun.web.ui.view.html.CCCheckBox")) : class$com$sun$web$ui$view$html$CCCheckBox);
        this.ptModel.registerChildren((ContainerViewBase)this);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(PAGE_TITLE)) {
            return new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        }
        if (name.equals(NAME_LABEL) || name.equals(HOST_LABEL) || name.equals(PATH_LABEL) || name.equals(REQUIRED_MESSAGE)) {
            return new CCLabel((ContainerView)this, name, null);
        }
        if (name.equals(CREATE_PATH)) {
            return new CCCheckBox((ContainerView)this, name, (Object)"true", (Object)"false", false);
        }
        if (name.equals(BROWSE_RULES)) {
            return new CCStaticTextField((ContainerView)this, name, null);
        }
        if (name.equals(NAME)) {
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(HOST)) {
            return new CCDropDownMenu((ContainerView)this, name, null);
        }
        if (name.equals(RFC_HOSTS)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(FILE_CHOOSER)) {
            return new RemoteFileChooserControl((ContainerView)this, new RemoteFileChooserModel(null), name);
        }
        if (this.ptModel.isChildSupported(name)) {
            return this.ptModel.createChild((View)this, name);
        }
        if (super.isChildSupported(name)) {
            return super.createChild(name);
        }
        throw new IllegalArgumentException("Invalid child '" + name + "'");
    }

    private void createPageTitleModel() {
        TraceUtil.trace3("Entering");
        this.ptModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/NewDiskVSNPageTitle.xml");
        TraceUtil.trace3("Exiting");
    }

    private void createFileChooserModel() {
        String serverName = RequestManager.getRequestContext().getRequest().getParameter("serverNameParam");
        String rootDir = RequestManager.getRequestContext().getRequest().getParameter("rootDir");
        this.fcModel = new RemoteFileChooserModel(serverName, 50);
        this.fcModel.setHomeDirectory(rootDir);
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(evt);
        String serverName = this.getServerName();
        RemoteFileChooserModel fcModel = (RemoteFileChooserModel)((RemoteFileChooserControl)this.getChild(FILE_CHOOSER)).getModel();
        fcModel.setServerName(serverName);
        try {
            DiskVSNHostBean bean = PolicyUtil.getSamQFSServerInfo();
            String[] hostNames = bean.getLiveHosts();
            if (hostNames == null) {
                throw new SamFSException(null, -2001);
            }
            CCDropDownMenu field = (CCDropDownMenu)this.getChild(HOST);
            field.setOptions(new OptionList(hostNames, hostNames));
            field.setValue((Object)serverName);
            ((CCHiddenField)this.getChild(RFC_HOSTS)).setValue((Object)bean.getRFCCapableHosts());
            if (bean.hasOlderServer()) {
                ((CCStaticTextField)this.getChild(BROWSE_RULES)).setValue((Object)"archiving.remotefilechooser.browsingrules");
            }
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "beingDisplay", "Unable to retrieve host names", serverName);
        }
    }

    public void handleFileChooserRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.forwardTo(this.getRequestContext());
    }

    public void handleCancelRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.forwardTo(this.getRequestContext());
    }

    public void handleSubmitRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        String serverName = this.getServerName();
        try {
            String name = this.getDisplayFieldStringValue(NAME);
            String host = this.getDisplayFieldStringValue(HOST);
            String createPath = this.getDisplayFieldStringValue(CREATE_PATH);
            RemoteFileChooserControl chooser = (RemoteFileChooserControl)this.getChild(FILE_CHOOSER);
            String path = chooser.getDisplayFieldStringValue("browsetextfield");
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            if (createPath.equals("true") || SamUtil.getModel(host).doesFileExist(path)) {
                if (serverName.equals(host)) {
                    host = null;
                }
            } else {
                throw new SamFSException("archiving.diskvsn.newvsn.error.pathnonexistent", -2027);
            }
            sysModel.getSamQFSSystemMediaManager().createDiskVSN(name, host, path);
            SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", SamUtil.getResourceString("archiving.diskvsn.newvsn.create.success", path), serverName);
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "unable to create disk vsn", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "archiving.diskvsn.newvsn.create.failure", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        this.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

