/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.ArchiveSetUpViewBean;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonTiledViewBase;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import javax.servlet.http.HttpServletRequest;

public class MediaParametersTiledView
extends CommonTiledViewBase {
    public MediaParametersTiledView(View parent, CCActionTableModel model, String name) {
        super(parent, model, name);
    }

    public void mapRequestParameters(HttpServletRequest request) throws ModelControlException {
        super.mapRequestParameters(request);
    }

    public boolean beginMaxArchiveFileSizeDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCTextField value = (CCTextField)this.getChild("MaxArchiveFileSize", index);
        try {
            String size = this.getArchiveEditableValue("MaxArchiveFileSize", index);
            String string = size = size != null ? size.trim() : "";
            if (!size.equals("")) {
                Capacity archmax = Capacity.newExactCapacity(Long.parseLong(size), 0);
                value.setValue((Object)String.valueOf(archmax.getSize()));
                String unitStr = String.valueOf(archmax.getUnit());
                this.model.setValue("MaxArchiveFileSizeHiddenField", (Object)unitStr);
            } else {
                value.setValue((Object)"");
                this.model.setValue("MaxArchiveFileSizeHiddenField", (Object)new Integer(2).toString());
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginMaxArchiveFileSizeDisplay", "Fail to set max archive file size value", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginMaxArchiveFileSizeDisplay", "Fail to set max archive file size value", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginMaxArchiveFileSizeUnitDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("MaxArchiveFileSizeUnit", index);
        dropDown.setOptions(new OptionList(SelectableGroupHelper.Sizes.labels, SelectableGroupHelper.Sizes.values));
        try {
            String unitStr = (String)this.model.getValue("MaxArchiveFileSizeHiddenField");
            if (unitStr != null) {
                dropDown.setValue((Object)unitStr);
            }
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginMaxArchiveFileSizeUnitDisplay", "Fail to set max archive file size unit", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginMinSizeForOverflowUnitDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("MinSizeForOverflowUnit", index);
        dropDown.setOptions(new OptionList(SelectableGroupHelper.Sizes.labels, SelectableGroupHelper.Sizes.values));
        try {
            String unitStr = (String)this.model.getValue("MinSizeForOverflowHiddenField");
            if (unitStr != null) {
                dropDown.setValue((Object)unitStr);
            }
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginMinSizeForOverflowUnitDisplay", "Fail to set min size for overflow unit", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginMinSizeForOverflowDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCTextField value = (CCTextField)this.getChild("MinSizeForOverflow", index);
        try {
            String size = this.getArchiveEditableValue("MinSizeForOverflow", index);
            TraceUtil.trace3("Min overflow size = " + size);
            String string = size = size != null ? size.trim() : "";
            if (!size.equals("")) {
                Capacity ovflmin = Capacity.newExactCapacity(Long.parseLong(size), 0);
                value.setValue((Object)String.valueOf(ovflmin.getSize()));
                String unitStr = String.valueOf(ovflmin.getUnit());
                this.model.setValue("MinSizeForOverflowHiddenField", (Object)unitStr);
            } else {
                value.setValue((Object)"");
                this.model.setValue("MinSizeForOverflowHiddenField", (Object)new Integer(2).toString());
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginMinSizeForOverflowDisplay", "Failed to set the minimum size for overflow value", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginMinSizeForOverflowDisplay", "Failed to set the minimum size for overflow value", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginArchiveBufferLockDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCCheckBox lock = (CCCheckBox)this.getChild("ArchiveBufferLock", index);
        try {
            lock.setValue((Object)this.getArchiveEditableValue("ArchiveBufferLock", index));
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginArchiveBufferLockDisplay", "Failed to set the lock", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginArchiveBufferLockDisplay", "Failed to set the lock", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginArchiveBufferSizeDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCTextField buffer = (CCTextField)this.getChild("ArchiveBufferSize", index);
        try {
            String size = this.getArchiveEditableValue("ArchiveBufferSize", index);
            if (!size.equals("-1")) {
                buffer.setValue((Object)size);
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginArchiveBufferSizeDisplay", "Failed to set buffer size", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginArchiveBufferSizeDisplay", "Failed to set buffer size", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private String getArchiveEditableValue(String type, int index) throws ModelControlException, SamFSException {
        BufferDirective buffer;
        BufferDirective[] buffers;
        TraceUtil.trace3("Entering");
        String value = "";
        GlobalArchiveDirective globalDir = ((ArchiveSetUpViewBean)this.getParentViewBean()).getGlobalDirective();
        if (globalDir == null) {
            throw new SamFSException(null, -2015);
        }
        if (type.equals("ArchiveBufferSize")) {
            BufferDirective buffer2;
            BufferDirective[] buffers2 = globalDir.getBufferSize();
            if (buffers2.length != 0 && (buffer2 = buffers2[index]) != null) {
                value = String.valueOf(buffer2.getSize());
                int mtype = buffer2.getMediaType();
                String mString = SamUtil.getMediaTypeString(mtype);
            }
        } else if (type.equals("ArchiveBufferLock")) {
            BufferDirective[] buffers3 = globalDir.getBufferSize();
            if (buffers3.length != 0) {
                BufferDirective buffer3 = buffers3[index];
                if (buffer3 != null) {
                    value = buffer3.isLocked() ? "true" : "false";
                    int mtype = buffer3.getMediaType();
                    String mString = SamUtil.getMediaTypeString(mtype);
                }
            } else {
                value = "false";
            }
        } else if (type.equals("MaxArchiveFileSize")) {
            BufferDirective buffer4;
            BufferDirective[] buffers4 = globalDir.getMaxFileSize();
            if (buffers4.length != 0 && (buffer4 = buffers4[index]) != null) {
                value = buffer4.getSizeString();
                int mtype = buffer4.getMediaType();
                String mString = SamUtil.getMediaTypeString(mtype);
            }
        } else if (type.equals("MinSizeForOverflow") && (buffers = globalDir.getMinFileSizeForOverflow()).length != 0 && (buffer = buffers[index]) != null) {
            value = buffer.getSizeString();
            int mtype = buffer.getMediaType();
            String mString = SamUtil.getMediaTypeString(mtype);
        }
        value = value != null ? value.trim() : "";
        TraceUtil.trace3(new NonSyncStringBuffer("Value for ").append(type).append(" is ").append(value).toString());
        TraceUtil.trace3("Exiting");
        return value;
    }

    public boolean beginStageBufferLockDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            ((CCCheckBox)this.getChild("StageBufferLock", index)).setValue((Object)this.getStagerEditableValue("StageBufferLock", index));
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginLockDisplay", "Failed to retrieve buffer directives", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginLockDisplay", "Failed to retrieve buffer directives", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginStageBufferSizeDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            String bufferValue = this.getStagerEditableValue("StageBufferSize", index);
            if (bufferValue != null && !bufferValue.equals("-1")) {
                ((CCTextField)this.getChild("StageBufferSize", index)).setValue((Object)bufferValue);
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginStageBuffersizeDisplay", "Failed to retrieve buffer directives", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginStageBuffersizeDisplay", "Failed to retrieve buffer directives", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private String getStagerEditableValue(String type, int index) throws ModelControlException, SamFSException {
        BufferDirective stagebuffer;
        TraceUtil.trace3("Entering");
        String value = "";
        BufferDirective[] stageBuffers = ((ArchiveSetUpViewBean)this.getParentViewBean()).getStageBufferDirectives();
        if (stageBuffers == null || stageBuffers.length == 0) {
            if (type.equals("StageBufferLock")) {
                return "false";
            }
            if (type.equals("StageBufferSize")) {
                return "";
            }
        }
        if ((stagebuffer = stageBuffers[index]) != null) {
            if (type.equals("StageBufferLock")) {
                value = stagebuffer.isLocked() ? "true" : "false";
            } else if (type.equals("StageBufferSize")) {
                value = String.valueOf(stagebuffer.getSize());
            }
        }
        value = value != null ? value.trim() : "";
        TraceUtil.trace3("Exiting");
        return value;
    }

    private String getServerName() {
        return ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
    }
}

