/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.GeneralArchivingSetupTiledView;
import com.sun.netstorage.samqfs.web.archive.GeneralArchivingSetupViewBean;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.FSArchiveDirective;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class GeneralArchivingSetupView
extends RequestHandlingViewBase {
    public static final String FS_TABLE = "filesystemTable";
    public static final String TILED_VIEW = "GeneralArchivingSetupTiledView";
    private CCActionTableModel fsTableModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$table$CCActionTable;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$GeneralArchivingSetupTiledView;

    public GeneralArchivingSetupView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.fsTableModel = this.createFSTableModel();
        this.populateTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(FS_TABLE, class$com$sun$web$ui$view$table$CCActionTable == null ? (class$com$sun$web$ui$view$table$CCActionTable = GeneralArchivingSetupView.class$("com.sun.web.ui.view.table.CCActionTable")) : class$com$sun$web$ui$view$table$CCActionTable);
        this.registerChild(TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$GeneralArchivingSetupTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$GeneralArchivingSetupTiledView = GeneralArchivingSetupView.class$("com.sun.netstorage.samqfs.web.archive.GeneralArchivingSetupTiledView")) : class$com$sun$netstorage$samqfs$web$archive$GeneralArchivingSetupTiledView);
        this.fsTableModel.registerChildren((ContainerViewBase)this);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(TILED_VIEW)) {
            return new GeneralArchivingSetupTiledView((View)this, this.fsTableModel, name);
        }
        if (name.equals(FS_TABLE)) {
            CCActionTable table = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.fsTableModel, name);
            table.setTiledView((ContainerView)this.getChild(TILED_VIEW));
            return table;
        }
        if (this.fsTableModel.isChildSupported(name)) {
            return this.fsTableModel.createChild((View)this, name);
        }
        throw new IllegalArgumentException("Invalid child '" + name + "'");
    }

    public CCActionTableModel createFSTableModel() {
        TraceUtil.trace3("Entering");
        ServletContext sc = RequestManager.getRequestContext().getServletContext();
        CCActionTableModel model = new CCActionTableModel(sc, "/jsp/archive/GeneralArchivingSetupFSTable.xml");
        TraceUtil.trace3("Exiting");
        return model;
    }

    private void initializeTableHeaders() {
        TraceUtil.trace3("Entering");
        this.fsTableModel.setActionValue("FSName", (Object)"archiving.fs.name");
        this.fsTableModel.setActionValue("ScanMethod", (Object)"archiving.scanmethod");
        this.fsTableModel.setActionValue("Interval", (Object)"archiving.interval");
        this.fsTableModel.setActionValue("LogFile", (Object)"archiving.logfile");
        TraceUtil.trace3("Exiting");
    }

    private void populateTableModel() {
        TraceUtil.trace3("Entering");
        FSArchiveDirective[] directives = this.getFSArchiveDirectives();
        for (int i = 0; i < directives.length; ++i) {
            if (i > 0) {
                this.fsTableModel.appendRow();
            }
            String fsName = directives[i].getFileSystemName();
            this.fsTableModel.setValue("FSNameText", (Object)fsName);
            this.fsTableModel.setValue("FSNameHidden", (Object)fsName);
        }
        CCHiddenField child = (CCHiddenField)this.getParentViewBean().getChild("numberofrows");
        int rowCount = this.fsTableModel.getNumRows();
        child.setValue((Object)Integer.toString(rowCount));
        TraceUtil.trace3("Exiting");
    }

    private FSArchiveDirective[] getFSArchiveDirectives() {
        FSArchiveDirective[] fsad = new FSArchiveDirective[]{};
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel();
            SamQFSSystemArchiveManager43 archiveManager = sysModel.getSamQFSSystemArchiveManager43();
            fsad = archiveManager.getFSGeneralArchiveDirective();
        }
        catch (SamFSWarnings sfw) {
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.summary", sfw.getMessage());
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "getFSArchiveDirectives()", "Unable to retrieve FS Directives");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.summary", smme.getSAMerrno(), "ArchiveConfig.error.detail");
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "getFSArchiveDirectives", "Unable to retrieve FS Directives");
        }
        catch (SamFSException sfe) {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage());
        }
        return fsad;
    }

    private FSArchiveDirective retrieveFSArchiveDirective(FSArchiveDirective[] directives, String fsname) {
        for (int i = 0; i < directives.length; ++i) {
            if (!fsname.equals(directives[i].getFileSystemName())) continue;
            return directives[i];
        }
        return null;
    }

    private void disablePageButtons() {
        GeneralArchivingSetupViewBean vb = (GeneralArchivingSetupViewBean)this.getParentViewBean();
        CCButton child = (CCButton)this.getChild("Save");
        child.setDisabled(true);
        child = (CCButton)this.getChild("Reset");
        child.setDisabled(true);
        child = (CCButton)this.getChild("Cancel");
        child.setDisabled(true);
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        TraceUtil.trace3("Exiting");
    }

    public List handleSaveRequest(RequestInvocationEvent rie) throws SamFSException {
        FSArchiveDirective[] directives = this.getFSArchiveDirectives();
        CCActionTable table = (CCActionTable)this.getChild(FS_TABLE);
        try {
            table.restoreStateData();
        }
        catch (ModelControlException mce) {
            throw new SamFSException(mce.getMessage());
        }
        CCActionTableModel model = (CCActionTableModel)table.getModel();
        ArrayList<String> errors = new ArrayList<String>(0);
        for (int i = 0; i < model.getNumRows(); ++i) {
            FSArchiveDirective directive;
            boolean intervalError = false;
            boolean logFileError = false;
            model.setRowIndex(i);
            String fsname = (String)model.getValue("FSNameHidden");
            String logfile = (String)model.getValue("LogFileText");
            String scanMethod = (String)model.getValue("ScanMethodText");
            String interval = (String)model.getValue("IntervalText");
            String intervalUnits = (String)model.getValue("IntervalUnits");
            int sm = Integer.parseInt(scanMethod);
            sm = sm == -999 ? -1 : sm;
            int u = Integer.parseInt(intervalUnits);
            u = u == -999 ? -1 : u;
            long intv = -1L;
            String string = interval = interval != null ? interval.trim() : "";
            if (!interval.equals("")) {
                try {
                    intv = Long.parseLong(interval);
                    if (intv < 0L) {
                        intervalError = true;
                        errors.add(SamUtil.getResourceString("GeneralArchivingSetup.error.intervalrange", fsname));
                    }
                    if (u == -1) {
                        intervalError = true;
                        errors.add(SamUtil.getResourceString("GeneralArchivingSetup.error.intervalDropDown", fsname));
                    }
                }
                catch (NumberFormatException nfe) {
                    intervalError = true;
                    errors.add(SamUtil.getResourceString("GeneralArchivingSetup.error.intervalrange", fsname));
                }
            } else if (u != -1) {
                intervalError = true;
                errors.add(SamUtil.getResourceString("GeneralArchivingSetup.error.intervalempty", fsname));
            }
            String string2 = logfile = logfile != null ? logfile.trim() : "";
            if (!logfile.equals("") && logfile.charAt(0) != '/') {
                logFileError = true;
                errors.add(SamUtil.getResourceString("GeneralArchivingSetup.error.logfile", fsname));
            }
            if ((directive = this.retrieveFSArchiveDirective(directives, fsname)) == null) continue;
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            buf.append("Saving FSArchiveDirective for File Systtem '").append(fsname).append("': scanMethod=").append(Integer.toString(sm)).append("; interval=").append(Long.toString(intv)).append("; interval unit=").append("; logfile=").append(logfile);
            TraceUtil.trace2(buf.toString());
            directive.setFSArchiveScanMethod(sm);
            if (!intervalError) {
                directive.setFSInterval(intv);
                directive.setFSIntervalUnit(u);
            }
            if (!logFileError) {
                directive.setFSArchiveLogfile(logfile);
            }
            directive.changeFSDirective();
        }
        return errors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

