/*
 * Copyright 04/08/04 Sun Microsystems, Inc. All Rights Reserved
 *
 */

#ifndef _LIBCOLLECTOR_H
#define	_LIBCOLLECTOR_H

#pragma ident "@(#)libcollector.h 1.9 04/04/08"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This file contains function prototypes for the user-callable API
 * routines in libcollector for C and C++ codes
 */

/* routine to record a sample in the experiment */
void	collector_sample(char *name);

/* routine to suspend data collection during an experiment */
void	collector_pause(void);

/* routine to resume data collection during an experiment */
void	collector_resume(void);

/* routine to suspend per-thread data collection during an experiment */
void	collector_thread_pause(unsigned int tid);

/* routine to resume per-thread data collection during an experiment */
void	collector_thread_resume(unsigned int tid);

/* routine to close the experiment, and stop all data collection */
void	collector_terminate_expt(void);

typedef struct {
	unsigned int	offset;
	unsigned int	lineno;
} Lineno;

/* routines to let libcollector know about a dynamically loaded function */
void	collector_func_load(char *name, char *alias, char  *sourcename,
		void *vaddr, int size, int lntsize, Lineno *lntable);

void	collector_func_unload(void *vaddr);

/* define the weak symbols for the API */
#if !defined(__SUNPRO_CC) && !defined(__SUNPRO_C)

/* GNU compilers */
void collector_sample() __attribute__ ((weak));
void collector_pause() __attribute__ ((weak));
void collector_resume() __attribute__ ((weak));
void collector_thread_pause() __attribute__ ((weak));
void collector_thread_resume() __attribute__ ((weak));
void collector_terminate_expt() __attribute__ ((weak));
void collector_func_load() __attribute__ ((weak));
void collector_func_unload() __attribute__ ((weak));

#else

/* Sun compilers */
#pragma weak collector_sample
#pragma weak collector_pause
#pragma weak collector_resume
#pragma weak collector_thread_pause
#pragma weak collector_thread_resume
#pragma weak collector_terminate_expt
#pragma weak collector_func_load
#pragma weak collector_func_unload

#endif

#ifdef	__cplusplus
}
#endif

/* define the macros that actually get inserted in the caller's code */
#define collector_sample(x) \
	( collector_sample ? collector_sample(x),0 : 0 )

#define collector_pause() \
	( collector_pause ? collector_pause(),0 : 0 )

#define collector_resume() \
	( collector_resume ? collector_resume(),0 : 0 )

#define collector_thread_pause(tid) \
	( collector_thread_pause ? collector_thread_pause(tid),0 : 0 )

#define collector_thread_resume(tid) \
	( collector_thread_resume ? collector_thread_resume(tid),0 : 0 )

#define collector_terminate_expt() \
	( collector_terminate_expt ? collector_terminate_expt(),0 : 0 )

#define collector_func_load(x0,x1,x2,x3,x4,x5,x6) \
	( collector_func_load ? collector_func_load(x0,x1,x2,x3,x4,x5,x6),0 : 0 )

#define collector_func_unload(x) \
	( collector_func_unload ? collector_func_unload(x),0 : 0 )


#endif	/* _LIBCOLLECTOR_H */
